/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.celleditor.drilllinks.DrillLinkRegistry;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleTemporalEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.IDrillLink;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.util.ModelUtil;

public class ResultSetTableCellEditor
extends DefaultCellEditor
implements PopupCellEditorHandler {
    private Object valFrompopupEditor = null;
    private int columnDataType = -1;
    private String columnDataTypeName = null;
    private Format format = null;
    private ICellEditor iCellEditor = null;
    private JTable table = null;

    public ResultSetTableCellEditor(ResultSetTable resultSetTable) {
        super(new RaptorTableEditorTextField((JTable)((Object)resultSetTable)));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component;
        this.valFrompopupEditor = null;
        this.columnDataType = -1;
        this.columnDataTypeName = null;
        this.format = null;
        this.iCellEditor = null;
        this.table = jTable;
        Object object2 = null;
        if (object != null && object.toString().indexOf("SQLDEV:") == 0 && (component = this.getDrillComponent(object, jTable)) != null) {
            return component;
        }
        component = null;
        if (jTable instanceof ResultSetTable && ((ResultSetTable)((Object)jTable)).getGridModel() != null) {
            Column column;
            Connection connection;
            ResultSetTableModel resultSetTableModel;
            ResultSetTable resultSetTable;
            block30: {
                resultSetTable = (ResultSetTable)((Object)jTable);
                resultSetTableModel = resultSetTable.getGridModel();
                connection = null;
                column = resultSetTableModel.getQueryColumn(resultSetTable.convertRowIndexToModel(n), resultSetTable.convertColumnIndexToModel(n2));
                if (column != null && column.getCellEditor() != null && column.getCellEditor() != null) {
                    try {
                        Object obj;
                        ClassLoader classLoader = column.getClassLoader();
                        Object obj2 = obj = classLoader == null ? Class.forName(column.getCellEditor()).newInstance() : Class.forName(column.getCellEditor(), true, classLoader).newInstance();
                        if (obj instanceof DefaultCellEditor) {
                            object2 = ((DefaultCellEditor)obj).getTableCellEditorComponent(jTable, object, bl, n, n2);
                            break block30;
                        }
                        if (obj instanceof ICellEditor) {
                            this.iCellEditor = (ICellEditor)obj;
                            object2 = ((ICellEditor)obj).getComponent(jTable, object, n, n2);
                            break block30;
                        }
                        RuntimeException runtimeException = new RuntimeException("Must be a DefaultCellEditor or ICellEditor");
                        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellEditorComponent", runtimeException);
                        throw runtimeException;
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                    }
                }
            }
            try {
                connection = Connections.getInstance().getConnection(resultSetTableModel.getConnectionName(), false);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            }
            if (connection != null) {
                Object object3;
                Object object4;
                boolean bl2 = resultSetTable.isEditable();
                this.columnDataType = resultSetTableModel.getGridColumns().get(jTable.convertColumnIndexToModel(n2)).getSqlType();
                this.columnDataTypeName = resultSetTableModel.getGridColumns().get(jTable.convertColumnIndexToModel(n2)).getSqlTypeName();
                this.format = this.getFormat(connection, this.columnDataType);
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2) {
                    bl4 = resultSetTableModel.isCellEditorEditable(resultSetTable.convertRowIndexToModel(n), resultSetTable.convertColumnIndexToModel(n2));
                    bl3 = bl4 && this.isInPlaceEditingAllowed(this.columnDataType);
                }
                PopupCellEditor popupCellEditor = null;
                if (column != null && column.getCellPopup() != null) {
                    try {
                        object4 = column.getClassLoader();
                        Object obj = object3 = object4 == null ? Class.forName(column.getCellPopup()).newInstance() : Class.forName(column.getCellPopup(), true, (ClassLoader)object4).newInstance();
                        if (!(object3 instanceof PopupCellEditor)) {
                            RuntimeException runtimeException = new RuntimeException("Must be a PopupCellEditor");
                            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellEditorComponent", runtimeException);
                            throw runtimeException;
                        }
                        popupCellEditor = (PopupCellEditor)object3;
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                    }
                }
                if (popupCellEditor == null && this.iCellEditor == null) {
                    popupCellEditor = PopupCellEditorFactory.getPopupCellEditor(resultSetTableModel.getConnectionName(), this.columnDataType, this.columnDataTypeName);
                }
                if (!Connections.getInstance().isOracle(connection) && DataTypesUtil.isDateOrTime((int)this.columnDataType) && popupCellEditor instanceof OracleTemporalEditPanel) {
                    popupCellEditor = null;
                }
                if (popupCellEditor != null) {
                    popupCellEditor.setConnection(connection);
                    popupCellEditor.setRowData(resultSetTableModel.getRowModel(n));
                    popupCellEditor.setEditable(bl4);
                    if (bl4) {
                        object4 = new EditableGridInfo(resultSetTableModel.getSql(), resultSetTableModel.getBindList(), resultSetTableModel.getBindMap(), ((EditableResultSetTableModel)resultSetTableModel).getTableName());
                        popupCellEditor.setGridInfo((EditableGridInfo)object4);
                    }
                }
                if (DataTypesUtil.isExtendedType((Object)object, (int)this.columnDataType) || DataTypesUtil.isTemporalType((Object)object, (int)this.columnDataType)) {
                    this.valFrompopupEditor = object instanceof String && ((String)object).length() == 0 ? null : object;
                }
                object = component == null ? DataTypesUtil.stringValue((Object)object, (Connection)connection, (int)Integer.MAX_VALUE) : component;
                object4 = null;
                if (object2 == null) {
                    object3 = connection;
                    RaptorTableEditorTextField raptorTableEditorTextField = new RaptorTableEditorTextField((JTable)((Object)resultSetTable));
                    raptorTableEditorTextField.setText(object != null ? object.toString() : "");
                    this.delegate = new DefaultCellEditor.EditorDelegate((Connection)object3, raptorTableEditorTextField){
                        final /* synthetic */ Connection val$m_conn;
                        final /* synthetic */ RaptorTableEditorTextField val$fld;
                        {
                            this.val$m_conn = connection;
                            this.val$fld = raptorTableEditorTextField;
                            super(ResultSetTableCellEditor.this);
                        }

                        @Override
                        public void setValue(Object object) {
                            String string = DataTypesUtil.stringValue((Object)object, (Connection)this.val$m_conn, (int)Integer.MAX_VALUE);
                            this.val$fld.setText(string != null ? string : "");
                        }

                        @Override
                        public Object getCellEditorValue() {
                            return this.val$fld.getText();
                        }
                    };
                    raptorTableEditorTextField.addActionListener(this.delegate);
                    String string = raptorTableEditorTextField.getText();
                    if (string.contains("\n") || string.contains("\t") || string.contains("\r")) {
                        bl3 = false;
                    }
                    raptorTableEditorTextField.setFont(jTable.getFont());
                    if (popupCellEditor != null) {
                        popupCellEditor.setFont(jTable.getFont());
                    }
                    object4 = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, raptorTableEditorTextField, bl3, popupCellEditor);
                } else {
                    object4 = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, (JComponent)object2, bl3, popupCellEditor);
                }
                object2 = object4;
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(RSTableMessages.getString("ResultSetTableModel.14"), Connections.getDisplayName(resultSetTableModel.getConnectionName())));
            }
        }
        if (object2 == null) {
            object2 = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        return object2;
    }

    protected boolean isInPlaceEditingAllowed(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2007: 
            case 2009: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 12: 
            case 91: 
            case 93: 
            case 2004: 
            case 2005: 
            case 2007: 
            case 2009: {
                return true;
            }
        }
        return false;
    }

    protected Format getFormat(Connection connection, int n) {
        if (Connections.getInstance().isOracle(connection)) {
            try {
                return NLSUtils.getFormat((Connection)connection, (int)n);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        return !(eventObject instanceof MouseEvent) || (mouseEvent = (MouseEvent)eventObject).getClickCount() == 2;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        if (this.format != null) {
            String string = (String)super.getCellEditorValue();
            if (string != null) {
                try {
                    String string2 = this.format.format(this.valFrompopupEditor);
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        this.valFrompopupEditor = this.format.parseObject(string, new ParsePosition(0));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            object = this.valFrompopupEditor;
        } else {
            object = this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.iCellEditor != null ? this.iCellEditor.getValue() : super.getCellEditorValue()));
        }
        return object;
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
    }

    @Override
    public void handlePopupEdit(final PopupCellEditor popupCellEditor) {
        final JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            return;
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)(popupCellEditor.isEditable() ? ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE") : ControlsArb.getString("RESULTSET_VIEW_VALUE_TITLE")));
        String string = popupCellEditor.getHelpTopicId();
        if (!ModelUtil.hasLength((String)string)) {
            string = "f1_extendeddataedit_html";
        }
        HelpSystem.getHelpSystem().registerTopic(jComponent, string);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string;
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && (string = popupCellEditor.validateValue()) != null) {
                    MessageDialog.error((Component)jComponent, (Object)string, (String)RSTableMessages.getString("ResultSetTableCellEditor.0"), (String)popupCellEditor.getHelpTopicId());
                    throw new PropertyVetoException(RSTableMessages.getString("ResultSetTableCellEditor.1"), propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setResizable(true);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(popupCellEditor.getClass().getName() + ".dialogSize"));
        jEWTDialog.setOKButtonEnabled(popupCellEditor.isEditable());
        popupCellEditor.setValue(this.getCellEditorValue());
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            @Override
            public void save(Object object) {
                if (this.savable()) {
                    ResultSetTableCellEditor.this.valFrompopupEditor = object;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ResultSetTableCellEditor.this.setValue(ResultSetTableCellEditor.this.valFrompopupEditor);
                            ResultSetTableCellEditor.this.stopCellEditing();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }

            @Override
            public boolean savable() {
                int n = ResultSetTableCellEditor.this.getCellEditorListeners().length;
                return n > 0;
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.valFrompopupEditor = popupCellEditor.getValue();
            this.setValue(this.valFrompopupEditor);
            this.stopCellEditing();
        } else if (!popupCellEditor.editorBrokeout()) {
            this.cancelCellEditing();
        }
        popupCellEditor.dismissPopupEditor();
        if (this.table != null) {
            this.table.requestFocusInWindow();
            this.table = null;
        }
    }

    private Component getDrillComponent(Object object, JTable jTable) {
        final RichHintLabel richHintLabel = new RichHintLabel();
        String string = ":";
        String string2 = object.toString();
        if (string2.startsWith("SQLDEV:LINK")) {
            if (string2.startsWith("SQLDEV:LINK{")) {
                string = string2.substring(string2.indexOf("{") + 1, string2.indexOf("}"));
                string2 = string2.substring(string2.indexOf("}") + 1);
            } else if (string2.startsWith("SQLDEV:LINK:")) {
                string2 = string2.substring(string2.indexOf("LINK:") + 5);
            }
            final String[] stringArray = string2.split(string);
            String string3 = stringArray[stringArray.length - 2];
            if (jTable instanceof ResultSetTable && ((ResultSetTable)((Object)jTable)).getGridModel() != null) {
                ResultSetTable resultSetTable = (ResultSetTable)((Object)jTable);
                ResultSetTableModel resultSetTableModel = resultSetTable.getGridModel();
                try {
                    Connection connection = Connections.getInstance().getConnection(resultSetTableModel.getConnectionName(), false);
                    if (connection != null) {
                        final String string4 = Connections.getInstance().getConnectionName(connection);
                        richHintLabel.setHtmlText("<a href=\"http:" + string3 + "\">" + string3 + "</a>");
                        richHintLabel.registerAction(string3, (Action)new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    IDrillLink iDrillLink = DrillLinkRegistry.getInstance().getDrillLink(stringArray, string4);
                                    if (iDrillLink != null) {
                                        iDrillLink.performDrill();
                                    }
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                                }
                            }
                        });
                        final HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, string3);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                richHintLabel.fireHyperlinkUpdate(hyperlinkEvent);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        return richHintLabel;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return null;
    }
}

