/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.Query;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.controls.search.URLListRenderer;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleConnection;

public class SearchPanel
extends BaseSearchPanel {
    private static final long serialVersionUID = 1L;
    private DBConnectionComboBox _dbSelector;
    static final String[] identifierTypes = new String[]{"ASSOC ARRAY", "BFILE DATATYPE", "BLOB DATATYPE", "BOOLEAN DATATYPE", "CHARACTER DATATYPE", "CLOB DATATYPE", "CONSTANT", "DATE DATATYPE", "DATABASE LINK", "EXCEPTION", "FORMAL IN", "FUNCTION", "INDEX TABLE", "INTERVAL DATATYPE", "NESTED TABLE", "NUMBER DATATYPE", "OBJECT", "OPAQUE", "PACKAGE", "PROCEDURE", "RECORD", "REFCURSOR", "SUBTYPE", "TIME DATATYPE", "TIMESTAMP DATATYPE", "UROWID", "VARIABLE", "VARRAY"};
    protected static final String ALL = "ALL";
    static final String allSource = "ALL SOURCE";
    static final String allObjects = "ALL OBJECTS";
    static final String[] objTypes = new String[]{"ALL OBJECTS", "VIEW", "SYNONYM", "INDEX", "TYPE", "TABLE", "PACKAGE", "PACKAGE BODY", "LIBRARY", "SEQUENCE", "TYPE BODY", "FUNCTION", "PROCEDURE", "TRIGGER", "MATERIALIZED VIEW", "MATERIALIZED VIEW LOG", "DATABASE LINK", "COLUMN"};
    static final String[] identifierUsages = new String[]{"ALL", "ASSIGNMENT", "CALL", "DECLARATION", "DEFINITION", "REFERENCE"};
    private String[] _typesForDisplay = null;
    private String[] _typesForSearch = null;
    JLabel lblConnection = new JLabel();
    JLabel lblSchema = new JLabel();
    JLabel lblName = new JLabel();
    JLabel lblType = new JLabel();
    JLabel lblUsage = new JLabel();
    JLabel lblTblSpace = new JLabel();
    JTextField fldName = new JTextField();
    JLabel lblWildCard = new JLabel();
    JCheckBox chkWildCard = new JCheckBox();
    JComboBox cmbTablespace = new JComboBox();
    JComboBox cmbSchema = new JComboBox();
    JComboBox cmbType = new JComboBox();
    JComboBox cmbUsage = new JComboBox();
    JButton lookupButton = new JButton(StringUtils.stripMnemonic((String)ControlsArb.getString("_LABEL_LOOKUP")), OracleIcons.getIcon((String)"find.png"));
    JButton moreButton = new JButton(StringUtils.stripMnemonic((String)ControlsArb.getString("More")), null);
    private boolean showMoreStuff = true;
    private JList _results;
    private MouseListener _resultsListMouseListener;
    private Logger logger = Logger.getLogger(SearchPanel.class.getName());
    private DefaultListModel _model;
    private boolean _init = false;
    protected String _connectionName;
    protected String[] _tablespaceNames = null;
    protected String[] _schemaNames = null;
    protected boolean _isMultipleSchemasEnabled = false;
    protected boolean _isTablespaceEnabled = false;
    private Query q = null;
    private boolean includeIds = true;
    private boolean includeStmts = true;
    private URLListRenderer ulr = new URLListRenderer();
    IObjectActionListener dropListener = new IObjectActionListener(){

        @Override
        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            if (!objectAction.isRenameAction()) {
                return;
            }
            int n = SearchPanel.this._model.indexOf(dBObject.getURL());
            if (n != -1) {
                SearchPanel.this._model.remove(n);
                String string2 = null;
                Object object = list.iterator();
                while (object.hasNext()) {
                    String string3;
                    string2 = string3 = object.next();
                }
                if (string2 != null) {
                    object = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", dBObject.getConnectionName(), dBObject.getCatalog(), dBObject.getSchemaName(), dBObject.getObjectType()), Service.handleMixedCase((String)string2));
                    SearchPanel.this._model.add(n, object);
                }
            }
        }

        @Override
        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            assert (dBObject != null);
            URL uRL = dBObject.getURL();
            SearchPanel.this._model.removeElement(uRL);
        }
    };
    ConnectionListener renameListener = new ConnectionListener(){

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)SearchPanel.this._results.getModel();
            switch (connectionEvent.getID()) {
                case 3: {
                    URL uRL;
                    String string;
                    String string2 = connectionEvent.getConnectionName();
                    if (defaultListModel.getSize() <= 0 || !string2.equals(string = DBURLFormatHelper.getConnectionName(uRL = (URL)SearchPanel.this._results.getModel().getElementAt(0)))) break;
                    defaultListModel.removeAllElements();
                    break;
                }
                case 5: {
                    URL uRL;
                    String string;
                    String string3 = connectionEvent.getOldName();
                    if (defaultListModel.getSize() <= 0 || !string3.equals(string = DBURLFormatHelper.getConnectionName(uRL = (URL)SearchPanel.this._results.getModel().getElementAt(0)))) break;
                    defaultListModel.removeAllElements();
                }
            }
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }
    };
    protected DatabaseQueryTask<ArrayList<URL>> searchTask;

    public SearchPanel() {
        super(new GridBagLayout());
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this.createGUI();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_extendedsearch_html");
        }
    }

    public void init(boolean bl) {
        if (bl) {
            this.removeAll();
            this.showMoreStuff = false;
            this.createGUI();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_extendedsearch_html");
            this.revalidate();
        }
    }

    @Override
    public URL getSelectedURL() {
        int n = this._results.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        Object e = ((DefaultListModel)this._results.getModel()).getElementAt(n);
        if (e instanceof URL) {
            return (URL)e;
        }
        return null;
    }

    public void addURL(URL uRL) {
        this.getModel().addElement(uRL);
    }

    public void removeURL(URL uRL) {
        Enumeration enumeration = this.getModel().elements();
        while (enumeration.hasMoreElements()) {
            URL uRL2 = (URL)enumeration.nextElement();
            if (!uRL2.equals(uRL)) continue;
            this.getModel().removeElement(uRL);
            break;
        }
    }

    public void removeAllURL() {
        this.getModel().clear();
    }

    protected boolean isAddConnection() {
        return true;
    }

    protected boolean isAddTableSpace() {
        return this._isTablespaceEnabled;
    }

    public void setAddTableSpace(boolean bl) {
        this._isTablespaceEnabled = bl;
    }

    public void setTableSpaceNames(String[] stringArray) {
        if (this.isAddTableSpace()) {
            this._tablespaceNames = stringArray;
        }
    }

    protected String[] getTableSpaceNames() {
        if (this.isAddTableSpace()) {
            return this._tablespaceNames;
        }
        return null;
    }

    protected boolean isAddMultipleSchemas() {
        return this._isMultipleSchemasEnabled;
    }

    public void setMultipleSchemas(String[] stringArray) {
        this._schemaNames = stringArray;
    }

    public void setAddMultipleSchemas(boolean bl) {
        this._isMultipleSchemasEnabled = bl;
    }

    public String[] getMultipleSchemas() {
        return this._schemaNames;
    }

    protected boolean isAddSchema() {
        return false;
    }

    protected boolean isAddType() {
        return true;
    }

    protected boolean isAddUsage() {
        return true;
    }

    protected boolean isShowSynonyms() {
        return true;
    }

    protected int getSelectionMode() {
        return 0;
    }

    protected String[] getTypesForSearch() {
        return this._typesForSearch;
    }

    protected String[] getTypes() {
        return this._typesForDisplay;
    }

    public void setTypesForDisplay(String[] stringArray) {
        this._typesForDisplay = stringArray;
    }

    public void setTypesForSearch(String[] stringArray) {
        this._typesForSearch = stringArray;
    }

    protected String getConnectionName() {
        if (this.isAddConnection()) {
            return this._dbSelector.getCurrentConnectionName();
        }
        return this._connectionName;
    }

    public void setConnectionName(String string) {
        this._connectionName = string;
    }

    public JList getResultsList() {
        return this._results;
    }

    public void setResultsListMouseListener(MouseListener mouseListener) {
        this._resultsListMouseListener = mouseListener;
    }

    public void createGUI() {
        if (this.isAddConnection()) {
            this.initConnection();
        }
        if (this.isAddTableSpace()) {
            ResourceUtils.resLabel((JLabel)this.lblTblSpace, (Component)this.cmbTablespace, (String)ControlsArb.getString("_LABEL_TABLESPACE"));
            this.cmbTablespace.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_TABLESPACE"));
        }
        if (this.isAddSchema()) {
            ResourceUtils.resLabel((JLabel)this.lblSchema, (Component)this.cmbSchema, (String)ControlsArb.getString("_LABEL_SCHEMA"));
            this.cmbSchema.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_SCHEMA"));
        }
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)ControlsArb.getString("_LABEL_NAME"));
        this.fldName.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_NAME"));
        this.fldName.setToolTipText(ControlsArb.getString("SearchPanel.NAME_TOOLTIP"));
        ResourceUtils.resLabel((JLabel)this.lblWildCard, (Component)this.chkWildCard, (String)"%");
        this.chkWildCard.getAccessibleContext().setAccessibleName("%");
        this.chkWildCard.setToolTipText(ControlsArb.getString("TOOLTIP_WILDCARD"));
        if (this.isAddType()) {
            ResourceUtils.resLabel((JLabel)this.lblType, (Component)this.cmbType, (String)ControlsArb.getString("_LABEL_TYPE"));
            this.cmbType.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_TYPE"));
            this.initCmbType();
        }
        if (this.isAddUsage()) {
            ResourceUtils.resLabel((JLabel)this.lblUsage, (Component)this.cmbUsage, (String)ControlsArb.getString("_LABEL_USAGE"));
            this.cmbUsage.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_USAGE"));
        }
        ObjectActionController.addListener(this.dropListener);
        this.lookupButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("_LABEL_LOOKUP")));
        this.lookupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Connection connection = SearchPanel.this.getConnection();
                if (connection != null) {
                    SearchPanel.this.doSearch();
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ControlsArb.getString("MSG_MISSING_CONN"), (String)ControlsArb.getString("MSG_MISSING_INFO"), null);
                }
            }
        });
        this.moreButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("More")));
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.moreOrLess();
            }
        });
        this._model = new DefaultListModel();
        this._results = new JList(this._model);
        this._results.setSelectionMode(this.getSelectionMode());
        this._results.getAccessibleContext().setAccessibleName(ControlsArb.getString("SearchPanel.2"));
        this._results.setCellRenderer(this.ulr);
        if (this._resultsListMouseListener != null) {
            this._results.addMouseListener(this._resultsListMouseListener);
        }
        if (this.isAddConnection()) {
            this.add((Component)this.lblConnection, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
            this.add((Component)this._dbSelector.getJComboBox(), new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        }
        this.fldName.setText("");
        this.fldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SearchPanel.this.doSearch();
                }
            }
        });
        this.chkWildCard.setSelected(DBConfig.getInstance().getBoolean("SEARCH_AUTO_WILDCARD"));
        this.chkWildCard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DBConfig dBConfig = DBConfig.getInstance();
                dBConfig.putBoolean("SEARCH_AUTO_WILDCARD", SearchPanel.this.chkWildCard.isSelected());
            }
        });
        this.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
        this.add((Component)this.lblWildCard, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)this.chkWildCard, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)this.moreButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 10, 0));
        this.add((Component)this.lookupButton, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 10, 0));
        this.add((Component)new JScrollPane(this._results), new GridBagConstraints(0, 6, 4, 5, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
        Connections.getInstance().addConnectionListener(this.renameListener);
    }

    private void moreOrLess() {
        boolean bl = this.showMoreStuff = !this.showMoreStuff;
        if (this.showMoreStuff) {
            this.moreButton.setText(StringUtils.stripMnemonic((String)ControlsArb.getString("More")));
            this.moreButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("More")));
            this.removeMore();
        } else {
            this.moreButton.setText(StringUtils.stripMnemonic((String)ControlsArb.getString("Less")));
            this.moreButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("Less")));
            if (this.isAddTableSpace()) {
                this.initTablespace();
            }
            if (this.isAddSchema()) {
                this.initSchema();
            }
            if (this.isAddType() || this.isAddUsage()) {
                this.initTypeUsage();
            }
            this.addMore();
        }
    }

    private void addMore() {
        int n = 2;
        if (this.isAddTableSpace()) {
            this.add((Component)this.lblTblSpace, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
            this.add((Component)this.cmbTablespace, new GridBagConstraints(1, n, 3, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 0, 0));
            ++n;
        }
        if (this.isAddSchema()) {
            this.add((Component)this.lblSchema, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
            this.add((Component)this.cmbSchema, new GridBagConstraints(1, n, 3, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
            ++n;
        }
        if (this.isAddType()) {
            this.add((Component)this.lblType, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
            this.add((Component)this.cmbType, new GridBagConstraints(1, n, 3, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 10, 0));
            ++n;
        }
        if (this.isAddUsage()) {
            this.add((Component)this.lblUsage, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
            this.add((Component)this.cmbUsage, new GridBagConstraints(1, n, 3, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 10, 0));
            ++n;
        }
    }

    private void removeMore() {
        if (this.isAddSchema()) {
            this.remove(this.lblSchema);
            this.remove(this.cmbSchema);
        }
        if (this.isAddType()) {
            this.remove(this.lblType);
            this.remove(this.cmbType);
        }
        if (this.isAddUsage()) {
            this.remove(this.lblUsage);
            this.remove(this.cmbUsage);
        }
        if (this.isAddTableSpace()) {
            this.remove(this.lblTblSpace);
            this.remove(this.cmbTablespace);
        }
        this.revalidate();
    }

    private DefaultListModel getModel() {
        return (DefaultListModel)this._results.getModel();
    }

    private void doSearch() {
        final String string = this._connectionName = this.getConnectionName();
        String string2 = MessageFormat.format(ControlsArb.getString("SearchPanel.4"), Connections.getDisplayName(string), this.fldName.getText());
        this.getModel().clear();
        this.getModel().addElement(string2 + " ...");
        this.searchTask = new DatabaseQueryTask<ArrayList<URL>>(string2, IRaptorTaskRunMode.NO_GUI, true, true){

            public ArrayList<URL> doWork() {
                String[] stringArray;
                String string6;
                String string2 = SearchPanel.this.getSchemaName();
                if (SearchPanel.ALL.equals(string2)) {
                    string2 = null;
                }
                if (SearchPanel.this.showMoreStuff && SearchPanel.this.isShowSynonyms()) {
                    string2 = null;
                }
                SearchPanel.this.q = SearchPanel.this.newQuery(string, string2);
                String string3 = SearchPanel.this.fldName.getText();
                if (DBConfig.getInstance().getBoolean("SEARCH_AUTO_WILDCARD").booleanValue()) {
                    string3 = string3 + "%";
                }
                string6 = (string6 = SearchPanel.this.getType()) != null ? string6.toUpperCase() : SearchPanel.ALL;
                String string4 = SearchPanel.this.getUsage();
                if (string4 != null) {
                    string4 = string4.toUpperCase();
                }
                boolean bl = false;
                if (!string6.equals(SearchPanel.allObjects) && !string6.equals(SearchPanel.ALL)) {
                    stringArray = new String[]{string6};
                    for (String string5 : objTypes) {
                        if (!string5.equals(string6) || "COLUMN".equals(string5)) continue;
                        bl = true;
                        break;
                    }
                } else if (SearchPanel.this.getTypes() == null || SearchPanel.this.getTypes().length == objTypes.length) {
                    stringArray = null;
                    bl = true;
                } else {
                    stringArray = SearchPanel.this.getTypesForSearch();
                    bl = true;
                }
                if (bl) {
                    String[] stringArray2;
                    Query query = SearchPanel.this.q;
                    if (string2 != null) {
                        String[] stringArray3 = new String[1];
                        stringArray2 = stringArray3;
                        stringArray3[0] = string2;
                    } else {
                        stringArray2 = null;
                    }
                    query.prepareAllObjects(string3, stringArray, stringArray2);
                }
                return SearchPanel.this.q.fetch();
            }

            public boolean cancel() {
                SearchPanel.this.getModel().clear();
                DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(ControlsArb.getString("SearchPanel.46"), IRaptorTaskRunMode.NO_GUI, false, false){

                    protected Void doWork() throws TaskException {
                        if (SearchPanel.this.q != null) {
                            SearchPanel.this.q.cancel();
                        }
                        return null;
                    }

                    @Override
                    public String getConnectionName() {
                        return SearchPanel.this._connectionName;
                    }

                    @Override
                    public String getQuery() {
                        return null;
                    }
                };
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
                return super.cancel();
            }

            @Override
            public String getConnectionName() {
                return SearchPanel.this._connectionName;
            }

            @Override
            public String getQuery() {
                return SearchPanel.this.q != null ? SearchPanel.this.q.QUERY_ALL_OBJECTS() : "";
            }
        };
        this.searchTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SearchPanel.this.getModel().clear();
                        ArrayList arrayList = null;
                        try {
                            arrayList = (ArrayList)SearchPanel.this.searchTask.getResult();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                            return;
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                            return;
                        }
                        if (arrayList != null) {
                            for (URL uRL : arrayList) {
                                SearchPanel.this.getModel().addElement(uRL);
                            }
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager.getInstance().addTask(this.searchTask);
    }

    private void initConnection() {
        this._dbSelector = new OracleConnectionComboBox();
        this._dbSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this._connectionName = SearchPanel.this._dbSelector.getCurrentConnectionName();
                SearchPanel.this.moreButton.setEnabled(true);
                SearchPanel.this.moreButton.setText(StringUtils.stripMnemonic((String)ControlsArb.getString("More")));
                SearchPanel.this.moreButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("More")));
                SearchPanel.this.removeMore();
                SearchPanel.this.showMoreStuff = true;
            }
        });
        this._dbSelector.getAccessibleContext().setAccessibleName(ControlsArb.getString("SearchPanel.1"));
        ResourceUtils.resLabel((JLabel)this.lblConnection, (Component)this._dbSelector.getJComboBox(), (String)ControlsArb.getString("_LABEL_CONN"));
        this._dbSelector.getJComboBox().setName("Connection");
    }

    private void initSchema() {
        SQLComboxModel sQLComboxModel = this.getSchemaModel();
        if (sQLComboxModel != null) {
            sQLComboxModel.setDelayed(true);
            this.cmbSchema = new JComboBox(sQLComboxModel);
            this.cmbSchema.setEnabled(true);
            this.lblSchema.setEnabled(true);
        } else if (this.isAddMultipleSchemas()) {
            this.cmbSchema = new JComboBox<String>(this.getMultipleSchemas());
            this.cmbSchema.setEnabled(true);
            if (this._schemaNames.length > 0) {
                this.cmbSchema.setSelectedIndex(0);
            }
            this.lblSchema.setEnabled(true);
        } else {
            this.cmbSchema = new JComboBox();
            this.cmbSchema.setEnabled(false);
            this.lblSchema.setEnabled(false);
        }
        ResourceUtils.resLabel((JLabel)this.lblSchema, (Component)this.cmbSchema, (String)ControlsArb.getString("_LABEL_SCHEMA"));
        this.cmbSchema.getAccessibleContext().setAccessibleName("SCHEMA_ACCESS");
        this.cmbSchema.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
    }

    private SQLComboxModel getSchemaModel() {
        SQLComboxModel sQLComboxModel = null;
        if (this.getConnection() != null) {
            if (this.isAddTableSpace()) {
                String string = "select distinct owner from dba_segments where tablespace_name = '" + this.getTableSpaceName() + "'";
                sQLComboxModel = new SQLComboxModel(Connections.getInstance().getConnectionName(this.getConnection()), string);
                sQLComboxModel.setDelayed(true);
            } else if (this.isAddMultipleSchemas()) {
                sQLComboxModel = null;
            } else {
                sQLComboxModel = new SQLComboxModel(this.getConnection(), "select username from sys.all_users union select 'ALL' from dual order by username", null, this.getSchemaName());
                sQLComboxModel.setDelayed(true);
            }
        }
        return sQLComboxModel;
    }

    private void initTablespace() {
        SQLComboxModel sQLComboxModel = this.getTablespaceModel();
        if (sQLComboxModel != null) {
            this.cmbTablespace = new JComboBox(sQLComboxModel);
            this.cmbTablespace.setEnabled(true);
            this.lblTblSpace.setEnabled(true);
        } else {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.getTableSpaceNames());
            this.cmbTablespace = new JComboBox<String>(defaultComboBoxModel);
            this.cmbTablespace.setEnabled(true);
            this.lblTblSpace.setEnabled(true);
        }
        this.cmbTablespace.getAccessibleContext().setAccessibleName("TABLESPACE_ACCESS");
        this.cmbTablespace.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
    }

    private SQLComboxModel getTablespaceModel() {
        SQLComboxModel sQLComboxModel = null;
        if (this.getConnection() != null) {
            try {
                if (this.getTableSpaceNames() == null) {
                    sQLComboxModel = new SQLComboxModel(Connections.getInstance().getConnectionName(this.getConnection()), "select tablespace_name from dba_tablespaces order by tablespace_name");
                    sQLComboxModel.setDelayed(true);
                }
            }
            catch (Exception exception) {
                this.logger.severe(ControlsArb.getString("DBObjectSearch.2") + exception.getMessage());
            }
        }
        return sQLComboxModel;
    }

    private void initTypeUsage() {
        String string = this.getConnectionName();
        try {
            Version version = RaptorVersionTracker.getDbVersion(Connections.getInstance().getConnection(string));
            if (version != null) {
                this.includeIds = new Version("11").compareTo(version) <= 0;
                boolean bl = this.includeStmts = new Version("12.2").compareTo(version) <= 0;
                if (this.isAddType()) {
                    this.initCmbType();
                }
                if (this.isAddUsage()) {
                    this.initCmbUsage();
                }
            }
        }
        catch (DBException dBException) {
            this.cmbUsage.setEnabled(false);
            this.cmbType.setEnabled(false);
        }
    }

    private void initCmbType() {
        this.cmbType.removeAllItems();
        if (this.getTypes() != null) {
            for (String string : this.getTypes()) {
                this.cmbType.addItem(string);
            }
        } else {
            if (this.includeIds) {
                this.cmbType.addItem(ALL);
            }
            for (String string : objTypes) {
                this.cmbType.addItem(string);
            }
            if (this.includeIds) {
                for (String string : identifierTypes) {
                    this.cmbType.addItem(string);
                }
            }
            this.cmbType.addItem(allSource);
        }
        this.cmbType.setEnabled(true);
    }

    private String getDefaultType() {
        if (this.getTypes() != null) {
            String[] stringArray = this.getTypes();
            return stringArray[0];
        }
        return allObjects;
    }

    private void initCmbUsage() {
        this.cmbUsage.removeAllItems();
        if (this.includeIds) {
            for (String string : identifierUsages) {
                this.cmbUsage.addItem(string);
            }
            this.cmbUsage.setEnabled(true);
        } else {
            this.cmbUsage.setEnabled(false);
        }
    }

    protected Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (DBException dBException) {
            this.logger.severe(ControlsArb.getString("DBObjectSearch.0") + dBException.getMessage());
            return null;
        }
    }

    protected String getSchemaName() {
        block8: {
            if (this.isAddSchema()) {
                try {
                    return this.cmbSchema.getSelectedItem().toString();
                }
                catch (Exception exception) {
                    if (this.getConnection() == null) break block8;
                    try {
                        if (this._isMultipleSchemasEnabled && this._schemaNames != null && this._schemaNames.length > 0) {
                            return this._schemaNames[0];
                        }
                        Connection connection = this.getConnection();
                        if (connection != null && connection instanceof OracleConnection) {
                            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                            dBUtil.setRaiseError(false);
                            String string = dBUtil.executeReturnOneCol("select USER from dual");
                            if (string != null) {
                                return string;
                            }
                        }
                        return this.getConnection().getMetaData().getUserName();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return ALL;
    }

    protected String getTableSpaceName() {
        block6: {
            if (this.isAddTableSpace()) {
                try {
                    String string = this.cmbTablespace.getSelectedItem().toString();
                    return string;
                }
                catch (Exception exception) {
                    if (this.getConnection() == null) break block6;
                    try {
                        if (this._tablespaceNames != null) {
                            return this._tablespaceNames[0];
                        }
                        return null;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    protected String getType() {
        if (this.isAddType()) {
            try {
                return this.cmbType.getSelectedItem().toString();
            }
            catch (Exception exception) {
                return this.getDefaultType();
            }
        }
        return null;
    }

    protected String getUsage() {
        if (this.isAddUsage()) {
            try {
                return this.cmbUsage.getSelectedItem().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Query newQuery(String string, String string2) {
        return this.isAddTableSpace() ? new Query(string, string2, this.getTableSpaceName()) : new Query(string, string2);
    }
}

