/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.sql.Connection;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizardCommitListener;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnPanel;
import oracle.dbtools.raptor.data.ui.ColumnShuttlePanel;
import oracle.dbtools.raptor.data.ui.DataPreviewPage;
import oracle.dbtools.raptor.data.ui.DataSummaryPage;
import oracle.dbtools.raptor.data.ui.DataTestPage;
import oracle.dbtools.raptor.data.ui.ExternalOptions;
import oracle.dbtools.raptor.data.ui.ImportMetadataPanel;
import oracle.dbtools.raptor.data.ui.ImportMethodPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class DataWizard
extends AbstractMenuAction {
    private static DataWizard m_instance = null;
    public static final String DATA_WIZARD_NAME = "raptor.dataWizard";
    public static final int DATA_WIZARD_ACTION = Ide.findOrCreateCmdID((String)"raptor.dataWizard");
    public static final String DATA_WIZARD_IS_CART = "DATA_WIZARD_IS_CART";
    public static final String DATA_WIZARD_IS_DROP = "DATA_WIZARD_IS_DROP";
    public static final String DATA_WIZARD_FILE_URL = "DATA_WIZARD_FILE_URL";
    public static final String DATA_WIZARD_CONFIG_URL = "DATA_WIZARD_CONFIG_URL";
    public static final String DATA_WIZARD_CONFIG_TYPE = "DATA_WIZARD_CONFIG_TYPE";
    public static final String DATA_WIZARD_EXTRACT_OBJECT = "DATA_WIZARD_EXTRACT_OBJECT";
    public static final int DATA_WIZARD_NO_CONFIG = 0;
    public static final int DATA_WIZARD_SELECTED_CONFIG = 1;
    public static final int DATA_WIZARD_NEW_CONFIG = 1;
    public static final int DATA_WIZARD_AUTO_CONFIG = 3;
    public static final String HELP_DATA_PREVIEW = "f1_importdatadatapreview_html";
    public static final String HELP_DATA_PREVIEW_CART = "f1_importdatadatapreviewcart_html";
    public static final String HELP_LOAD_METHOD = "f1_importloadmethod_html";
    public static final String HELP_LOAD_METADATA = "f1_importloadmetadata_html";
    public static final String HELP_FILE = "f1_helpdatawizardfile_html";
    public static final String HELP_CHOOSE_COLUMNS = "f1_importdatachoosecolumns_html";
    public static final String HELP_DEFINE_COLUMNS = "f1_importdatadefinecolumns_html";
    public static final String HELP_DATA_TEST = "f1_dataTest_html";
    public static final String HELP_SUMMARY = "f1_importdatasummary_html";
    public static final String HELP_SUMMARY_CART = "f1_importdatasummarycart_html";
    public static final String TRANSITION_TEST = "TEST";
    public static final String TRANSITION_EXTERNAL = "EXTERNAL";
    public static final String TRANSITION_FINAL = "FINAL";
    private Namespace initialData;
    private WizardDialog wiz;
    private DBObject dbo;
    private boolean _isCart = false;
    private boolean _isDWCS = false;
    private static final FileNameExtensionFilter CONFIG_FILTER = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");

    private FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DataImportArb.getString("WIZARD_PREVIEW_DATA"), DataPreviewPage.class, this._isCart ? HELP_DATA_PREVIEW_CART : HELP_DATA_PREVIEW);
        Step step2 = new Step(DataImportArb.getString("WIZARD_LOAD_METHOD"), ImportMethodPanel.class, HELP_LOAD_METHOD);
        Step step3 = new Step(DataImportArb.getString("WIZARD_LOAD_METADATA"), ImportMetadataPanel.class, HELP_LOAD_METADATA);
        Step step4 = new Step(DataImportArb.getString("WIZARD_CHOOSE_COLUMNS"), ColumnShuttlePanel.class, HELP_CHOOSE_COLUMNS);
        Step step5 = new Step(DataImportArb.getString("WIZARD_DEFINE_COLUMNS"), ColumnPanel.class, HELP_DEFINE_COLUMNS);
        Step step6 = new Step(Messages.getString("DataWizard.0"), ExternalOptions.class, "f1_importoptions_html");
        Step step7 = new Step(Messages.getString("DataWizard.3"), DataTestPage.class, HELP_DATA_TEST);
        Step step8 = new Step(Messages.getString("DataWizard.1"), DataSummaryPage.class, this._isCart ? HELP_SUMMARY_CART : HELP_SUMMARY);
        String string = this.dbo != null ? step2.getTraversableClass().getSimpleName() : step3.getTraversableClass().getSimpleName();
        String string2 = step4.getTraversableClass().getSimpleName();
        String string3 = step5.getTraversableClass().getSimpleName();
        String string4 = step6.getTraversableClass().getSimpleName();
        String string5 = step7.getTraversableClass().getSimpleName();
        String string6 = step8.getTraversableClass().getSimpleName();
        fSMBuilder.newStartState(step, (Object)string2);
        fSMBuilder.setDefaultTrans((Object)string);
        fSMBuilder.addStateTrans((Object)true, (Object)string2);
        fSMBuilder.addStateTrans((Object)false, (Object)string);
        if (this.dbo != null) {
            fSMBuilder.newState((Object)string, step2, (Object)string2);
        } else {
            fSMBuilder.newState((Object)string, step3, (Object)string2);
        }
        fSMBuilder.addStateTrans((Object)true, (Object)string3);
        fSMBuilder.addStateTrans((Object)false, (Object)string2);
        fSMBuilder.newState((Object)string2, step4, (Object)string3);
        fSMBuilder.newState((Object)string3, step5, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINAL, (Object)string6);
        if (!this._isDWCS) {
            fSMBuilder.addStateTrans((Object)TRANSITION_EXTERNAL, (Object)string4);
            fSMBuilder.newState((Object)string4, step6, (Object)string6);
            fSMBuilder.addStateTrans((Object)TRANSITION_FINAL, (Object)string6);
        } else {
            fSMBuilder.addStateTrans((Object)TRANSITION_TEST, (Object)string5);
            fSMBuilder.addStateTrans((Object)TRANSITION_EXTERNAL, (Object)string4);
            fSMBuilder.newState((Object)string5, step7, (Object)string6);
            fSMBuilder.addStateTrans((Object)TRANSITION_FINAL, (Object)string6);
            fSMBuilder.newState((Object)string4, step6, (Object)string6);
            fSMBuilder.addStateTrans((Object)TRANSITION_FINAL, (Object)string6);
        }
        fSMBuilder.newFinalState((Object)string6, step8);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public static DataWizard getInstance() {
        if (m_instance == null) {
            m_instance = new DataWizard();
        }
        return m_instance;
    }

    public static void main(String[] stringArray) {
        DataWizard dataWizard = new DataWizard();
        dataWizard.launch();
    }

    public WizardDialog getWizard() {
        Connection connection;
        Object object;
        Context context = this.getContext();
        this.initialData = new Namespace();
        ImportProperties importProperties = new ImportProperties();
        this.initialData.put("IMPORT_PROPERTIES", (Object)importProperties);
        context.setProperty("IMPORT_PROPERTIES", (Object)importProperties);
        importProperties.put(ImportKeys.DBOBJECT, this.dbo);
        if (this.dbo != null) {
            object = this.dbo.getConnectionName();
            importProperties.put(ImportKeys.CONNECTION_NAME, object);
            try {
                connection = Connections.getInstance().getConnection((String)object);
                this._isDWCS = DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"dbms_cloud");
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            importProperties.put(ImportKeys.IS_DWCS, this._isDWCS);
        }
        if ((object = (URL)context.getProperty(DATA_WIZARD_CONFIG_URL)) == null) {
            importProperties.put(ImportKeys.IS_CONFIGFILE, false);
        } else {
            importProperties.put(ImportKeys.IS_CONFIGFILE, true);
        }
        importProperties.put(ImportKeys.INITIAL_CONFIG_URL, (URL)context.getProperty(DATA_WIZARD_CONFIG_URL));
        importProperties.put(ImportKeys.INITIAL_FILE_URL, (URL)context.getProperty(DATA_WIZARD_FILE_URL));
        importProperties.put(ImportKeys.EXTRACT_OBJECT, (ExtractObject)context.getProperty(DATA_WIZARD_EXTRACT_OBJECT));
        if (context.getProperty(DATA_WIZARD_IS_CART) != null) {
            this._isCart = context.getBoolean(DATA_WIZARD_IS_CART);
            importProperties.put(ImportKeys.IS_CART, this._isCart);
            this._isCart = context.getBoolean(DATA_WIZARD_IS_CART);
        } else {
            importProperties.put(ImportKeys.IS_CART, false);
        }
        if (context.getProperty(DATA_WIZARD_IS_DROP) != null) {
            importProperties.put(ImportKeys.IS_DROP, context.getBoolean(DATA_WIZARD_IS_DROP));
        } else {
            importProperties.put(ImportKeys.IS_DROP, false);
        }
        importProperties.put(ImportKeys.OBJECTACTION, (Object)this.getObjectAction());
        this.setBlockOACRefresh(true);
        connection = this.getFSM();
        FSMWizard fSMWizard = new FSMWizard((FSM)connection, this.initialData);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        if (this._isCart || this._isDWCS) {
            fSMWizard.addCommitListener((CommitListener)new DataWizardCommitListener());
        }
        bigWizardDialog.setPreferredSize(new Dimension(1024, 640));
        fSMWizard.setWizardTitle(DataImportArb.getString("WIZARD_DATA_IMPORT_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DataImportArb.getImage("WIZARD_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DATA_WIZARD_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    @Override
    public void setArgs(String string) {
    }

    @Override
    public void launch() {
        this.runDialog();
    }

    public boolean runDialog() {
        ColumnMapMediator.getInstance().clearMap();
        this.dbo = this.getDBObject();
        this.wiz = this.getWizard();
        return WizardLauncher.runDialog((JDialog)this.wiz);
    }

    public static class DataController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                DataWizard.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

