/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportXMLUtil;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DataWizardCommitListener
implements CommitListener {
    private ImportProperties _iProps;
    private boolean _isCart = false;
    private boolean _isDWCS = false;
    private static final FileNameExtensionFilter CONFIG_FILTER = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    private JEWTDialog _actionDialog;
    private TargetOptionsPanel _targetOptions;
    private TargetFormat _targetFormat;
    private String _fileName;

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        SwingUtilities.invokeLater(() -> {
            TraversableContext traversableContext = applyEvent.getTraversableContext();
            this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
            this._isDWCS = this._iProps.getValueBoolean(ImportKeys.IS_DWCS);
            this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
            if (this._isDWCS && !this._isCart) {
                this.cleanupTest(this._iProps);
            } else {
                this.saveConfig(this._iProps);
                DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
                if (dataPreviewGizmo != null) {
                    try {
                        dataPreviewGizmo.commit(null);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                    }
                }
            }
        });
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        SwingUtilities.invokeLater(() -> {
            TraversableContext traversableContext = applyEvent.getTraversableContext();
            this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
            if (this._iProps != null) {
                this._isDWCS = this._iProps.getValueBoolean(ImportKeys.IS_DWCS);
                this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
                if (this._isDWCS && !this._isCart) {
                    this.cleanupTest(this._iProps);
                } else {
                    DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
                    if (dataPreviewGizmo != null) {
                        try {
                            dataPreviewGizmo.cancel(null);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupTest(ImportProperties importProperties) {
        if (this._iProps.getValueBoolean(ImportKeys.IS_CLEANUP_TEST_NEEDED).booleanValue()) {
            this._iProps.put(ImportKeys.IS_CLEANUP_TEST_NEEDED, false);
            ImportGenerator importGenerator = (ImportGenerator)this._iProps.get(ImportKeys.TEST_GENERATOR);
            this._iProps.put(ImportKeys.TEST_GENERATOR, null);
            Connection connection = null;
            if (importGenerator != null) {
                try {
                    connection = Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
                    if (Connections.getInstance().lock(connection)) {
                        importGenerator.cleanUpTest();
                    }
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                }
                catch (Exception exception) {
                    try {
                        ExceptionHandler.handleException((Throwable)exception);
                        if (connection != null) {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            Connections.getInstance().unlock(connection);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public void saveConfig(ImportProperties importProperties) {
        this._iProps = importProperties;
        try {
            ExtractObject extractObject = (ExtractObject)this._iProps.get(ImportKeys.EXTRACT_OBJECT);
            if (extractObject != null) {
                extractObject.isPreSelected(extractObject.getConfigUrl() != null);
                extractObject.setImportProperties(this._iProps);
                if (this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                    try {
                        extractObject.setUrl(new URL((String)this._iProps.get(ImportKeys.OSS_PATH)));
                    }
                    catch (Exception exception) {
                        Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getMessage(), exception);
                    }
                } else {
                    extractObject.setUrl(((LoadFile)this._iProps.get(ImportKeys.LOAD_FILE)).getURL());
                }
                String string = (String)this._iProps.get(ImportKeys.TABLE_NAME);
                if (!string.startsWith("\"")) {
                    string = string.toUpperCase();
                }
                extractObject.setTableName(string);
                DBObject dBObject = extractObject.getDBObject();
                if (dBObject != null) {
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", dBObject.getConnectionName(), null, dBObject.getSchemaName(), dBObject.getObjectType());
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, string);
                    extractObject.setDBObjectForMetaData(new DBObject(uRL2));
                }
                this.showDialog();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void showDialog() {
        int n;
        Object object;
        Object object2;
        final ExtractObject extractObject = (ExtractObject)this._iProps.get(ImportKeys.EXTRACT_OBJECT);
        String string = DataImportArb.getString("SAVE_CONFIG_DIALOG_TITLE");
        String string2 = DataImportArb.getString("SAVE_CONFIG_INSTRUCTIONS");
        String string3 = DataImportArb.getString("SAVE_CONFIG_INSTRUCTIONS2");
        JLabel jLabel = new JLabel(string2);
        JLabel jLabel2 = new JLabel(string3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_saveimportconfig_html");
        this._targetFormat = new TargetFormat(1, 3);
        this._targetFormat.setShowEncoding(true);
        this._targetFormat.setEncoding(IdeUtil.getIdeEncoding());
        this._targetFormat.setShowCompression(false);
        this._targetFormat.setShowSaveAsType(false);
        this._targetFormat.isCompressed(false);
        this._targetFormat.setSaveAsType(0);
        URL uRL = extractObject.getConfigUrl();
        if (uRL != null) {
            this._fileName = uRL.getFile();
        } else {
            Object object3;
            object2 = extractObject.getUrl();
            object = ((URL)object2).getFile();
            n = ((String)object).lastIndexOf(".");
            if (n < 0) {
                n = 0;
            }
            String string4 = ((String)object).substring(n + 1);
            String string5 = null;
            if (extractObject.isTypeDataFileLocal()) {
                string5 = ((String)object).substring(0, n) + "_" + ((String)object).substring(n + 1, ((String)object).length()) + ".sdimp";
            } else {
                object3 = this._targetFormat.getDefaultDirectory();
                if (object3 == null || ((String)object3).isEmpty()) {
                    object3 = Ide.getUserSettingsDirectory();
                }
                int n2 = ((String)object).lastIndexOf("/");
                if (!((String)object3).endsWith(File.separator)) {
                    object3 = (String)object3 + File.separator;
                }
                string5 = (String)object3 + ((String)object).substring(n2 < 0 ? 0 : n2 + 1, n) + ".sdimp";
            }
            object3 = new File(string5);
            try {
                this._fileName = ((File)object3).getPath();
            }
            catch (Exception exception) {
                Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
            }
        }
        this._targetFormat.setSaveAs(this._fileName);
        this._targetOptions = new TargetOptionsPanel(jPanel, this._targetFormat);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (extractObject != null && uRL == null) {
            jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(16, 0, 0, 0), 0, 0));
        }
        jPanel.add((Component)this._targetOptions.getPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        object2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DataWizardCommitListener.this._targetFormat = DataWizardCommitListener.this._targetOptions.getFormat();
                    DataWizardCommitListener.this._fileName = DataWizardCommitListener.this._targetFormat.getSaveAs();
                    if (DataWizardCommitListener.this._fileName != null && !DataWizardCommitListener.this._fileName.contains(".sdimp")) {
                        DataWizardCommitListener.this._fileName = DataWizardCommitListener.this._fileName + ".sdimp";
                        DataWizardCommitListener.this._targetFormat.setSaveAs(DataWizardCommitListener.this._fileName);
                    }
                    if ((n = DataWizardCommitListener.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow())) == 1) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataWizardCommitListener.this._targetFormat.getValidationMessage(), (String)DataImportArb.getString("OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
                        DataWizardCommitListener.this._fileName = null;
                    } else if (n == 0) {
                        File file = new File(DataWizardCommitListener.this._fileName);
                        ImportXMLUtil importXMLUtil = new ImportXMLUtil();
                        importXMLUtil.saveConfigOptions(file, DataWizardCommitListener.this._iProps, DataWizardCommitListener.this._targetFormat.getEncoding());
                        file = new File(DataWizardCommitListener.this._fileName);
                        try {
                            extractObject.setConfigUrl(file.toURI().toURL());
                            extractObject.isPreSelected(true);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                        }
                        DataWizardCommitListener.this._actionDialog.setVisible(false);
                        DataWizardCommitListener.this._actionDialog.dispose();
                    }
                }
            }
        };
        this._actionDialog.addActionListener((ActionListener)object2);
        object = jPanel.getPreferredSize();
        n = (int)((Dimension)object).getHeight() + 100;
        int n3 = (int)((Dimension)object).getWidth() + 200;
        this._actionDialog.setMinimumSize(n3, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
        WizardLauncher.runDialog((JDialog)this._actionDialog);
    }
}

