/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.formattors;

import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import oracle.dbtools.data.formattors.NumberFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NumberFormattorImport
extends NumberFormattor {
    Character _nlsDecimalSeparator;

    public void setNlsDecimalSeparator(Character c) {
        this._nlsDecimalSeparator = c;
    }

    public String formatData(Object object, Column column) {
        String string = "NULL";
        if (object != null) {
            String string2 = object.toString();
            NumberFormat numberFormat = null;
            ParsePosition parsePosition = new ParsePosition(0);
            numberFormat = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
            if (this._nlsDecimalSeparator != null && numberFormat instanceof DecimalFormat) {
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator(this._nlsDecimalSeparator.charValue());
                ((DecimalFormat)numberFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            }
            try {
                if (numberFormat instanceof DecimalFormat) {
                    ((DecimalFormat)numberFormat).setParseBigDecimal(true);
                    string = "" + ((BigDecimal)numberFormat.parse(string2, parsePosition)).toPlainString();
                } else {
                    string = column.getPrecision() > 0 && column.getScale() > 0 || column.getPrecision() == 0 && column.getScale() == 0 || this.isScaleImported() ? "" + ((BigDecimal)numberFormat.parse(string2, parsePosition)).doubleValue() : "" + ((BigDecimal)numberFormat.parse(string2, parsePosition)).longValue();
                }
            }
            catch (Exception exception) {
                string = string2;
            }
            if (parsePosition.getIndex() < string2.length()) {
                return string2;
            }
        }
        if (string.length() == 0) {
            return "NULL";
        }
        return string;
    }

    public Object formatDataForJava(Object object, Column column) throws Exception {
        String string = this.formatData(object, column);
        if (this.getConnection() != null && string != null) {
            String string2 = "" + ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.getConnection())).getDecimalSeparator();
            string = string.replace(".", string2);
        }
        return string;
    }
}

