/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderEvent;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderListener;

public abstract class DataReader
implements DataReadable {
    public static String NAME;
    public static String EXT;
    private String m_filename;
    private ArrayList<DataReaderListener> m_listeners = new ArrayList();
    private String defColumn = DataImportArb.getString("DEFAULT_COLUMN_PREFIX");
    protected String[] m_defaultColumnNames;
    protected String[] m_headerRowColumnNames;
    private String[] m_userDefaultColumnNames;
    private boolean m_isUserDefaultColumnNames = false;
    protected boolean m_refreshPreview = true;
    protected boolean m_showPreviewMessages = true;
    protected ImportDataFormat dataFormat;
    private int m_headerLocation = 0;

    @Override
    public abstract List<Object[]> getPreviewRows();

    @Override
    public void setDataFormat(ImportDataFormat importDataFormat) {
        this.dataFormat = importDataFormat;
    }

    @Override
    public void setFileName(String string) throws DataReaderException {
        this.m_filename = string;
        this.openFile(string);
    }

    @Override
    public String getFileName() {
        return this.m_filename;
    }

    @Override
    public void fireListeners(DataReaderEvent dataReaderEvent) {
        for (DataReaderListener dataReaderListener : this.getListeners()) {
            dataReaderListener.raiseEvent(dataReaderEvent);
        }
    }

    @Override
    public void fireSimpleEvent(String string) {
        DataReaderEvent dataReaderEvent = new DataReaderEvent(string);
        this.fireListeners(dataReaderEvent);
    }

    @Override
    public ArrayList<DataReaderListener> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        return this.m_listeners;
    }

    @Override
    public void addListener(DataReaderListener dataReaderListener) {
        this.getListeners().add(dataReaderListener);
    }

    @Override
    public TableModel getTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        List<Object[]> list = null;
        list = this.getPreviewRows();
        Iterator<Object[]> iterator = list.iterator();
        if (iterator.hasNext()) {
            if (this.dataFormat.isHeader()) {
                iterator.next();
            }
            String[] stringArray = this.getColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultTableModel.addColumn(stringArray[i]);
            }
        }
        while (iterator.hasNext()) {
            defaultTableModel.addRow(iterator.next());
        }
        return defaultTableModel;
    }

    @Override
    public void refreshPreview(boolean bl) {
        this.m_refreshPreview = bl;
    }

    @Override
    public boolean refreshPreview() {
        return this.m_refreshPreview;
    }

    @Override
    public void showPreviewMessages(boolean bl) {
        this.m_showPreviewMessages = bl;
    }

    @Override
    public void setDefaultColumnNames(String[] stringArray) {
        this.m_userDefaultColumnNames = stringArray;
        this.m_isUserDefaultColumnNames = true;
    }

    public boolean isUserDefaultColumnNames() {
        return this.m_isUserDefaultColumnNames;
    }

    public String[] getUserDefaultColumnNames() {
        return this.m_userDefaultColumnNames;
    }

    public String[] getDefaultColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            arrayList.add(this.getDefColumn() + (i + 1));
        }
        this.m_defaultColumnNames = arrayList.toArray(new String[arrayList.size()]);
        return this.m_defaultColumnNames;
    }

    public String getDefColumn() {
        return this.defColumn.toUpperCase();
    }

    public void setDefColumn(String string) {
        this.defColumn = string;
    }

    @Override
    public abstract Object[] readline() throws DataFormatException;

    @Override
    public String readCurrentLine() throws DataFormatException {
        return "";
    }

    @Override
    public boolean isOracleLoaderReadable() {
        return true;
    }

    @Override
    public boolean isEncodingAllowed() {
        return true;
    }

    public boolean isHeaderOptionSupported() {
        return true;
    }

    public boolean isHeader() {
        return this.dataFormat != null ? this.dataFormat.isHeader() : false;
    }

    @Override
    public boolean isSkipSupported() {
        return true;
    }

    @Override
    public boolean isPreviewLimitSupported() {
        return true;
    }

    @Override
    public boolean isHeaderLocationSupported() {
        return true;
    }

    @Override
    public int getHeaderLocation() {
        return this.m_headerLocation;
    }

    @Override
    public void setHeaderLocation(int n) {
        this.m_headerLocation = n;
    }

    public boolean isLineTerminatorSupported() {
        return false;
    }

    public String getLineTerminator() {
        return this.dataFormat != null ? this.dataFormat.getRecordTerminator() : "";
    }

    public String getLineTerminatorConfigKey() {
        return "";
    }

    public boolean isDelimiterSupported() {
        return false;
    }

    public boolean isDelimiterConfigurable() {
        return false;
    }

    public String getDefaultDelimiter() {
        return "";
    }

    public String getDelimiter() {
        return this.dataFormat != null ? this.dataFormat.getDelimiter() : "";
    }

    public String getDelimiterConfigKey() {
        return "";
    }

    public boolean isEnclosuresSupported() {
        return false;
    }

    public boolean isEnclosed() {
        return this.dataFormat != null ? this.dataFormat.getEnclosures() : false;
    }

    public String getEnclosureLeft() {
        return this.dataFormat != null ? this.dataFormat.getEnclosureLeft() : "";
    }

    public String getEnclosureRight() {
        return this.dataFormat != null ? this.dataFormat.getEnclosureRight() : "";
    }

    public String getEnclosuresConfigKey() {
        return "";
    }

    public String getEnclosureLeftConfigKey() {
        return "";
    }

    public String getEnclosureRightConfigKey() {
        return "";
    }

    public String getEnclosureRightDoubleConfigKey() {
        return "";
    }

    public boolean isEnclosureRightDoubleConfigurable() {
        return true;
    }
}

