/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnDefinitionDetective;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.javatools.util.ModelUtil;

public class ColumnPropertiesPanel
extends ColumnPropertyPanel {
    private static final long serialVersionUID = -320015483611378667L;
    private LoadFile _loadFile;
    private ItemListener columnListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                switch ((DataType)((Object)jComboBox.getSelectedItem())) {
                    case DATE: 
                    case TIMESTAMP: 
                    case TIMESTAMPTZ: 
                    case TIMESTAMPLTZ: {
                        ColumnPropertiesPanel.this.addDateMask((String)ColumnPropertiesPanel.this.dateMask.getEditor().getItem());
                    }
                }
            }
        }
    };
    private ItemListener _precisionItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                int n = 0;
                try {
                    n = Integer.parseInt(((JTextField)((JComboBox)ColumnPropertiesPanel.this.precisionField).getEditor().getEditorComponent()).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ColumnPropertiesPanel.this.column.setPrecision(n);
                ColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertiesPanel.this.column, ColumnChangeEvent.Type.PRECISION));
            }
        }
    };
    private DocumentListener _precisionDocumentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        void valueChanged(DocumentEvent documentEvent) {
            String string = "";
            int n = 0;
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ColumnPropertiesPanel.this.column.setPrecision(n);
            ColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertiesPanel.this.column, ColumnChangeEvent.Type.PRECISION));
        }
    };
    private DocumentListener _scaleDocumentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        void valueChanged(DocumentEvent documentEvent) {
            String string = "";
            int n = 0;
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ColumnPropertiesPanel.this.column.setScale(n);
            ColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertiesPanel.this.column, ColumnChangeEvent.Type.SCALE));
        }
    };

    public ColumnPropertiesPanel(ImportProperties importProperties) {
        this(importProperties, null);
    }

    public ColumnPropertiesPanel(ImportProperties importProperties, DataType[] dataTypeArray) {
        super(importProperties);
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this.typeField = new JComboBox<DataType>(dataTypeArray == null ? DataType.values() : dataTypeArray);
        this.add(this.typeField, this.typeFieldConstraints);
        ((JComboBox)this.typeField).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                DataType dataType = (DataType)((Object)jComboBox.getSelectedItem());
                switch (dataType) {
                    case DATE: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addDateMask();
                        ColumnPropertiesPanel.this.setDateMaskModel(dataType.toString());
                        break;
                    }
                    case INTEGER: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case NUMBER: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addPrecisionScale();
                        ColumnPropertiesPanel.this.enableScale();
                        ColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case TIMESTAMP: 
                    case TIMESTAMPTZ: 
                    case TIMESTAMPLTZ: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addPrecision();
                        ColumnPropertiesPanel.this.addDateMask();
                        ColumnPropertiesPanel.this.setDateMaskModel(dataType.toString());
                        break;
                    }
                    default: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addPrecision();
                        ColumnPropertiesPanel.this.removeDateMask();
                    }
                }
                ColumnPropertiesPanel.this.getColumnDetails();
                ColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertiesPanel.this.column, ColumnChangeEvent.Type.DATATYPE));
            }
        });
        ((JComboBox)this.typeField).addItemListener(this.columnListener);
        this.precisionField = new JComboBox();
        ((JComboBox)this.precisionField).setEditable(true);
        this.precisionField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                String string2 = "";
                if (ColumnPropertiesPanel.this.typeField instanceof JComboBox) {
                    string = ((JComboBox)focusEvent.getSource()).getSelectedItem().toString();
                    string2 = ((JComboBox)ColumnPropertiesPanel.this.typeField).getSelectedItem().toString();
                } else if (ColumnPropertiesPanel.this.typeField instanceof JTextField) {
                    string = ((JTextField)focusEvent.getSource()).getText();
                    string2 = ((JTextField)ColumnPropertiesPanel.this.typeField).getText();
                }
                ColumnPropertiesPanel.this.scaleField.setEnabled(false);
                if (ModelUtil.hasLength((String)string) && DataType.NUMBER.toString().equals(string2) && Integer.parseInt(string.trim()) > 0) {
                    ColumnPropertiesPanel.this.scaleField.setEnabled(true);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.addPrecisionItemListener();
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        this.nameField = new JTextField();
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            void valueChanged(DocumentEvent documentEvent) {
                String string = "";
                try {
                    string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ColumnPropertiesPanel.this.column.setName(string);
                ColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertiesPanel.this.column, ColumnChangeEvent.Type.NAME));
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.nameField, gridBagConstraints);
    }

    public void addPrecisionDocumentListener() {
        if (this.precisionField instanceof JComboBox) {
            ((JTextField)((JComboBox)this.precisionField).getEditor().getEditorComponent()).getDocument().addDocumentListener(this._precisionDocumentListener);
        }
    }

    public void removePrecisionDocumentListener() {
        if (this.precisionField instanceof JComboBox) {
            ((JTextField)((JComboBox)this.precisionField).getEditor().getEditorComponent()).getDocument().removeDocumentListener(this._precisionDocumentListener);
        }
    }

    public void addPrecisionItemListener() {
        if (this.precisionField instanceof JComboBox) {
            ((JComboBox)this.precisionField).addItemListener(this._precisionItemListener);
        }
    }

    public void removePrecisionItemListener() {
        if (this.precisionField instanceof JComboBox) {
            ((JComboBox)this.precisionField).removeItemListener(this._precisionItemListener);
        }
    }

    public void addScaleDocumentListener() {
        this.scaleField.getDocument().addDocumentListener(this._scaleDocumentListener);
    }

    public void removeScaleDocumentListener() {
        this.scaleField.getDocument().removeDocumentListener(this._precisionDocumentListener);
    }

    @Override
    void switchColumn(Column column) {
        Column column2 = null;
        if (column != null) {
            column2 = this.m_table.getSrcColName(column.getName());
        }
        if (column2 == null) {
            column2 = this.m_table.getColumnByName(column.getName());
        }
        if (column2 == null) {
            this.m_table.addColumn(column);
        }
        if (column != null) {
            this.setColumn(column);
        }
    }

    @Override
    void setTable(GenericTable genericTable) {
        this.m_table = genericTable.getTable();
        for (Column column : this.m_table.getColumns()) {
        }
    }

    @Override
    void setColumnName(String string) {
        this.nameField.setText(string);
    }

    @Override
    void setDataType(String string) {
        if (string != null) {
            ComboBoxModel comboBoxModel = ((JComboBox)this.typeField).getModel();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                DataType dataType = (DataType)((Object)comboBoxModel.getElementAt(i));
                if (!string.toUpperCase().equals(dataType.toString())) continue;
                ((JComboBox)this.typeField).setSelectedIndex(i);
                return;
            }
        } else {
            ((JComboBox)this.typeField).setSelectedIndex(0);
        }
    }

    @Override
    public Column getColumnDetails() {
        int n;
        Column column = new Column();
        column.setName(this.nameField.getText());
        column.setType(((DataType)((Object)((JComboBox)this.typeField).getSelectedItem())).toString());
        if (this.scaleField.getText() != null && !this.scaleField.getText().equals("")) {
            column.setScale(Integer.parseInt(this.scaleField.getText()));
        }
        if ((n = this.getPrecision()) == 0) {
            LoadField loadField = this._loadFile.getFieldByName(column.getName());
            n = loadField.getDetectedPrecision();
            column.setPrecision(ColumnDefinitionDetective.getDefaultPrecision(n, column.getType()));
        } else {
            column.setPrecision(n);
        }
        column.setNullable(this.nullCheck.isSelected());
        column.setComment(this.commentArea.getText());
        column.setDefault(this.defaultField.getText());
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(column.getType())) {
            column.setFormat((String)this.dateMask.getEditor().getItem());
            this.addDateMask(column.getFormat());
        }
        if (column.getType().equals(DataType.VARCHAR2.toString()) && column.getScale() < 1) {
            column.setScale(0);
        }
        this.column = column;
        return column;
    }

    public void enableComment(boolean bl) {
        this.commentArea.setEnabled(bl);
        this.commentLabel.setEnabled(bl);
    }

    @Override
    void setColumn(Column column) {
        Object object;
        this.column = column;
        this.setColumnName(column.getName());
        if (this.precisionField instanceof JComboBox) {
            this.removePrecisionDocumentListener();
            ((JComboBox)this.precisionField).removeAllItems();
            this.addPrecisionDocumentListener();
        }
        int n = column.getPrecision();
        if (column.getSourceColID() != -1) {
            object = this._loadFile.getField(column.getSourceColID());
            n = object.getDetectedPrecision();
        }
        this.setPrecision(column.getPrecision(), n, column.getType());
        this.removeScaleDocumentListener();
        this.setScale(column.getScale());
        this.addScaleDocumentListener();
        this.setNullable(column.isNullable());
        this.defaultField.setText(column.getDefault());
        this.setComment(column.getComment());
        object = column.getFormat();
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(column.getType())) {
            this.setDateMaskModel(column.getType(), column.getFormat());
        }
        this.setDataType(column.getType());
        this.setDateMask((String)(object != null ? object : ""));
    }

    protected void setPrecision(int n, int n2, String string) {
        if (this.precisionField != null) {
            String string2 = String.valueOf(n);
            if (this.precisionField instanceof JComboBox) {
                this.removePrecisionItemListener();
                this.removePrecisionDocumentListener();
                JComboBox jComboBox = (JComboBox)this.precisionField;
                int n3 = ColumnDefinitionDetective.getRoundedPrecision(n2, string);
                int n4 = ColumnDefinitionDetective.getMaxPrecision(n2, string);
                this.addPrecisionItems(n2, this._isRounded ? n3 : n2, n4);
                this.addComboNum(jComboBox, n);
                jComboBox.setSelectedItem(n);
                this.addPrecisionItemListener();
                this.addPrecisionDocumentListener();
            } else {
                ((JTextField)this.precisionField).setText(string2);
            }
        }
    }

    private void addPrecisionItems(int n, int n2, int n3) {
        if (n > n2) {
            this.swap(n, n2);
        }
        JComboBox jComboBox = (JComboBox)this.precisionField;
        this.addComboNum(jComboBox, n);
        this.addComboNum(jComboBox, n2);
        this.addComboNum(jComboBox, n3);
    }

    private void swap(int n, int n2) {
        int n3 = n2;
        n2 = n;
        n = n3;
    }

    private void addComboNum(JComboBox<String> jComboBox, int n) {
        boolean bl = false;
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).equals(String.valueOf(n))) continue;
            bl = true;
        }
        if (!bl) {
            jComboBox.addItem(String.valueOf(n));
        }
    }
}

