/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizardCommitListener;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportXMLUtil;
import oracle.dbtools.raptor.data.readers.DataReader;
import oracle.dbtools.raptor.data.readers.DataReaderUtils;
import oracle.dbtools.raptor.data.readers.DelimitedReader;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataPreviewPage;
import oracle.dbtools.raptor.data.ui.DataSummaryPanel;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.writers.ImportGenHelper;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class DataSummaryPage
extends DefaultTraversablePanel {
    protected final String ENCODING = "UTF-8";
    private JPanel savePanel;
    private JButton _saveButton;
    private URLFileChooser _configChooser;
    private final FileNameExtensionFilter _configFilter = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext m_ctx;
    private DataSummaryPanel _summaryPanel = new DataSummaryPanel();
    private ImportProperties _iProps;
    private boolean _isCart = false;

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.FIELDSEPARATOR, DBConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getString("IMPORT_DELIMITER"));
        this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        this._summaryPanel.onEntry(traversableContext);
        this.build();
        this.getSaveButton().setVisible(!this._isCart || this._iProps.get(ImportKeys.INITIAL_CONFIG_URL) == null);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            ImportGenerator importGenerator;
            if (this._iProps.getValueBoolean(ImportKeys.IS_CLEANUP_TEST_NEEDED).booleanValue()) {
                this._iProps.put(ImportKeys.IS_CLEANUP_TEST_NEEDED, false);
                importGenerator = (ImportGenerator)this._iProps.get(ImportKeys.TEST_GENERATOR);
                this._iProps.put(ImportKeys.TEST_GENERATOR, null);
                Connection connection = null;
                if (importGenerator != null) {
                    try {
                        connection = Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
                        if (Connections.getInstance().lock(connection)) {
                            importGenerator.cleanUpTest();
                        }
                        if (connection != null) {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            ExceptionHandler.handleException((Throwable)exception);
                            if (connection != null) {
                                Connections.getInstance().unlock(connection);
                            }
                        }
                        catch (Throwable throwable) {
                            if (connection != null) {
                                Connections.getInstance().unlock(connection);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            this.initGenProperties();
            if (!this._isCart) {
                importGenerator = new ImportGenerator(this._iProps);
                importGenerator.gen();
            }
        }
    }

    private void initGenProperties() {
        try {
            GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (Column column : columnArray) {
                Column column2 = genericTable.getTable().getColumnByName(column.getName());
                column2.setSourceColumnName(column.getSourceColumnName());
                column2.setSourceColID(column.getSourceColID());
                column = column2;
            }
            this._iProps.put(ImportKeys.TABLE, genericTable);
            ImportWriteStream importWriteStream = DataSummaryPage.createPrintStream(this._iProps);
            this._iProps.put(ImportKeys.URL_FOR_AUTO_OPEN, importWriteStream.getURL());
            this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, importWriteStream);
            this._iProps.put(ImportKeys.IS_BATCH, false);
            this._iProps.put(ImportKeys.ERROR_LIMIT, 0);
        }
        catch (Exception exception) {
            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static ImportWriteStream createPrintStream(ImportProperties importProperties) throws IOException, UnsupportedEncodingException {
        Object object;
        String string = Ide.getEnvironOptions().getEncoding();
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        int n = 0;
        String string2 = null;
        String string3 = null;
        if (importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            string2 = (String)importProperties.get(ImportKeys.OSS_PATH);
            n = string2.lastIndexOf("/");
            string3 = ".log";
        } else {
            string2 = loadFile.getName();
            n = string2.lastIndexOf(File.separator);
            string3 = ".sql";
        }
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        string2 = string2.replace(".", "-");
        String string4 = null;
        int n2 = importProperties.getValueInteger(ImportKeys.LOAD_METHOD);
        if (n2 == 0 || n2 == 1) {
            object = DBConfig.getInstance();
            string4 = object.getString("IMPORT_INS_GEN_DIR");
            boolean bl = object.getBoolean("IMPORT_INS_GEN_TEMP");
            if (string4 == null || string4.length() == 0) {
                string4 = object.getString("IMPORTDIR");
                if (bl) {
                    try {
                        string4 = ImportWriteStream.getTempDir();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        object = new ImportWriteStream(DataImportArb.getString("IMPORT_TOOL") + "-" + string2, string, string4, string3);
        return object;
    }

    public void build() {
        JLabel jLabel = new JLabel(DataImportArb.getString("SAVE_CONFIG"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add((Component)this.getSaveButton(), "South");
        this.removeAll();
        this.add(jPanel, "North");
        this.add((Component)((Object)this._summaryPanel), "Center");
    }

    private Component getXTableComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("XTABLE_TITLE")));
        ResultSetTable resultSetTable = new ResultSetTable();
        jPanel.add((Component)((Object)resultSetTable), "Center");
        int n = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        String string = n == 3 ? ImportGenHelper.addUser(this._iProps, (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME)) : ImportGenHelper.addUser(this._iProps, (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME));
        resultSetTable.setQuery((String)this._iProps.get(ImportKeys.CONNECTION_NAME), "select * from " + string, null, null);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)resultSetTable));
        jScrollPane.setRowHeaderView(resultSetTable.getRowHeader());
        jScrollPane.setColumnHeaderView(resultSetTable.getTableHeader());
        try {
            resultSetTable.open(false);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return jScrollPane;
    }

    private Component getDDLComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextComponent jTextComponent = this.createTextPane(false);
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", (String)this._iProps.get(ImportKeys.CONNECTION_NAME), null, dBObject.getSchemaName(), "TABLE");
        URL uRL2 = DBURLFormatHelper.getURL(uRL, (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME));
        ExtractListModel extractListModel = new ExtractListModel();
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setTableDeps(false);
        dDLTypes.setShowTableDeps(false);
        extractListModel.setDDLTypes(dDLTypes);
        extractListModel.setDDLFormat(new DDLFormat());
        ExtractObject extractObject = new ExtractObject(uRL2, extractListModel);
        jTextComponent.setText(extractObject.getDDL(1));
        extractObject.setListModel(extractListModel);
        jTextComponent.setCaretPosition(0);
        jPanel.add((Component)jTextComponent, "Center");
        return jPanel;
    }

    private String getTempBadFile(String string) {
        String string2 = null;
        String string3 = (String)this._iProps.get(ImportKeys.OSS_PATH);
        int n = string3.lastIndexOf("/");
        String string4 = string3.substring(0, n);
        String string5 = (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL);
        File file = null;
        try {
            String string6 = DataUIUtils.getSample(this._iProps, string4 + "/" + string, string5);
            if (string6 != null) {
                String string7 = DataReaderUtils.getTempName("oss");
                file = File.createTempFile(string7, ".dsv");
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[string6.length()];
                byArray = string6.getBytes();
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                string2 = file.getPath();
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("OPEN_FILE_ERROR", string3, exception.getMessage()), (String)DataImportArb.getString("OPEN_FILE_ERROR_TITLE"), (String)"IMPORT_OPEN_FILE_ERROR");
            try {
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception2) {
                ExceptionHandler.handleException((Throwable)exception2);
            }
        }
        return string2;
    }

    private JPanel getBadComponents(String string) {
        boolean bl = false;
        JPanel jPanel = new JPanel(new BorderLayout(0, 16));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        DelimitedReader delimitedReader = new DelimitedReader();
        try {
            delimitedReader.setFileName(string);
            ImportDataFormat importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            bl = importDataFormat.isHeader();
            importDataFormat.isHeader(false);
            LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            String[] stringArray = new String[loadFile.getFieldCount()];
            int n = 0;
            for (LoadField loadField : loadFile.getFields()) {
                Column column = loadField.getColumn();
                if (column == null) continue;
                stringArray[n++] = ImportGenHelper.addDoubleQuote(this._iProps, column.getName());
            }
            delimitedReader.setDefaultColumnNames(stringArray);
            delimitedReader.setDataFormat(importDataFormat);
            this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, importDataFormat);
            DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo(delimitedReader);
            dataPreviewGizmo.setDataFormat(importDataFormat);
            dataPreviewGizmo.initUI();
            jPanel.add((Component)dataPreviewGizmo, "Center");
            dataPreviewGizmo.populateDataTable(delimitedReader);
            dataPreviewGizmo.resetData(true);
            delimitedReader.openFile(string);
            jPanel.add((Component)this.getUIOneCol(delimitedReader), "North");
            importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            importDataFormat.isHeader(bl);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return jPanel;
    }

    private JPanel getUIOneCol(DataReader dataReader) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("GIZMO_TITLE_RECORDS")));
        JScrollPane jScrollPane = new JScrollPane(22, 32);
        jPanel.add((Component)jScrollPane, "Center");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        while (dataReader.hasMoreRows()) {
            try {
                defaultListModel.addElement(dataReader.readCurrentLine());
            }
            catch (Exception exception) {}
        }
        JList<String> jList = new JList<String>(defaultListModel){
            private static final long serialVersionUID = 1L;
        };
        jScrollPane.setViewportView(jList);
        return jPanel;
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected JButton getSaveButton() {
        if (this._saveButton == null) {
            this._saveButton = new JButton(DataImportArb.getString("CONFIG_SAVE_STATE"));
            this._saveButton.setIcon(RaptorImagesArb.getIcon("GEAR"));
            this._saveButton.setToolTipText(DataImportArb.getString("SAVE_CONFIG_TIP"));
            this._saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSummaryPage.this.saveConfig();
                }
            });
        }
        return this._saveButton;
    }

    public void saveConfig() {
        Object object;
        File file;
        String string = DataImportArb.getString("SAVE_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_saveimportconfig_html");
        this._configChooser = new URLFileChooser();
        this._configChooser.showEncodings(true);
        this._configChooser.setSelectedURL(null);
        this._configChooser.setPathContext(DataPreviewPage.CONFIG_PATH_CONTEXT);
        URL uRL = (URL)this._iProps.get(ImportKeys.CONFIG_URL);
        if (uRL != null) {
            this._configChooser.setSelectedURL(uRL);
        } else if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            file = new File(loadFile.getName()).getParentFile();
            object = new File(file.getPath() + File.separator + loadFile.getShortName() + ".sdimp");
            try {
                this._configChooser.setSelectedFile((File)object);
            }
            catch (Exception exception) {
                Logger.getLogger(DataSummaryPage.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
            }
        }
        this._configChooser.clearChooseableURLFilters();
        this._configChooser.setFileFilter(this._configFilter);
        int n = this._configChooser.showSaveDialog((Component)((Object)this), string);
        if (n == 0) {
            file = this._configChooser.getSelectedFile();
            object = new TargetFormat(1, 1);
            ((TargetFormat)object).setSaveAsType(0);
            String string2 = null;
            if (file != null && !(string2 = file.getPath()).contains(".")) {
                string2 = string2 + ".sdimp";
                file = new File(string2);
            }
            ((TargetFormat)object).setSaveAs(string2);
            int n2 = ((TargetFormat)object).validateSaveAs((Component)((Object)this));
            if (n2 == 1) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)((TargetFormat)object).getValidationMessage(), (String)DataImportArb.getString("OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
            } else if (n2 == 0) {
                ImportXMLUtil importXMLUtil = new ImportXMLUtil();
                importXMLUtil.saveConfigOptions(file, this._iProps, this._configChooser.getEncoding());
                if (this._isCart) {
                    URL uRL2 = null;
                    try {
                        uRL2 = file.toURI().toURL();
                        if (uRL2 == null) {
                            this._iProps.put(ImportKeys.IS_CONFIGFILE, false);
                        } else {
                            this._iProps.put(ImportKeys.IS_CONFIGFILE, true);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(DataSummaryPage.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                        this._iProps.put(ImportKeys.IS_CONFIGFILE, false);
                    }
                    this._iProps.put(ImportKeys.INITIAL_CONFIG_URL, uRL2);
                }
            }
        }
    }
}

