/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizardCommitListener;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReader;
import oracle.dbtools.raptor.data.readers.DataReaderUtils;
import oracle.dbtools.raptor.data.readers.DelimitedReader;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataSummaryPage;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.writers.ImportGenHelper;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DataTestPage
extends DefaultTraversablePanel {
    protected final String ENCODING = "UTF-8";
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext _ctx;
    private ImportProperties _iProps;
    private boolean _isCart = false;
    private boolean _isTested = false;
    private boolean _isTestShowing = false;
    private boolean _isResultsLoaded = false;
    private boolean _isTableDataLoaded = false;
    private boolean _isTableDDLLoaded = false;
    private boolean _isBadLoaded = false;
    private boolean _isBadData = false;
    private boolean _isXTabData = false;
    private boolean _isOSS;
    private JTextPane _instructions;
    private JLabel _testRowsLabel;
    private NumericSpinBox _testRowsCmp;
    private JButton _testCmp = new JButton();
    private JButton _getBadCmp = new JButton();
    private JLabel _noBadDataMsg = new JLabel();
    private JLabel _noXTabDataMsg = new JLabel();
    private JTextComponent _clickTestInstr1;
    private JTextComponent _clickTestInstr2;
    private JTextComponent _clickTestInstr3;
    private JTextComponent _clickTestInstr4;
    private JPanel _badPanel = new JPanel(new BorderLayout());
    private JPanel _badCmpPanel;
    private JPanel _testPanel;
    private JPanel _testRowsPanel;
    private JTabbedPane _testTabbedPane = new JTabbedPane();
    private JTextComponent _msgsPane;
    private JPanel _resultsPanel = new JPanel(new BorderLayout());
    private JPanel _xTableDataPanel = new JPanel(new BorderLayout());
    private JPanel _xTableDDLPanel = new JPanel(new BorderLayout());
    private JLabel _statusLabel;
    private JLabel _statusCmp;
    private JLabel _statusPrevLabel;
    private JLabel _statusPrevCmp;
    private String _statusPrevStr;
    private Icon _statusPrevIcon;
    private DatabaseQueryTask<Boolean> _testTask = null;
    Component _defaultGlassPane;
    private JEWTDialog _statusDialog;
    private Connection _conn;
    private ImportGenerator _generator;

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._iProps = (ImportProperties)this._ctx.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.FIELDSEPARATOR, DBConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getString("IMPORT_DELIMITER"));
        this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        this._isOSS = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
        this.build();
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            // empty if block
        }
    }

    private void initGenProperties() {
        try {
            GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (Column column : columnArray) {
                Column column2 = genericTable.getTable().getColumnByName(column.getName());
                column2.setSourceColumnName(column.getSourceColumnName());
                column2.setSourceColID(column.getSourceColID());
                column = column2;
            }
            this._iProps.put(ImportKeys.TABLE, genericTable);
            ImportWriteStream importWriteStream = DataTestPage.createPrintStream(this._iProps);
            this._iProps.put(ImportKeys.URL_FOR_AUTO_OPEN, importWriteStream.getURL());
            this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, importWriteStream);
            this._iProps.put(ImportKeys.IS_BATCH, false);
            this._iProps.put(ImportKeys.ERROR_LIMIT, 0);
        }
        catch (Exception exception) {
            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static ImportWriteStream createPrintStream(ImportProperties importProperties) throws IOException, UnsupportedEncodingException {
        String string = Ide.getEnvironOptions().getEncoding();
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        int n = 0;
        String string2 = null;
        if (importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            string2 = (String)importProperties.get(ImportKeys.OSS_PATH);
            n = string2.lastIndexOf("/");
        } else {
            string2 = loadFile.getName();
            n = string2.lastIndexOf(File.separator);
        }
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        string2 = string2.replace(".", "-");
        ImportWriteStream importWriteStream = new ImportWriteStream(string2, string);
        return importWriteStream;
    }

    public void build() {
        this._isTested = false;
        this.setLayout(new BorderLayout());
        if (this._isOSS && !this._isTestShowing) {
            this.removeAll();
            this._testCmp.setText(StringUtils.stripMnemonic((String)DataImportArb.getString("SUMMARY_TEST")));
            this._testCmp.setMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SUMMARY_TEST")));
            this._testCmp.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    Serializable serializable;
                    SwingUtilities.invokeLater(() -> DataTestPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
                    if (DataTestPage.this._iProps.getValueBoolean(ImportKeys.IS_CLEANUP_TEST_NEEDED).booleanValue()) {
                        DataTestPage.this._iProps.put(ImportKeys.IS_CLEANUP_TEST_NEEDED, false);
                        DataTestPage.this._generator = (ImportGenerator)DataTestPage.this._iProps.get(ImportKeys.TEST_GENERATOR);
                        DataTestPage.this._iProps.put(ImportKeys.TEST_GENERATOR, null);
                        if (DataTestPage.this._generator != null) {
                            try {
                                if (Connections.getInstance().lock(DataTestPage.this._conn)) {
                                    DataTestPage.this._generator.cleanUpTest();
                                }
                            }
                            catch (Exception exception) {
                                ExceptionHandler.handleException((Throwable)exception);
                            }
                            finally {
                                if (DataTestPage.this._conn != null) {
                                    Connections.getInstance().unlock(DataTestPage.this._conn);
                                }
                            }
                        }
                    }
                    DataTestPage.this._isTested = true;
                    boolean bl2 = false;
                    DataTestPage.this._isResultsLoaded = false;
                    DataTestPage.this._isTableDataLoaded = false;
                    DataTestPage.this._isTableDDLLoaded = false;
                    DataTestPage.this._isBadLoaded = false;
                    DataTestPage.this._isXTabData = false;
                    DataTestPage.this._isBadData = false;
                    DataTestPage.this._testCmp.setEnabled(false);
                    DataTestPage.this._statusCmp.setText(DataImportArb.getString("PREREQ_TEST_STARTED"));
                    DataTestPage.this._statusPrevLabel.setVisible(false);
                    DataTestPage.this._statusPrevCmp.setVisible(false);
                    String string = (String)DataTestPage.this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
                    String string2 = (String)DataTestPage.this._iProps.get(ImportKeys.CONNECTION_NAME);
                    try {
                        if (DataTestPage.this._conn == null) {
                            DataTestPage.this._conn = Connections.getInstance().getConnection(string2);
                        }
                        if (DataTestPage.this._msgsPane == null) {
                            DataTestPage.this._msgsPane = DataTestPage.this.createTextPane(false);
                        }
                        DataTestPage.this._resultsPanel.removeAll();
                        DataTestPage.this._resultsPanel.add((Component)new JScrollPane(DataTestPage.this._msgsPane, 20, 30), "Center");
                        DataTestPage.this.initGenProperties();
                        DataTestPage.this._generator = new ImportGenerator(DataTestPage.this._iProps);
                        DataTestPage.this._iProps.put(ImportKeys.TEST_GENERATOR, DataTestPage.this._generator);
                        DataTestPage.this._iProps.put(ImportKeys.IS_CLEANUP_TEST_NEEDED, true);
                        serializable = new SimpleDateFormat("dd_HHmmssssss");
                        StringBuilder stringBuilder = new StringBuilder(((DateFormat)serializable).format(new Date()));
                        String string3 = "X" + stringBuilder.toString();
                        DataTestPage.this._iProps.put(ImportKeys.STAGING_TABLE_NAME, string3);
                        DataTestPage.this.doTestWithRaptorTask();
                        StringBuffer stringBuffer = DataTestPage.this._generator.getLogFromTest();
                        if (stringBuffer != null && stringBuffer.length() > 0) {
                            DataTestPage.this._msgsPane.setText(stringBuffer.toString());
                            DataTestPage.this._msgsPane.setCaretPosition(0);
                        }
                        DataTestPage.this._testTabbedPane.setSelectedIndex(0);
                        DataTestPage.this._testTabbedPane.addChangeListener(new tabChangeListener());
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                    finally {
                        if (DataTestPage.this._conn != null) {
                            Connections.getInstance().unlock(DataTestPage.this._conn);
                        }
                        SwingUtilities.invokeLater(() -> DataTestPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
                    }
                    serializable = new StringBuffer();
                    boolean bl3 = DataTestPage.this._generator.isDataRows();
                    boolean bl4 = bl = DataTestPage.this._generator.getOperationId() != null;
                    if (!bl3) {
                        ((StringBuffer)serializable).append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_NO_DATA")));
                        DataTestPage.this._statusCmp.setIcon(OracleIcons.getIcon((String)"error.png"));
                        if (DataTestPage.this._generator.isBadRows()) {
                            DataTestPage.this._isBadData = true;
                            ((StringBuffer)serializable).append("; " + DataImportArb.getString("PREREQ_TEST_BAD_ROWS"));
                        }
                    } else if (!bl) {
                        ((StringBuffer)serializable).append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_VAL_FAILED")));
                        DataTestPage.this._statusCmp.setIcon(OracleIcons.getIcon((String)"error.png"));
                    } else if (!DataTestPage.this._generator.isLogRows()) {
                        DataTestPage.this._isXTabData = true;
                        ((StringBuffer)serializable).append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_LOG_FAILED")));
                        DataTestPage.this._statusCmp.setIcon(OracleIcons.getIcon((String)"error.png"));
                        if (DataTestPage.this._generator.isBadRows()) {
                            DataTestPage.this._isBadData = true;
                            ((StringBuffer)serializable).append("; " + DataImportArb.getString("PREREQ_TEST_BAD_ROWS"));
                        }
                    } else if (DataTestPage.this._generator.isBadRows()) {
                        DataTestPage.this._isXTabData = true;
                        DataTestPage.this._isBadData = true;
                        ((StringBuffer)serializable).append(DataImportArb.format("PREREQ_TEST_WARN", DataImportArb.getString("PREREQ_TEST_BAD_ROWS")));
                        DataTestPage.this._statusCmp.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else {
                        DataTestPage.this._isXTabData = true;
                        ((StringBuffer)serializable).append(DataImportArb.getString("PREREQ_TEST_SUCCESS"));
                        DataTestPage.this._statusCmp.setIcon(OracleIcons.getIcon((String)"check.png"));
                    }
                    DataTestPage.this._statusCmp.setText(((StringBuffer)serializable).toString());
                    DataTestPage.this._statusPrevStr = DataTestPage.this._statusCmp.getText();
                    DataTestPage.this._statusPrevIcon = DataTestPage.this._statusCmp.getIcon();
                }
            });
            this._testRowsLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("SUMMARY_TEST_ROWS")));
            this._testRowsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SUMMARY_TEST_ROWS")));
            this._testRowsCmp = new NumericSpinBox(0, Integer.MAX_VALUE);
            this._testRowsCmp.setIntValue(1000);
            ((NumericSpinBoxModel)this._testRowsCmp.getModel()).skip(100);
            this._testRowsCmp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DataTestPage.this._testCmp.setEnabled(true);
                }
            });
            this._testPanel = new JPanel(new FlowLayout(0));
            this._testPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
            this._testRowsPanel = new JPanel(new FlowLayout(0));
            this._testRowsPanel.add(this._testRowsLabel);
            this._testRowsPanel.add((Component)this._testRowsCmp);
            this._testPanel.add(this._testCmp);
            this._statusLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("PREREQ_CHECK_HEADING_STATUS2")));
            this._statusLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("PREREQ_CHECK_HEADING_STATUS2")));
            this._statusCmp = new JLabel(DataImportArb.getString("PREREQ_ROWS_INITIAL_STATUS"));
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(this._statusLabel);
            jPanel.add(this._statusCmp);
            this._testPanel.add(jPanel);
            this._statusPrevLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("PREREQ_ROWS_PREVIOUS_RESULTS")));
            this._statusPrevLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("PREREQ_ROWS_PREVIOUS_RESULTS")));
            this._statusPrevCmp = new JLabel();
            this._statusPrevLabel.setVisible(false);
            this._statusPrevCmp.setVisible(false);
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            jPanel2.add(this._statusPrevLabel);
            jPanel2.add(this._statusPrevCmp);
            this._testPanel.add(jPanel2);
            this._clickTestInstr1 = this.createTextPane(false);
            this._clickTestInstr1.setText(DataImportArb.getString("SUMMARY_TEST_PROMPT"));
            this._clickTestInstr2 = this.createTextPane(false);
            this._clickTestInstr2.setText(DataImportArb.getString("SUMMARY_TEST_PROMPT"));
            this._clickTestInstr3 = this.createTextPane(false);
            this._clickTestInstr3.setText(DataImportArb.getString("SUMMARY_TEST_PROMPT"));
            this._clickTestInstr4 = this.createTextPane(false);
            this._clickTestInstr4.setText(DataImportArb.getString("SUMMARY_TEST_PROMPT"));
            this._resultsPanel.add((Component)this._clickTestInstr1, "Center");
            this._xTableDataPanel.add((Component)this._clickTestInstr2, "Center");
            this._xTableDDLPanel.add((Component)this._clickTestInstr3, "Center");
            this._badPanel.add((Component)this._clickTestInstr4, "Center");
            this._testTabbedPane.add(DataImportArb.getString("SUMMARY_TEST_TITLE"), this._resultsPanel);
            this._testTabbedPane.add(DataImportArb.getString("XTABLE_TITLE"), this._xTableDataPanel);
            this._testTabbedPane.add(DataImportArb.getString("SUMMARY_DDL_TITLE"), this._xTableDDLPanel);
            this._testTabbedPane.add(DataImportArb.getString("SUMMARY_BAD_TITLE"), this._badPanel);
            this._instructions = new JTextPane();
            this._instructions.setEditable(false);
            this._instructions.setOpaque(false);
            this._instructions.setRequestFocusEnabled(false);
            this._instructions.setFocusable(false);
            this.setInstruction((DBObject)this._iProps.get(ImportKeys.DBOBJECT));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this._instructions, "North");
            jPanel3.add((Component)this._testRowsPanel, "Center");
            jPanel3.add((Component)this._testPanel, "South");
            this.add(jPanel3, "North");
            this.add(this._testTabbedPane, "Center");
        } else {
            this._testCmp.setEnabled(true);
            if (this._statusPrevStr != null && !this._statusPrevStr.isEmpty()) {
                this._statusPrevCmp.setText(this._statusPrevStr);
                this._statusPrevCmp.setIcon(this._statusPrevIcon);
                this._statusPrevLabel.setVisible(true);
                this._statusPrevCmp.setVisible(true);
            }
            this._statusCmp.setText("");
            this._statusCmp.setIcon(null);
        }
        this._isTestShowing = this._isOSS;
    }

    private void setInstruction(DBObject dBObject) {
        if (DataUIUtils.isExisting(dBObject)) {
            this._instructions.setText(DataImportArb.getString("TEST_EXISTING_INFO_ADWC_OSS"));
            return;
        }
        this._instructions.setText(DataImportArb.getString("TEST_CREATE_INFO_ADWC_OSS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getXTableComponent() {
        Object object;
        this._xTableDataPanel.removeAll();
        if (!this._isXTabData) {
            this._noXTabDataMsg.setText(DataImportArb.getString("SUMMARY_NO_DATA"));
            this._xTableDataPanel.add((Component)this._noXTabDataMsg, "North");
            return this._xTableDataPanel;
        }
        this._isTableDataLoaded = true;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("XTABLE_TITLE")));
        ResultSetTable resultSetTable = new ResultSetTable();
        jPanel.add((Component)((Object)resultSetTable), "Center");
        int n = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        String string = ImportGenHelper.addUser(this._iProps, (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME));
        if (n == 2) {
            object = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            string = ImportGenHelper.addUser(this._iProps, object.getTable().getTablename());
        }
        resultSetTable.setQuery((String)this._iProps.get(ImportKeys.CONNECTION_NAME), "select * from " + string, null, null);
        object = new JScrollPane((Component)((Object)resultSetTable));
        ((JScrollPane)object).setRowHeaderView(resultSetTable.getRowHeader());
        ((JScrollPane)object).setColumnHeaderView(resultSetTable.getTableHeader());
        try {
            if (Connections.getInstance().lock(this._conn)) {
                resultSetTable.open(false);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (this._conn != null) {
                Connections.getInstance().unlock(this._conn);
            }
        }
        this._xTableDataPanel.add((Component)object, "Center");
        return this._xTableDataPanel;
    }

    private Component getDDLComponent() {
        URL uRL;
        this._isTableDDLLoaded = true;
        JTextComponent jTextComponent = this.createTextPane(false);
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", (String)this._iProps.get(ImportKeys.CONNECTION_NAME), null, dBObject.getSchemaName(), "TABLE");
        int n = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        String string = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        if (n == 2 && !(string = (uRL = (GenericTable)this._iProps.get(ImportKeys.TABLE)).getTable().getTablename()).startsWith("\"")) {
            string = string.toUpperCase();
        }
        uRL = DBURLFormatHelper.getURL(uRL2, string);
        ExtractListModel extractListModel = new ExtractListModel();
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setTableDeps(false);
        dDLTypes.setShowTableDeps(false);
        extractListModel.setDDLTypes(dDLTypes);
        extractListModel.setDDLFormat(new DDLFormat());
        ExtractObject extractObject = new ExtractObject(uRL, extractListModel);
        jTextComponent.setText(extractObject.getDDL(1));
        extractObject.setListModel(extractListModel);
        jTextComponent.setCaretPosition(0);
        this._xTableDDLPanel.removeAll();
        this._xTableDDLPanel.add((Component)new JScrollPane(jTextComponent, 20, 30), "Center");
        return this._xTableDDLPanel;
    }

    private JPanel getBadComponents() {
        this._badPanel.removeAll();
        this._badPanel.setLayout(new BorderLayout(0, 16));
        this._badPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        if (!this._isBadData) {
            this._noBadDataMsg.setText(DataImportArb.getString("SUMMARY_NO_BAD"));
            this._badPanel.add((Component)this._noBadDataMsg, "North");
            return this._badPanel;
        }
        this._getBadCmp.setEnabled(true);
        this._getBadCmp.setText(StringUtils.stripMnemonic((String)DataImportArb.getString("SUMMARY_GET_BAD")));
        this._getBadCmp.setMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SUMMARY_GET_BAD")));
        this._getBadCmp.setToolTipText(DataImportArb.getString("SUMMARY_GET_BAD_TIP"));
        this._getBadCmp.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTestPage.this._isBadLoaded = true;
                DataTestPage.this._getBadCmp.setEnabled(false);
                String string = (String)DataTestPage.this._iProps.get(ImportKeys.CONNECTION_NAME);
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                    String string2 = DataTestPage.this._generator.putBadFileTest();
                    if (string2 != null && !string2.isEmpty()) {
                        String string3 = DataTestPage.this.getTempBadFile(string2);
                        DataTestPage.this._generator.cleanupBadFileTest();
                        DataTestPage.this._badPanel.remove(DataTestPage.this._badCmpPanel);
                        DataTestPage.this._badPanel.add((Component)DataTestPage.this.getBadGizmo(string3), "Center");
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("SUMMARY_NO_BAD"), (String)DataImportArb.getString("SUMMARY_BAD_TITLE"), (String)"IMPORT_BAD_FILE_ERROR");
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
                finally {
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                }
            }
        });
        this._badCmpPanel = new JPanel(new FlowLayout(0));
        this._badCmpPanel.add(this._getBadCmp);
        this._badPanel.add((Component)this._badCmpPanel, "North");
        return this._badPanel;
    }

    private String getTempBadFile(String string) {
        String string2 = null;
        String string3 = (String)this._iProps.get(ImportKeys.OSS_PATH);
        int n = string3.lastIndexOf("/");
        String string4 = string3.substring(0, n);
        String string5 = (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL);
        File file = null;
        try {
            String string6 = DataUIUtils.getSample(this._iProps, string4 + "/" + string, string5);
            if (string6 != null) {
                String string7 = DataReaderUtils.getTempName("oss");
                file = File.createTempFile(string7, ".dsv");
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[string6.length()];
                byArray = string6.getBytes();
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                string2 = file.getPath();
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("OPEN_FILE_ERROR", string3, exception.getMessage()), (String)DataImportArb.getString("OPEN_FILE_ERROR_TITLE"), (String)"IMPORT_OPEN_FILE_ERROR");
            try {
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception2) {
                ExceptionHandler.handleException((Throwable)exception2);
            }
        }
        return string2;
    }

    private JPanel getBadGizmo(String string) {
        boolean bl = false;
        JPanel jPanel = new JPanel(new BorderLayout(0, 16));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        DelimitedReader delimitedReader = new DelimitedReader();
        try {
            delimitedReader.setFileName(string);
            ImportDataFormat importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            bl = importDataFormat.isHeader();
            importDataFormat.isHeader(false);
            LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            String[] stringArray = new String[loadFile.getFieldCount()];
            int n = 0;
            for (LoadField loadField : loadFile.getFields()) {
                Column column = loadField.getColumn();
                if (column == null) continue;
                stringArray[n++] = ImportGenHelper.addDoubleQuote(this._iProps, column.getName());
            }
            delimitedReader.setDefaultColumnNames(stringArray);
            delimitedReader.setDataFormat(importDataFormat);
            this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, importDataFormat);
            DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo(delimitedReader);
            dataPreviewGizmo.setDataFormat(importDataFormat);
            dataPreviewGizmo.initUI();
            jPanel.add((Component)dataPreviewGizmo, "Center");
            dataPreviewGizmo.populateDataTable(delimitedReader);
            dataPreviewGizmo.resetData(true);
            delimitedReader.openFile(string);
            jPanel.add((Component)this.getUIOneCol(delimitedReader), "North");
            importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            importDataFormat.isHeader(bl);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return jPanel;
    }

    private JPanel getUIOneCol(DataReader dataReader) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("GIZMO_TITLE_RECORDS")));
        JScrollPane jScrollPane = new JScrollPane(22, 32);
        jPanel.add((Component)jScrollPane, "Center");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        while (dataReader.hasMoreRows()) {
            try {
                defaultListModel.addElement(dataReader.readCurrentLine());
            }
            catch (Exception exception) {}
        }
        JList<String> jList = new JList<String>(defaultListModel){
            private static final long serialVersionUID = 1L;
        };
        jScrollPane.setViewportView(jList);
        return jPanel;
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void doTestWithRaptorTask() {
        block2: {
            this._testTask = new DatabaseQueryTask<Boolean>(DataImportArb.getString("SUMMARY_TASK_TITLE"), IRaptorTaskRunMode.NO_GUI, false, true){

                public Boolean doWork() throws TaskException {
                    return DataTestPage.this._generator.test(new BigDecimal(DataTestPage.this._testRowsCmp.getIntValue()));
                }

                @Override
                public String getConnectionName() {
                    return (String)DataTestPage.this._iProps.get(ImportKeys.CONNECTION_NAME);
                }

                @Override
                public String getQuery() {
                    return "";
                }
            };
            this._testTask.setCancellable(true);
            this._testTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanTask();
                }

                public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanTask();
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanTask();
                }

                private void cleanTask() {
                    if (DataTestPage.this._statusDialog != null) {
                        DataTestPage.this._statusDialog.setVisible(false);
                        DataTestPage.this._statusDialog.dispose();
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask(this._testTask);
            JProgressBar jProgressBar = new JProgressBar(0, 60);
            jProgressBar.setIndeterminate(true);
            JPanel jPanel = new JPanel();
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_import_test_html");
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel.add((Component)jProgressBar, "Center");
            this._statusDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)DataImportArb.getString("SUMMARY_TEST_PROGRESS"), (int)5);
            Dimension dimension = this._statusDialog.getPreferredSize();
            this._statusDialog.setPreferredSize(new Dimension((int)dimension.getWidth() + 100, (int)dimension.getHeight() + 50));
            this._statusDialog.setResizable(true);
            this._statusDialog.setOKButtonEnabled(true);
            WizardLauncher.runDialog((JDialog)this._statusDialog);
            try {
                this._testTask.getResult();
                this._testTask = null;
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable == null || !(throwable instanceof TaskException)) break block2;
                String string = throwable.getMessage();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("SUMMARY_TEST_ERROR", string == null ? "" : string), (String)DataImportArb.getString("SUMMARY_TEST_TITLE"), (String)"IMPORT_BAD_FILE_ERROR");
            }
        }
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataTestPage.this._testTabbedPane.removeChangeListener(this);
            int n = DataTestPage.this._testTabbedPane.getSelectedIndex();
            if (n == 1 && !DataTestPage.this._isTableDataLoaded) {
                DataTestPage.this.getXTableComponent();
                DataTestPage.this._testTabbedPane.repaint();
            } else if (n == 2 && !DataTestPage.this._isTableDDLLoaded) {
                DataTestPage.this.getDDLComponent();
                DataTestPage.this._testTabbedPane.repaint();
            } else if (n == 3 && !DataTestPage.this._isBadLoaded) {
                DataTestPage.this.getBadComponents();
                DataTestPage.this._testTabbedPane.repaint();
            }
            DataTestPage.this._testTabbedPane.setSelectedIndex(n);
            DataTestPage.this._testTabbedPane.addChangeListener(this);
        }
    }
}

