/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class DataUIUtils {
    public static final String dbms_cloudGetObject = "{? = call C##CLOUD$SERVICE.DBMS_CLOUD.GET_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?, STARTOFFSET => ?, ENDOFFSET => ?)}";

    public static JComboBox<String> getSQLCombo(JLabel jLabel) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEnabled(true);
        jLabel.setEnabled(true);
        jLabel.setLabelFor(jComboBox);
        jComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        return jComboBox;
    }

    public static void setCredentialModel(JComboBox<String> jComboBox, String string) {
        DataUIUtils.initSQLComboBox(jComboBox, string, "select CREDENTIAL_NAME from all_credentials", false);
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2) {
        DataUIUtils.initSQLComboBox(jComboBox, string, string2, true);
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2, boolean bl) {
        if (string != null && jComboBox != null) {
            SQLComboxModel sQLComboxModel = DataUIUtils.getSQLComboModel(string, string2, bl);
            jComboBox.setModel(sQLComboxModel);
        }
    }

    private static SQLComboxModel getSQLComboModel(String string, String string2, boolean bl) {
        SQLComboxModel sQLComboxModel = null;
        if (string != null) {
            sQLComboxModel = new SQLComboxModel(string, string2);
            sQLComboxModel.setDelayed(bl);
        }
        return sQLComboxModel;
    }

    public static byte[] getSampleBytes(ImportProperties importProperties, String string, String string2) {
        return DataUIUtils.getSampleBytes((String)importProperties.get(ImportKeys.CONNECTION_NAME), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSampleBytes(String string, String string2, String string3) {
        long l = 0L;
        byte[] byArray = null;
        Connection connection = null;
        Blob blob = null;
        CallableStatement callableStatement = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            callableStatement = connection.prepareCall(dbms_cloudGetObject);
            callableStatement.registerOutParameter(1, 2004);
            callableStatement.setString(2, string3);
            callableStatement.setString(3, string2);
            callableStatement.setBigDecimal(4, new BigDecimal(0));
            callableStatement.setBigDecimal(5, new BigDecimal(20000));
            callableStatement.execute();
            blob = callableStatement.getBlob(1);
            if (blob != null) {
                l = blob.length();
                byte[] byArray2 = byArray = blob.getBytes(1L, (int)l);
                return byArray2;
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            byte[] byArray3 = null;
            return byArray3;
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("OPEN_FILE_CRED_ERROR", string2, string3), (String)DataImportArb.getString("OPEN_FILE_ERROR_TITLE"), (String)"OPEN_FILE_NO_DATA");
        return null;
    }

    public static String getSample(ImportProperties importProperties, String string, String string2) {
        return DataUIUtils.getSample((String)importProperties.get(ImportKeys.CONNECTION_NAME), string, string2);
    }

    public static String getSample(String string, String string2, String string3) {
        return DataUIUtils.getSample(string, string2, string3, new Integer(20000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSample(String string, String string2, String string3, Integer n) {
        String string4 = "select to_clob(dbms_cloud.get_object(:CREDENTIAL, :FILE_URI,0,:LIMIT)) from dual";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string5 = null;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            hashMap.put("CREDENTIAL", string3);
            hashMap.put("FILE_URI", string2);
            hashMap.put("LIMIT", n);
            if (Connections.getInstance().lock(connection)) {
                string5 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string4, hashMap);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            String string6 = null;
            return string6;
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        if (string5 != null && !string5.isEmpty()) {
            return string5;
        }
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataImportArb.format("OPEN_FILE_CRED_ERROR", string2, string3), (String)DataImportArb.getString("OPEN_FILE_ERROR_TITLE"), (String)"OPEN_FILE_NO_DATA");
        return null;
    }

    public static String getOssTempExtension(String string) {
        String string2 = "csv";
        int n = string.lastIndexOf(".");
        if (!(n == -1 || (string2 = string.substring(n + 1, string.length())).equalsIgnoreCase("csv") || string2.equalsIgnoreCase("dsv") || string2.equalsIgnoreCase("tsv"))) {
            string2 = "csv";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(ImportProperties importProperties, String string) {
        String string2 = "drop table :TABLE";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = (String)importProperties.get(ImportKeys.CONNECTION_NAME);
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string3);
            hashMap.put("TABLE", string);
            if (Connections.getInstance().lock(connection)) {
                PreparedStatement preparedStatement = DBUtil.getInstance((Connection)connection).prepareExecute(string2, hashMap);
                preparedStatement.execute();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public static void setFileColumnsFromSource(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)importProperties.get(ImportKeys.GIZMO);
        boolean bl = importProperties.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
        boolean bl2 = importProperties.getValueBoolean(ImportKeys.IS_CART);
        ArrayList arrayList = (ArrayList)loadFile.getFields();
        JTable jTable = dataPreviewGizmo.getTable();
        TableColumnModel tableColumnModel = jTable.getTableHeader().getColumnModel();
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Column column = new Column();
            Object object = tableColumnModel.getColumn(i).getHeaderValue();
            String string = object == null ? "" : object.toString();
            column.setSourceColumnName(string);
            if (bl) {
                column.setName("");
            } else {
                column.setName(column.getSourceColumnName());
            }
            column.setSourceColID(DataUIUtils.getSourceID(importProperties, column.getSourceColumnName()));
            column.setPrecision(dataPreviewGizmo.getDataReader().getWidth(i));
            column.setType("VARCHAR2");
            column.setScale(0);
            column.setNullable(true);
            arrayList2.add(i, column);
            ((LoadField)arrayList.get(i)).setColumn(column);
            if (bl2) {
                ((LoadField)arrayList.get(i)).setName(column.getName());
            }
            importProperties.put(ImportKeys.FILE_COLUMNS, arrayList2.toArray(new Column[arrayList2.size()]));
        }
    }

    public static int getSourceID(ImportProperties importProperties, String string) {
        int n = -1;
        DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)importProperties.get(ImportKeys.GIZMO);
        String[] stringArray = dataPreviewGizmo.getDataReader().getColumnNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static boolean isExisting(Object object) {
        if (object != null && object instanceof DBObject) {
            DBObject dBObject = (DBObject)object;
            return dBObject.getObjectType().equals("TABLE");
        }
        return false;
    }
}

