/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ImportBadFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportBadFilePanel;
import oracle.dbtools.raptor.data.ui.ImportDiscardFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportGenFilesPanel;
import oracle.dbtools.raptor.data.ui.ImportLogFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportLogFilePanel;
import oracle.dbtools.raptor.data.ui.RejectLimitPanel;
import oracle.dbtools.raptor.data.ui.ValidateLimitPanel;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.gss.util.NLSLocale;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class ExternalOptions
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -4806824652842858395L;
    private static final String[] TRIM_OPTIONS = new String[]{DataImportArb.getString("NOTRIM"), DataImportArb.getString("LTRIM"), DataImportArb.getString("RTRIM"), DataImportArb.getString("TRIM")};
    private static final String[] NULL_ROWS_OPTIONS = new String[]{DataImportArb.getString("IGNORE"), DataImportArb.getString("ACCEPT")};
    private static final String[] CONVERSION_ERRORS_OPTIONS = new String[]{DataImportArb.getString("SET_NULL"), DataImportArb.getString("REJECT_ROW")};
    private static final String[] MISSING_FIELDS_OPTIONS = new String[]{DataImportArb.getString("SET_NULL"), DataImportArb.getString("REJECT_ROW")};
    private TraversableContext m_ctx;
    BasicEditorPane m_summaryPanel = null;
    private ImportDataFormat m_dataFormat;
    private JLabel m_pathLabel;
    private JTextField m_pathValue;
    private JLabel m_directoryLabel;
    private JComboBox m_directoryValue;
    private String m_myDir = null;
    private JComboBox m_outputComboBox;
    private String[] _recordTerminators;
    private JLabel _trimLabel;
    private JLabel _nullRowsLabel;
    private JLabel _conversionErrorsLabel;
    private JLabel _missingFieldsLabel;
    private JPanel _mainPanel;
    private JPanel _lowerPanel;
    private JCheckBox _useValidateCmp;
    private JPanel _validateCmpPanel;
    private ValidateLimitPanel _validateLimitPanel;
    private JCheckBox _copyLogCmp;
    private JCheckBox _dropBadAndLogCmp;
    private JCheckBox _copyBadCmp;
    private JComboBox<String> _trimCmp = new JComboBox<String>(TRIM_OPTIONS);
    private JComboBox<String> _nullRowsCmp = new JComboBox<String>(NULL_ROWS_OPTIONS);
    private JComboBox<String> _conversionErrorsCmp = new JComboBox<String>(CONVERSION_ERRORS_OPTIONS);
    private JComboBox<String> _missingFieldsCmp = new JComboBox<String>(MISSING_FIELDS_OPTIONS);
    private JCheckBox _blankColumnsCmp;
    private JCheckBox _truncateColumnsCmp;
    private RejectLimitPanel _rejectLimitPanel;
    private JTextField m_numChars;
    private JCheckBox m_charsetCheckBox;
    private JLabel m_charsetLabel;
    private JComboBox m_charsetComboBox;
    private ButtonGroup m_genDirsGroup;
    private JLabel m_genDirsLabel;
    private JRadioButton m_saveInInputDirRadio;
    private JRadioButton m_saveInGenDirRadio;
    private ImportBadFilePanel m_importBadFilePanel;
    private ImportLogFilePanel m_importLogFilePanel;
    private ImportGenFilesPanel m_importGenFilesPanel;
    private ImportBadFileOraPanel m_importBadFileOraPanel;
    private ImportLogFileOraPanel m_importLogFileOraPanel;
    private ImportDiscardFileOraPanel m_importDiscardFileOraPanel;
    Vector<String> m_dirList;
    private Integer _loadMethodType;
    private JComboBox<String> _loadMethod;
    private DefaultComboBoxModel<String> _loadMethodModel;
    private String m_inputFileDir;
    private LoadFile m_file;
    private ImportProperties _iProps;
    private boolean _init = false;
    private boolean _isOss;
    private boolean _isCart;
    private boolean _isConfigUsed = false;

    public void onEntry(TraversableContext traversableContext) {
        String string;
        Object object;
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        if (this._loadMethodType != null && this._loadMethodType != (Integer)this._iProps.get(ImportKeys.LOAD_METHOD)) {
            this._init = false;
        }
        this._loadMethodType = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        this._isOss = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
        this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        DBConfig dBConfig = DBConfig.getInstance();
        String string2 = dBConfig.getString("IMPORT_ORA_DIR");
        String string3 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
        if (!((Boolean)this._iProps.get(ImportKeys.IS_CONFIGFILE)).booleanValue() || string3 == null || string3.length() < 1) {
            this._iProps.put(ImportKeys.ORADIRNAME, dBConfig.getString("IMPORT_ORA_DIR"));
        }
        this.m_dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        this.m_file = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.build();
        if (this._isCart) {
            this._loadMethod.setSelectedItem(ImportDataFormat.getLoadMethodName(this._loadMethodType));
        }
        if (this._isCart || this._isOss) {
            this._validateCmpPanel.setVisible(this._loadMethodType != 5);
            this._useValidateCmp.setVisible(this._loadMethodType != 5);
            this._useValidateCmp.setSelected(this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE));
            if (this._validateLimitPanel != null && this._validateLimitPanel.getValidateLimitCheckBox() != null) {
                this._validateLimitPanel.getValidateLimitCheckBox().setSelected(this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT));
                object = this._iProps.getValueInteger(ImportKeys.VALIDATE_LIMIT);
                if (object == null || (Integer)object == -1) {
                    object = new Integer(0);
                }
                this._validateLimitPanel.getValidateLimitSpinBox().setValue((Number)object);
            }
            this._copyLogCmp.setSelected(this._iProps.getValueBoolean(ImportKeys.IS_COPY_LOG));
            this._copyBadCmp.setSelected(this._iProps.getValueBoolean(ImportKeys.IS_COPY_BAD));
            this._rejectLimitPanel.getRejectLimitCheckBox().setSelected(this._iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT));
            object = this._iProps.getValueInteger(ImportKeys.REJECT_LIMIT);
            if (object == null || (Integer)object == -1) {
                object = new Integer(0);
            }
            this._rejectLimitPanel.getRejectLimitSpinBox().setValue((Number)object);
            this._trimCmp.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.TRIM));
            this._nullRowsCmp.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.NULL_ROWS));
            this._conversionErrorsCmp.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.CONVERSION_ERRORS));
            this._missingFieldsCmp.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.MISSING_FIELDS));
            this._blankColumnsCmp.setSelected(this._iProps.getValueBoolean(ImportKeys.IS_BLANK_COLS));
            this._missingFieldsCmp.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.MISSING_FIELDS));
            this._truncateColumnsCmp.setSelected(this._iProps.getValueBoolean(ImportKeys.IS_TRUNCATE_COLS));
        } else if (this._loadMethodType == 2 || this._loadMethodType == 3) {
            this.setDefaultPath();
            this.setDefaultDirectory();
            object = (String)this.m_directoryValue.getSelectedItem();
            this.m_importLogFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).setSelectedItem(object);
            }
            this.m_importBadFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).setSelectedItem(object);
            }
            this.m_importDiscardFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).setSelectedItem(object);
            }
        } else {
            if (this.m_importLogFilePanel != null) {
                this.m_importLogFilePanel.onEntry(this.m_ctx);
            }
            if (this.m_importBadFilePanel != null) {
                this.m_importBadFilePanel.onEntry(this.m_ctx);
            }
            if (this.m_importGenFilesPanel != null) {
                this.m_importGenFilesPanel.onEntry(this.m_ctx);
            }
            if ((object = (String)this._iProps.get(ImportKeys.FILEOUTNEWLINE)) == null || ((String)object).length() == 0) {
                object = BaseDataFormat.getRecordTerminatorFromConfigValue(dBConfig.getString("IMPORT_LDR_GEN_TERM"));
            }
            if (object != null && ((String)object).length() > 0) {
                string = object;
                this.m_outputComboBox.setSelectedItem(string);
            } else {
                string = DataToolsArb.getString("IMPORT_FILE");
                boolean bl = false;
                for (int i = 0; string != null && i < this._recordTerminators.length; ++i) {
                    if (!this._recordTerminators[i].equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.m_outputComboBox.addItem(string);
                }
                this.m_outputComboBox.setSelectedItem(string);
            }
        }
        if (this.m_numChars != null) {
            object = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
            if (object != null) {
                this.m_numChars.setText((String)object);
            } else {
                this.m_numChars.setText("4000");
            }
        }
        object = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (this.m_charsetComboBox != null && object != null) {
            this.m_charsetComboBox.setSelectedItem(object);
        }
        if (this.m_charsetCheckBox != null) {
            boolean bl = this._iProps.getValueBoolean(ImportKeys.IS_GENERATE_CHARSET);
            this.m_charsetCheckBox.setSelected(bl);
            this.m_charsetComboBox.setEnabled(bl);
            this.m_charsetLabel.setEnabled(bl);
        }
    }

    public void setImportMethod(int n) {
        this.changeLoadMethod(n);
    }

    public void changeLoadMethod(int n) {
        this._loadMethodType = n;
        this._validateCmpPanel.setVisible(this._loadMethodType != 5);
        this._useValidateCmp.setVisible(this._loadMethodType != 5);
        this._mainPanel.validate();
        this._mainPanel.repaint();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.LOAD_METHOD, this._loadMethodType);
        if (this._isCart || this._isOss) {
            this._iProps.put(ImportKeys.USE_VALIDATE, this._useValidateCmp.isSelected());
            this._iProps.put(ImportKeys.USE_VALIDATE_LIMIT, this._validateLimitPanel.getValidateLimitCheckBox().isSelected());
            this._iProps.put(ImportKeys.VALIDATE_LIMIT, this._validateLimitPanel.getValidateLimitSpinBox().getValue());
            this._iProps.put(ImportKeys.IS_COPY_LOG, this._copyLogCmp.isSelected());
            this._iProps.put(ImportKeys.IS_COPY_BAD, this._copyBadCmp.isSelected());
            this._iProps.put(ImportKeys.IS_DROP_BAD_AND_LOG, false);
            this._iProps.put(ImportKeys.USE_REJECT_LIMIT, this._rejectLimitPanel.getRejectLimitCheckBox().isSelected());
            this._iProps.put(ImportKeys.REJECT_LIMIT, this._rejectLimitPanel.getRejectLimitSpinBox().getValue());
            this._iProps.put(ImportKeys.TRIM, this._trimCmp.getSelectedIndex());
            this._iProps.put(ImportKeys.NULL_ROWS, this._nullRowsCmp.getSelectedIndex());
            this._iProps.put(ImportKeys.CONVERSION_ERRORS, this._conversionErrorsCmp.getSelectedIndex());
            this._iProps.put(ImportKeys.MISSING_FIELDS, this._missingFieldsCmp.getSelectedIndex());
            this._iProps.put(ImportKeys.IS_BLANK_COLS, this._blankColumnsCmp.isSelected());
            this._iProps.put(ImportKeys.IS_TRUNCATE_COLS, this._truncateColumnsCmp.isSelected());
        } else if (this._loadMethodType == 2 || this._loadMethodType == 3) {
            this._iProps.put(ImportKeys.DIRPATH, this.m_pathValue.getText());
            this._iProps.put(ImportKeys.ORADIRNAME, (String)this.m_directoryValue.getSelectedItem());
            if (this.m_importBadFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORABADDIRNAME, ((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USEBADFILE, true);
            } else {
                this._iProps.put(ImportKeys.USEBADFILE, false);
            }
            if (this.m_importLogFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORALOGDIRNAME, ((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USELOGFILE, true);
            } else {
                this._iProps.put(ImportKeys.USELOGFILE, false);
            }
            if (this.m_importDiscardFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORADISCARDDIRNAME, ((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USEDISCARDFILE, true);
            } else {
                this._iProps.put(ImportKeys.USEDISCARDFILE, false);
            }
        } else if (this._loadMethodType == 4) {
            String string;
            String string2 = this.m_importBadFilePanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.BADDIRNAME, string2);
            if (string2 != null && string2.trim().length() > 0 && (string = this.validateDirectory(string2, DataImportArb.getString("BAD_FILE_DIR"))) != null) {
                throw new TraversalException(string);
            }
            string2 = this.m_importLogFilePanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.LOGDIRNAME, string2);
            if (string2 != null && string2.trim().length() > 0 && (string = this.validateDirectory(string2, DataImportArb.getString("LOG_FILE_DIR"))) != null) {
                throw new TraversalException(string);
            }
            this._iProps.put(ImportKeys.USEGENDIR, this.m_saveInGenDirRadio.isSelected());
            string = this.m_importGenFilesPanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.GENDIR, string);
            this._iProps.put(ImportKeys.FILEOUTNEWLINE, (String)this.m_outputComboBox.getSelectedItem());
            String string3 = this.validateDirectory(this.m_saveInGenDirRadio.isSelected() ? string : this.m_inputFileDir, DataImportArb.getString("GENERATED_FILES_IN"));
            this._iProps.put(ImportKeys.GENDIR, this.m_saveInGenDirRadio.isSelected() ? string : this.m_inputFileDir);
            if (string3 != null) {
                throw new TraversalException(string3);
            }
        }
        if (this.m_numChars != null) {
            this._iProps.put(ImportKeys.CHARNUMCHARACTERS, this.m_numChars.getText());
        }
        if (this.m_charsetCheckBox != null && this.m_charsetCheckBox.isSelected()) {
            this._iProps.put(ImportKeys.CHARSETVAL, this.m_charsetComboBox.getSelectedItem());
            this._iProps.put(ImportKeys.IS_GENERATE_CHARSET, true);
        } else {
            this._iProps.put(ImportKeys.CHARSETVAL, "");
            this._iProps.put(ImportKeys.IS_GENERATE_CHARSET, false);
        }
    }

    private String validateDirectory(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return DataImportArb.format("NO_DIR", string2);
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return this.canWrite(file);
        }
        if (file.isFile()) {
            return DataImportArb.format("NOT_A_DIR", string, string2);
        }
        boolean bl = MessageDialog.confirm((Component)((Object)this), (Object)DataImportArb.format("CREATE_DIRS", string, string2), (String)DataImportArb.getString("CONFIRM_CREATE_DIR"), null);
        if (!bl) {
            return DataImportArb.format("VALIDATION_FAILED", string, string2);
        }
        if (file != null && file.mkdirs()) {
            return this.canWrite(file);
        }
        return DataImportArb.format("INVALID_DIR", string, string2);
    }

    private String canWrite(File file) {
        return file.canWrite() ? null : DataImportArb.format("NOT_WRITABLE", file.getPath());
    }

    protected void build() {
        if (!this._init) {
            this._isConfigUsed = (Boolean)this._iProps.get(ImportKeys.IS_CONFIGFILE);
            this.removeAll();
            this._init = true;
            this.setLayout(new BorderLayout());
            this.add(this.getMainPanel(), "Center");
            if (!this._isConfigUsed && (this._isOss || this._isCart)) {
                try {
                    this.onExit(this.m_ctx);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected JPanel getMainPanel() {
        this._mainPanel = new JPanel(new GridBagLayout());
        this._lowerPanel = new JPanel();
        this._lowerPanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        if (this._isCart || this._isOss) {
            this._lowerPanel.setBorder(new TitledBorder(null, DataImportArb.getString("VALIDATE_EXTERNAL_TABLE_OPTIONS"), 0, 0, null, null));
            this._validateLimitPanel = new ValidateLimitPanel();
            this._validateLimitPanel.initValidateLimit();
            this._validateLimitPanel.onEntry();
            this._lowerPanel.add(this.getUseValidateCmp(), new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 0, 0), 0, 0));
            int n3 = 0;
            this._validateCmpPanel = new JPanel(new GridBagLayout());
            this._validateCmpPanel.add((Component)this._validateLimitPanel.getValidateLimitCheckBox(), new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            this._validateCmpPanel.add((Component)this._validateLimitPanel.getValidateLimitSpinBox(), new GridBagConstraints(1, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            this._validateCmpPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, n3, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._lowerPanel.add((Component)this._validateCmpPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 0), 0, 0));
            this._lowerPanel.add(this.getCopyLogCmp(), new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this._lowerPanel.add(this.getCopyBadCmp(), new GridBagConstraints(0, ++n2, 1, 1, 1.0, 1.0, 17, 0, new Insets(8, 16, 8, 0), 0, 0));
            this._lowerPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, n2, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            int n4 = 0;
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(new TitledBorder(null, DataImportArb.getString("REJECT_OPTIONS"), 0, 0, null, null));
            jPanel2.setLayout(new GridBagLayout());
            this._rejectLimitPanel = new RejectLimitPanel();
            this._rejectLimitPanel.setRejectLimit(0);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)this._rejectLimitPanel.getRejectLimitCheckBox(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel3.add((Component)this._rejectLimitPanel.getRejectLimitSpinBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
            jPanel3.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)jPanel3, new GridBagConstraints(0, n4, 2, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
            jPanel2.add((Component)this.getNullRowsLabel(), new GridBagConstraints(0, ++n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
            jPanel2.add(this.getNullRowsCmp(), new GridBagConstraints(1, n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(8, 8, 6, 0), 0, 0));
            jPanel2.add((Component)this.getConversionErrorsLabel(), new GridBagConstraints(0, ++n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
            jPanel2.add(this.getConversionErrorsCmp(), new GridBagConstraints(1, n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(8, 8, 6, 0), 0, 0));
            jPanel2.add((Component)this.getMissingFieldsLabel(), new GridBagConstraints(0, ++n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
            jPanel2.add(this.getMissingFieldsCmp(), new GridBagConstraints(1, n4, 1, 1, 0.0, 0.0, 17, 1, new Insets(8, 8, 6, 0), 0, 0));
            jPanel2.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            jPanel4.setBorder(new TitledBorder(null, DataImportArb.getString("FIELD_OPTIONS"), 0, 0, null, null));
            jPanel4.setLayout(new GridBagLayout());
            n4 = 0;
            jPanel4.add(this.getBlankColumnsCmp(), new GridBagConstraints(0, n4, 2, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
            jPanel4.add(this.getTruncateColumnsCmp(), new GridBagConstraints(0, ++n4, 2, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
            jPanel4.add((Component)this.getTrimLabel(), new GridBagConstraints(0, ++n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 0, 0), 0, 0));
            jPanel4.add(this.getTrimCmp(), new GridBagConstraints(1, n4, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 6, 0), 0, 0));
            jPanel4.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel4.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, ++n, 1, 0, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            n4 = 0;
            if (this._isCart) {
                JPanel jPanel5 = new JPanel(new GridBagLayout());
                jPanel5.setLayout(new GridBagLayout());
                JLabel jLabel = new JLabel();
                jLabel.setText(DataImportArb.getString("METHOD_LABEL"));
                this._loadMethodModel = new DefaultComboBoxModel<String>(this._isOss ? ImportDataFormat.getDwcsNewLoadMethods(true) : ImportDataFormat.getDwcsExistingLoadMethods(true));
                this._loadMethod = new JComboBox<String>(this._loadMethodModel);
                this._loadMethod.setSelectedItem(ImportDataFormat.getDefaultDwcsNewMethod(true));
                jLabel.setLabelFor(this._loadMethod);
                jPanel5.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 6, 0, 8), 0, 0));
                jPanel5.add(this._loadMethod, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
                ItemListener itemListener = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            ExternalOptions.this.changeLoadMethod(ImportDataFormat.getLoadMethodType((String)ExternalOptions.this._loadMethodModel.getSelectedItem()));
                        }
                    }
                };
                this._loadMethod.addItemListener(itemListener);
                jPanel.add((Component)this.createInstructions(), new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 1, new Insets(8, 0, 16, 0), 0, 0));
                jPanel.add((Component)jPanel5, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 16, 0), 0, 0));
            }
            jPanel.add((Component)jPanel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 16, 0), 0, 0));
            jPanel.add((Component)jPanel2, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 16, 16, 0), 0, 0));
            jPanel.add((Component)this._lowerPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 16, 0), 0, 0));
        } else {
            this._lowerPanel.setBorder(new TitledBorder(null, DataImportArb.getString("EXTERNAL_TABLE_OPTIONS"), 0, 0, null, null));
            if (this._loadMethodType == 2 || this._loadMethodType == 3) {
                n2 = 0;
                this._lowerPanel.add((Component)this.getPathLabel(), new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
                this._lowerPanel.add((Component)this.getPathValue(), new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 6, 0), 0, 0));
                this.m_dirList = this.getDirectories();
                this._lowerPanel.add((Component)this.getDirectoryLabel(), new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
                this._lowerPanel.add((Component)this.getDirectoryValue(), new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 8, 6, 0), 0, 0));
                this.m_importLogFileOraPanel = new ImportLogFileOraPanel(true, this.m_dirList);
                this._lowerPanel.add((Component)this.m_importLogFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
                this._lowerPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, n2, 1, 3, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_importBadFileOraPanel = new ImportBadFileOraPanel(true, this.m_dirList);
                this._lowerPanel.add((Component)this.m_importBadFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
                this.m_importDiscardFileOraPanel = new ImportDiscardFileOraPanel(true, this.m_dirList);
                this._lowerPanel.add((Component)this.m_importDiscardFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
                this._lowerPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this._lowerPanel.setBorder(new TitledBorder(null, DataImportArb.getString("SQLLDR_OPTIONS"), 0, 0, null, null));
                this._lowerPanel.setLayout(new GridBagLayout());
                n2 = 0;
                this.m_importLogFilePanel = new ImportLogFilePanel();
                this._lowerPanel.add((Component)this.m_importLogFilePanel, new GridBagConstraints(0, n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 8), 0, 0));
                this.m_importBadFilePanel = new ImportBadFilePanel();
                this._lowerPanel.add((Component)this.m_importBadFilePanel, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
                this._lowerPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this._mainPanel.add((Component)this._lowerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_genDirsLabel = new JLabel();
                this.m_genDirsGroup = new ButtonGroup();
                this.m_genDirsLabel.setText(DataImportArb.getString("GENERATED_FILES_IN"));
                String string = this.m_file.getName();
                String string2 = "filename";
                try {
                    string2 = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                this.m_inputFileDir = string2.substring(0, string2.lastIndexOf(File.separator));
                this.m_saveInInputDirRadio = new JRadioButton();
                this.m_saveInInputDirRadio.setText(DataImportArb.format("SAVE_IN_INPUT_DIR", this.m_inputFileDir));
                this.m_saveInInputDirRadio.setToolTipText(DataImportArb.getString("SAVE_IN_INPUT_DIR_TIP"));
                this.m_saveInInputDirRadio.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExternalOptions.this.m_importGenFilesPanel.setEnabled(!ExternalOptions.this.m_saveInInputDirRadio.isSelected());
                    }
                });
                this.m_genDirsGroup.add(this.m_saveInInputDirRadio);
                this.m_saveInGenDirRadio = new JRadioButton();
                this.m_saveInGenDirRadio.setText(DataImportArb.getString("SAVE_IN_GEN_DIR"));
                this.m_saveInGenDirRadio.setToolTipText(DataImportArb.getString("SAVE_IN_GEN_DIR_TIP"));
                this.m_saveInGenDirRadio.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExternalOptions.this.m_importGenFilesPanel.setEnabled(ExternalOptions.this.m_saveInGenDirRadio.isSelected());
                    }
                });
                this.m_genDirsGroup.add(this.m_saveInGenDirRadio);
                this.m_importGenFilesPanel = new ImportGenFilesPanel();
                boolean bl = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
                String string3 = (String)this._iProps.get(ImportKeys.GENDIR);
                if (bl) {
                    this.m_saveInGenDirRadio.setSelected(true);
                    this.m_importGenFilesPanel.setCurrentDirectory(string3);
                } else {
                    this.m_saveInInputDirRadio.setSelected(true);
                }
                this.m_importGenFilesPanel.setEnabled(this.m_saveInGenDirRadio.isSelected());
                this._lowerPanel.add((Component)this.m_genDirsLabel, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 8), 0, 0));
                this._lowerPanel.add((Component)this.m_saveInInputDirRadio, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
                this._lowerPanel.add((Component)this.m_saveInGenDirRadio, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
                this._lowerPanel.add((Component)this.m_importGenFilesPanel, new GridBagConstraints(1, n2, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
                this._lowerPanel.add((Component)new JLabel(DataImportArb.getString("GENERATED_FILE_NEWLINE")), new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 17, 1, new Insets(16, 0, 0, 8), 0, 0));
                this._lowerPanel.add(this.getOutputNewline(), new GridBagConstraints(2, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(16, 0, 6, 8), 0, 0));
            }
        }
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(new TitledBorder(null, DataImportArb.getString("GENERIC_OPTIONS"), 0, 0, null, null));
        jPanel6.setLayout(new GridBagLayout());
        int n5 = 0;
        if (!this._isCart && !this._isOss) {
            jPanel6.add((Component)new JLabel(DataImportArb.getString("NUMBER_OF_CHARACTERS")), new GridBagConstraints(0, ++n5, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 8), 0, 0));
            jPanel6.add(this.getNumChars(), new GridBagConstraints(1, n5, 1, 1, 0.0, 0.0, 17, 1, new Insets(8, 8, 6, 8), 0, 0));
        }
        jPanel6.add(this.getCharsetCheckBox(), new GridBagConstraints(0, ++n5, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 8, 6, 0), 0, 0));
        this.m_charsetLabel = new JLabel(DataImportArb.getString("FILE_CHARSET"));
        jPanel6.add((Component)this.m_charsetLabel, new GridBagConstraints(0, ++n5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 26, 0, 0), 0, 0));
        jPanel6.add(this.getCharsetComboBox(), new GridBagConstraints(1, n5, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 8, 6, 8), 0, 0));
        this.m_charsetCheckBox.setSelected(false);
        this.m_charsetComboBox.setEnabled(false);
        this.m_charsetLabel.setEnabled(false);
        jPanel6.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, n5, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (!this._isCart && !this._isOss) {
            jPanel.add((Component)this._lowerPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 16, 0), 0, 0));
        }
        jPanel.add((Component)jPanel6, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 16, 0), 0, 0));
        jPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, ++n, 1, 0, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this._mainPanel;
    }

    private void setDefaultPath() {
        String string = (String)this._iProps.get(ImportKeys.DIRPATH);
        String string2 = null;
        String string3 = null;
        string3 = string != null ? string : ((string2 = this.m_file.getCanonicalName()) != null && string2.indexOf(File.separator) != -1 ? string2.substring(0, string2.lastIndexOf(File.separator)) : "unknown");
        this.m_pathValue.setText(string3);
        this.m_myDir = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setDefaultDirectory() {
        String string = (String)this._iProps.get(ImportKeys.ORADIRNAME);
        String string2 = DataImportArb.getString("ENTERNEWDIR");
        if (string != null) {
            string2 = string;
        } else {
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            boolean bl = false;
            String string3 = this.m_myDir.toLowerCase();
            if (this.m_myDir.toLowerCase().matches("^[a-z]:.*")) {
                bl = true;
                string3 = string3.replaceFirst("^([a-z]:)([^\\\\])", "$1\\\\$2");
            }
            ResultSet resultSet = null;
            if (Connections.getInstance().lock(dBObject.getConnectionName())) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                    resultSet = dBUtil.executeQuery("select DIRECTORY_NAME,DIRECTORY_PATH  from all_directories", Collections.EMPTY_MAP);
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        String string5 = resultSet.getString(2);
                        if (string5 == null) continue;
                        if (bl) {
                            if (!string5.toLowerCase().replaceFirst("^([a-z]:)([^\\\\])", "$1\\\\$2").equals(string3)) continue;
                            string2 = string4;
                            break;
                        }
                        if (!string5.equals(this.m_myDir)) continue;
                        string2 = string4;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(dBObject.getConnectionName());
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(dBObject.getConnectionName());
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
            }
        }
        this.m_directoryValue.setSelectedItem(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector<String> getDirectories() {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        if (Connections.getInstance().lock(dBObject.getConnectionName())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                resultSet = dBUtil.executeQuery("select DIRECTORY_NAME from all_directories", Collections.EMPTY_MAP);
                while (resultSet.next()) {
                    vector.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(dBObject.getConnectionName());
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(dBObject.getConnectionName());
        }
        return vector;
    }

    protected Component getOutputNewline() {
        if (this.m_outputComboBox == null) {
            this._recordTerminators = new String[]{DataToolsArb.getString("PLATFORM_DEFAULT"), DataToolsArb.getString("ENV_DEFAULT"), DataToolsArb.getString("IMPORT_FILE"), DataToolsArb.getString("LF"), DataToolsArb.getString("CRLF"), DataToolsArb.getString("CR")};
            this.m_outputComboBox = new JComboBox<String>(this._recordTerminators);
        }
        return this.m_outputComboBox;
    }

    protected Component getNumChars() {
        if (this.m_numChars == null) {
            this.m_numChars = new JTextField("4000", 4);
        }
        return this.m_numChars;
    }

    private Component getUseValidateCmp() {
        this._useValidateCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._useValidateCmp, (String)DataImportArb.getString("VALIDATE"));
        this._useValidateCmp.setToolTipText(DataImportArb.getString("VALIDATE_TIP"));
        this._useValidateCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ExternalOptions.this._validateLimitPanel.getValidateLimitCheckBox().setEnabled(jCheckBox.isSelected());
                ExternalOptions.this._validateLimitPanel.getValidateLimitSpinBox().setEnabled(jCheckBox.isSelected());
                ExternalOptions.this._copyLogCmp.setEnabled(jCheckBox.isSelected());
                ExternalOptions.this._copyBadCmp.setEnabled(jCheckBox.isSelected());
            }
        });
        this._useValidateCmp.setSelected(true);
        return this._useValidateCmp;
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(DataImportArb.getString("OPTIONS_DBMS_CLOUD_INSTR"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    private Component getCopyLogCmp() {
        this._copyLogCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._copyLogCmp, (String)DataImportArb.getString("COPY_LOG"));
        this._copyLogCmp.setToolTipText(DataImportArb.getString("COPY_LOG_TIP"));
        return this._copyLogCmp;
    }

    private Component getCopyBadCmp() {
        this._copyBadCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._copyBadCmp, (String)DataImportArb.getString("COPY_BAD"));
        this._copyBadCmp.setToolTipText(DataImportArb.getString("COPY_BAD_TIP"));
        return this._copyBadCmp;
    }

    private Component getDropBadAndLogCmp() {
        this._dropBadAndLogCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._dropBadAndLogCmp, (String)DataImportArb.getString("DROP_BAD_LOG"));
        this._dropBadAndLogCmp.setToolTipText(DataImportArb.getString("DROP_BAD_LOG_TIP"));
        return this._dropBadAndLogCmp;
    }

    private JLabel getTrimLabel() {
        this._trimLabel = new JLabel(DataImportArb.getString("TRIM_SPACES"));
        this._trimLabel.setToolTipText(DataImportArb.getString("TRIM_SPACES_TIP"));
        this._trimLabel.setLabelFor(this._trimCmp);
        return this._trimLabel;
    }

    private Component getTrimCmp() {
        this._trimCmp.setSelectedIndex(2);
        return this._trimCmp;
    }

    private Component getBlankColumnsCmp() {
        this._blankColumnsCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._blankColumnsCmp, (String)DataImportArb.getString("BLANK_COLUMNS"));
        this._blankColumnsCmp.setToolTipText(DataImportArb.getString("BLANK_COLUMNS_TIP"));
        return this._blankColumnsCmp;
    }

    private Component getTruncateColumnsCmp() {
        this._truncateColumnsCmp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._truncateColumnsCmp, (String)DataImportArb.getString("TRUNCATE_COLUMNS"));
        this._truncateColumnsCmp.setToolTipText(DataImportArb.getString("TRUNCATE_COLUMNS_TIP"));
        return this._truncateColumnsCmp;
    }

    private JLabel getNullRowsLabel() {
        this._nullRowsLabel = new JLabel(DataImportArb.getString("NULL_LINES"));
        this._nullRowsLabel.setToolTipText(DataImportArb.getString("NULL_LINES_TIP"));
        this._nullRowsLabel.setLabelFor(this._nullRowsCmp);
        return this._nullRowsLabel;
    }

    private Component getNullRowsCmp() {
        this._nullRowsCmp.setSelectedIndex(1);
        return this._nullRowsCmp;
    }

    private JLabel getConversionErrorsLabel() {
        this._conversionErrorsLabel = new JLabel(DataImportArb.getString("CONVERSION_ERRORS"));
        this._conversionErrorsLabel.setToolTipText(DataImportArb.getString("CONVERSION_ERRORS_TIP"));
        this._conversionErrorsLabel.setLabelFor(this._conversionErrorsCmp);
        return this._conversionErrorsLabel;
    }

    private Component getConversionErrorsCmp() {
        this._conversionErrorsCmp.setSelectedIndex(1);
        return this._conversionErrorsCmp;
    }

    private JLabel getMissingFieldsLabel() {
        this._missingFieldsLabel = new JLabel(DataImportArb.getString("MISSING_FIELDS"));
        this._missingFieldsLabel.setToolTipText(DataImportArb.getString("MISSING_FIELDS_TIP"));
        this._missingFieldsLabel.setLabelFor(this._missingFieldsCmp);
        return this._missingFieldsLabel;
    }

    private Component getMissingFieldsCmp() {
        this._missingFieldsCmp.setSelectedIndex(0);
        return this._missingFieldsCmp;
    }

    protected Component getTrim() {
        if (this.m_numChars == null) {
            this.m_numChars = new JTextField("4000", 4);
        }
        return this.m_numChars;
    }

    protected Component getCharsetCheckBox() {
        this.m_charsetCheckBox = new JCheckBox();
        this.m_charsetCheckBox.setSelected(true);
        this.m_charsetCheckBox.setText(DataImportArb.getString("GEN_FILE_CHARSET"));
        this.m_charsetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ExternalOptions.this.m_charsetComboBox.setEnabled(jCheckBox.isSelected());
                ExternalOptions.this.m_charsetLabel.setEnabled(jCheckBox.isSelected());
            }
        });
        return this.m_charsetCheckBox;
    }

    protected Component getCharsetComboBox() {
        if (this.m_charsetComboBox == null) {
            String string;
            this.m_charsetComboBox = new JComboBox();
            this.m_charsetComboBox.addItem("");
            NLSLocale nLSLocale = NLSLocale.getInstance();
            Enumeration enumeration = nLSLocale.enumNLSCharsets();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                if (!ExternalOptions.validCharSet(string)) continue;
                if (this.m_charsetComboBox.getItemCount() == 0) {
                    this.m_charsetComboBox.addItem(string);
                    continue;
                }
                boolean bl = false;
                for (int i = 0; i < this.m_charsetComboBox.getItemCount(); ++i) {
                    if (string.compareTo(this.m_charsetComboBox.getItemAt(i).toString()) < 0) {
                        this.m_charsetComboBox.insertItemAt(string, i);
                        bl = true;
                        break;
                    }
                    if (string.compareTo(this.m_charsetComboBox.getItemAt(i).toString()) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.m_charsetComboBox.addItem(string);
            }
            string = this.m_dataFormat == null ? "UTF8" : NLSLocale.getInstance().getNLSCharset(this.m_dataFormat.getEncoding());
            this.m_charsetComboBox.setSelectedItem(string);
            this.m_charsetComboBox.setEditable(true);
        }
        return this.m_charsetComboBox;
    }

    private static boolean validCharSet(String string) {
        return !string.equals("AL16UTF16LE") && !string.equals("ISO2022-CN") && !string.equals("ISO2022-JP") && !string.equals("ISO2022-KR") && !string.equals("HZ-GB-2312");
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        ExternalOptions externalOptions = new ExternalOptions();
        jDialog.add((Component)((Object)externalOptions));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected JLabel getPathLabel() {
        if (this.m_pathLabel == null) {
            this.m_pathLabel = new JLabel();
            this.m_pathLabel.setText(DataImportArb.getString("SERVER_SIDE_PATH"));
        }
        return this.m_pathLabel;
    }

    protected JTextField getPathValue() {
        if (this.m_pathValue == null) {
            this.m_pathValue = new JTextField();
            this.m_pathValue.setText("");
        }
        return this.m_pathValue;
    }

    protected JLabel getDirectoryLabel() {
        if (this.m_directoryLabel == null) {
            this.m_directoryLabel = new JLabel();
            this.m_directoryLabel.setText(DataImportArb.getString("ORACLE_DIRECTORY_NAME"));
        }
        return this.m_directoryLabel;
    }

    protected JComboBox getDirectoryValue() {
        if (this.m_directoryValue == null) {
            this.m_directoryValue = new JComboBox<String>(this.m_dirList);
            this.m_directoryValue.setEditable(true);
        }
        return this.m_directoryValue;
    }
}

