/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.ui.ExternalOptions;
import oracle.dbtools.raptor.data.ui.LoadLimitPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public class ImportMethodPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(ImportMethodPanel.class.getName());
    private JTextField _tableNameField;
    private JTextField _stagingTableNameField;
    private JLabel _stagingTableNameLabel;
    private String _stagingTableName;
    private String _stagingSuffix;
    private JCheckBox _dropStagingTable;
    private JCheckBox _sendToWorksheet;
    private GenericTable _table;
    private JTextPane _instructions;
    private JPanel _mainPanel;
    private LoadLimitPanel _loadLimitPanel;
    private JPanel _gizmoPanel;
    private DataPreviewGizmo _dataGizmo;
    private boolean _init = false;
    private boolean _isExistingTable;
    private TraversableContext _ctx;
    private int _loadMethodType;
    private JComboBox _loadMethod;
    private DefaultComboBoxModel _loadMethodModel;
    private JButton _optionsCmp = new JButton();
    private ExternalOptions _options;
    private ImportProperties _iProps;
    private boolean _isDWCS;
    private boolean _isOSS;
    private boolean _isCart;

    public ImportMethodPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        DBConfig dBConfig = DBConfig.getInstance();
        this._stagingSuffix = dBConfig.getString("IMPORT_ORA_STAGE_SUFFIX");
        this.setLayout(gridBagLayout);
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        int n = 0;
        this._mainPanel = new JPanel(new GridBagLayout());
        this._mainPanel.add((Component)this._instructions, new GridBagConstraints(0, n, 4, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        JLabel jLabel = new JLabel();
        jLabel.setText(DataImportArb.getString("METHOD_LABEL"));
        this._loadMethod = new JComboBox();
        jLabel.setLabelFor(this._loadMethod);
        this._mainPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._loadMethod, new GridBagConstraints(1, n, 1, 1, 0.1, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ImportMethodPanel.this.changeLoadMethod(ImportDataFormat.getLoadMethodType((String)ImportMethodPanel.this._loadMethodModel.getSelectedItem()));
                }
            }
        };
        this._loadMethod.addItemListener(itemListener);
        this.initOptionsComponent();
        this._mainPanel.add((Component)this._optionsCmp, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(3, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Table Name");
        jLabel2.setText(DataImportArb.getString("TABLE_NAME_LABEL"));
        this._tableNameField = new JTextField();
        this._tableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    ImportMethodPanel.this._table.setTableName(string);
                    ImportMethodPanel.this._table.getTable().setTablename(string);
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    ImportMethodPanel.this._tableNameField.setText("");
                    ImportMethodPanel.this._table.setTableName("");
                    ImportMethodPanel.this._table.getTable().setTablename("");
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    ImportMethodPanel.this._stagingTableName = string.substring(0, string.length() - 2) + ImportMethodPanel.this._stagingSuffix + "\"";
                } else {
                    ImportMethodPanel.this._stagingTableName = string + ImportMethodPanel.this._stagingSuffix;
                }
                ImportMethodPanel.this._stagingTableNameField.setText(ImportMethodPanel.this._stagingTableName);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._tableNameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                String string2 = ImportMethodPanel.this._tableNameField.getText();
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    ImportMethodPanel.this._stagingTableName = string2.substring(0, string2.length() - 2) + ImportMethodPanel.this._stagingSuffix + "\"";
                } else {
                    ImportMethodPanel.this._stagingTableName = string2 + ImportMethodPanel.this._stagingSuffix;
                }
                ImportMethodPanel.this._stagingTableNameField.setText(ImportMethodPanel.this._stagingTableName);
                ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
        this._stagingTableNameLabel = new JLabel();
        this._stagingTableNameLabel.setText(DataImportArb.getString("STAGING_TABLE_NAME_LABEL"));
        this._dropStagingTable = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._dropStagingTable, (String)DataImportArb.getString("METHOD_DROP_STAGING"));
        this._dropStagingTable.setToolTipText(DataImportArb.getString("METHOD_DROP_STAGING_TIP"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (ImportMethodPanel.this._isOSS) {
                    ImportMethodPanel.this._stagingTableNameLabel.setVisible(!jCheckBox.isSelected());
                    ImportMethodPanel.this._stagingTableNameField.setVisible(!jCheckBox.isSelected());
                }
            }
        };
        this._dropStagingTable.addActionListener(actionListener);
        this._stagingTableNameField = new JTextField();
        this._stagingTableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    ImportMethodPanel.this._stagingTableName = ImportMethodPanel.this._stagingTableNameField.getText();
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._stagingTableNameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                ImportMethodPanel.this._stagingTableName = ImportMethodPanel.this._stagingTableNameField.getText();
                ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
        this._sendToWorksheet = new JCheckBox();
        this._mainPanel.add((Component)this._sendToWorksheet, new GridBagConstraints(1, ++n, 3, 1, 0.0, 0.0, 18, 0, new Insets(8, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._dropStagingTable, new GridBagConstraints(1, ++n, 3, 1, 0.1, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._tableNameField, new GridBagConstraints(1, n, 3, 1, 1.0, 1.0, 18, 2, new Insets(16, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._stagingTableNameLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._stagingTableNameField, new GridBagConstraints(1, n, 3, 1, 1.0, 1.0, 18, 2, new Insets(16, 6, 0, 0), 0, 0));
        if (this._isOSS) {
            this._sendToWorksheet.setVisible(false);
        }
        this._loadLimitPanel = new LoadLimitPanel(null, true);
        this._loadLimitPanel.onEntry();
        this._mainPanel.add((Component)this._loadLimitPanel.getUseLoadLimitComponent(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._loadLimitPanel.getLoadLimitComponent(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 6, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.DEFAULT_STAGING_SUFFIX, DataImportArb.getString("METHOD_STAGING_SUFFIX"));
        boolean bl = this._isDWCS && this._isOSS && this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) == false || !this._isOSS && this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false;
        this._isDWCS = this._iProps.getValueBoolean(ImportKeys.IS_DWCS);
        this._isOSS = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
        this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        if (this._stagingSuffix == null || this._stagingSuffix.length() == 0) {
            this._stagingSuffix = (String)this._iProps.get(ImportKeys.DEFAULT_STAGING_SUFFIX);
        }
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        ImportDataFormat importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        DataReadable dataReadable = DataReaderRegistry.getReader(loadFile.getType() != null ? loadFile.getType() : importDataFormat.getFormat());
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (!this._init) {
            this._init = true;
            this._isExistingTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this.populateDBO(traversableContext);
            this.populateTableName();
            this._loadMethodModel = null;
            this._dataGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
            boolean bl2 = (Boolean)this._iProps.get(ImportKeys.IS_CONFIGFILE);
            int n = bl2 ? (Integer)this._iProps.get(ImportKeys.LOAD_METHOD) : ImportDataFormat.getDefaultNewLoadMethod(dataReadable.isOracleLoaderReadable());
            if (!this._isDWCS) {
                if (this._isExistingTable && !bl2) {
                    this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getExistingLoadMethods(dataReadable.isOracleLoaderReadable()));
                    n = ImportDataFormat.getDefaultExistingLoadMethod(dataReadable.isOracleLoaderReadable());
                } else {
                    this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getNewLoadMethods(dataReadable.isOracleLoaderReadable()));
                }
            } else if (this._isExistingTable && !bl2) {
                this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getDwcsExistingLoadMethods(this._isOSS));
                n = ImportDataFormat.getDefaultDwcsExistingMethod(this._isOSS);
            } else if (this._isExistingTable) {
                this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getDwcsExistingLoadMethods(this._isOSS));
            } else {
                this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getDwcsNewLoadMethods(this._isOSS));
                if (!bl2) {
                    n = ImportDataFormat.getDefaultDwcsNewMethod(this._isOSS);
                }
            }
            if (this._isOSS) {
                this._sendToWorksheet.setText(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET_OSS"));
            } else {
                this._sendToWorksheet.setText(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET"));
            }
            if (bl2) {
                this._stagingTableName = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
                this._sendToWorksheet.setSelected(this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET));
                this._dropStagingTable.setSelected((Boolean)this._iProps.get(ImportKeys.DROP_STAGING_TABLE));
                this._tableNameField.setText((String)this._iProps.get(ImportKeys.TABLE_NAME));
            } else {
                this._sendToWorksheet.setSelected(!this._isOSS);
                this._dropStagingTable.setSelected(true);
            }
            this._loadLimitPanel.onEntry(this._iProps);
            this.setLayout(new BorderLayout());
            this.add(this._mainPanel, "North");
            this._gizmoPanel = new JPanel(new BorderLayout(0, 0));
            this._gizmoPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
            this._gizmoPanel.add((Component)this._dataGizmo, "Center");
            this.add(this._gizmoPanel, "Center");
            this._loadMethod.setModel(this._loadMethodModel);
            try {
                this._loadMethodModel.setSelectedItem(ImportDataFormat.getLoadMethodName(n));
            }
            catch (Exception exception) {
                n = 1;
                this._loadMethodModel.setSelectedItem(ImportDataFormat.METHOD_INSERT_SCRIPT_NAME);
            }
            this.changeLoadMethod(n);
        } else {
            this.setInstruction((DBObject)this._iProps.get(ImportKeys.DBOBJECT));
            if (!this._isOSS) {
                this._sendToWorksheet.setText(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET"));
            } else {
                this._sendToWorksheet.setText(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET_OSS"));
            }
            if (bl) {
                this._loadMethodModel = new DefaultComboBoxModel<String>(this._isExistingTable ? ImportDataFormat.getDwcsExistingLoadMethods(this._isOSS) : ImportDataFormat.getDwcsNewLoadMethods(this._isOSS));
                this._loadMethodModel.setSelectedItem(ImportDataFormat.getLoadMethodName(this._isExistingTable ? ImportDataFormat.getDefaultDwcsExistingMethod(this._isOSS) : ImportDataFormat.getDefaultDwcsNewMethod(this._isOSS)));
                this._loadMethod.setModel(this._loadMethodModel);
                this.changeLoadMethod(this._isExistingTable ? ImportDataFormat.getDefaultDwcsExistingMethod(this._isOSS) : ImportDataFormat.getDefaultDwcsNewMethod(this._isOSS));
            }
            if (this._iProps.get(ImportKeys.TABLE) == null) {
                this.populateDBO(traversableContext);
            }
            this._dataGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
            this._gizmoPanel.remove(this._dataGizmo);
            this._gizmoPanel.add((Component)this._dataGizmo, "Center");
        }
        this._optionsCmp.setVisible(this._isOSS);
        if (this._isOSS) {
            if (this._options == null) {
                this._options = new ExternalOptions();
            }
            this._iProps.put(ImportKeys.LOAD_METHOD, this._loadMethodType);
            this._options.onEntry(this._ctx);
            try {
                this._options.onExit(this._ctx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSendToWorksheetComponents();
        this.setloadLimitComponents();
        traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
    }

    private void initOptionsComponent() {
        this._optionsCmp.setText(StringUtils.stripMnemonic((String)DataImportArb.getString("METHOD_LOAD_OPTIONS")));
        this._optionsCmp.setMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("METHOD_LOAD_OPTIONS")));
        this._optionsCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportMethodPanel.this.showOptions();
            }
        });
    }

    private void showOptions() {
        this._options.setImportMethod(this._loadMethodType);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this._options), "f1_importcloudloadoptions_html");
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)this._options), null, (String)StringUtils.stripMnemonic((String)DataImportArb.getString("METHOD_LOAD_OPTIONS")), (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    try {
                        ImportMethodPanel.this._options.onExit(ImportMethodPanel.this._ctx);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jEWTDialog.setVisible(false);
                jEWTDialog.dispose();
            }
        };
        jEWTDialog.addActionListener(actionListener);
        Dimension dimension = this._options.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 40;
        jEWTDialog.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    private void populateTableName() {
        String string;
        this._tableNameField.setEnabled(!this._isExistingTable);
        String string2 = string = this._table.getTable().getTablename() == null ? "" : this._table.getTable().getTablename();
        if (!this._isExistingTable) {
            this._tableNameField.setText(string);
        } else {
            this._tableNameField.setText(DBUtil.addDoubleQuote((String)string));
        }
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._stagingTableName == null) {
            this._stagingTableName = string.startsWith("\"") && string.endsWith("\"") ? string.substring(0, string.length() - 2) + this._stagingSuffix + "\"" : string + this._stagingSuffix;
            this._dropStagingTable.setSelected(dBConfig.getBoolean("IMPORT_ORA_STAGE_DROP"));
        }
        this._stagingTableNameField.setText(this._stagingTableName);
        if (this._tableNameField.getText().trim().length() > 0) {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public Object getExitTransition() {
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        return Boolean.valueOf(n == 2 || n == 3 || n == 4) != false || n == 5 && this._isOSS;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        if (traversableContext.getDirection() == 1) {
            if (this._tableNameField.getText().trim().length() > 0) {
                if (dBObject != null && !dBObject.getDatabase().isValidName("TABLE", this._tableNameField.getText().trim())) {
                    throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
                }
            } else {
                this._tableNameField.setText("");
                throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
            }
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            if (this._loadMethodType == 2 || this._loadMethodType == 3 || this._loadMethodType == 4) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
        }
        DBUtil dBUtil = null;
        if (dBObject != null) {
            string = dBObject.getConnectionName();
            dBUtil = DBUtil.getInstance((String)string);
            if (traversableContext.getDirection() == 1 && !this._isExistingTable) {
                String string2 = this._tableNameField.getText();
                if (!(this._iProps.getValueBoolean(ImportKeys.IS_CLEANUP_TEST_NEEDED).booleanValue() && string2.equals((String)this._iProps.get(ImportKeys.TABLE_NAME)) || dBUtil.resolveName(string2) == null)) {
                    throw new TraversalException(DataImportArb.format("TABLE_NAME_EXISTS_ERROR", string2));
                }
            }
        }
        if (this._loadMethodType == 3) {
            string = this._stagingTableNameField.getText().trim();
            this._iProps.put(ImportKeys.STAGING_TABLE_NAME, string);
            this._iProps.put(ImportKeys.DROP_STAGING_TABLE, this._dropStagingTable.isSelected());
            if (traversableContext.getDirection() == 1 && !this._isOSS) {
                if (string.length() > 0) {
                    if (dBObject != null && !dBObject.getDatabase().isValidName("TABLE", this._stagingTableNameField.getText().trim())) {
                        throw new TraversalException(DataImportArb.getString("INVALID_STAGING_TABLE_NAME"));
                    }
                    if (dBObject != null && dBUtil.resolveName(string) != null) {
                        throw new TraversalException(DataImportArb.format("STAGING_TABLE_NAME_EXISTS_ERROR", string));
                    }
                    this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    throw new TraversalException(DataImportArb.getString("MISSING_STAGING_TABLE_NAME"));
                }
            }
        }
        this._iProps.put(ImportKeys.IS_EXISTING_TABLE, this._isExistingTable);
        this._iProps.put(ImportKeys.TABLE_NAME, this._tableNameField.getText());
        this._table.setTableName(this._tableNameField.getText());
        this._loadLimitPanel.onExit(this._iProps);
        if (this._isExistingTable && !this._isOSS) {
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, false);
        } else {
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, this._sendToWorksheet.isSelected());
        }
        this._iProps.put(ImportKeys.LOAD_METHOD, this._loadMethodType);
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        GenericTable genericTable = null;
        if (this._iProps.get(ImportKeys.TABLE) != null) {
            genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            this.setTable(genericTable);
        } else {
            if (this._iProps.get(ImportKeys.DBOBJECT) == null) {
                genericTable = new GenericTable();
            } else if (((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getObjectName() != null) {
                Column[] columnArray = (Column[])this._iProps.get(ImportKeys.DBOBJECT);
                try {
                    genericTable = new GenericTable(Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), columnArray.getSchemaName(), columnArray.getObjectName());
                }
                catch (DBException dBException) {
                    LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                }
            } else {
                genericTable = new GenericTable();
            }
            if (!this._isExistingTable) {
                genericTable.setColumns((Column[])this._iProps.get(ImportKeys.FILE_COLUMNS));
                for (Column column : genericTable.getColumns()) {
                    column.setPrecision(0);
                }
            }
            this.setTable(genericTable);
            this._iProps.put(ImportKeys.TABLE, genericTable);
        }
        this.setInstruction((DBObject)this._iProps.get(ImportKeys.DBOBJECT));
    }

    private void setInstruction(DBObject dBObject) {
        if (this._isDWCS) {
            if (DataUIUtils.isExisting(dBObject)) {
                this._instructions.setText(this._isOSS ? DataImportArb.getString("METHOD_EXISTING_INFO_ADWC_OSS") : DataImportArb.getString("METHOD_EXISTING_INFO_ADWC_LOCAL"));
                return;
            }
            this._instructions.setText(this._isOSS ? DataImportArb.getString("METHOD_CREATE_INFO_ADWC_OSS") : DataImportArb.getString("METHOD_CREATE_INFO_ADWC_LOCAL"));
            return;
        }
        if (DataUIUtils.isExisting(dBObject)) {
            this._instructions.setText(DataImportArb.getString("METHOD_EXISTING_INFO"));
            return;
        }
        this._instructions.setText(DataImportArb.getString("METHOD_CREATE_INFO"));
    }

    private void changeLoadMethod(int n) {
        this._loadMethodType = n;
        this.enableStagingComponents(this._loadMethodType == 3);
        this.enableLoadLimitComponents(this._loadMethodType != 2);
        if (!this._isExistingTable) {
            this.setSendToWorksheetComponents();
        }
        this._stagingTableNameField.setText(this._stagingTableName);
        if (this._loadMethodType == 2 || this._loadMethodType == 3) {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
        } else if (this._loadMethodType == 4) {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        } else {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        }
    }

    private void enableStagingComponents(boolean bl) {
        this._stagingTableNameField.setEnabled(bl);
        this._stagingTableNameLabel.setEnabled(bl);
        this._dropStagingTable.setEnabled(bl);
        if (this._isOSS) {
            this._stagingTableNameField.setVisible(bl && !this._dropStagingTable.isSelected());
            this._stagingTableNameLabel.setVisible(bl && !this._dropStagingTable.isSelected());
        } else {
            this._stagingTableNameField.setVisible(bl);
            this._stagingTableNameLabel.setVisible(bl);
        }
        this._dropStagingTable.setVisible(bl);
    }

    private void enableLoadLimitComponents(boolean bl) {
        this._loadLimitPanel.getUseLoadLimitComponent().setEnabled(bl);
        this._loadLimitPanel.getLoadLimitComponent().setEnabled(bl);
    }

    private void setSendToWorksheetComponents() {
        if (this._loadMethodType == 1 || this._loadMethodType == 2 || this._loadMethodType == 3 || this._loadMethodType == 5) {
            if (!this._isOSS && !this._isCart) {
                this._sendToWorksheet.setSelected(true);
                this._sendToWorksheet.setEnabled(false);
                this._sendToWorksheet.setVisible(true);
            } else {
                this._sendToWorksheet.setSelected(false);
                this._sendToWorksheet.setEnabled(true);
                this._sendToWorksheet.setVisible(false);
            }
        } else if (this._loadMethodType == 0) {
            this._sendToWorksheet.setSelected(false);
            this._sendToWorksheet.setEnabled(false);
        } else {
            this._sendToWorksheet.setSelected(true);
            this._sendToWorksheet.setEnabled(true);
        }
    }

    private void setloadLimitComponents() {
        if (this._loadMethodType == 1 || this._loadMethodType == 0) {
            this._loadLimitPanel.getUseLoadLimitComponent().setVisible(true);
            this._loadLimitPanel.getLoadLimitComponent().setVisible(true);
        } else {
            this._loadLimitPanel.getUseLoadLimitComponent().setVisible(false);
            this._loadLimitPanel.getLoadLimitComponent().setVisible(false);
        }
    }

    private void setTable(GenericTable genericTable) {
        this._table = genericTable;
    }
}

