/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class RejectLimitPanel {
    private JCheckBox rejectLimitCheckBox;
    private NumericSpinBox rejectLimitSpinBox;
    private boolean checkBoxControlled;
    private static final long serialVersionUID = -2739487292165944123L;

    public RejectLimitPanel() {
        this(true);
    }

    public RejectLimitPanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initRejectLimit();
    }

    public JCheckBox getRejectLimitCheckBox() {
        return this.rejectLimitCheckBox;
    }

    public NumericSpinBox getRejectLimitSpinBox() {
        return this.rejectLimitSpinBox;
    }

    void initRejectLimit() {
        this.initRejectLimit(100);
    }

    void initRejectLimit(int n) {
        this.rejectLimitCheckBox = new JCheckBox();
        this.rejectLimitCheckBox.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.rejectLimitCheckBox, (String)DataImportArb.getString("WIZARD_REJECT_LIMIT"));
        if (this.checkBoxControlled) {
            this.rejectLimitCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    RejectLimitPanel.this.rejectLimitSpinBox.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.rejectLimitSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
        ((NumericSpinBoxModel)this.rejectLimitSpinBox.getModel()).skip(100);
        ((NumericSpinBoxModel)this.rejectLimitSpinBox.getModel()).setValue(n);
    }

    public void setRejectLimit(int n) {
        this.rejectLimitSpinBox.setIntValue(n);
    }

    public void onEntry() {
        this.setOptions();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.setOptions();
    }

    private void setOptions() {
        this.rejectLimitCheckBox.setSelected(true);
        this.rejectLimitSpinBox.setIntValue(100);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ImportProperties importProperties = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        importProperties.put(ImportKeys.USE_REJECT_LIMIT, this.rejectLimitCheckBox.isSelected());
        importProperties.put(ImportKeys.REJECT_LIMIT, this.rejectLimitSpinBox.getIntValue());
    }
}

