/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ValidateLimitPanel {
    private JCheckBox validateLimitCheckBox;
    private NumericSpinBox validateLimitSpinBox;
    private boolean checkBoxControlled;
    private static final long serialVersionUID = -2739487292165944123L;

    public ValidateLimitPanel() {
        this(true);
    }

    public ValidateLimitPanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initValidateLimit();
    }

    public JCheckBox getValidateLimitCheckBox() {
        return this.validateLimitCheckBox;
    }

    public NumericSpinBox getValidateLimitSpinBox() {
        return this.validateLimitSpinBox;
    }

    void initValidateLimit() {
        this.validateLimitCheckBox = new JCheckBox();
        this.validateLimitCheckBox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this.validateLimitCheckBox, (String)DataImportArb.getString("VALIDATE_LIMIT"));
        if (this.checkBoxControlled) {
            this.validateLimitCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    ValidateLimitPanel.this.validateLimitSpinBox.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.validateLimitSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
        ((NumericSpinBoxModel)this.validateLimitSpinBox.getModel()).skip(100);
        ((NumericSpinBoxModel)this.validateLimitSpinBox.getModel()).setValue(100);
    }

    public void onEntry() {
        this.setOptions();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.setOptions();
    }

    private void setOptions() {
        this.validateLimitCheckBox.setSelected(false);
        this.validateLimitSpinBox.setIntValue(100);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ImportProperties importProperties = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        importProperties.put(ImportKeys.USE_VALIDATE_LIMIT, this.validateLimitCheckBox.isSelected());
        importProperties.put(ImportKeys.VALIDATE_LIMIT, this.validateLimitSpinBox.getIntValue());
    }
}

