/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.DnDDropGenerator;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.raptor.data.formattors.NumberFormattorImport;
import oracle.dbtools.raptor.data.writers.ImportGenHelper;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public abstract class ImportGen {
    private static final String DEFAULT_GROUP_QUOTE = "importgen";
    protected final String ENCODING_UTF8 = "UTF-8";
    private final String NL = "\n";
    private static STGroup _templateGroup = null;
    private ImportProperties _iProps;
    private GenericTable _genTable;
    private boolean _isExistingTable;
    private boolean _isBatch;
    private Connection _baseConn;
    private String _baseUser;
    private String _schemaName;
    private String _connName;
    private ImportDataFormat _dataFormat;
    private ImportWriteStream _stream;
    private String _encoding;
    private ExtractLogger _eLogger;
    Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGen(ImportProperties importProperties) {
        this._iProps = importProperties;
    }

    public ExitCode start() {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.1"));
        try {
            this._encoding = Ide.getEnvironOptions().getEncoding();
            this._stream = (ImportWriteStream)this._iProps.get(ImportKeys.IMPORT_WRITE_STREAM);
            this._isExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
            this._isBatch = this._iProps.getValueBoolean(ImportKeys.IS_BATCH);
            this._genTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            if (dBObject != null) {
                this._connName = dBObject.getConnectionName();
                this._baseConn = Connections.getInstance().getConnection(this._connName);
                this._baseUser = this._baseConn.getMetaData().getUserName();
                this._schemaName = dBObject.getSchemaName();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exception.getMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public void putWriteStream(ImportWriteStream importWriteStream) {
        this._stream = importWriteStream;
    }

    public abstract ExitCode generate();

    public boolean test(BigDecimal bigDecimal) {
        return true;
    }

    protected boolean isBatch() {
        return this._isBatch;
    }

    protected boolean isExistingTable() {
        return this._isExistingTable;
    }

    protected Connection getConn() {
        return this._baseConn;
    }

    protected String getConnName() {
        return this._connName;
    }

    protected String getUser() {
        return this._baseUser;
    }

    protected String getSchemaName() {
        return this._schemaName;
    }

    protected GenericTable getGenTable() {
        return this._genTable;
    }

    protected String getTableName() {
        if (this._genTable != null && this._genTable.getTable() != null) {
            return this._genTable.getTable().getTablename();
        }
        return (String)this._iProps.get(ImportKeys.TABLE_NAME);
    }

    protected ImportDataFormat getDataFormat() {
        return this._dataFormat;
    }

    protected ImportWriteStream getStream() {
        return this._stream;
    }

    protected String getEncoding() {
        return this._encoding;
    }

    protected String addUser(String string) {
        return ImportGenHelper.addUser(this._iProps, string);
    }

    protected String addDoubleQuote(String string) {
        return ImportGenHelper.addDoubleQuote(this._iProps, string);
    }

    protected String translateEOL(String string) {
        return ImportGenHelper.translateEOL(this._iProps, string);
    }

    protected String dos(String string) {
        return ImportGenHelper.dos(string);
    }

    protected String nix(String string) {
        return ImportGenHelper.dos(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getLogFromTest() {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        if (this.getStream() != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this._stream.getLogName());
                String string = Ide.getEnvironOptions().getEncoding();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
                bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                this._stream = null;
            }
        }
        return stringBuffer;
    }

    public void cleanUpTest() {
    }

    public boolean isLogRows() {
        return false;
    }

    public boolean isBadRows() {
        return false;
    }

    public boolean isDataRows() {
        return true;
    }

    public BigDecimal getOperationId() {
        return null;
    }

    public String putBadFileTest() {
        return null;
    }

    public void cleanupBadFileTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutFile(File file, String string) {
        OutputStreamWriter outputStreamWriter = null;
        String string2 = DBConfig.getInstance().getString("IMPORT_LDR_GEN_ENCODING");
        try {
            outputStreamWriter = string2 != null && string2.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2) : (this._encoding == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this._encoding));
            outputStreamWriter.write(string);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
    }

    public String getCreateTableStatementWithComments() {
        return this.getCreateTableStatementWithComments(null);
    }

    public String getCreateTableStatementWithComments(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        stringBuffer.append(this.getCreateTableStatement(string) + "\n\n");
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
            stringBuffer.append(this.getCommentStatement(string != null ? string : this._genTable.getTable().getTablename(), columnArray[i].getName(), columnArray[i].getComment()) + "\n\n");
        }
        return stringBuffer.toString();
    }

    protected String getCreateTableStatement() {
        return this.getCreateTableStatement(null);
    }

    protected String getCreateTableStatement(String string) {
        String string2 = string != null ? string : this._genTable.getTable().getTablename();
        String[] stringArray = this.formatTableColumns();
        ST sT = this.getTemplateGroup().getInstanceOf("CreateTableStatement");
        sT.add("tableName", (Object)this.addUser(string2));
        sT.add("colList", (Object)stringArray);
        return sT.render();
    }

    public String getComments() {
        return this.getComments(null);
    }

    public String getComments(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
            stringBuffer.append(this.getCommentStatement(string != null ? string : this._genTable.getTable().getTablename(), columnArray[i].getName(), columnArray[i].getComment()) + "\n\n");
        }
        return stringBuffer.toString();
    }

    protected String getCommentStatement(String string, String string2, String string3) {
        ST sT = this.getTemplateGroup().getInstanceOf("CommentOnColumnStatement");
        sT.add("tableName", (Object)this.addUser(string));
        sT.add("colName", (Object)this.addDoubleQuote(string2));
        sT.add("comment", (Object)string3);
        return sT.render();
    }

    protected String getInsertStatement(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 1);
    }

    protected String getInsertStatementForPrepare(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 2);
    }

    protected String getInsertStatementForError(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 3);
    }

    protected String getInsertStatementForComment(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 4);
    }

    private String getInsertStatement(String string, Column[] columnArray, Object[] objectArray, int n) {
        int n2;
        ST sT;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 1) {
            sT = this.getTemplateGroup().getInstanceOf("InsertStatement");
        } else if (n == 2) {
            bl = true;
            sT = this.getTemplateGroup().getInstanceOf("InsertStatementForPrepare");
        } else if (n == 3) {
            bl2 = true;
            sT = this.getTemplateGroup().getInstanceOf("InsertStatementForError");
        } else {
            sT = this.getTemplateGroup().getInstanceOf("InsertStatementForComment");
        }
        String[] stringArray = new String[columnArray.length];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColID() < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String[] stringArray2 = new String[objectArray2.length];
        ITypeFormattor iTypeFormattor = null;
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            stringArray[n2] = this._isExistingTable ? DBUtil.addDoubleQuote((String)columnArray[n2].getName()) : columnArray[n2].getName();
        }
        if (!bl2) {
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                String string2;
                if (bl) {
                    stringArray2[n2] = "?";
                    continue;
                }
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[n2].getType());
                if (iTypeFormattor == null) {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
                if (iTypeFormattor instanceof NumberFormattorImport) {
                    ((NumberFormattorImport)iTypeFormattor).setNlsDecimalSeparator((Character)this._iProps.get(ImportKeys.NLS_DECIMAL_SEPARATOR));
                }
                if ((string2 = iTypeFormattor.formatData(objectArray2[n2], columnArray[n2])).length() > 4000) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = string2.length();
                    if ((n3 = (string2 = string2.substring(1, n3 - 1)).length()) > 0) {
                        int n4 = 0;
                        int n5 = 500;
                        while (n3 > 0) {
                            String string3 = string2.substring(n4, n5);
                            if (string3.endsWith("'") && !string3.endsWith("''")) {
                                --n5;
                            }
                            stringBuffer.append("TO_CLOB('" + string2.substring(n4, n5));
                            if ((n3 -= n5 - n4) == 0) {
                                stringBuffer.append("')");
                            } else {
                                stringBuffer.append("')\n|| ");
                            }
                            n4 = n5;
                            n5 += Math.min(500, n3);
                        }
                        string2 = stringBuffer.toString();
                    } else {
                        stringBuffer.append("''");
                    }
                }
                stringArray2[n2] = string2;
            }
        }
        sT.add("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        sT.add("colList", (Object)stringArray);
        if (!bl2) {
            sT.add("valList", (Object)stringArray2);
        }
        return sT.render();
    }

    protected String[] formatTableColumns() {
        return ImportGenHelper.formatTableColumns(this._iProps);
    }

    protected String[] formatTableColumns(boolean bl) {
        return ImportGenHelper.formatTableColumns(this._iProps, bl);
    }

    protected void loadTemplates() {
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    public void setTemplateName(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DnDDropGenerator.class.getClassLoader());
        try {
            this.setTemplateGroup((STGroup)new STGroupFile("oracle/dbtools/raptor/data/templates/" + string + ".stg"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void setTemplateGroup(STGroup sTGroup) {
        _templateGroup = sTGroup;
    }

    protected STGroup getTemplateGroup() {
        if (_templateGroup == null) {
            this.loadTemplates();
        }
        return _templateGroup;
    }

    protected static void openSqlNodeForURL(URL uRL) throws Exception {
        SqlNode sqlNode = null;
        sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
        final SqlNode sqlNode2 = sqlNode;
        if (sqlNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                }
            });
        }
    }

    protected static void openTextNodeForURL(URL uRL) throws Exception {
        TextNode textNode = null;
        textNode = (TextNode)NodeFactory.findOrCreate(TextNode.class, (URL)uRL);
        final TextNode textNode2 = textNode;
        if (textNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)textNode2);
                        }
                    });
                }
            });
        }
    }

    protected ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
        ObjectAction objectAction = (ObjectAction)((Object)this._iProps.get(ImportKeys.OBJECTACTION));
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
        return objectActionPostProcess;
    }

    protected boolean isFileWritable(String string) {
        File file = new File(string);
        boolean bl = true;
        if (file.exists()) {
            boolean bl2 = bl = this._iProps.getValueBoolean(ImportKeys.IS_BATCH) == false;
            if (bl) {
                AskDelete askDelete = new AskDelete(string);
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        askDelete.run();
                    } else {
                        SwingUtilities.invokeAndWait(askDelete);
                    }
                    if (askDelete.getDeleted() != null && askDelete.getDeleted().equals(Boolean.FALSE)) {
                        bl = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
                }
            }
        }
        return bl;
    }

    protected void eLog(String string) {
        if (this._eLogger != null) {
            this._eLogger.log(string);
        }
    }

    protected void eLogException(Throwable throwable) {
        if (throwable != null && this._eLogger != null) {
            this._eLogger.logException(throwable);
        }
    }

    protected void eLogHref(URL uRL) {
        if (uRL != null && this._eLogger != null) {
            this._eLogger.logHref(uRL);
        }
    }

    protected void eLogToolEnd() {
        if (this._eLogger != null) {
            this._eLogger.logToolEnd();
        }
    }

    protected void initELogger() {
        this._eLogger = new ExtractLogger(ExtractMessagePage.EXTRACT_VIEW_ID);
        this._eLogger.logToolStart(this.getELoggerName());
    }

    protected void eLogImportMessages() {
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        String string = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : loadFile.getName();
        this.eLog(DataImportArb.format("IMPORT_ELOG", string, Connections.getDisplayName((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), ImportGenHelper.getSchema(this._iProps), this.getTableName()));
        int n = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        this.eLog(DataImportArb.format("IMPORT_LOAD_METHOD", ImportDataFormat.getLoadMethodName(n)));
    }

    protected ExtractLogger getELogger() {
        return this._eLogger;
    }

    protected String getELoggerName() {
        return DataImportArb.getString("IMPORT_TOOL");
    }

    static class AskDelete
    implements Runnable {
        private Boolean deleted = Boolean.FALSE;
        private String in = null;
        private File inFile = null;

        public AskDelete(String string) {
            this.in = string;
            this.inFile = new File(this.in);
        }

        @Override
        public void run() {
            String string = this.in;
            int n = this.in.lastIndexOf(File.separator);
            if (n != -1) {
                string = this.in.substring(n + 1);
            }
            switch (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("FILE_EXISTS_OVERWRITE"), (String)string)) {
                case 1: {
                    this.inFile.delete();
                    this.deleted = Boolean.TRUE;
                    break;
                }
                default: {
                    this.deleted = Boolean.FALSE;
                }
            }
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }
}

