/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGenExec;
import oracle.dbtools.raptor.data.writers.ImportGenHelper;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.extract.DbmsCloudAPI;
import oracle.dbtools.raptor.extract.DbmsCloudResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import org.stringtemplate.v4.ST;

public class ImportGenDbmsCloud
extends ImportGenExec {
    private static final String AND = " AND ";
    private static final String BEGIN = "begin";
    private static final String CLOSEP = ")";
    private static final String COMMA = ",";
    private static final String CREDENTIAL_NAME = "credential_name => ";
    private static final String DBMS_CLOUD_OWNER = "C##CLOUD$SERVICE";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String TAB = "\\t";
    private static final String TABLE_NAME = "table_name => ";
    private static final String DOT = ".";
    private static final String END = "end";
    private static final String FILE_URI_LIST = "file_uri_list => ";
    private static final String NL = "\n";
    private static final String OPENP = "(";
    private static final String SINGLEQ = "'";
    private static final String SEMI = ";";
    private static final String SLASH = "/";
    private static final String SPACE = " ";
    private static final String VALUE = " value ";
    private ImportProperties _iProps;
    private RaptorTask<Void> _task;
    private boolean _isValid = false;
    private boolean _isSendToWorksheet = false;
    private String _tableName;
    private String _stagingTableName;
    private String _xTableName;
    private BigDecimal _operationId;
    private boolean _isBadRows = false;
    private boolean _isLogRows = false;
    private boolean _isDataRows = false;
    private ArrayList<String> _badFileNames;
    private String _xTabBad;
    private String _xTabLog;
    private int _loadMethod;
    private DbmsCloudAPI _cloudAPI;
    public static final String dbms_cloudCreateExternalTablePrefix = "{call ";
    public static final String dbms_cloudCreateExternalTableSuffix = " }";
    public static final String dbms_cloudGetXTabCount1 = "select count(*) from ";
    public static final String dbms_cloudGetXTabCount2 = " where rownum = ";

    public ImportGenDbmsCloud(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        this._tableName = this.getTableName();
        this._stagingTableName = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        this._loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        this._xTableName = this._loadMethod == 3 || this._loadMethod == 5 ? this.addUser(this._stagingTableName) : this.addUser(this.addDoubleQuote(this._tableName));
        this._isSendToWorksheet = this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET);
        this._isDataRows = false;
        this._isLogRows = false;
        this._isBadRows = false;
        this._operationId = null;
        this._isValid = exitCode == ExitCode.EXIT_SUCCESS;
        return this.validate();
    }

    @Override
    public ExitCode generate() {
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        return super.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doImport(RaptorTask<Void> raptorTask) {
        if (raptorTask != null) {
            this._task = raptorTask;
            this.setProgressUpdater(raptorTask.getRaptorTaskProgressUpdater());
        }
        boolean bl = false;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this.initELogger();
            this.eLogImportMessages();
        }
        try {
            bl = this._isSendToWorksheet ? this.generateScript() : this.generateExec();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (!this.isBatch()) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.77"));
                if (this.getStream() != null) {
                    URL uRL = this.getStream().getURL();
                    try {
                        this.getStream().closeLog();
                        ImportGenDbmsCloud.openTextNodeForURL(uRL);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    try {
                        this.eLogHref(uRL);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        this.eLogException(exception);
                    }
                }
            }
            this.getStream().finished();
        }
        return bl;
    }

    private boolean generateScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        if (!(this.isExistingTable() || this._loadMethod != 3 && this._loadMethod != 5)) {
            stringBuffer.append(this.getCreateTableStatementWithComments() + NL);
        }
        if (this._loadMethod == 5) {
            stringBuffer.append(this.getCloudAPI().getCopyDataStatement(this._tableName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this.getSchemaName(), this.getFields(), this.getFormat()));
        } else {
            stringBuffer.append(this.getExtCreateTableStatementStatement() + "\n\n");
            stringBuffer.append(this.getSanityCheck());
            stringBuffer.append(this.getValidateExternalTableStatement());
            if (this._loadMethod == 3) {
                stringBuffer.append(this.getInsertStatementFromStaging() + "\n\n");
            }
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("\\r", "");
        this.getStream().println(string);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.68"));
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateExec() {
        boolean bl = false;
        try {
            Object object;
            boolean bl2 = this._loadMethod == 3 || this._loadMethod == 5;
            boolean bl3 = this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE);
            boolean bl4 = this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT);
            BigDecimal bigDecimal = null;
            if (bl4) {
                bigDecimal = new BigDecimal(this._iProps.getValueInteger(ImportKeys.VALIDATE_LIMIT));
            }
            boolean bl5 = this._iProps.getValueBoolean(ImportKeys.DROP_STAGING_TABLE);
            boolean bl6 = this._iProps.getValueBoolean(ImportKeys.IS_COPY_LOG);
            boolean bl7 = this._iProps.getValueBoolean(ImportKeys.IS_COPY_BAD);
            boolean bl8 = this._iProps.getValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG);
            this._operationId = null;
            String string = null;
            if (!this.isExistingTable() && bl2) {
                this.setProgress(DataImportArb.getString("TASK_PROGRESS_CREATE_TABLE"));
                if (!this.doCreateTable()) {
                    return true;
                }
                this.checkCanProceed();
            }
            if (this._loadMethod == 5) {
                string = "COPY$";
                this.setProgress(DataImportArb.getString("TASK_PROGRESS_COPY_DATA"));
                try {
                    object = this.getCloudAPI().getCopyDataProcedure(this._tableName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this.getSchemaName(), this.getFields(), this.getFormat());
                    this._operationId = this.getCloudAPI().doCopy((String)object);
                    this.checkCanProceed();
                }
                catch (SQLException sQLException) {
                    this.setExitCode(this._cloudAPI.getExitCode());
                    this._operationId = this._cloudAPI.getLastOperationId();
                    bl = false;
                }
                this._isDataRows = this.getCloudAPI().isDataRows(this._tableName);
                this.checkCanProceed();
            } else {
                string = "VALIDATE$";
                this.setProgress(DataImportArb.getString("TASK_PROGRESS_CREATE_XTABLE"));
                object = this.getExtCreateTableStatement();
                try {
                    this.createExternalTable((String)object);
                    this._isDataRows = this.getCloudAPI().isDataRows(this._xTableName);
                    this.checkCanProceed();
                }
                catch (SQLException sQLException) {
                    this.getStream().println(DataImportArb.format("VAL_FAILED", sQLException.getMessage()));
                    bl = false;
                }
                if (bl3) {
                    this.setProgress(DataImportArb.getString("TASK_PROGRESS_VAL_XTABLE"));
                    try {
                        this._operationId = this.validateExternalTable(this._xTableName, this.getSchemaName(), bigDecimal);
                        this.checkCanProceed();
                    }
                    catch (SQLException sQLException) {
                        this.setExitCode(this._cloudAPI.getExitCode());
                        this._operationId = this._cloudAPI.getLastOperationId();
                        bl = false;
                    }
                }
            }
            if (this._operationId != null) {
                this.setProgress(DataImportArb.getString("TASK_PROGRESS_RESULTS"));
                this._xTabLog = string + this._operationId + "_LOG";
                this._xTabBad = string + this._operationId + "_BAD";
                this._badFileNames = new ArrayList();
                object = new ArrayList();
                String string2 = (String)this._iProps.get(ImportKeys.OSS_PATH);
                this._isLogRows = this.logXTabLog(this._xTabLog, this._badFileNames, (ArrayList<String>)object);
                this.checkCanProceed();
                this._isBadRows = this.logXTabBad(this._xTabBad);
                this.checkCanProceed();
                if (this._isBadRows && bl7 && !this._badFileNames.isEmpty()) {
                    this.setProgress(DataImportArb.getString("TASK_PROGRESS_COPY_BAD"));
                    try {
                        this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), string2, this._badFileNames, true);
                        this.checkCanProceed();
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                }
                if (bl6) {
                    this.setProgress(DataImportArb.getString("TASK_PROGRESS_COPY_LOG"));
                    try {
                        this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), string2, (ArrayList<String>)object, false);
                        this.checkCanProceed();
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                }
                if (!bl8) {
                    // empty if block
                }
            } else {
                this.getStream().println(DataImportArb.getString("VAL_NOT_AVAILABLE"));
            }
            this.logIsDataRows(this._tableName);
            if (this._operationId == null) return bl;
            this.getStream().println(SPACE);
            if (!bl8) {
                this.getStream().println(DataImportArb.format("VAL_XTAB_LOG", this._xTabLog));
            }
            if (bl8) return bl;
            this.getStream().println(DataImportArb.format("VAL_XTAB_BAD", this._xTabBad));
            return bl;
        }
        catch (ExecutionException executionException) {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doTest(BigDecimal bigDecimal) {
        block16: {
            try {
                if (!this.lockConnectionForImport()) break block16;
                this.setExitCode(ExitCode.EXIT_SUCCESS);
                if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                    this.getStream().println(DataImportArb.getString("TEST_NOT_SUPPORTED"));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this._loadMethod == 3 || this._loadMethod == 5;
                this._operationId = null;
                String string = null;
                if (!this.isExistingTable() && bl) {
                    if (!this.doCreateTable()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    this.dropTable((String)this._iProps.get(ImportKeys.TABLE_NAME), null, false);
                }
                string = "VALIDATE$";
                boolean bl3 = this._iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT);
                this._iProps.put(ImportKeys.USE_REJECT_LIMIT, false);
                this._iProps.put(ImportKeys.TEST_ROWS, bigDecimal);
                String string2 = this.getExtCreateTableStatement();
                this._iProps.put(ImportKeys.USE_REJECT_LIMIT, bl3);
                this._iProps.put(ImportKeys.TEST_ROWS, null);
                try {
                    this.createExternalTable(string2);
                    this._isDataRows = this.getCloudAPI().isDataRows(this._xTableName);
                }
                catch (SQLException sQLException) {
                    boolean bl4 = false;
                    this.unlockConnectionForImport();
                    this.getStream().finished();
                    return bl4;
                }
                try {
                    this._operationId = this.validateExternalTable(this._xTableName, this.getSchemaName(), bigDecimal);
                }
                catch (SQLException sQLException) {
                    boolean bl5 = false;
                    this.unlockConnectionForImport();
                    this.getStream().finished();
                    return bl5;
                }
                if (this._operationId == null) {
                    this.getStream().println(DataImportArb.getString("VAL_NOT_AVAILABLE"));
                    boolean bl6 = false;
                    return bl6;
                }
                String string3 = string + this._operationId + "_LOG";
                String string4 = string + this._operationId + "_BAD";
                this.getStream().println(SPACE);
                this.getStream().println(DataImportArb.format("VAL_XTAB_LOG", string3));
                this.getStream().println(DataImportArb.format("VAL_XTAB_BAD", string4));
                this._badFileNames = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                this._isLogRows = this.logXTabLog(string3, this._badFileNames, arrayList);
                this._isBadRows = this.logXTabBad(string4);
                this.logIsDataRows(this._xTableName);
            }
            finally {
                this.unlockConnectionForImport();
                this.getStream().finished();
            }
        }
        return true;
    }

    @Override
    public boolean isLogRows() {
        return this._isLogRows;
    }

    @Override
    public boolean isBadRows() {
        return this._isBadRows;
    }

    @Override
    public boolean isDataRows() {
        return this._isDataRows;
    }

    @Override
    public void cleanUpTest() {
        this.dropTable(this._xTableName, null, false);
        if (this._operationId != null) {
            try {
                this.deleteOperation(this._operationId);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    @Override
    public String putBadFileTest() {
        if (this._isBadRows && this._isBadRows && !this._badFileNames.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this._badFileNames.get(0));
            String string = (String)this._iProps.get(ImportKeys.OSS_PATH);
            try {
                this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), string, arrayList, false);
            }
            catch (SQLException sQLException) {
                return null;
            }
            return arrayList.get(0);
        }
        return null;
    }

    @Override
    public void cleanupBadFileTest() {
        if (this._isBadRows && this._isBadRows && !this._badFileNames.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this._badFileNames.get(0));
            String string = (String)this._iProps.get(ImportKeys.OSS_PATH);
            try {
                this.deleteObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), string, arrayList);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public BigDecimal getOperationId() {
        return this._operationId;
    }

    public String getXTabBad() {
        return this._xTabBad;
    }

    public String getXTabLog() {
        return this._xTabLog;
    }

    @Override
    protected ExitCode validate() {
        return super.validate();
    }

    private String getExtCreateTableStatementStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/\n");
        stringBuffer.append("begin\n");
        stringBuffer.append(this.getExtCreateTableStatement());
        stringBuffer.append(";\n");
        stringBuffer.append("end;\n");
        stringBuffer.append(SLASH);
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    private String getExtCreateTableStatement() {
        ArrayList<String> arrayList = this.getColumns();
        StringBuffer stringBuffer = new StringBuffer();
        String string = NL;
        for (String string2 : arrayList) {
            stringBuffer.append(string + string2);
            string = ",\n";
        }
        String string3 = this._loadMethod == 3 || this._loadMethod == 5 ? this.addUser(this._stagingTableName) : this.addUser(this.addDoubleQuote(this._tableName));
        return this.getCloudAPI().getExtCreateTableStatement(string3, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this.getSchemaName(), stringBuffer.toString(), this.getFormat());
    }

    public String getColumnsAsString() {
        ArrayList<String> arrayList = this.getColumns();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (String string2 : arrayList) {
            stringBuffer.append(string + string2);
            string = ", ";
        }
        return stringBuffer.toString();
    }

    private ArrayList<String> getColumns() {
        String[] stringArray = this.formatTableColumns(this._loadMethod == 3 && this.isExistingTable());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string.replaceAll("NOT NULL", ""));
        }
        return arrayList;
    }

    private String getSanityCheck() {
        String string = this._loadMethod == 3 ? this.addUser(this._stagingTableName) : this.addUser(this.addDoubleQuote(this._tableName));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from ");
        stringBuffer.append(string + SPACE);
        stringBuffer.append("WHERE ROWNUM <= 100;\n");
        return stringBuffer.toString();
    }

    private void appendCredential(StringBuffer stringBuffer) {
        this._iProps.get(ImportKeys.OSS_CREDENTIAL);
        stringBuffer.append(CREDENTIAL_NAME);
        stringBuffer.append(SINGLEQ + (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL) + SINGLEQ);
        stringBuffer.append(COMMA);
    }

    private void appendFileUri(StringBuffer stringBuffer) {
        stringBuffer.append(FILE_URI_LIST);
        stringBuffer.append(SINGLEQ + this._iProps.get(ImportKeys.OSS_PATH) + SINGLEQ);
        stringBuffer.append(COMMA);
    }

    public String getFields() {
        return this.getFields(NL);
    }

    public String getFields(String string) {
        return this.getFields(string, false);
    }

    public String getFields(String string, boolean bl) {
        return this.getFields(string, false, false);
    }

    public String getFields(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendFields(stringBuffer, string, bl, bl2);
        return stringBuffer.toString();
    }

    private void appendFields(StringBuffer stringBuffer, String string, boolean bl, boolean bl2) {
        if (bl || this.isExistingTable()) {
            String string2 = string;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isExistingTable()) {
                ImportGenHelper.genFieldsFromLoadFile(arrayList, this._iProps, this.isExistingTable(), bl2);
            }
            if (!arrayList.isEmpty()) {
                for (String string3 : arrayList) {
                    stringBuffer.append(string2 + string3);
                    string2 = COMMA + string;
                }
            }
        }
    }

    private void appendFormat(StringBuffer stringBuffer) {
        stringBuffer.append("format => ");
        stringBuffer.append(this.getFormat());
    }

    public String getFormat() {
        boolean bl;
        boolean bl2;
        Integer n;
        Number number;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("json_object(");
        stringBuffer.append("'delimiter'");
        ImportDataFormat importDataFormat = this.getDataFormat();
        String string2 = BaseDataFormat.getDelimiterString(importDataFormat.getDelimiter());
        string2 = string2 == null || string2.equals("") ? "','" : (string2.equals("X'09'") ? "'\\\\t'" : SINGLEQ + string2 + SINGLEQ);
        stringBuffer.append(VALUE + string2);
        String string3 = this.formatString(BaseDataFormat.getRecordTerminatorString(importDataFormat.getRecordTerminator()));
        Version version = new Version("18.0");
        Version version2 = RaptorVersionTracker.getDbVersion(this.getConn());
        if (version.compareTo(version2) <= 0) {
            string3 = string3.replace("\\\\", "\\");
        }
        String string4 = BaseDataFormat.singleQuote(BaseDataFormat.singleQuote(BaseDataFormat.singleQuote(string3)));
        stringBuffer.append(", ");
        stringBuffer.append("'recorddelimiter'");
        stringBuffer.append(VALUE);
        stringBuffer.append(string4);
        Integer n2 = this.getDataFormat().isHeader() ? importDataFormat.getSkipRows() + 1 : importDataFormat.getSkipRows();
        if (n2 != 0) {
            stringBuffer.append(", ");
            stringBuffer.append("'skipheaders'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + n2.toString() + SINGLEQ);
        }
        if ((string = (String)this._iProps.get(ImportKeys.DATE_MASK_DATE)) != null && !string.isEmpty()) {
            stringBuffer.append(", ");
            stringBuffer.append("'dateformat'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + string + SINGLEQ);
        }
        if ((string = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMP)) != null && !string.isEmpty()) {
            stringBuffer.append(", ");
            stringBuffer.append("'timestampformat'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + string + SINGLEQ);
        }
        if ((string = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMPTZ)) != null && !string.isEmpty()) {
            stringBuffer.append(", ");
            stringBuffer.append("'timestamptzformat'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + string + SINGLEQ);
        }
        if ((string = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMPLTZ)) != null && !string.isEmpty()) {
            stringBuffer.append(", ");
            stringBuffer.append("'timestampltzformat'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + string + SINGLEQ);
        }
        String string5 = importDataFormat.getEnclosureLeftValue();
        String string6 = importDataFormat.getEnclosureRightValue();
        String string7 = this.formatString(string5);
        if (string7.length() != 0) {
            stringBuffer.append(", ");
            stringBuffer.append("'quote'");
            stringBuffer.append(VALUE);
            if (!string6.equals(string5)) {
                stringBuffer.append("'''" + string7 + SINGLEQ + SINGLEQ);
                stringBuffer.append(" AND ''" + this.formatString(string6) + SINGLEQ + SINGLEQ + SINGLEQ);
            } else {
                stringBuffer.append(SINGLEQ + string7 + SINGLEQ);
            }
        }
        if (this._iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT).booleanValue()) {
            stringBuffer.append(", ");
            stringBuffer.append("'rejectlimit'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + this._iProps.getValueInteger(ImportKeys.REJECT_LIMIT).toString() + SINGLEQ);
        } else {
            stringBuffer.append(", ");
            stringBuffer.append("'rejectlimit'");
            stringBuffer.append(VALUE);
            if (this._iProps.get(ImportKeys.TEST_ROWS) == null) {
                stringBuffer.append("'UNLIMITED'");
            } else {
                number = (BigDecimal)this._iProps.get(ImportKeys.TEST_ROWS);
                stringBuffer.append(SINGLEQ + ((BigDecimal)number).toBigInteger().toString() + SINGLEQ);
            }
        }
        number = this._iProps.getValueInteger(ImportKeys.TRIM);
        String string8 = null;
        if (number != null) {
            switch ((Integer)number) {
                case 0: {
                    string8 = "notrim";
                    break;
                }
                case 1: {
                    string8 = "ltrim";
                    break;
                }
                case 2: {
                    string8 = "rtrim";
                    break;
                }
                case 3: {
                    string8 = "lrtrim";
                }
            }
            if (string8 != null) {
                stringBuffer.append(", ");
                stringBuffer.append("'trimspaces'");
                stringBuffer.append(VALUE);
                stringBuffer.append(SINGLEQ + string8 + SINGLEQ);
            }
        }
        Integer n3 = this._iProps.getValueInteger(ImportKeys.NULL_ROWS);
        stringBuffer.append(", ");
        stringBuffer.append("'ignoreblanklines'");
        stringBuffer.append(VALUE);
        if (n3 == 0) {
            stringBuffer.append("'true'");
        } else {
            stringBuffer.append("'false'");
        }
        Integer n4 = this._iProps.getValueInteger(ImportKeys.CONVERSION_ERRORS);
        if (n4 == 0) {
            stringBuffer.append(", ");
            stringBuffer.append("'conversionerrors'");
            stringBuffer.append(VALUE);
            stringBuffer.append("'store_null'");
        }
        if ((n = this._iProps.getValueInteger(ImportKeys.MISSING_FIELDS)) == 0) {
            stringBuffer.append(", ");
            stringBuffer.append("'ignoremissingcolumns'");
            stringBuffer.append(VALUE);
            stringBuffer.append("'true'");
        }
        if (bl2 = this._iProps.getValueBoolean(ImportKeys.IS_BLANK_COLS).booleanValue()) {
            stringBuffer.append(", ");
            stringBuffer.append("'blankasnull'");
            stringBuffer.append(VALUE);
            stringBuffer.append("'true'");
        }
        if (bl = this._iProps.getValueBoolean(ImportKeys.IS_TRUNCATE_COLS).booleanValue()) {
            stringBuffer.append(", ");
            stringBuffer.append("'truncatecol'");
            stringBuffer.append(VALUE);
            stringBuffer.append("'true'");
        }
        boolean bl3 = this._iProps.getValueBoolean(ImportKeys.IS_GENERATE_CHARSET);
        String string9 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (bl3 && string9 != null && !string9.equals("")) {
            stringBuffer.append(", ");
            stringBuffer.append("'characterset'");
            stringBuffer.append(VALUE);
            stringBuffer.append(SINGLEQ + string9 + SINGLEQ);
        }
        stringBuffer.append(CLOSEP);
        return stringBuffer.toString();
    }

    private String getValidateExternalTableStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/\n");
        stringBuffer.append("begin\n");
        stringBuffer.append("C##CLOUD$SERVICE.dbms_cloud.");
        stringBuffer.append("validate_external_table(\n");
        String string = this._loadMethod == 3 ? this.addUser(this._stagingTableName) : this.addUser(this.addDoubleQuote(this._tableName));
        stringBuffer.append(TABLE_NAME);
        stringBuffer.append(SINGLEQ + string + SINGLEQ);
        stringBuffer.append(",\n");
        stringBuffer.append("rowcount => '100' ");
        stringBuffer.append(NL);
        stringBuffer.append(");\n");
        stringBuffer.append("end;\n");
        stringBuffer.append("/\n");
        return stringBuffer.toString();
    }

    private String getInsertStatementFromStaging() {
        String string = (String)this._iProps.get(ImportKeys.TABLE_NAME);
        String string2 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        ST sT = (ST)this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        String[] stringArray = new String[((Column[])sT).length];
        int n = 0;
        for (Column column : sT) {
            stringArray[n++] = this.addDoubleQuote(column.getName());
        }
        ST sT2 = null;
        sT2 = (Boolean)this._iProps.get(ImportKeys.DROP_STAGING_TABLE) != false ? this.getTemplateGroup().getInstanceOf("InsertStatementFromStagingWithDrop") : this.getTemplateGroup().getInstanceOf("InsertStatementFromStaging");
        sT2.add("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        sT2.add("stagingTableName", (Object)this.addUser(this.addDoubleQuote(string2)));
        sT2.add("colList", (Object)stringArray);
        int n2 = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n2 > 0) {
            String string3 = "WHERE ROWNUM <= " + n2;
            sT2.add("loadLimitClause", (Object)string3);
        }
        return sT2.render();
    }

    private String formatString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\\' || c == '\'') {
                stringBuffer.append("\\");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void createExternalTable(String string) throws SQLException {
        this.getCloudAPI().createExternalTable(string);
    }

    public BigDecimal validateExternalTable(String string, String string2, BigDecimal bigDecimal) throws SQLException {
        return this.getCloudAPI().validateExternalTable(string, string2, bigDecimal);
    }

    public boolean logXTabLog(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        return this.getCloudAPI().logXTabLog(string, arrayList, arrayList2);
    }

    public boolean logXTabBad(String string) {
        return this.getCloudAPI().logXTabBad(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountXTab(String string, String string2) {
        String string3 = null;
        try {
            if (Connections.getInstance().lock(this.getConn())) {
                string3 = DBUtil.getInstance((Connection)this.getConn()).executeReturnOneCol(dbms_cloudGetXTabCount1 + string + dbms_cloudGetXTabCount2 + string2, Collections.EMPTY_MAP);
            }
        }
        finally {
            if (this.getConn() != null) {
                Connections.getInstance().unlock(this.getConn());
            }
        }
        return string3;
    }

    public void logIsDataRows(String string) {
        String string2 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.format("DBMS_CLOUD_STEP_IS_DATA_ROWS", string)));
        if (this._isDataRows) {
            this.getStream().println(DbmsCloudResources.getString("DBMS_CLOUD_STEP_DATA_ROWS"));
        } else {
            this.getStream().println(DbmsCloudResources.getString("DBMS_CLOUD_STEP_NO_DATA_ROWS"));
        }
        this.getStream().println(string2);
        this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.format("DBMS_CLOUD_STEP_IS_DATA_ROWS", string) + NL));
    }

    private void putObject(String string, String string2, ArrayList<String> arrayList, boolean bl) throws SQLException {
        this.getCloudAPI().putObject(string, string2, arrayList, bl);
    }

    public void deleteObject(String string, String string2, ArrayList<String> arrayList) throws SQLException {
        this.getCloudAPI().deleteObject(string, string2, arrayList);
    }

    public void deleteObject(String string, String string2) throws SQLException {
        this.getCloudAPI().deleteObject(string, string2);
    }

    private boolean dropTable(String string, String string2, boolean bl) {
        return this.getCloudAPI().dropTable(string, string2, bl);
    }

    private void deleteOperation(BigDecimal bigDecimal) throws SQLException {
        this.getCloudAPI().deleteOperation(bigDecimal);
    }

    public void putObject(String string, String string2, FileInputStream fileInputStream) throws SQLException {
        this.getCloudAPI().putObject(string, string2, fileInputStream);
    }

    @Override
    protected String getStatusMsg() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.isDataRows();
        boolean bl3 = bl = this.getOperationId() != null;
        if (!bl2) {
            stringBuffer.append(DataImportArb.getString("TASK_FAILED_AND_COMMITTED") + NL);
            stringBuffer.append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_NO_DATA")));
            if (this.isBadRows()) {
                stringBuffer.append("; " + DataImportArb.getString("PREREQ_TEST_BAD_ROWS"));
            }
        } else if (!bl) {
            stringBuffer.append(DataImportArb.getString("TASK_FAILED_AND_COMMITTED") + NL);
            stringBuffer.append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_VAL_FAILED")));
        } else if (!this.isLogRows()) {
            stringBuffer.append(DataImportArb.getString("TASK_FAILED_AND_COMMITTED") + NL);
            stringBuffer.append(DataImportArb.format("PREREQ_TEST_FAIL", DataImportArb.getString("PREREQ_TEST_LOG_FAILED")));
            if (this.isBadRows()) {
                stringBuffer.append("; " + DataImportArb.getString("PREREQ_TEST_BAD_ROWS"));
            }
        } else if (this.isBadRows()) {
            stringBuffer.append(DataImportArb.getString("TASK_WARNING_AND_COMMITTED") + NL);
            stringBuffer.append(DataImportArb.format("PREREQ_TEST_WARN", DataImportArb.getString("PREREQ_TEST_BAD_ROWS")));
        } else {
            stringBuffer.append(DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED"));
        }
        return stringBuffer.toString();
    }

    private DbmsCloudAPI getCloudAPI() {
        if (this._cloudAPI == null) {
            this._cloudAPI = new DbmsCloudAPI(this.getStream());
            this._cloudAPI.setSchema(ImportGenHelper.getSchema(this._iProps));
            this._cloudAPI.isConnLocked(true);
            this.setExitCode(this._cloudAPI.startService(this.getConnName()));
        }
        return this._cloudAPI;
    }
}

