/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.extract.DbmsCloudResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.MessageDialog;
import org.stringtemplate.v4.ST;

public abstract class ImportGenExec
extends ImportGen {
    private static final String NL = "\n";
    private ExitCode _exitCode;
    private ImportProperties _iProps;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private boolean _connLocked = false;
    private boolean _autoCommit;
    private boolean _cancelled = false;
    private StringBuffer _createTableSql = new StringBuffer();
    private boolean _isIgnoreAllErrors = false;
    private boolean _isTableCreated = false;
    private String _taskFullName;
    private RaptorTask<Void> _task;
    private IRaptorTaskProgressUpdater _progressUpdater;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGenExec(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    public boolean doImport() {
        return this.doImport(null);
    }

    public abstract boolean doImport(RaptorTask<Void> var1);

    protected abstract String getStatusMsg();

    protected void setProgressUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this._progressUpdater = iRaptorTaskProgressUpdater;
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
    }

    public StringBuffer getCreateTableSql() {
        return this._createTableSql;
    }

    public void setCreateTableSql(StringBuffer stringBuffer) {
        this._createTableSql = stringBuffer;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        return this.validate();
    }

    @Override
    public ExitCode generate() {
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        this._exitCode = ExitCode.EXIT_SUCCESS;
        String string = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : this._loadFile.getName();
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        int n = -1;
        n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        String string2 = genericTable.getTable().getTablename();
        this._taskFullName = DataImportArb.format("TASK_FULL_NAME", string2, string);
        if (this.isBatch()) {
            this.generateBatch();
        } else {
            this.generateUI();
        }
        return this._exitCode;
    }

    protected ExitCode validate() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._isValid = true;
        return this._exitCode;
    }

    private ExitCode generateBatch() {
        block12: {
            try {
                if (!this.lockConnectionForImport()) break block12;
                this._cancelled = this.doImport();
                String string = this._taskFullName + ". ";
                if (this._exitCode == ExitCode.EXIT_SUCCESS && !this._cancelled) {
                    this.commitTask();
                    string = string + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
                } else {
                    this.rollbackTask();
                    string = string + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                    string = string + " " + this._exitCode.getShortMessage() + " " + this._exitCode.getMessage();
                }
                this.outBad(string);
            }
            catch (Throwable throwable) {
                try {
                    if (this._connLocked) {
                        Connections.getInstance().unlock(this.getConn());
                        this.getConn().setAutoCommit(this._autoCommit);
                        this._connLocked = false;
                    }
                }
                catch (Exception exception) {
                    this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                this.closeFiles();
                if (this.getStream().isBadFileUsed()) {
                    this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
                }
                throw throwable;
            }
        }
        try {
            if (this._connLocked) {
                Connections.getInstance().unlock(this.getConn());
                this.getConn().setAutoCommit(this._autoCommit);
                this._connLocked = false;
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.closeFiles();
        if (this.getStream().isBadFileUsed()) {
            this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
        }
        return this._exitCode;
    }

    private ExitCode generateUI() {
        try {
            this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.78"));
            this._task = new RaptorTask<Void>(this._taskFullName, true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                public Void doWork() {
                    ImportGenExec.this._progressUpdater = ImportGenExec.this._task.getRaptorTaskProgressUpdater();
                    ImportGenExec.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
                    try {
                        if (ImportGenExec.this.lockConnectionForImport()) {
                            ImportGenExec.this._cancelled = ImportGenExec.this.doImport(this);
                            if (ImportGenExec.this._exitCode == ExitCode.EXIT_SUCCESS && !ImportGenExec.this._cancelled) {
                                ImportGenExec.this.commitTask();
                            } else {
                                ImportGenExec.this.rollbackTask();
                            }
                        } else {
                            this.getDescriptor().setMessage(ImportGenExec.this._exitCode.getShortMessage() + " " + ImportGenExec.this._exitCode.getMessage());
                            ImportGenExec.this._cancelled = true;
                        }
                    }
                    finally {
                        try {
                            if (ImportGenExec.this._connLocked) {
                                Connections.getInstance().unlock(ImportGenExec.this.getConn());
                                ImportGenExec.this.getConn().setAutoCommit(ImportGenExec.this._autoCommit);
                                ImportGenExec.this._connLocked = false;
                            }
                        }
                        catch (Exception exception) {
                            ImportGenExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    return null;
                }

                public boolean cancel() {
                    ImportGenExec.this._cancelled = true;
                    return true;
                }
            };
            this._task.setCancellable(true);
            this._task.setPausable(false);
            this._task.getDescriptor().addListener((IRaptorTaskListener)new DBTaskListener(this._taskFullName));
            RaptorTaskManager.getInstance().addTask(this._task);
        }
        catch (Exception exception) {
            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
            LogManager.getLogManager().getLogWindow().activate();
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return this._exitCode;
    }

    @Override
    public boolean test(BigDecimal bigDecimal) {
        if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            return true;
        }
        this.start();
        if (!this._isValid) {
            return false;
        }
        this._exitCode = ExitCode.EXIT_SUCCESS;
        String string = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : this._loadFile.getName();
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        int n = -1;
        n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        String string2 = genericTable.getTable().getTablename();
        this._taskFullName = DataImportArb.format("TASK_FULL_NAME", string2, string);
        if (this.isBatch()) {
            return this.doTest(bigDecimal);
        }
        return this.doTest(bigDecimal);
    }

    public boolean testSave(BigDecimal bigDecimal) {
        if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            return true;
        }
        this.start();
        if (!this._isValid) {
            return false;
        }
        this._exitCode = ExitCode.EXIT_SUCCESS;
        String string = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : this._loadFile.getName();
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        int n = -1;
        n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        String string2 = genericTable.getTable().getTablename();
        this._taskFullName = DataImportArb.format("TASK_FULL_NAME", string2, string);
        if (this.isBatch()) {
            this._cancelled = this.doTest(bigDecimal);
            return this._cancelled;
        }
        return this.doTest(bigDecimal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testBatch(BigDecimal bigDecimal) {
        boolean bl;
        block12: {
            bl = false;
            try {
                if (!this.lockConnectionForImport()) break block12;
                this._cancelled = this.doTest(bigDecimal);
                String string = this._taskFullName + ". ";
                if (this._exitCode == ExitCode.EXIT_SUCCESS && !this._cancelled) {
                    this.commitTask();
                    string = string + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
                    bl = true;
                } else {
                    this.rollbackTask();
                    string = string + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                    string = string + " " + this._exitCode.getShortMessage() + " " + this._exitCode.getMessage();
                }
                this.outBad(string);
            }
            catch (Throwable throwable) {
                try {
                    if (this._connLocked) {
                        Connections.getInstance().unlock(this.getConn());
                        this.getConn().setAutoCommit(this._autoCommit);
                        this._connLocked = false;
                    }
                }
                catch (Exception exception) {
                    this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                this.closeFiles();
                if (this.getStream().isBadFileUsed()) {
                    this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
                }
                throw throwable;
            }
        }
        try {
            if (this._connLocked) {
                Connections.getInstance().unlock(this.getConn());
                this.getConn().setAutoCommit(this._autoCommit);
                this._connLocked = false;
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.closeFiles();
        if (this.getStream().isBadFileUsed()) {
            this._exitCode.setShortMessage(DataImportArb.format("BAD_FILE", this.getStream().geturlBad().toExternalForm()));
        }
        return bl;
    }

    private boolean testUI(final BigDecimal bigDecimal) {
        try {
            this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.78"));
            this._task = new RaptorTask<Void>(this._taskFullName, true, IRaptorTaskRunMode.MODAL){

                public Void doWork() {
                    ImportGenExec.this._progressUpdater = ImportGenExec.this._task.getRaptorTaskProgressUpdater();
                    ImportGenExec.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
                    try {
                        if (ImportGenExec.this.lockConnectionForImport()) {
                            ImportGenExec.this._cancelled = ImportGenExec.this.doTest(bigDecimal);
                            if (ImportGenExec.this._exitCode == ExitCode.EXIT_SUCCESS && !ImportGenExec.this._cancelled) {
                                ImportGenExec.this.commitTask();
                            } else {
                                ImportGenExec.this.rollbackTask();
                            }
                        } else {
                            this.getDescriptor().setMessage(ImportGenExec.this._exitCode.getShortMessage() + " " + ImportGenExec.this._exitCode.getMessage());
                            ImportGenExec.this._cancelled = true;
                        }
                    }
                    finally {
                        try {
                            if (ImportGenExec.this._connLocked) {
                                Connections.getInstance().unlock(ImportGenExec.this.getConn());
                                ImportGenExec.this.getConn().setAutoCommit(ImportGenExec.this._autoCommit);
                                ImportGenExec.this._connLocked = false;
                            }
                        }
                        catch (Exception exception) {
                            ImportGenExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    return null;
                }

                public boolean cancel() {
                    ImportGenExec.this._cancelled = true;
                    return true;
                }
            };
            this._task.setCancellable(true);
            this._task.setPausable(false);
            this._task.getDescriptor().addListener((IRaptorTaskListener)new DBTaskListener(this._taskFullName));
            RaptorTaskManager.getInstance().addTask(this._task);
        }
        catch (Exception exception) {
            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
            LogManager.getLogManager().getLogWindow().activate();
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return this._cancelled;
    }

    public boolean doTest(BigDecimal bigDecimal) {
        return true;
    }

    public boolean doCreateTable() {
        if (!this.isExistingTable()) {
            this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_DEST_TAB")));
            String string = this.getCreateTableStatementWithComments();
            string = string.replace(";", "");
            string = string.replace(NL, "  ");
            this._createTableSql.append(this.getDropTableStatement() + NL);
            this._createTableSql.append("/*\n");
            this._createTableSql.append(string);
            this._createTableSql.append("*/\n");
            string = this.getCreateTableStatement();
            string = string.replace(";", "");
            string = string.replace(NL, "  ");
            this.getStream().println(string);
            String string2 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
            boolean bl = this.pstmtExec(string);
            if (!bl) {
                this._exitCode = ExitCode.EXIT_ERROR;
                this._exitCode.setShortMessage(DataImportArb.getString("STATEMENT_FAILED") + " ");
                string2 = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                this.getStream().println(string2);
                this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_DEST_TAB")) + NL);
                return false;
            }
            this.getStream().println(DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS"));
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
                string = this.getCommentStatement(this.getTableName(), columnArray[i].getName(), columnArray[i].getComment());
                string = string.replace(";", "");
                this.getStream().println(string);
                bl = this.pstmtExec(string);
                if (!bl) {
                    this._exitCode.setShortMessage(DataImportArb.getString("STATEMENT_FAILED") + " ");
                    string2 = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                    this.getStream().println(string2);
                    this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_DEST_TAB")) + NL);
                    return false;
                }
                this.getStream().println(DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS"));
            }
            this._isTableCreated = true;
            this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_DEST_TAB")) + NL);
        }
        return true;
    }

    public boolean addComments() {
        if (!this.isExistingTable()) {
            this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_ADD_COMMENTS")));
            boolean bl = true;
            String string = "";
            String string2 = "";
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
                string2 = this.getCommentStatement(this.getTableName(), columnArray[i].getName(), columnArray[i].getComment());
                string2 = string2.replace(";", "");
                this.getStream().println(string2);
                bl = this.pstmtExec(string2);
                if (!bl) {
                    this._exitCode.setShortMessage(DataImportArb.getString("STATEMENT_FAILED") + " ");
                    string = this._exitCode.getShortMessage() + this._exitCode.getMessage();
                    this.getStream().println(string);
                    this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_ADD_COMMENTS")) + NL);
                    return false;
                }
                this.getStream().println(DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS"));
            }
            this.getStream().println(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_ADD_COMMENTS")) + NL);
        }
        return true;
    }

    public boolean pstmtExec(String string) {
        try {
            PreparedStatement preparedStatement = this.getConn().prepareStatement(string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            this._exitCode = ExitCode.EXIT_ERROR;
            this._exitCode.setMessage(string + " " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    public void checkCanProceed() throws ExecutionException {
        if (this._progressUpdater != null) {
            this._progressUpdater.checkCanProceed();
        }
    }

    public void setProgress(String string) throws ExecutionException {
        if (this._progressUpdater != null) {
            this._progressUpdater.getDescriptor().setMessage(string);
        }
    }

    public boolean requestCancel() {
        this._cancelled = true;
        if (this._task != null) {
            return this._task.requestCancel();
        }
        return false;
    }

    public void setMessage(String string) {
        if (this._task != null) {
            this._task.setMessage(string);
        }
    }

    protected boolean lockConnectionForImport() {
        try {
            this._connLocked = Connections.getInstance().lock(this.getConn());
            if (!this._connLocked) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, DataImportArb.getString("LOCK_CONN_ERR"));
                this._exitCode = ExitCode.EXIT_SEVERE;
                this._exitCode.setShortMessage(DataImportArb.getString("LOCK_CONN_ERR"));
                return false;
            }
            this._autoCommit = this.getConn().getAutoCommit();
            this.getConn().setAutoCommit(false);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this._exitCode.setShortMessage(exception.getMessage());
            return false;
        }
        return this._connLocked;
    }

    protected void unlockConnectionForImport() {
        try {
            if (this._connLocked) {
                Connections.getInstance().unlock(this.getConn());
                this.getConn().setAutoCommit(this._autoCommit);
                this._connLocked = false;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected boolean cancelTask() {
        this.rollbackTask();
        if (this._task != null) {
            boolean bl = this._task.requestCancel();
            return bl;
        }
        return true;
    }

    public final void rollbackTask() {
        try {
            if (!this.getConn().isClosed() && this._connLocked) {
                this.getConn().rollback();
                if (this._isTableCreated && !this._isIgnoreAllErrors) {
                    String string = this.getDropTableStatementForPrepare();
                    PreparedStatement preparedStatement = this.getConn().prepareStatement(string);
                    preparedStatement.execute();
                    this.getConn().commit();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void commitTask() {
        try {
            if (this._connLocked) {
                this.getConn().commit();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void outBad(String string) {
        try {
            this.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private String getDropTableStatement() {
        ST sT = this.getTemplateGroup().getInstanceOf("DropTableStatement");
        sT.add("tableName", (Object)this.addUser(this.getTableName()));
        return sT.render();
    }

    private String getDropTableStatementForPrepare() {
        ST sT = this.getTemplateGroup().getInstanceOf("DropTableStatementForPrepare");
        sT.add("tableName", (Object)this.addUser(this.getTableName()));
        return sT.render();
    }

    public void closeFiles() {
        if (this.getStream() != null) {
            this.getStream().finished();
            this.getStream().deleteEmptyFile();
            try {
                this.getStream().finishedBad();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    final class DBTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private String _msg = "";

        DBTaskListener(String string) {
            this._taskFullName = string;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                ImportGenExec.this.LOGGER.log(Level.WARNING, this._msg);
            } else {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_FAILED_ROLLBACK");
                ImportGenExec.this.LOGGER.log(Level.SEVERE, this._msg);
            }
            ImportGenExec.this.rollbackTask();
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this._msg = this._taskFullName + ". ";
            this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
            this._msg = this._msg + " " + raptorTaskEvent.getTaskDescriptor().getMessage();
            ImportGenExec.this.LOGGER.log(Level.WARNING, this._msg);
            ImportGenExec.this.rollbackTask();
            this.finish(this._msg);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled() || ImportGenExec.this._cancelled) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED_ROLLBACK");
                this._msg = this._msg + " " + raptorTaskEvent.getTaskDescriptor().getMessage();
                ImportGenExec.this.outBad("-- " + this._msg);
            } else {
                try {
                    if (ImportGenExec.this._connLocked) {
                        ImportGenExec.this.getConn().commit();
                    }
                }
                catch (Exception exception) {
                    ImportGenExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                if (ImportGenExec.this.getStream().isBadFileUsed()) {
                    try {
                        ImportGenExec.this.eLogHref(ImportGenExec.this.getStream().geturlBad());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        ImportGenExec.this.eLogException(exception);
                    }
                }
            }
            if (this._msg.length() == 0) {
                this._msg = ImportGenExec.this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? ImportGenExec.this.getStatusMsg() : this._taskFullName + ". " + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
            }
            this.finish(this._msg);
            ImportGenExec.this.eLogToolEnd();
        }

        private void finish(String string) {
            ImportGenExec.this.closeFiles();
            if (ImportGenExec.this.getStream().isBadFileUsed()) {
                try {
                    ImportGen.openSqlNodeForURL(ImportGenExec.this.getStream().geturlBad());
                }
                catch (Exception exception) {
                    ImportGenExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            ImportGenExec.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
            this.showFinalMsg(this._msg);
        }

        private void showFinalMsg(String string) {
            if (!ImportGenExec.this.isBatch()) {
                final String string2 = string == null || string.length() == 0 ? "" : string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            ImportGenExec.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

