/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGenHelper;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.GuidGen;
import oracle.gss.util.NLSLocale;

public class ImportGenFile
extends ResultsFormatter {
    private static String _term = "\n";
    private static final Logger LOGGER = Logger.getLogger(ImportGenFile.class.getName());
    public static final String TYPE = "LOADER";
    public static final String EXT = "ctl";
    public static final String EXT_DAT = "ldr";
    private ExtractObject _EO;
    private ImportProperties _iProps;
    private LoadFile _loadFile;
    private String _dataFileName;
    private boolean _isMetaTable;
    private ImportDataFormat _dataFormat;
    private long numRows = 0L;
    String EOL = FormatRegistry.getLineTerminator();
    private static final String COMMA = ",";
    private static final String COMMENT_SEP_LINE = "--------------------------------------------------------";
    private static final String COMMENT_LINE_START = "==  ";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String SEMI_COLON = ";";
    private static final String SPACE = " ";

    public ImportGenFile() {
        super(TYPE, Messages.getString("LoaderFormatter.3"), EXT_DAT);
    }

    public void setTableName(String string) {
    }

    public ExitCode start(ExtractObject extractObject) {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.1"));
        try {
            this._EO = extractObject;
            this._iProps = this._EO.getImportProperties();
            this._isMetaTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exception.getMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public int print() {
        int n = 0;
        try {
            this.end();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            if (this._out != null) {
                try {
                    this._out.flush();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    public void start() throws IOException {
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
    }

    public void endRow() throws IOException {
    }

    public void end() throws IOException {
        Object object;
        Object object2;
        Object object3;
        this._dataFileName = this.getNewFileName(EXT_DAT, "");
        String string = this.genControlFile(this._EO);
        String string2 = this.getNewFileName(EXT, "");
        long l = 0L;
        if (this.numRows == 0L) {
            object3 = this._loadFile.getFields();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (LoadField)object2.next();
                l += (long)object.getLength();
            }
        }
        if (l > 0L) {
            this.numRows = new File(this._loadFile.getName()).length() / l;
        }
        this.numRows = this.numRows > 500L ? (this.numRows /= 10L) : 50L;
        object3 = this._dataFormat.isHeader() ? this._dataFormat.getSkipRows() + 1 : this._dataFormat.getSkipRows();
        object2 = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        object = "OPTIONS (ERRORS=" + Long.toString(this.numRows) + ", SKIP=" + Integer.toString((Integer)object3) + ((Integer)object2 > 0 ? ", LOAD=" + Integer.toString((Integer)object2) : "") + RIGHT_PAREN + this.EOL;
        if (this._zipper == null) {
            if (!string2.equals("")) {
                Writer writer = this.getNewWriter(string2);
                this.addToControllingFile(string2);
                writer.write((String)object);
                writer.write(string.toString());
                writer.close();
            }
        } else if (this._zipper != null) {
            this._zipper.closeEntry();
            this._zipper.openEntry(string2);
            this.write((String)object);
            this.write(string.toString());
            this._zipper.closeEntry();
            this._zipper.writeFileEntry(this._loadFile.getName(), this._dataFileName, true);
        }
    }

    public void setExtractObject(ExtractObject extractObject) {
        this._EO = extractObject;
    }

    public static String getDDL(ExtractObject extractObject) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
        Date date = new Date();
        String string = COMMENT_SEP_LINE + ImportGenFile.getTerm() + Messages.getString("ExportAPI.157") + simpleDateFormat.format(date) + "   " + ImportGenFile.getTerm() + COMMENT_SEP_LINE + ImportGenFile.getTerm();
        stringBuffer.append(string);
        stringBuffer.append(COMMENT_SEP_LINE + ImportGenFile.getTerm());
        stringBuffer.append(DataImportArb.getString("DDL_FOR_Table"));
        stringBuffer.append(SPACE + extractObject.getTableName() + ImportGenFile.getTerm());
        stringBuffer.append(COMMENT_SEP_LINE + ImportGenFile.getTerm());
        ImportProperties importProperties = extractObject.getImportProperties();
        String[] stringArray = ImportGenHelper.formatTableColumns(importProperties, importProperties.getValueBoolean(ImportKeys.IS_EXISTING_TABLE));
        stringBuffer.append("CREATE TABLE " + ImportGenHelper.addUser(importProperties, extractObject.getTableName()) + ImportGenFile.getTerm() + LEFT_PAREN);
        boolean bl = true;
        for (String string2 : stringArray) {
            if (!bl) {
                stringBuffer.append(COMMA);
            } else {
                bl = false;
            }
            stringBuffer.append(string2 + ImportGenFile.getTerm());
        }
        stringBuffer.append(");" + ImportGenFile.getTerm());
        return stringBuffer.toString();
    }

    public String genControlFile(ExtractObject extractObject) {
        Object object;
        ImportProperties importProperties = extractObject.getImportProperties();
        ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
        GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
        Column[] columnArray = (Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS);
        for (Column stringArray2 : columnArray) {
            object = genericTable.getTable().getColumnByName(stringArray2.getName());
            object.setSourceColumnName(stringArray2.getSourceColumnName());
            object.setSourceColID(stringArray2.getSourceColID());
        }
        importProperties.put(ImportKeys.TABLE, genericTable);
        importProperties.put(ImportKeys.IS_BATCH, true);
        importProperties.put(ImportKeys.ERROR_LIMIT, 5);
        importProperties.put(ImportKeys.REPLACE_GEN_FILES, true);
        importProperties.put(ImportKeys.SEND_TO_WORKSHEET, true);
        importProperties.put(ImportKeys.LOAD_METHOD, 4);
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._dataFileName;
        stringBuffer.append("LOAD DATA CHARACTERSET ");
        String string2 = importDataFormat == null ? "UTF8" : NLSLocale.getInstance().getNLSCharset(importDataFormat.getEncoding());
        stringBuffer.append("\"" + string2 + "\"");
        stringBuffer.append(" LENGTH CHAR" + this.EOL);
        stringBuffer.append("INFILE '" + string + "' \"str '" + ImportDataFormat.getRecordTerminatorString(importDataFormat.getRecordTerminatorValue()) + "'\"" + this.EOL);
        stringBuffer.append("APPEND" + this.EOL);
        String[] stringArray = extractObject.getTableName().split("\\.");
        if (stringArray.length == 1) {
            stringBuffer.append("INTO TABLE " + stringArray[0] + this.EOL);
        } else {
            stringBuffer.append("INTO TABLE " + stringArray[0] + ".");
            stringBuffer.append(stringArray[1] + this.EOL);
        }
        object = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(importDataFormat.getDelimiter()));
        if (object == null || ((String)object).equals("")) {
            object = "','";
        } else if (((String)object).equals("'WHITESPACE'")) {
            object = "WHITESPACE";
        }
        stringBuffer.append("FIELDS TERMINATED BY " + (String)object + this.EOL);
        if (importDataFormat.getEnclosureLeftValue().length() != 0) {
            stringBuffer.append("OPTIONALLY ENCLOSED BY '" + this.handleSpecialEnclosure(importDataFormat.getEnclosureLeftValue()) + "' AND '" + this.handleSpecialEnclosure(importDataFormat.getEnclosureRightValue()) + "'" + this.EOL);
        }
        stringBuffer.append("TRAILING NULLCOLS ( " + this.EOL);
        ArrayList<String> arrayList = new ArrayList<String>();
        ImportGenHelper.genControlFileFields(arrayList, this._iProps, this._isMetaTable);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = arrayList.get(i);
            stringBuffer.append(string3);
            stringBuffer.append(i != arrayList.size() - 1 ? COMMA + this.EOL : this.EOL + RIGHT_PAREN);
        }
        return stringBuffer.toString();
    }

    private String getConnectionName(String string) {
        String string2 = null;
        for (String string3 : Connections.getInstance().getConnNames()) {
            String string4 = Connections.getDisplayName(string3);
            if (!string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private static String getTerm() {
        return FormatRegistry.getLineTerminator();
    }

    private String getNewFileName(String string) {
        return this.getNewFileName(string, GuidGen.toString((byte[])GuidGen.uuidCreate()).replaceAll("\\" + this._delimiter, "_"));
    }

    private String getNewFileName(String string, String string2) {
        String string3 = this.getFileName();
        if (string3 == null) {
            return "";
        }
        int n = string3.lastIndexOf(".");
        String string4 = n != -1 ? string3.substring(0, n) : string3;
        int n2 = 0;
        string3 = string4 + string2 + "." + string;
        if (!new File(string3).exists()) {
            return string3;
        }
        while (new File(string3).exists()) {
            string3 = string4 + string2 + "_" + ++n2 + "." + string;
        }
        return string3;
    }

    private Writer getNewWriter(String string) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.getEncode());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        return bufferedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String string, Reader reader) {
        Writer writer = this.getNewWriter(string);
        boolean bl = true;
        if (writer != null) {
            try {
                char[] cArray = new char[4096];
                int n = 0;
                while ((n = reader.read(cArray)) != -1) {
                    writer.write(cArray, 0, n);
                    bl = false;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }
}

