/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportXMLUtil;
import oracle.dbtools.raptor.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class ImportGenHelper {
    Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public static final String addUser(ImportProperties importProperties, String string) {
        String string2;
        String string3 = (String)importProperties.get(ImportKeys.CONNECTION_USER);
        DBObject dBObject = (DBObject)importProperties.get(ImportKeys.DBOBJECT);
        if (string3 == null && dBObject != null) {
            string2 = ((DBObject)importProperties.get(ImportKeys.DBOBJECT)).getConnectionName();
            try {
                Connection connection = Connections.getInstance().getConnection(string2);
                string3 = connection.getMetaData().getUserName();
                importProperties.put(ImportKeys.CONNECTION_USER, string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string4 = string2 = dBObject == null ? null : ((DBObject)importProperties.get(ImportKeys.DBOBJECT)).getSchemaName();
        if (string3 != null && string2 != null && !string3.equals(string2)) {
            return DBUtil.addDoubleQuote((String)string2) + "." + string;
        }
        return string;
    }

    public static final String getSchema(ImportProperties importProperties) {
        String string = (String)importProperties.get(ImportKeys.CONNECTION_USER);
        DBObject dBObject = (DBObject)importProperties.get(ImportKeys.DBOBJECT);
        if (string == null && dBObject != null) {
            String string2 = ((DBObject)importProperties.get(ImportKeys.DBOBJECT)).getConnectionName();
            try {
                Connection connection = Connections.getInstance().getConnection(string2);
                string = connection.getMetaData().getUserName();
                importProperties.put(ImportKeys.CONNECTION_USER, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dBObject == null ? string : ((DBObject)importProperties.get(ImportKeys.DBOBJECT)).getSchemaName();
    }

    public static final String addDoubleQuote(ImportProperties importProperties, String string, boolean bl) {
        String string2;
        if (importProperties.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue() && (string2 = DBUtil.addDoubleQuote((String)string)).startsWith("\"")) {
            return "\\" + string2.substring(0, string2.length() - 1) + "\\";
        }
        return string;
    }

    public static final String addDoubleQuote(ImportProperties importProperties, String string) {
        if (importProperties.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue()) {
            return DBUtil.addDoubleQuote((String)string);
        }
        return string;
    }

    protected static final String translateEOL(ImportProperties importProperties, String string) {
        string = string.replaceAll("\\r", "");
        ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
        String string2 = importDataFormat.getRecordTerminatorValue((String)importProperties.get(ImportKeys.FILEOUTNEWLINE));
        String string3 = importDataFormat.getRecordTerminatorValue(importDataFormat.getRecordTerminator());
        String string4 = string2 != null && !BaseDataFormat.isRecordTerminatorImportFile(string2) ? string2 : string3;
        string = string.replaceAll("\\n", string4);
        return string;
    }

    protected static final String dos(String string) {
        return string.replaceAll("\\r", "").replaceAll("\\n", "\r\n");
    }

    protected static final String nix(String string) {
        return string.replaceAll("\\r", "");
    }

    public static final ImportProperties getConfig(URL uRL) throws IOException {
        ImportXMLUtil importXMLUtil = new ImportXMLUtil();
        importXMLUtil.setImport(true);
        FileInputStream fileInputStream = new FileInputStream(new File(uRL.getPath()));
        importXMLUtil.parseXML(fileInputStream, true);
        ((InputStream)fileInputStream).close();
        return importXMLUtil.getProperties();
    }

    protected static final String[] formatTableColumns(ImportProperties importProperties) {
        return ImportGenHelper.formatTableColumns(importProperties, false);
    }

    protected static final String[] formatTableColumns(ImportProperties importProperties, boolean bl) {
        String[] stringArray = null;
        Column[] columnArray = null;
        String string = null;
        ITypeFormattor iTypeFormattor = null;
        columnArray = (Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS);
        stringArray = new String[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            string = columnArray[i].getType();
            iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(string.toUpperCase());
            if (iTypeFormattor != null) {
                iTypeFormattor.setLocale((Locale)importProperties.get(ImportKeys.LOCALE));
            } else {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            iTypeFormattor.isAddDoubleQuote(bl);
            stringArray[i] = iTypeFormattor.formatColumn(columnArray[i]);
        }
        return stringArray;
    }

    protected static final void genControlFileFields(ArrayList<String> arrayList, ImportProperties importProperties, boolean bl) {
        GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
        for (Column column : genericTable.getColumns()) {
            arrayList.add(ImportGenHelper.getField(importProperties, bl, column));
        }
    }

    protected static final void genFieldsFromLoadFile(ArrayList<String> arrayList, ImportProperties importProperties, boolean bl, boolean bl2) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
        if (genericTable != null) {
            Column column;
            Column[] columnArray = genericTable.getColumns();
            int n = 0;
            boolean bl3 = false;
            for (LoadField loadField : loadFile.getFields()) {
                column = loadField.getColumn();
                if (column != null && !columnArray[n].getName().equals(column.getName())) {
                    bl3 = true;
                    break;
                }
                ++n;
            }
            if (bl3) {
                for (LoadField loadField : loadFile.getFields()) {
                    column = loadField.getColumn();
                    if (column == null) continue;
                    arrayList.add(ImportGenHelper.getField(importProperties, bl, column, bl2));
                }
            }
        }
    }

    protected static final String getField(ImportProperties importProperties, boolean bl, Column column) {
        return ImportGenHelper.getField(importProperties, bl, column, false);
    }

    protected static final String getField(ImportProperties importProperties, boolean bl, Column column, boolean bl2) {
        String string = (String)importProperties.get(ImportKeys.CHARNUMCHARACTERS);
        boolean bl3 = false;
        if (string != null && string.length() != 0 && string.replaceAll("[0-9]*", "").equals("")) {
            bl3 = true;
        }
        String string2 = column.getType().toUpperCase();
        String string3 = bl2 ? "\\\"" : "\"";
        switch (string2) {
            case "NUMBER": 
            case "INTEGER": 
            case "FLOAT": {
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2);
            }
            case "DATE": {
                if (column.getFormat() == null) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " DATE";
                }
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " DATE " + string3 + column.getFormat() + string3;
            }
            case "TIMESTAMP": {
                if (column.getFormat() == null) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " TIMESTAMP";
                }
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " TIMESTAMP " + string3 + column.getFormat() + string3;
            }
            case "CHAR": 
            case "NCHAR": {
                if (bl) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + column.getPrecision() + ")";
                }
                if (bl3) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + string + ")";
                }
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(2000)";
            }
            case "VARCHAR2": 
            case "NVARCHAR2": {
                if (bl) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + column.getPrecision() + ")";
                }
                if (bl3) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + string + ")";
                }
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(32767)";
            }
            case "CLOB": {
                if (bl3) {
                    return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + string + ")";
                }
                return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(32767)";
            }
        }
        if (bl3) {
            return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(" + string + ")";
        }
        return ImportGenHelper.addDoubleQuote(importProperties, column.getName(), bl2) + " CHAR(4000)";
    }
}

