/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.extract.ExtractLogger;

public class ImportWriteStream
extends ExtractLogger {
    private FileOutputStream _badStream;
    private OutputStreamWriter _badStreamWriter;
    private File _badFile;
    private URL _badFileURL;
    private String _genDirPath;
    private String _badDirPath;
    private String _genFileName;
    private String _badFileName;
    private String _defaultDir;
    private boolean _isGenTemp;
    private String _encoding;

    public ImportWriteStream(OutputStreamWriter outputStreamWriter) throws IOException {
        super(outputStreamWriter);
    }

    public ImportWriteStream(FileOutputStream fileOutputStream) throws IOException {
        super(fileOutputStream);
    }

    public ImportWriteStream(File file) throws IOException {
        super(file);
    }

    public ImportWriteStream(File file, String string) throws IOException {
        super(file, string);
    }

    public ImportWriteStream(String string, String string2) throws IOException {
        this(string, string2, null, null);
    }

    public ImportWriteStream(String string, String string2, String string3, String string4) throws IOException {
        super(string, string2, string4, string3);
        this._encoding = string2;
        if (string3 != null) {
            this._badDirPath = this._genDirPath = string3;
        } else {
            this.init();
            this._genDirPath = this._defaultDir;
            this._badDirPath = this._defaultDir;
        }
        try {
            this.setGenFiles(string, string4);
        }
        catch (IOException iOException) {
            this._badDirPath = this._genDirPath = ImportWriteStream.getTempDir();
            this.setGenFiles(string, string4);
        }
    }

    private void setGenFiles(String string) throws IOException {
        this.setGenFiles(string, null);
    }

    private void setGenFiles(String string, String string2) throws IOException {
        String string3 = string2 == null ? ".sql" : string2;
        String string4 = string;
        this._genFileName = this.getUniqueFileName(this._genDirPath, string4 + "_" + this.getStartTime(), string3);
        this._badFileName = this.getUniqueFileName(this._badDirPath, string4 + "-bad_" + this.getStartTime(), string3);
        this._badFile = new File(this._badFileName);
        this._badFileURL = this._badFile.toURI().toURL();
        if (this._isGenTemp) {
            // empty if block
        }
        if (this._encoding == null) {
            this._badStream = new FileOutputStream(this._badFile);
            this._badStreamWriter = new OutputStreamWriter(this._badStream);
        } else {
            this._badStream = new FileOutputStream(this._badFile);
            this._badStreamWriter = new OutputStreamWriter((OutputStream)this._badStream, this._encoding);
        }
        super.setWriter();
    }

    private void init() {
        DBConfig dBConfig = DBConfig.getInstance();
        this._defaultDir = dBConfig.getString("IMPORT_INS_GEN_DIR");
        this._isGenTemp = dBConfig.getBoolean("IMPORT_INS_GEN_TEMP");
        if (this._defaultDir == null || this._defaultDir.length() == 0) {
            this._defaultDir = dBConfig.getString("IMPORTDIR");
            if (this._isGenTemp) {
                try {
                    this._defaultDir = ImportWriteStream.getTempDir();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected FileOutputStream getBadStream() {
        return this._badStream;
    }

    protected OutputStreamWriter getBadStreamWriter() {
        return this._badStreamWriter;
    }

    public void endObject() {
    }

    public void endPreamble() {
    }

    @Override
    public void finished() {
        super.finished();
    }

    public void finishedBad() throws IOException {
        if (this._badStreamWriter != null) {
            this._badStreamWriter.flush();
            this._badStreamWriter.close();
            this._badStreamWriter = null;
        }
        if (!this.isBadFileUsed()) {
            this.deleteEmptyBadFile();
        }
    }

    protected void printErrorSummary(String[] stringArray) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(this.getFile(), false);
        outputStreamWriter = this._encoding == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, this._encoding);
        this.finished();
        for (String string : stringArray) {
            outputStreamWriter.write(string);
        }
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    public void println(String string) {
        super.log(string);
    }

    public void printlnBad(String string) throws IOException {
        this._badStreamWriter.write(string + "\n");
    }

    public boolean isBadFileUsed() {
        return this._badFile != null & this._badFile.exists() && this._badFile.length() > 0L;
    }

    public void deleteEmptyBadFile() {
        if (this._badFile != null && this._badFile.exists() && this._badFile.length() == 0L) {
            this._badFile.delete();
        }
    }

    public void startObject(String string, String string2) {
    }

    public void startPreamble(String string) throws FileNotFoundException, UnsupportedEncodingException {
    }

    public void seturlBad(URL uRL) {
        this._badFileURL = uRL;
    }

    public URL geturlBad() {
        return this._badFileURL;
    }

    public String getFileName() {
        return this._genFileName;
    }

    public static String getTempDir() throws IOException {
        File file = File.createTempFile("pref", "suf");
        String string = file.getParentFile().getPath();
        file.delete();
        return string;
    }

    private String getUniqueFileName(String string, String string2, String string3) {
        String string4 = string + File.separator + string2 + string3;
        File file = new File(string4);
        int n = 0;
        while (file.isFile()) {
            string4 = string + File.separator + string2 + "_" + ++n + string3;
            file = new File(string4);
        }
        return string4;
    }
}

