/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.dbdiff.DBDiffResources;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbdiff.editor.DbDiffEditorNode;
import oracle.dbtools.raptor.dbdiff.editor.DiffTextCompareContributor;
import oracle.dbtools.raptor.dbdiff.editor.tree.CheckTreeManager;
import oracle.dbtools.raptor.dbdiff.editor.tree.DbDiffCheckTree;
import oracle.dbtools.raptor.dbdiff.models.DbDiffObject;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.ExportGenerationOutputStream;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;

public class DbDiffEditor
extends Editor {
    private JPanel _panel = new JPanel();
    private JPanel _ui = new JPanel();
    private Toolbar _toolbar = new Toolbar();
    private JLabel _connsLabel = new JLabel();
    JCheckBox _isShowEqualsCb = new JCheckBox(DBDiffResources.getString("DbDiffEditor_showEqual"), false);
    JCheckBox _isShowNewCb = new JCheckBox(DBDiffResources.getString("DbDiffEditor_showNew"), true);
    private DbDiffEditorNode _editorNode;
    private DbDiffEditor _editor;
    private DbDiffCheckTree _dbDiffCheckTree;
    private BasicEditorPane _sql;
    private CompareView _diff;
    private DbDiffObject _selectedDiffObject;
    private boolean actionState;
    private IdeAction action = null;
    private String _EOL;
    private JPanel diffPanel = new JPanel(new GridBagLayout());
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private TargetOptionsPanel _targetOptions;
    private TargetFormat _targetFormat;
    private ExportGenerationOutputStream _genOutputStream;
    private String _destConnName;
    private JEWTDialog _actionDialog;
    private boolean _cancel = false;

    public DbDiffEditor() {
        this.setEditorAttribute("scrollable", Boolean.FALSE);
        this._editor = this;
        this._panel.setLayout(new BorderLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._ui, "f1_db_diffresults_html");
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void open() {
        this._editorNode = (DbDiffEditorNode)this.getContext().getNode();
        this.buildToolbar();
        this._panel.add((Component)this._toolbar, "First");
        this.buildUI();
        this._panel.add(this._ui);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._ui, "f1_db_diffresults_html");
        if (this.action != null) {
            this.actionState = this.action.isEnabled();
            this.action.setEnabled(false);
        }
    }

    public void close() {
        if (this.action != null) {
            this.action.setEnabled(this.actionState);
        }
        super.close();
    }

    public Component getGUI() {
        this.refresh();
        return this._panel;
    }

    private void refresh() {
        this._sql.setEditable(true);
        if (this._selectedDiffObject != null) {
            ExtractObject extractObject = this._selectedDiffObject.getExtractObject();
            if (!this._selectedDiffObject.isAvailable()) {
                this._sql.setText(this._selectedDiffObject.getNotAvailable());
            } else if (extractObject.isExistsSource() && !extractObject.isExistsDest()) {
                this._sql.setText(this._selectedDiffObject.getAlterRight());
            } else if (this._selectedDiffObject.isChanged()) {
                this._sql.setText(this._selectedDiffObject.getAlterRight());
            } else {
                this._sql.setText("-- " + DBDiffResources.getString("DbDiffEditor_objectsEqual"));
            }
            this._sql.updateUI();
            DiffTextCompareContributor diffTextCompareContributor = new DiffTextCompareContributor(this._selectedDiffObject.getCreateLeft());
            DiffTextCompareContributor diffTextCompareContributor2 = new DiffTextCompareContributor(this._selectedDiffObject.getCreateRight());
            CompareInvocation compareInvocation = CompareUtil.createInvocationContext((Element)this._editorNode, (CompareContributor)diffTextCompareContributor, (CompareContributor)diffTextCompareContributor2, (StreamType)StreamType.OTHER);
            try {
                CompareModel compareModel = CompareUtil.createCompareModel((CompareContributor)diffTextCompareContributor, (CompareContributor)diffTextCompareContributor2, (CompareInvocation)compareInvocation);
                this._diff = CompareViewFactory.createCompareView((CompareModel)compareModel);
                this.diffPanel.removeAll();
                this.diffPanel.add(this._diff.getGUI(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.diffPanel.updateUI();
            }
            catch (CompareFailedException compareFailedException) {
                this.diffPanel.removeAll();
                this.diffPanel.updateUI();
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, compareFailedException.getStackTrace()[0].toString(), compareFailedException);
            }
        } else {
            this._sql.setText("");
            this.diffPanel.removeAll();
            this.diffPanel.updateUI();
        }
        this._sql.setEditable(false);
    }

    private void buildToolbar() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DbDiffEditor.12"), CommonArb.getIcon("SQLWORKSHEET_ICON")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbDiffEditor.this._targetFormat = new TargetFormat(1, 2);
                DbDiffEditor.this._targetFormat.setShowEncoding(true);
                DbDiffEditor.this._targetFormat.setShowCompression(false);
                DbDiffEditor.this._targetFormat.setShowSaveAsType(true);
                DbDiffEditor.this._targetFormat.isCompressed(false);
                DbDiffEditor.this._targetFormat.setSaveAsType(0);
                DbDiffEditor.this._targetFormat.setSaveAs(DbDiffEditor.this._targetFormat.getDefaultSaveAs());
                DbDiffEditor.this._targetOptions = new TargetOptionsPanel(DbDiffEditor.this._editor.getGUI(), DbDiffEditor.this._targetFormat);
                JPanel jPanel = DbDiffEditor.this._targetOptions.getPanel();
                DbDiffEditor.this._targetOptions.getSaveAsTypeComponent().addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            String string = "sql";
                            DbDiffEditor.this._targetOptions.saveAsTypeChanged(string);
                        }
                    }
                });
                HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_diffGenDDL_html");
                jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
                DbDiffEditor.this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)Messages.getString("DbDiffEditor.GenSqlTitle"), (int)14);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = 0;
                        if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                            DbDiffEditor.this._targetFormat = DbDiffEditor.this._targetOptions.getFormat();
                            if (DbDiffEditor.this._targetFormat.getSaveAsType() < 4) {
                                n = DbDiffEditor.this._targetFormat.validateSaveAs((Component)Ide.getMainWindow());
                            }
                            if (n == 0) {
                                DbDiffEditor.this.writeDiff();
                            }
                        }
                        if (n == 0) {
                            DbDiffEditor.this._actionDialog.setVisible(false);
                            DbDiffEditor.this._actionDialog.dispose();
                        } else if (n == 1) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbDiffEditor.this._targetFormat.getValidationMessage(), (String)Messages.getString("DbDiffEditor.GenSqlTitle"), (String)"DBDIFF_FILE_ERROR");
                        }
                    }
                };
                DbDiffEditor.this._actionDialog.addActionListener(actionListener);
                Dimension dimension = jPanel.getPreferredSize();
                int n = (int)dimension.getHeight() + 100;
                int n2 = (int)dimension.getWidth() + 28;
                DbDiffEditor.this._actionDialog.setSize(n2, n);
                DbDiffEditor.this._actionDialog.setPreferredSize(n2, n);
                DbDiffEditor.this._actionDialog.setMinimumSize(n2, n);
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)DbDiffEditor.this._actionDialog);
                WizardLauncher.runDialog((JDialog)DbDiffEditor.this._actionDialog);
            }
        };
        abstractAction.putValue("ShortDescription", Messages.getString("DbDiffEditor.14"));
        this._toolbar.add((Action)abstractAction);
        this._toolbar.addFiller();
        this._toolbar.addSeparator();
        this._toolbar.addFiller();
        if (this._editorNode != null && this._editorNode.getDiffObjects() != null && this._editorNode.getDiffObjects().size() > 0) {
            String string = this._editorNode.getSourceName();
            String string2 = this._editorNode.getDestName();
            this._connsLabel.setText(string + " -> " + string2);
        } else {
            this._connsLabel.setText(Messages.getString("DbDiffEditor.NoResults"));
        }
        this._toolbar.add((Component)this._connsLabel);
        this._toolbar.addFiller();
        this._toolbar.addSeparator();
        this._toolbar.addFiller();
        this._isShowEqualsCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DbDiffEditor.this._dbDiffCheckTree.refreshModel(DbDiffEditor.this._isShowEqualsCb.isSelected(), DbDiffEditor.this._isShowNewCb.isSelected());
                DbDiffEditor.this._selectedDiffObject = null;
                DbDiffEditor.this.refresh();
            }
        });
        this._toolbar.add((Component)this._isShowEqualsCb);
        this._toolbar.addFiller();
        this._toolbar.addSeparator();
        this._toolbar.addFiller();
        this._isShowNewCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DbDiffEditor.this._dbDiffCheckTree.refreshModel(DbDiffEditor.this._isShowEqualsCb.isSelected(), DbDiffEditor.this._isShowNewCb.isSelected());
                DbDiffEditor.this._selectedDiffObject = null;
                DbDiffEditor.this.refresh();
            }
        });
        this._toolbar.add((Component)this._isShowNewCb);
    }

    private void buildUI() {
        this._dbDiffCheckTree = new DbDiffCheckTree(this._editorNode.getDiffObjects());
        JTree jTree = this._dbDiffCheckTree.getTree();
        this._dbDiffCheckTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DbDiffEditor.this._selectedDiffObject = DbDiffEditor.this._dbDiffCheckTree.getSelectedDifference();
                DbDiffEditor.this.refresh();
            }
        });
        this.buildSqlEditor();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._sql);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(jTree);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(DBDiffResources.getString("DbDiffEditor_DdlTab"), null, this.diffPanel, DBDiffResources.getString("DbDiffEditor_DdlTabTip"));
        jTabbedPane.addTab(DBDiffResources.getString("DbDiffEditor_ScriptTab"), null, jScrollPane, DBDiffResources.getString("DbDiffEditor_ScriptTabTip"));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jTabbedPane);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this._ui.setLayout(new GridBagLayout());
        this._ui.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildSqlEditor() {
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setPreferredSize(new Dimension(300, 200));
        this._sql.setText("");
        this._sql.setEditable(false);
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void writeDiff() {
        WriteDiffTask writeDiffTask = new WriteDiffTask(Messages.getString("DbDiffEditor.16"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true, false);
        writeDiffTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)writeDiffTask);
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public void outputDiff(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        ExtractObject extractObject;
        List<Object> list;
        Object object;
        ArrayList<TreePath> arrayList = CheckTreeManager.getAllCheckedPaths(this._dbDiffCheckTree.getCheckTreeManager(), this._dbDiffCheckTree.getTree());
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (Serializable serializable : arrayList) {
            object = serializable.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (list = ((DefaultMutableTreeNode)object).getUserObject()) == null || !(list instanceof DbDiffObject)) continue;
            DbDiffObject dbDiffObject = (DbDiffObject)((Object)list);
            extractObject = ((DbDiffObject)((Object)list)).getExtractObject();
            extractObject.setProperty("DIFF_IS_CHANGED", dbDiffObject.isChanged());
            if (!this._cancel) {
                if (extractObject.isExistsDest()) {
                    if (dbDiffObject.isChanged()) {
                        extractObject.setProperty("DIFF_DDL", dbDiffObject.getAlterRight());
                    }
                } else {
                    extractObject.setProperty("DIFF_DDL", dbDiffObject.getAlterRight());
                }
                iRaptorTaskProgressUpdater.getDescriptor().setMessage(dbDiffObject.getObjectName());
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            if (extractObject.getPropertyValue("DIFF_DDL") == null || ((String)extractObject.getPropertyValue("DIFF_DDL")).length() <= 0) continue;
            arrayList2.add(((DbDiffObject)((Object)list)).getExtractObject());
        }
        if (!arrayList2.isEmpty()) {
            Serializable serializable;
            this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
            this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
            this._genOutputStream.endPreamble();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
            serializable = new Date();
            object = "--------------------------------------------------------" + this.getTerm() + Messages.getString("DbDiffEditor.FileCreated") + simpleDateFormat.format((Date)serializable) + "   " + this.getTerm() + "--------------------------------------------------------" + this.getTerm();
            if (this._targetFormat.getSaveAsType() == 0) {
                this._genOutputStream.println((String)object);
            } else {
                this._genOutputStream.setControllingFileHeader((String)object);
            }
            list = new ArrayList();
            list = ((ExtractObject)arrayList2.get(0)).getListModel().getCreateProcessList(arrayList2, 1);
            this._destConnName = ((ExtractObject)arrayList2.get(0)).getListModel().getDestConnName();
            for (int i = 0; i < list.size(); ++i) {
                extractObject = (ExtractObject)list.get(i);
                Boolean bl = (Boolean)extractObject.getPropertyValue("DIFF_IS_CHANGED");
                if (this._cancel) continue;
                DBObject dBObject = extractObject.getDBObject();
                if (extractObject.isExistsDest()) {
                    if (bl.booleanValue()) {
                        this._genOutputStream.startObject(dBObject.getObjectName(), dBObject.getObjectType());
                        this._genOutputStream.println("---------------------------" + this.getTerm());
                        this._genOutputStream.println("--" + Messages.getString("DbDiffEditor.Changed") + " " + extractObject.getDBObject().getObjectType() + this.getTerm());
                        this._genOutputStream.println("--" + extractObject.getDBObject().getObjectName() + this.getTerm());
                        this._genOutputStream.println("---------------------------" + this.getTerm());
                        this._genOutputStream.println((String)extractObject.getPropertyValue("DIFF_DDL") + this.getTerm());
                    }
                } else {
                    this._genOutputStream.startObject(dBObject.getObjectName(), dBObject.getObjectType());
                    this._genOutputStream.println("---------------------------" + this.getTerm());
                    this._genOutputStream.println("--" + Messages.getString("DbDiffEditor.New") + " " + extractObject.getDBObject().getObjectType() + this.getTerm());
                    this._genOutputStream.println("--" + extractObject.getDBObject().getObjectName() + this.getTerm());
                    this._genOutputStream.println("---------------------------" + this.getTerm());
                    this._genOutputStream.println((String)extractObject.getPropertyValue("DIFF_DDL") + this.getTerm());
                }
                iRaptorTaskProgressUpdater.getDescriptor().setMessage(dBObject.getObjectName());
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            this._genOutputStream.finished();
        }
    }

    private class WriteDiffTask
    extends RaptorTask<Void> {
        public WriteDiffTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
            super(string, bl3, iRaptorTaskRunMode);
            this.setMessage(string);
            this.setPausable(bl);
            this.setCancellable(bl2);
        }

        protected Void doWork() {
            block5: {
                try {
                    DbDiffEditor.this.outputDiff(this.getRaptorTaskProgressUpdater());
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    return null;
                }
                if (DbDiffEditor.this._genOutputStream != null) {
                    try {
                        DbDiffEditor.this._genOutputStream.openTargetInUI(DbDiffEditor.this._destConnName);
                    }
                    catch (Exception exception) {
                        Throwable throwable = exception.getCause();
                        if (throwable instanceof CancellationException) break block5;
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
            return null;
        }
    }
}

