/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Logger;

public final class DDLTypes {
    public static final String DROP = "DROP";
    public static final String DATA = "DATA";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String APEX_PAGE = "APEX_PAGE";
    public static final String APEX = "APEX";
    public static final String QUEUETABLE = "QUEUE TABLE";
    public static final String REFCONSTRAINT = "REFCONSTRAINT";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String QUEUE = "QUEUE";
    public static final String DIRECTORY = "DIRECTORY";
    public static final String MATVIEWLOG = "MATERIALIZED VIEW LOG";
    public static final String SYNONYM = "SYNONYM";
    public static final String DBLINK = "DATABASE LINK";
    public static final String FUNCTION = "FUNCTION";
    public static final String OPERATOR = "OPERATOR";
    public static final String INDEX = "INDEX";
    public static final String MATVIEW = "MATERIALIZED VIEW";
    public static final String PACKSPEC = "PACKAGE";
    public static final String PACKBODY = "PACKAGE BODY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String TABLE = "TABLE";
    public static final String TRIGGER = "TRIGGER";
    public static final String TYPE = "TYPE";
    public static final String EDITION_VIEW = "EDITION_VIEW";
    public static final String VIEW = "VIEW";
    public static final String[] DATA_OBJECT_URL_TYPES = new String[]{"TABLE", "VIEW", "EDITION_VIEW", "MATERIALIZED+VIEW"};
    public static final String[] DATA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "EDITION_VIEW"};
    public static final LinkedHashMap<String, String> ret = new LinkedHashMap();
    public static final ArrayList<String> standardTypes = new ArrayList();
    public static final ArrayList<String> extensionTypes = new ArrayList();
    private static final Set<DDLTypeDef> sTypeList = new LinkedHashSet<DDLTypeDef>();
    private final Map<String, State> mStates = new HashMap<String, State>();
    private boolean _doTabDeps = false;
    private boolean _showTabDeps = false;
    private static final String[] TYPES_WITH_DATA;
    private static final String[] TYPES_WITH_DATA_XVIEW;

    public static void registerDDLType(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        sTypeList.add(new DDLTypeDef(string, DDLTypes.initCap(string), bl, bl2, bl3, bl4));
        extensionTypes.add(string);
    }

    public static void registerDDLType(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        sTypeList.add(new DDLTypeDef(string, string2, bl, bl2, bl3, bl4));
        extensionTypes.add(string);
    }

    public static void registerDDLType(String string, boolean bl) {
        sTypeList.add(new DDLTypeDef(string, DDLTypes.initCap(string), bl));
        extensionTypes.add(string);
    }

    public static void registerDDLType(String string, String string2, boolean bl) {
        sTypeList.add(new DDLTypeDef(string, string2, bl));
        extensionTypes.add(string);
    }

    private static void registerDDLTypeStandard(String string, String string2, boolean bl) {
        sTypeList.add(new DDLTypeDef(string, string2, bl));
        standardTypes.add(string);
    }

    private static void registerDDLTypeStandard(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        sTypeList.add(new DDLTypeDef(string, string, bl, bl2, bl3, bl4));
        standardTypes.add(string);
    }

    private static void registerDDLTypeStandard(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        sTypeList.add(new DDLTypeDef(string, string2, bl, bl2, bl3, bl4));
        standardTypes.add(string);
    }

    public DDLTypes() {
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            State state = new State(dDLTypeDef.label, dDLTypeDef.defaultState, dDLTypeDef.defaultShown);
            this.mStates.put(dDLTypeDef.type, state);
        }
    }

    public void setEnable(boolean bl) {
        for (Map.Entry<String, State> entry : this.mStates.entrySet()) {
            State state = entry.getValue();
            if (state.enable == bl) continue;
            entry.setValue(new State(state.label, bl, state.show));
        }
        this._doTabDeps = bl;
    }

    public void setShow(boolean bl) {
        for (Map.Entry<String, State> entry : this.mStates.entrySet()) {
            State state = entry.getValue();
            if (state.show == bl) continue;
            entry.setValue(new State(state.label, state.enable, bl));
        }
        this._showTabDeps = bl;
    }

    public void setTypeState(String string, boolean bl) {
        State state = this.mStates.get(string);
        if (state == null) {
            Logger.warn(DDLTypes.class, (String)("DDL type " + string + " not registered."));
            this.mStates.put(string, new State(string, bl, false));
        } else if (state.enable != bl) {
            this.mStates.put(string, new State(state.label, bl, state.show));
        }
    }

    public boolean getTypeState(String string) {
        State state = this.mStates.get(string);
        return state != null && state.enable && state.show;
    }

    public void setTypeShown(String string, boolean bl) {
        State state = this.mStates.get(string);
        if (state == null) {
            Logger.warn(DDLTypes.class, (String)("DDL type " + string + " not registered."));
            this.mStates.put(string, new State(string, false, bl));
        } else if (state.show != bl) {
            this.mStates.put(string, new State(state.label, state.enable, bl));
        }
    }

    public boolean isTypeShown(String string) {
        State state = this.mStates.get(string);
        return state != null && state.show;
    }

    public String getTypeLabel(String string) {
        State state = this.mStates.get(string);
        return state != null ? state.label : string;
    }

    public void setView(boolean bl) {
        this.setTypeState(VIEW, bl);
    }

    public void setType(boolean bl) {
        this.setTypeState(TYPE, bl);
    }

    public void setTrigger(boolean bl) {
        this.setTypeState(TRIGGER, bl);
    }

    public void setTable(boolean bl) {
        this.setTypeState(TABLE, bl);
    }

    public void setSequence(boolean bl) {
        this.setTypeState(SEQUENCE, bl);
    }

    public void setProcedure(boolean bl) {
        this.setTypeState(PROCEDURE, bl);
    }

    public void setPackBody(boolean bl) {
        this.setTypeState(PACKBODY, bl);
    }

    public void setPackSpec(boolean bl) {
        this.setTypeState(PACKSPEC, bl);
    }

    public void setMatView(boolean bl) {
        this.setTypeState(MATVIEW, bl);
    }

    public void setIndex(boolean bl) {
        this.setTypeState(INDEX, bl);
    }

    public void setFunction(boolean bl) {
        this.setTypeState(FUNCTION, bl);
    }

    public void setOperator(boolean bl) {
        this.setTypeState(OPERATOR, bl);
    }

    public void setDbLink(boolean bl) {
        this.setTypeState(DBLINK, bl);
    }

    public void setConstraint(boolean bl) {
        this.setTypeState(CONSTRAINT, bl);
    }

    public void setRefConstraint(boolean bl) {
        this.setTypeState(REFCONSTRAINT, bl);
    }

    public void setSynonymn(boolean bl) {
        this.setTypeState(SYNONYM, bl);
    }

    public void setMatViewLog(boolean bl) {
        this.setTypeState(MATVIEWLOG, bl);
    }

    public void setTableDeps(boolean bl) {
        this._doTabDeps = bl;
    }

    public void setDirectory(boolean bl) {
        this.setTypeState(DIRECTORY, bl);
    }

    public void setQueue(boolean bl) {
        this.setTypeState(QUEUE, bl);
    }

    public void setQueueTable(boolean bl) {
        this.setTypeState(QUEUETABLE, bl);
    }

    public void setApex(boolean bl) {
        this.setTypeState(APEX, bl);
    }

    public void setApexPage(boolean bl) {
        this.setTypeState(APEX_PAGE, bl);
    }

    public boolean getView() {
        return this.getTypeState(VIEW);
    }

    public boolean getType() {
        return this.getTypeState(TYPE);
    }

    public boolean getTrigger() {
        return this.getTypeState(TRIGGER);
    }

    public boolean getTable() {
        return this.getTypeState(TABLE);
    }

    public boolean getSequence() {
        return this.getTypeState(SEQUENCE);
    }

    public boolean getProcedure() {
        return this.getTypeState(PROCEDURE);
    }

    public boolean getPackBody() {
        return this.getTypeState(PACKBODY);
    }

    public boolean getPackSpec() {
        return this.getTypeState(PACKSPEC);
    }

    public boolean getMatView() {
        return this.getTypeState(MATVIEW);
    }

    public boolean getIndex() {
        return this.getTypeState(INDEX);
    }

    public boolean getFunction() {
        return this.getTypeState(FUNCTION);
    }

    public boolean getOperator() {
        return this.getTypeState(OPERATOR);
    }

    public boolean getDbLink() {
        return this.getTypeState(DBLINK);
    }

    public boolean getConstraint() {
        return this.getTypeState(CONSTRAINT);
    }

    public boolean getRefConstraint() {
        if (!this.isTypeShown(REFCONSTRAINT)) {
            return this.getTypeState(CONSTRAINT);
        }
        return this.getTypeState(REFCONSTRAINT);
    }

    public boolean getSynonymn() {
        return this.getTypeState(SYNONYM);
    }

    public boolean getMatViewLog() {
        return this.getTypeState(MATVIEWLOG);
    }

    public boolean getTableDeps() {
        return this._showTabDeps && this._doTabDeps;
    }

    public boolean getDirectory() {
        return this.getTypeState(DIRECTORY);
    }

    public boolean getQueue() {
        return this.getTypeState(QUEUE);
    }

    public boolean getQueueTable() {
        return this.getTypeState(QUEUETABLE);
    }

    public boolean getApex() {
        return this.getTypeState(APEX);
    }

    public boolean getApexPage() {
        return this.getTypeState(APEX_PAGE);
    }

    public void setShowView(boolean bl) {
        this.setTypeShown(VIEW, bl);
    }

    public void setShowType(boolean bl) {
        this.setTypeShown(TYPE, bl);
    }

    public void setShowTrigger(boolean bl) {
        this.setTypeShown(TRIGGER, bl);
    }

    public void setShowTable(boolean bl) {
        this.setTypeShown(TABLE, bl);
    }

    public void setShowSequence(boolean bl) {
        this.setTypeShown(SEQUENCE, bl);
    }

    public void setShowProcedure(boolean bl) {
        this.setTypeShown(PROCEDURE, bl);
    }

    public void setShowPackBody(boolean bl) {
        this.setTypeShown(PACKBODY, bl);
    }

    public void setShowPackSpec(boolean bl) {
        this.setTypeShown(PACKSPEC, bl);
    }

    public void setShowMatView(boolean bl) {
        this.setTypeShown(MATVIEW, bl);
    }

    public void setShowIndex(boolean bl) {
        this.setTypeShown(INDEX, bl);
    }

    public void setShowFunction(boolean bl) {
        this.setTypeShown(FUNCTION, bl);
    }

    public void setShowOperator(boolean bl) {
        this.setTypeShown(OPERATOR, bl);
    }

    public void setShowDbLink(boolean bl) {
        this.setTypeShown(DBLINK, bl);
    }

    public void setShowData(boolean bl) {
    }

    public void setShowConstraint(boolean bl) {
        this.setTypeShown(CONSTRAINT, bl);
    }

    public void setShowRefConstraint(boolean bl) {
        this.setTypeShown(REFCONSTRAINT, bl);
    }

    public void setShowSynonymn(boolean bl) {
        this.setTypeShown(SYNONYM, bl);
    }

    public void setShowMatViewLog(boolean bl) {
        this.setTypeShown(MATVIEWLOG, bl);
    }

    public void setShowTableDeps(boolean bl) {
        this._showTabDeps = bl;
    }

    public void setShowDirectory(boolean bl) {
        this.setTypeShown(DIRECTORY, bl);
    }

    public void setShowQueue(boolean bl) {
        this.setTypeShown(QUEUE, bl);
    }

    public void setShowQueueTable(boolean bl) {
        this.setTypeShown(QUEUETABLE, bl);
    }

    public void setShowApex(boolean bl) {
        this.setTypeShown(APEX, bl);
    }

    public void setShowApexPage(boolean bl) {
        this.setTypeShown(APEX_PAGE, bl);
    }

    public boolean getShowView() {
        return this.isTypeShown(VIEW);
    }

    public boolean getShowType() {
        return this.isTypeShown(TYPE);
    }

    public boolean getShowTrigger() {
        return this.isTypeShown(TRIGGER);
    }

    public boolean getShowTable() {
        return this.isTypeShown(TABLE);
    }

    public boolean getShowSequence() {
        return this.isTypeShown(SEQUENCE);
    }

    public boolean getShowProcedure() {
        return this.isTypeShown(PROCEDURE);
    }

    public boolean getShowPackBody() {
        return this.isTypeShown(PACKBODY);
    }

    public boolean getShowPackSpec() {
        return this.isTypeShown(PACKSPEC);
    }

    public boolean getShowMatView() {
        return this.isTypeShown(MATVIEW);
    }

    public boolean getShowIndex() {
        return this.isTypeShown(INDEX);
    }

    public boolean getShowFunction() {
        return this.isTypeShown(FUNCTION);
    }

    public boolean getShowOperator() {
        return this.isTypeShown(OPERATOR);
    }

    public boolean getShowDbLink() {
        return this.isTypeShown(DBLINK);
    }

    public boolean getShowConstraint() {
        return this.isTypeShown(CONSTRAINT);
    }

    public boolean getShowRefConstraint() {
        return this.isTypeShown(REFCONSTRAINT);
    }

    public boolean getShowSynonymn() {
        return this.isTypeShown(SYNONYM);
    }

    public boolean getShowMatViewLog() {
        return this.isTypeShown(MATVIEWLOG);
    }

    public boolean getShowTableDeps() {
        return this._showTabDeps;
    }

    public boolean getShowDirectory() {
        return this.isTypeShown(DIRECTORY);
    }

    public boolean getShowQueue() {
        return this.isTypeShown(QUEUE);
    }

    public boolean getShowQueueTable() {
        return this.isTypeShown(QUEUETABLE);
    }

    public boolean getShowApex() {
        return this.isTypeShown(APEX);
    }

    public boolean getShowApexPage() {
        return this.isTypeShown(APEX_PAGE);
    }

    public List<String> getTypes(int n) {
        switch (n) {
            case 1: {
                return this.getCreateTypes();
            }
            case 2: {
                return this.getCreatePreDataTypes();
            }
            case 3: {
                return this.getCreatePostDataTypes();
            }
            case 4: {
                return this.getDropTypes();
            }
            case 5: {
                return this.getTableType();
            }
            case 6: {
                return this.getTableType();
            }
            case 7: {
                return this.getTableType();
            }
        }
        return null;
    }

    public List<String> getCreateTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (!this.getTypeState(dDLTypeDef.type)) continue;
            arrayList.add(dDLTypeDef.type);
        }
        return arrayList;
    }

    public List<String> getCreatePreDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (!dDLTypeDef.createPreData || !this.getTypeState(dDLTypeDef.type)) continue;
            arrayList.add(dDLTypeDef.type);
        }
        return arrayList;
    }

    public List<String> getCreatePostDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (dDLTypeDef.createPreData || !this.getTypeState(dDLTypeDef.type)) continue;
            arrayList.add(dDLTypeDef.type);
        }
        return arrayList;
    }

    public List<String> getDropTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (!dDLTypeDef.canDrop || !this.getTypeState(dDLTypeDef.type)) continue;
            arrayList.add(dDLTypeDef.type);
        }
        if (arrayList.contains(TABLE)) {
            arrayList.remove(TRIGGER);
            arrayList.remove(INDEX);
        }
        return new ArrayList<String>(arrayList);
    }

    public List<String> getTableType() {
        return this.getTypeState(TABLE) ? Collections.singletonList(TABLE) : Collections.emptyList();
    }

    public Map<String, String> getTypes(boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (!this.getTypeState(dDLTypeDef.type)) continue;
            linkedHashMap.put(dDLTypeDef.type, dDLTypeDef.key);
        }
        if (bl) {
            linkedHashMap.put(DATA, "Oracle#DATA");
        }
        return linkedHashMap;
    }

    public String getTypeKey(String string) {
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (!dDLTypeDef.type.equals(string)) continue;
            return dDLTypeDef.key;
        }
        return "";
    }

    public boolean isSupportedType(String string) {
        return DATA.equals(string) || this.getTypeState(string);
    }

    public boolean isSupportedFolderType(String string) {
        if (string.endsWith("_FOLDER")) {
            String string2 = string.substring(0, string.length() - 7);
            return this.getTypeState(string2);
        }
        return false;
    }

    public List<String> getTypeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DDLTypeDef dDLTypeDef : sTypeList) {
            if (CONSTRAINT.equals(dDLTypeDef.type) || REFCONSTRAINT.equals(dDLTypeDef.type) || !this.getTypeState(dDLTypeDef.type)) continue;
            arrayList.add(dDLTypeDef.type);
        }
        return arrayList;
    }

    public List<String> getTypeListForData() {
        return this.getTypeListForData(true);
    }

    public List<String> getTypeListForData(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : bl ? TYPES_WITH_DATA : TYPES_WITH_DATA_XVIEW) {
            if (!this.getTypeState(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getAllTypes() {
        String string = "";
        for (String string2 : this.getTypeList()) {
            string = string2 + ":" + string;
        }
        return string;
    }

    public void setTypes(List<ExtractObject> list) {
        this.setTypes(list, true);
    }

    public void setTypes(List<ExtractObject> list, boolean bl) {
        this.setEnable(false);
        for (ExtractObject extractObject : list) {
            if (extractObject.getType() == 0) {
                URL uRL = extractObject.getDBObject().getURL();
                String string = DBURLFormatHelper.getBaseType(uRL);
                if (uRL == null) continue;
                if (EDITION_VIEW.equals(string)) {
                    string = VIEW;
                }
                if (!this.mStates.containsKey(string)) continue;
                this.setTypeState(string, true);
                if (TABLE.equals(string) && bl) {
                    this.setTypeState(CONSTRAINT, true);
                    this.setTypeState(REFCONSTRAINT, true);
                    this.setTypeState(INDEX, true);
                    this.setTypeState(TRIGGER, true);
                    continue;
                }
                if (VIEW.equals(string) && bl) {
                    this.setTypeState(TRIGGER, true);
                    continue;
                }
                if (!APEX.equals(string) && !APEX_PAGE.equals(string)) continue;
                this.setTypeShown(string, true);
                continue;
            }
            if (extractObject.getType() != 4) continue;
            this.setTypeState(TABLE, true);
            if (!bl) continue;
            this.setTypeState(CONSTRAINT, true);
            this.setTypeState(REFCONSTRAINT, true);
            this.setTypeState(INDEX, true);
            this.setTypeState(TRIGGER, true);
        }
    }

    public static JLabel getFolderLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(DDLTypes.getFolderName(string));
        jLabel.setIcon(DDLTypes.getFolderIcon(string));
        return jLabel;
    }

    public static String getFolderName(String string) {
        String string2 = string.replaceAll(" ", "_") + "_FOLDER_LABEL";
        return DDLResources.getString(string2);
    }

    public static Icon getFolderIcon(String string) {
        String string2 = string.replaceAll(" ", "_") + "_FOLDER_ICON";
        return DDLResources.getIcon(string2);
    }

    public static String getLabel(String string) {
        String string2 = string.replaceAll(" ", "_") + "_LABEL";
        return DDLResources.getString(string2);
    }

    public static String initCap(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean bl = true;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ' || Character.isWhitespace(cArray[i])) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                bl = false;
                continue;
            }
            cArray[i] = Character.toLowerCase(cArray[i]);
        }
        return new String(cArray);
    }

    static {
        DDLTypes.registerDDLTypeStandard(DBLINK, DDLResources.getString("DB_LINK"), true);
        DDLTypes.registerDDLTypeStandard(TYPE, DDLResources.getString(TYPE), true);
        DDLTypes.registerDDLTypeStandard(SEQUENCE, DDLResources.getString("SEQ"), true);
        DDLTypes.registerDDLTypeStandard(TABLE, DDLResources.getString("TAB"), true);
        DDLTypes.registerDDLTypeStandard(VIEW, DDLResources.getString(VIEW), true);
        DDLTypes.registerDDLTypeStandard(MATVIEW, DDLResources.getString("MAT_VIEW"), true);
        DDLTypes.registerDDLTypeStandard(INDEX, DDLResources.getString("IND"), false);
        DDLTypes.registerDDLTypeStandard(TRIGGER, DDLResources.getString("TRIG"), false);
        DDLTypes.registerDDLTypeStandard(MATVIEWLOG, DDLResources.getString("MAT_VIEW_LOG"), false);
        DDLTypes.registerDDLTypeStandard(PROCEDURE, DDLResources.getString("PROC"), false);
        DDLTypes.registerDDLTypeStandard(PACKSPEC, DDLResources.getString("PACKS"), false);
        DDLTypes.registerDDLTypeStandard(PACKBODY, DDLResources.getString("PACKB"), false);
        DDLTypes.registerDDLTypeStandard(FUNCTION, DDLResources.getString("FUN"), false);
        DDLTypes.registerDDLTypeStandard(OPERATOR, DDLResources.getString("OPER"), false);
        DDLTypes.registerDDLTypeStandard(SYNONYM, DDLResources.getString("SYN"), false);
        DDLTypes.registerDDLTypeStandard(QUEUE, DDLResources.getString("QUEUE_TABLE"), false);
        DDLTypes.registerDDLTypeStandard(QUEUETABLE, DDLResources.getString("QUEUE_TABLE"), false);
        DDLTypes.registerDDLTypeStandard(CONSTRAINT, DDLResources.getString("CONS"), false, false, true, true);
        DDLTypes.registerDDLTypeStandard(REFCONSTRAINT, DDLResources.getString("REF_CONS"), false, false, true, true);
        DDLTypes.registerDDLTypeStandard(DIRECTORY, DDLResources.getString(DIRECTORY), false, true, false, false);
        DDLTypes.registerDDLTypeStandard(APEX, false, false, false, false);
        DDLTypes.registerDDLTypeStandard(APEX_PAGE, false, false, false, false);
        TYPES_WITH_DATA = new String[]{TABLE, VIEW, MATVIEW};
        TYPES_WITH_DATA_XVIEW = new String[]{TABLE};
    }

    private static final class DDLTypeDef {
        private final String type;
        private final String label;
        private final String key;
        private final boolean createPreData;
        private final boolean canDrop;
        private final boolean defaultState;
        private final boolean defaultShown;

        public DDLTypeDef(String string, boolean bl) {
            this(string, bl, true, true, true);
        }

        public DDLTypeDef(String string, String string2, boolean bl) {
            this(string, string2, bl, true, true, true);
        }

        DDLTypeDef(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(string, string, bl, true, true, true);
        }

        public DDLTypeDef(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.type = string;
            this.label = string2;
            this.createPreData = bl;
            this.canDrop = bl2;
            this.defaultState = bl3;
            this.defaultShown = bl4;
            this.key = "Oracle#" + string.replace(' ', '_');
        }
    }

    private static final class State {
        final String label;
        final boolean enable;
        final boolean show;

        State(String string, boolean bl, boolean bl2) {
            this.label = string;
            this.enable = bl;
            this.show = bl2;
        }
    }
}

