/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class ConnectionRename
extends AbstractMenuAction {
    private static final long serialVersionUID = 1L;
    private JEWTDialog dlg;
    private JTextField gName = null;
    private String oName;

    public boolean validateInput() {
        boolean bl = true;
        if (this.gName.getText() == null || this.gName.getText().trim().length() == 0 || !Pattern.matches("^[^<>:\\\"/\\\\|?*()%&'$^~#]*$", this.gName.getText())) {
            LogManager.getIdeLogWindow().log((Object)Messages.getString((String)"ConnectionRename.0"));
            bl = false;
        }
        return bl;
    }

    public void showPanel(String string, final String string2) {
        this.oName = string;
        PropertyPanel propertyPanel = new PropertyPanel();
        String string3 = Messages.getString((String)"ConnectionRename.1");
        String string4 = Messages.getString((String)"ConnectionRename.2");
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        this.gName.setText(string);
        propertyPanel.addComp(string4, (JComponent)this.gName);
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string3, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConnectionRename.this.validateInput()) {
                    Boolean bl = ConnectionRename.this.renameConnection(ConnectionRename.this.oName, ConnectionRename.this.gName.getText(), string2);
                    if (bl.booleanValue()) {
                        ConnectionRename.this.dlg.dispose();
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ConnectionRename.4"), (String)Messages.getString((String)"ConnectionRename.5"), (String)"f1_connectionnamedup_html");
                    }
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ConnectionRename.3"), (String)Messages.getString((String)"ConnectionRename.5"), null);
                }
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    boolean renameConnection(String string, String string2, String string3) {
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        DatabaseConnections databaseConnections = databaseConnectionStores.getStore(string3);
        try {
            if (databaseConnections.getProperties(string2) != null) {
                return false;
            }
            Properties properties = databaseConnections.getProperties(string);
            properties.setProperty("ConnName", string2);
            databaseConnections.updateConnection(string, string2, properties);
        }
        catch (ConnectionException connectionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() {
        Object object;
        DBObject dBObject;
        boolean bl;
        block10: {
            bl = true;
            dBObject = this.getDBObject();
            Element element = dBObject.getElement();
            if (element instanceof DatabaseConnection && ((BaseConnectionNode)(object = (DatabaseConnection)element)).isConnectionOpen()) {
                Connection connection = null;
                try {
                    connection = (Connection)((BaseConnectionNode)object).getConnection();
                    bl = false;
                    Connections connections = Connections.getInstance();
                    if (!connections.lock(connection, true)) break block10;
                    try {
                        if (MessageDialog.confirm(null, (Object)CreateDialogArb.format("CONN_RENAME_OPEN_CONN", ((DatabaseConnection)object).getConnectionName()), (String)CreateDialogArb.getString("CONN_RENAME_OPEN_TITLE"), null)) {
                            if (connections.closeConnection(((DatabaseConnection)object).getQualifiedConnectionName())) {
                                bl = true;
                            } else {
                                MessageDialog.critical(null, (Object)CreateDialogArb.format("CONN_RENAME_CANNOT_CLOSE", ((DatabaseConnection)object).getConnectionName()), (String)CreateDialogArb.getString("CONN_RENAME_CANNOT_CLOSE_TITLE"), null);
                            }
                        }
                    }
                    finally {
                        connections.unlock(connection);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            object = dBObject.getObjectName();
            this.showPanel(Connections.getConnectionName((String)object), Connections.getStoreName((String)object));
        }
    }

    @Override
    public void setArgs(String string) {
    }
}

