/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.writers.ImportGenFile;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportGenerationOutputStream;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.PDFFormatter;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.SQLFormatterWrapper;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

public class ExportAPI {
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    public static final String SPACE = " ";
    protected static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private DatabaseQueryTask<Void> _task = null;
    private IRaptorTaskProgressUpdater _progressUpdater;
    private String _connName;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private TargetFormat _targetFormat;
    private DDLTypes _ddlType;
    private String _eol;
    private ExtractListModel _listModel;
    private ExtractLogger _eLogger;
    private boolean _showElog = true;
    private boolean _cancel;
    private boolean _cleanCloudNLS = false;
    private String badSetup;
    ResultsFormatter _formatter = null;
    ResultSet _rs;
    private boolean _isExportOwnedResultSet;
    private boolean _isGridResultSet;
    private ExportGenerationOutputStream _genOutputStream;
    private Map<String, HashMap<String, String>> nlsHashMap;

    private final String INIT_APEX_SQL() {
        return "declare\nsgid number := 0;\nappid number := wwv_flow_utilities.minimum_free_flow;\nbegin\nfor r in ( select workspace_id,schema from apex_workspace_schemas ) loop\nwwv_flow_application_install.set_workspace_id(r.workspace_id);\nwwv_flow_application_install.set_schema(r.schema);\nwwv_flow_application_install.set_image_prefix( wwv_flow_global.g_image_prefix );\nsgid := r.workspace_id;\nend loop;\nwwv_flow_application_install.set_application_id(appid);\nwwv_flow_api.set_security_group_id( sgid);\nwwv_flow_application_install.set_application_alias(appid);\nwwv_flow_application_install.generate_offset;\nend;\n/\n";
    }

    public ExportAPI() {
        this.setTerm();
    }

    public void setExtractListModel(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        this.setConnection(this._listModel.getSourceConnName());
        this._ddlFormat = this._listModel.getDDLFormat();
        this._dataFormat = this._listModel.getDataFormat();
        this._ddlType = this._listModel.getDDLTypes();
    }

    private void setConnection(String string) {
        this._connName = string;
    }

    public void setTargetFormat(TargetFormat targetFormat) {
        this._targetFormat = targetFormat;
    }

    public void setQuickDDL(ExtractListModel extractListModel, int n, String string) {
        try {
            this._listModel = extractListModel;
            DDLFormat dDLFormat = new DDLFormat();
            dDLFormat.isExtractEnabled(true);
            this._listModel.setDDLFormat(dDLFormat);
            DDLTypes dDLTypes = this._listModel.getDDLTypes();
            List<ExtractObject> list = this._listModel.getList(0, new int[]{107});
            dDLTypes.setTypes(list);
            this._listModel.setDDLTypes(dDLTypes);
            this.setExtractListModel(extractListModel);
            extractListModel.clearSelectExtractData();
            TargetFormat targetFormat = new TargetFormat(1, 1);
            targetFormat.isCompressed(false);
            targetFormat.setSaveAsType(n);
            if (n == 4) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_WORKSHEET"));
            } else if (n == 5) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_CLIPBOARD"));
            } else {
                targetFormat.setSaveAs(string);
            }
            this.setTargetFormat(targetFormat);
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
    }

    public void setDeploy(DbCartDeployOptions dbCartDeployOptions) {
        this._listModel = new ExtractListModel();
        this._listModel.setSelectedExtractObjects(dbCartDeployOptions.getSourceExtractObjectList());
        this._listModel.setSchemas();
        this.setExtractListModel(this._listModel);
        this._ddlFormat = dbCartDeployOptions.getDDLFormat();
        this._listModel.setDDLFormat(this._ddlFormat);
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        List<ExtractObject> list = this._listModel.getList(0, new int[]{100, 101});
        List<ExtractObject> list2 = ExtractListModel.getList(list, new int[]{107});
        dDLTypes.setTypes(list2);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        dDLTypes.setConstraint(this._ddlFormat.getConstraint());
        dDLTypes.setRefConstraint(this._ddlFormat.getRefConstraint());
        this._listModel.setDDLTypes(dDLTypes);
        this._dataFormat = dbCartDeployOptions.getDataFormat();
        this._dataFormat.isExportEnabled(dbCartDeployOptions.isIncludeData());
        this._listModel.setDataFormat(this._dataFormat);
        for (ExtractObject extractObject : dbCartDeployOptions.getSourceExtractObjectList()) {
            if (extractObject.isTypeDataFile() && (extractObject.isExtractMetaData() || extractObject.isExtractData())) {
                extractObject.getGenFile();
            }
            extractObject.setListModel(this._listModel);
        }
        this.setTargetFormat(dbCartDeployOptions.getTargetFormat());
        this._listModel.setReconcileType(ExtractReconciler.ReconcileType.OBJECTS);
        this._showElog = !this._targetFormat.isDeployCloud();
    }

    private void initELogger() {
        this._eLogger = this._showElog ? new ExtractLogger(ExtractMessagePage.EXTRACT_VIEW_ID) : new ExtractLogger(this.getELoggerName(), this._targetFormat.getEncoding());
        this._eLogger.logToolStart(this.getELoggerName());
        String string = this._targetFormat.getSaveAsType() < 4 ? this._targetFormat.getSaveAs() : this._targetFormat.getSaveAsTypeString();
        String string2 = ExportWizArb.format("UNLOADING2", this._targetFormat.getSaveAsTypeString(), string);
        this._eLogger.log(string2);
    }

    protected ExtractLogger getELogger() {
        return this._eLogger;
    }

    protected String getELoggerName() {
        return Messages.getString("EXPORT_TOOL");
    }

    protected ExtractDataFormat getDataFormat() {
        return this._dataFormat;
    }

    protected TargetFormat getTargetFormat() {
        return this._targetFormat;
    }

    public static String validateOptions(DDLFormat dDLFormat, ExtractDataFormat extractDataFormat, TargetFormat targetFormat, PDFFormatOptions pDFFormatOptions, Component component) {
        int n;
        int n2 = 0;
        String string = "";
        if ((targetFormat.getSaveAsType() == 0 || targetFormat.getSaveAsType() >= 4) && extractDataFormat.isExportEnabled() && dDLFormat.isExtractEnabled() && !extractDataFormat.isInsert()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat()};
            return ExportWizArb.format("SINGLE_FILE_NOT_SUPPORTED", objectArray);
        }
        if (targetFormat.getSaveAsType() == 0 && extractDataFormat.isExportEnabled() && extractDataFormat.isLoader() && extractDataFormat.isSeparateDataFile()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat(), ExportWizArb.getString("SEPARATE_DATA_FILE")};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT_WITH_OPT", objectArray);
        }
        if (targetFormat.isCompressed() && extractDataFormat.isExportEnabled() && ((ResultsFormatter)extractDataFormat.getFormatter()).isStreamHandler()) {
            Object[] objectArray = new Object[]{ExportWizArb.getString("COMPRESSED"), extractDataFormat.getFormat()};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", objectArray);
        }
        if (targetFormat.getSaveAsType() < 4) {
            n2 = targetFormat.validateSaveAs(component);
            if (n2 == 1) {
                return targetFormat.getValidationMessage();
            }
            if (n2 == 2) {
                return "";
            }
        } else if (extractDataFormat.isExportEnabled() && !extractDataFormat.isTextEditorReadable()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat()};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", objectArray);
        }
        ResultsFormatter resultsFormatter = (ResultsFormatter)extractDataFormat.getFormatter();
        if (!dDLFormat.isExtractEnabled() && extractDataFormat.isExportEnabled()) {
            targetFormat.setDataFormatExtension(resultsFormatter.getExt());
        }
        if (resultsFormatter instanceof PDFFormatter) {
            if (pDFFormatOptions == null) {
                pDFFormatOptions = new PDFConfig().getPDFPreferences();
            }
            ((PDFFormatter)resultsFormatter).setPDFFormatOptions(pDFFormatOptions);
        }
        if (resultsFormatter.isQuerySupported()) {
            resultsFormatter.setQueryName(extractDataFormat.getQueryName());
            resultsFormatter.isQuerySaved(extractDataFormat.isQuerySaved());
        }
        if (resultsFormatter.isDataNameSupported()) {
            resultsFormatter.setDataName(extractDataFormat.getDataName());
        }
        if (resultsFormatter.isCommitSupported()) {
            resultsFormatter.isCommit(extractDataFormat.isCommit());
            resultsFormatter.setCommitRows(extractDataFormat.getCommitRows());
        }
        if ((n = resultsFormatter.validateOptions()) != 0) {
            string = string + (string.length() == 0 ? resultsFormatter.getValidationMessage() : "\n\n" + resultsFormatter.getValidationMessage());
        }
        if (n2 != 0 || n != 0) {
            if (n2 == 1 || n == 1) {
                return string;
            }
            return "";
        }
        return null;
    }

    private boolean isExportDBObjects() {
        return this._listModel.isTypeDBO();
    }

    protected boolean isDeployPdbCloud() {
        return false;
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this._targetFormat.getSaveAs() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_FILE") + this.getTerm());
            bl = false;
        }
        if (this._targetFormat.getSaveAsType() == 4 || this._targetFormat.getSaveAsType() == 5) {
            this._targetFormat.isCompressed(false);
        }
        if (this.isExportDBObjects()) {
            if (this._ddlFormat == null) {
                stringBuilder.append(ExportWizArb.getString("NO_FORMAT") + this.getTerm());
                bl = false;
            }
            if (this._ddlType == null) {
                stringBuilder.append(ExportWizArb.getString("NO_TYPE") + this.getTerm());
                bl = false;
            }
        } else if (this._listModel == null || this._listModel.getFirstDataObject() == null || this._listModel.getFirstDataObject().getTable() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_DATA") + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    protected boolean isCancel() {
        return this._cancel;
    }

    protected ResultsFormatter getFormatter() {
        return this._formatter;
    }

    protected ExportGenerationOutputStream getGenOutputStream() {
        return this._genOutputStream;
    }

    protected ExtractListModel getListModel() {
        return this._listModel;
    }

    protected IRaptorTaskProgressUpdater getProgressUpdater() {
        return this._progressUpdater;
    }

    public void setTerm() {
        if (this._eol == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._eol = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
    }

    public String getTerm() {
        return this._eol;
    }

    protected void write(String string) throws IOException {
        this._genOutputStream.println(string);
    }

    public void cancelExport() {
        this._cancel = true;
    }

    private void exportMetaListAppend(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                String string = ExtractResources.getString("OPERATION_DDL") + SPACE + extractObject.getObjectType() + SPACE + extractObject.getTableName();
                this.taskProgress(string);
                if (!this._cancel) {
                    String string2 = this.getDDL(extractObject, n);
                    if (string2.length() <= 0) continue;
                    this.write(string2 + this.getTerm());
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.warn(ExportAPI.class, (Throwable)iOException);
            this.eLogException(iOException);
        }
    }

    private void exportMetaList(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                String string = ExtractResources.getString("OPERATION_DDL") + SPACE + extractObject.getObjectType() + SPACE + extractObject.getTableName();
                this.taskProgress(string);
                if (!this._cancel) {
                    String string2;
                    DBObject dBObject = extractObject.getDBObject();
                    String string3 = extractObject.getExternalTableName();
                    String string4 = extractObject.isTypeDataFile() ? "TABLE" : dBObject.getObjectType();
                    ExtractScript extractScript = null;
                    if (n == 2 || n == 3) {
                        extractScript = extractObject.getScript(110);
                    }
                    if (extractScript == null) {
                        this._genOutputStream.startObject(string3, string4);
                    } else {
                        this._genOutputStream.startObject(string3, string4, extractScript.getType(), extractScript.getPath());
                    }
                    if (this._targetFormat.isDeployCloud() && (string4.equals("APEX") || string4.equals("APEX_PAGE"))) {
                        this.write(this.INIT_APEX_SQL());
                    }
                    if ((string2 = this.getDDL(extractObject, n)).length() > 0) {
                        this.write(string2 + this.getTerm());
                    }
                    if (n == 2) {
                        this.exportScript(extractObject, 111);
                        continue;
                    }
                    if (n != 3) continue;
                    this.exportScript(extractObject, 111);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.warn(ExportAPI.class, (Throwable)iOException);
            this.eLogException(iOException);
        }
    }

    protected void exportDataList(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                String string = ExtractResources.getString("OPERATION_DATA") + SPACE + extractObject.getObjectType() + SPACE + extractObject.getTableName();
                this.taskProgress(string);
                if (this._cancel) break;
                DBObject dBObject = extractObject.getDBObject();
                String string2 = extractObject.getExternalTableName();
                String string3 = extractObject.isTypeDataFile() ? "TABLE" : dBObject.getObjectType();
                this.initDataExport(extractObject);
                ExtractScript extractScript = extractObject.getScript(112);
                if (extractScript == null) {
                    this._genOutputStream.startObject(string2, "DATA_" + string3);
                } else {
                    this._genOutputStream.startObject(string2, "DATA_" + string3, extractScript.getType(), extractScript.getPath());
                }
                if (!extractObject.isEmptySelect()) {
                    this.writeDataUsingFormatter(extractObject);
                }
                this.exportScript(extractObject, 113);
            }
            if (list.size() > 0) {
                this._formatter.finishExport();
            }
        }
        catch (IOException iOException) {
            Logger.warn(ExportAPI.class, (Throwable)iOException);
            this.eLogException(iOException);
        }
    }

    protected String getDDL(ExtractObject extractObject, int n) {
        return extractObject.getDDL(n).trim();
    }

    protected ExitCode start() {
        return ExitCode.EXIT_SUCCESS;
    }

    public String getTaskConnectionName() {
        return this._connName;
    }

    protected void finish() {
    }

    private void loadAndSetNls(List<ExtractObject> list) {
        this.nlsHashMap = new HashMap<String, HashMap<String, String>>();
        for (ExtractObject extractObject : list) {
            String string = extractObject.getSourceConnName();
            if (!this.nlsHashMap.containsKey(string)) {
                this.nlsHashMap.put(string, new HashMap());
                Map<String, String> map = this.getConNlsValues(string);
                map.put("NLS_LANGUAGE", this.getNlsValue(string, "NLS_LANGUAGE"));
                map.put("NLS_TERRITORY", this.getNlsValue(string, "NLS_TERRITORY"));
                map.put("NLS_CALENDAR", this.getNlsValue(string, "NLS_CALENDAR"));
            }
            this.setCloudNLS(string, "NLS_LANGUAGE", "AMERICAN");
            this.setCloudNLS(string, "NLS_TERRITORY", "AMERICA");
            this.setCloudNLS(string, "NLS_CALENDAR", "GREGORIAN");
        }
    }

    private Map<String, String> getConNlsValues(String string) {
        return this.nlsHashMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNlsValue(String string, String string2) {
        String string3 = "SELECT value FROM NLS_DATABASE_PARAMETERS where parameter = :PARAM";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("PARAM", string2);
        String string4 = null;
        boolean bl = false;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                string4 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string3, hashMap);
            }
        }
        catch (Exception exception) {
            Logger.severe(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string4;
    }

    private void unsetCloudNLS() {
        for (String string : this.nlsHashMap.keySet()) {
            Map<String, String> map = this.getConNlsValues(string);
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                this.setCloudNLS(string, string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCloudNLS(String string, String string2, String string3) {
        String string4 = "ALTER SESSION SET " + string2 + "=:VALUE";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("VALUE", string3);
        Connection connection = null;
        boolean bl = false;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                DBUtil.getInstance((Connection)connection).executeUpdate(string4, hashMap);
            }
        }
        catch (Exception exception) {
            Logger.severe(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void exportScript(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        for (ExtractObject extractObject : list) {
            String string = ExtractResources.getString("OPERATION_BUILD") + SPACE + ExtractListModel.getListTypeName(n) + SPACE + extractObject.getTableName();
            this.taskProgress(string);
            if (this._cancel) break;
            this.exportScript(extractObject, n == 9 ? 114 : 115);
        }
    }

    protected void exportScript(ExtractObject extractObject, int n) {
        ExtractScript extractScript = extractObject.getScript(n);
        if (extractScript != null) {
            try {
                DBObject dBObject = extractObject.getDBObject();
                String string = extractObject.getTableName();
                if (!extractObject.isTypeDataFile()) {
                    string = extractObject.getType() == 0 ? extractObject.getDBObject().getObjectName() : (n == 114 ? "INITIAL" : "FINAL");
                }
                this._genOutputStream.writeScript(string, extractScript.getType(), extractScript.getPath());
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
    }

    private void exportScriptList(int n, int n2) {
    }

    private void writeExportDBObjects() throws Exception {
        this.writeExportDBObjects(null);
    }

    private void writeExportDBObjects(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Object object;
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        dDLGenerator.setWriter(this._genOutputStream.getWriter());
        dDLGenerator.setFormating(this._ddlFormat);
        if (this._targetFormat.isGenDate()) {
            object = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
            Date date = new Date();
            String string = "--------------------------------------------------------" + this.getTerm() + Messages.getString("ExportAPI.157") + ((DateFormat)object).format(date) + "   " + this.getTerm() + "--------------------------------------------------------" + this.getTerm();
            if (this._targetFormat.getSaveAsType() == 0) {
                if (this._ddlFormat.isExtractEnabled() || this._dataFormat.isInsert()) {
                    this.write(string);
                }
            } else {
                this._genOutputStream.setControllingFileHeader(string);
            }
        }
        this.taskProgress();
        if (!this._cancel && !this._listModel.getReconcileType().isNone()) {
            if (this._listModel.getReconcileType().isTypesAndObjects()) {
                this._listModel.startProcess(iRaptorTaskProgressUpdater);
            } else {
                this._listModel.startProcessReconcileObjects(iRaptorTaskProgressUpdater);
            }
        }
        this.taskProgress("");
        if (!this._cancel) {
            this.exportScript(9);
        }
        if (!this._cancel && this._targetFormat.isDeployCloud()) {
            object = this._listModel.getList(0, new int[]{100, 8});
            this.loadAndSetNls((List<ExtractObject>)object);
            this._cleanCloudNLS = true;
        }
        this.taskProgress();
        if (!this._cancel && this._ddlFormat.isExtractEnabled() && this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("DROP", "DROP");
            this.exportMetaListAppend(4);
        }
        this.taskProgress();
        if (!this._cancel && this._ddlFormat.getDep()) {
            this._ddlType.setTypes(this._listModel.getList(0, new int[]{100}));
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(2, 110);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportMetaList(2);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(2, 111);
        }
        this.taskProgress();
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(7);
        }
        this.taskProgress();
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isTruncate() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("TRUNCATE", "TRUNCATE");
            this.exportMetaListAppend(5);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(0, 112);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportDataList(8);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(0, 113);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(3, 110);
        }
        if (!this._cancel) {
            this.exportMetaList(3);
        }
        this.taskProgress();
        this.taskProgress();
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(6);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScriptList(3, 111);
        }
        this.taskProgress();
        if (!this._cancel) {
            this.exportScript(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExportJTable(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Boolean bl = true;
        try {
            ExtractObject extractObject = this._listModel.getFirstDataObject();
            JTable jTable = null;
            jTable = !extractObject.isSqlExtendable() ? extractObject.getTable() : extractObject.getTable();
            if (bl.booleanValue()) {
                this.initDataExport();
                this._genOutputStream.startObject(extractObject.getTableName(), "DATA");
                if (extractObject.isEmptySelect()) {
                    return;
                }
                this._formatter.setOutWriter(this._genOutputStream.getWriter());
                this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
                this._formatter.setDbObject((Object)extractObject.getDBObject());
                this._formatter.setTableName(this._dataFormat.isTableNameVisible() ? this._dataFormat.getTableName() : extractObject.getTableName());
                if (jTable != null && !extractObject.isExcludedColumns()) {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)this.getDataProvider(jTable));
                } else if (extractObject.isSqlExtendable()) {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                } else {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                }
                this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
                this._formatter.doPrint(iRaptorTaskProgressUpdater);
                if (this._formatter.getResultsFormatterWrapper() != null) {
                    this.eLog(ExportWizArb.getString("EXPORTED_ROWS") + SPACE + this._formatter.getResultsFormatterWrapper().getRowNum() + "");
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                DBUtil.closeResultSet((ResultSet)this._rs);
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
    }

    public String deployDataObjectSave(ExtractObject extractObject) throws Exception {
        return this.deployDataObjectSave(extractObject, this._progressUpdater);
    }

    public String deployDataObjectSave(ExtractObject extractObject, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Object object;
        String string = null;
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        if (!this._cancel && this._targetFormat.isDeployCloud()) {
            object = new ArrayList<ExtractObject>();
            object.add(extractObject);
            this.loadAndSetNls((List<ExtractObject>)object);
            this._cleanCloudNLS = true;
        }
        this.taskProgress();
        try {
            this.taskProgress();
            object = extractObject.getDBObject();
            String string2 = extractObject.getExternalTableName();
            String string3 = extractObject.isTypeDataFile() ? "TABLE" : ((DBObject)object).getObjectType();
            this.initDataExport(extractObject);
            this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
            this._genOutputStream.endPreamble();
            this._genOutputStream.startObject(string2, string3);
            if (!extractObject.isEmptySelect()) {
                this.writeDataUsingFormatter(extractObject);
            }
            this._formatter.finishExport();
            try {
                if (this._cleanCloudNLS && this._targetFormat.isDeployCloud()) {
                    this.unsetCloudNLS();
                }
                DBUtil.closeResultSet((ResultSet)this._rs);
                if (this._targetFormat.getSaveAsType() == 4) {
                    string = this._genOutputStream.toString();
                }
                this._genOutputStream.finished();
                this._genOutputStream = null;
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
        catch (IOException iOException) {
            Logger.warn(ExportAPI.class, (Throwable)iOException);
            this.eLogException(iOException);
        }
        return string;
    }

    private void initDataExport() {
        this.initDataExport(null);
    }

    protected void initDataExport(ExtractObject extractObject) {
        this.initDataExport(extractObject, null);
    }

    protected void initDataExport(ExtractObject extractObject, ResultsFormatter resultsFormatter) {
        BaseDataFormat baseDataFormat = null;
        if (extractObject != null && extractObject.isTypeDataFile()) {
            this._formatter = resultsFormatter != null ? resultsFormatter : extractObject.getGenFile();
            baseDataFormat = (ImportDataFormat)extractObject.getImportProperties().get(ImportKeys.IMPORT_DATA_FORMAT);
        } else {
            this._formatter = resultsFormatter != null ? resultsFormatter : (ResultsFormatter)this._dataFormat.getFormatter();
            baseDataFormat = this._dataFormat;
        }
        this._formatter.startExport();
        this._formatter.isHeader(baseDataFormat.isHeader());
        this._formatter.setDelimiter(baseDataFormat.getDelimiterValue());
        this._formatter.setEnclosures(baseDataFormat.getEnclosures(), this._dataFormat.getEnclosureLeftValue(), this._dataFormat.getEnclosureRightValue(), this._dataFormat.isEnclosureRightDouble());
        this._formatter.setLineTerminator(baseDataFormat.getRecordTerminatorValue());
        this._formatter.setLineTerminatorString(BaseDataFormat.getRecordTerminatorString(baseDataFormat.getRecordTerminatorValue()));
        this._formatter.isSeparateDataFile(true);
        this._formatter.setEncode(this._targetFormat.getEncoding());
        this._dataFormat.setEncoding(this._targetFormat.getEncoding());
        this._formatter.isDeployCloud(this._targetFormat.isDeployCloud());
        this._targetFormat.setDataFormatExtension(this._formatter.getExt());
        this._genOutputStream.setFormatter(this._formatter);
        if (this._formatter instanceof ImportGenFile) {
            this._formatter.setDataName("");
            this._formatter.isQuerySaved(false);
            this._formatter.setQueryName("");
        } else {
            this._formatter.setDataName(this._dataFormat.getDataName());
            this._formatter.isQuerySaved(this._dataFormat.isQuerySaved());
            this._formatter.setQueryName(this._dataFormat.getQueryName());
        }
        if (this._formatter instanceof PDFFormatter) {
            PDFFormatOptions pDFFormatOptions = (PDFFormatOptions)this._listModel.getPropertyValue("REPORT_OPTIONS");
            if (pDFFormatOptions == null) {
                pDFFormatOptions = new PDFConfig().getPDFPreferences();
            } else {
                PDFFormatOptions pDFFormatOptions2 = new PDFConfig().getPDFPreferences();
                pDFFormatOptions.setFontLocations(pDFFormatOptions2.getFontLocations());
                pDFFormatOptions.setExternalLibrary(pDFFormatOptions2.getExternalLibrary());
            }
            ((PDFFormatter)this._formatter).setTempTitle(this._dataFormat.getTitle());
            ((PDFFormatter)this._formatter).setTempSubject(this._dataFormat.getSubject());
            ((PDFFormatter)this._formatter).setTempKeywords(this._dataFormat.getKeywords());
            ((PDFFormatter)this._formatter).setPDFFormatOptions(pDFFormatOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDataUsingFormatter(ExtractObject extractObject) throws FileNotFoundException {
        if (!this._targetFormat.isCompressed()) {
            this._formatter.setOutWriter(this._genOutputStream.getWriter());
            this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
        } else {
            this._formatter.setZipper(this._genOutputStream.getZipper());
        }
        JTable jTable = extractObject.getTable();
        try {
            this._isExportOwnedResultSet = false;
            if (jTable != null && !extractObject.isTableDirty() && !extractObject.isExcludedColumns()) {
                this._formatter.setDataProvider((IResultsFormatterWrapper)this.getDataProvider(jTable));
            } else if (!extractObject.getListModel().isSourceConnTimesTen()) {
                this._isExportOwnedResultSet = true;
                if (extractObject.getDBObject() != null) {
                    if (extractObject.isSqlExtendable()) {
                        this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSqlForVisibleCols() + extractObject.getFinalWhere(), extractObject.getBindMap()));
                    } else {
                        this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSql() + extractObject.getFinalWhere()));
                    }
                }
            }
            this._formatter.setDbObject((Object)extractObject.getDBObject());
            this._formatter.setTableName(extractObject.getTableName());
            this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
            this._formatter.doPrint(this._task != null ? this._task.getRaptorTaskProgressUpdater() : null);
            if (this._formatter.getResultsFormatterWrapper() != null) {
                this.eLog(ExportWizArb.getString("EXPORTED_ROWS") + SPACE + this._formatter.getResultsFormatterWrapper().getRowNum() + "");
            }
            ArrayList arrayList = this._formatter.getAddToControllingFile();
            for (String string : arrayList) {
                this._genOutputStream.addToControllingFile(string);
            }
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                DBUtil.closeResultSet((ResultSet)this._rs);
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
    }

    private ResultsFormatterWrapper getDataProvider(JTable jTable) throws Exception {
        boolean bl = false;
        if (jTable instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)jTable)).allRowsFetched();
        }
        if (!bl) {
            Connection connection = Connections.getInstance().getConnection(((ResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
            String string = ((ResultSetTableModel)((Object)jTable.getModel())).getModifiedSql();
            Map<String, ?> map = ((ResultSetTableModel)((Object)jTable.getModel())).getBindMap();
            List<?> list = ((ResultSetTableModel)((Object)jTable.getModel())).getBindList();
            this._rs = this.getClonedResultSetForTableSql(connection, string, map, list);
            TableModel tableModel = jTable.getModel();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableFormatterWrapper tableFormatterWrapper = new TableFormatterWrapper(jTable);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            int[] nArray = new int[tableFormatterWrapper.getColumnCount()];
            int[] nArray2 = new int[tableFormatterWrapper.getColumnCount()];
            IResultSetTableModel iResultSetTableModel = ExportAPI.getBaseModel(tableModel);
            for (int i = 0; i < tableFormatterWrapper.getColumnCount(); ++i) {
                int n2;
                n = n2 = tableColumnModel.getColumn(i).getModelIndex();
                arrayList.add(n);
                nArray[i] = tableFormatterWrapper.getColumnSize(i);
                arrayList2.add(tableFormatterWrapper.getColumnName(i));
                nArray2[i] = iResultSetTableModel != null ? iResultSetTableModel.getColumnSqlType(n2) : 0;
            }
            this._isExportOwnedResultSet = true;
            return new ResultSetFormatterWrapper(this._rs, arrayList, arrayList2, nArray, nArray2, string);
        }
        return new TableFormatterWrapper(jTable);
    }

    private static IResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof IResultSetTableModel ? (IResultSetTableModel)((Object)tableModel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getClonedResultSetForTableSql(Connection connection, String string, Map<String, ?> map, List<?> list) {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                resultSet = map != null ? DBUtil.getInstance((Connection)connection).executeQuery(string, map) : DBUtil.getInstance((Connection)connection).executeQuery(string, list);
            }
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return resultSet;
    }

    public void writeExportHeadless() {
        if (this._showElog) {
            this.initELogger();
        }
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        try {
            this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
            this._genOutputStream.endPreamble();
            if (!this.checkSetup()) {
                this.write(this.badSetup);
            }
            this.writeExportDBObjects();
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        finally {
            try {
                DBUtil.closeResultSet((ResultSet)this._rs);
                this._genOutputStream.finished();
                if (this._targetFormat.isSftp()) {
                    SftpUtil sftpUtil = new SftpUtil();
                    sftpUtil.SftpPut(this._targetFormat.getSftpParms(), true);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeExportWithDialog() {
        this.initELogger();
        boolean bl = false;
        ExtractObject extractObject = this._listModel.getFirstDataObject();
        if (extractObject != null && extractObject.getTable() != null && extractObject.getTable() instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)extractObject.getTable())).allRowsFetched();
        }
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        if (this.isDeployPdbCloud()) {
            iRaptorTaskRunMode = IRaptorTaskRunMode.TASKVIEWER;
        } else if (!this.isExportDBObjects()) {
            iRaptorTaskRunMode = this._targetFormat.getSaveAsType() == 0 && !bl ? IRaptorTaskRunMode.IDE_STATUSBAR : IRaptorTaskRunMode.MODAL;
        }
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        String string = this._targetFormat.getSaveAsType() < 4 ? this._targetFormat.getSaveAs() : this._targetFormat.getSaveAsTypeString();
        String string2 = ExportWizArb.format("UNLOADING", string);
        this._cancel = false;
        this._task = new DatabaseQueryTask<Void>(string2, iRaptorTaskRunMode, false, true){

            public Void doWork() {
                if (ExportAPI.this.start() == ExitCode.EXIT_SUCCESS) {
                    try {
                        ExportAPI.this._progressUpdater = this.getRaptorTaskProgressUpdater();
                        ExportAPI.this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
                        ExportAPI.this._genOutputStream.endPreamble();
                        if (!ExportAPI.this.checkSetup()) {
                            ExportAPI.this.write(ExportAPI.this.badSetup);
                        }
                        if (!ExportAPI.this._targetFormat.getSaveAs().equals("")) {
                            if (ExportAPI.this.isExportDBObjects()) {
                                ExportAPI.this.writeExportDBObjects(this.getRaptorTaskProgressUpdater());
                            } else {
                                ExportAPI.this.writeExportJTable(this.getRaptorTaskProgressUpdater());
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.warn(ExportAPI.class, (Throwable)exception);
                        ExportAPI.this.eLogException(exception);
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                    finally {
                        try {
                            if (ExportAPI.this._cleanCloudNLS && ExportAPI.this._targetFormat.isDeployCloud()) {
                                ExportAPI.this.unsetCloudNLS();
                            }
                            DBUtil.closeResultSet((ResultSet)ExportAPI.this._rs);
                            ExportAPI.this._genOutputStream.finished();
                            ExportAPI.this.finish();
                        }
                        catch (Exception exception) {
                            Logger.warn(ExportAPI.class, (Throwable)exception);
                            ExportAPI.this.eLogException(exception);
                            ExceptionHandler.handleException((Throwable)exception);
                        }
                    }
                }
                return null;
            }

            public boolean cancel() {
                ExportAPI.this._cancel = true;
                return true;
            }

            @Override
            public String getConnectionName() {
                return ExportAPI.this.getTaskConnectionName();
            }

            @Override
            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    Object object;
                    ExportAPI.this.taskFinishedProcess();
                    try {
                        ExportAPI.this.eLogHref(ExportAPI.this._targetFormat.getSaveAsURL());
                    }
                    catch (Exception exception) {
                        Logger.warn(ExportAPI.class, (Throwable)exception);
                        ExportAPI.this.eLogException(exception);
                    }
                    if ((ExportAPI.this._targetFormat.isMultipleFiles() || ExportAPI.this._targetFormat.isTypeFiles() || ExportAPI.this._targetFormat.isSeparateDirs()) && (object = ExportAPI.this._targetFormat.getControllingURL()) != null) {
                        try {
                            ExportAPI.this.eLogHref(ExportAPI.this._targetFormat.getControllingURL());
                        }
                        catch (Exception exception) {
                            Logger.warn(ExportAPI.class, (Throwable)exception);
                            ExportAPI.this.eLogException(exception);
                        }
                    }
                    ExportAPI.this.eLogToolEnd();
                    if (!ExportAPI.this._targetFormat.isSftp()) {
                        if (ExportAPI.this._genOutputStream != null) {
                            ExportAPI.this._genOutputStream.openTargetInUI(ExportAPI.this._connName);
                        }
                    } else {
                        object = new SftpUtil();
                        boolean bl = ((SftpUtil)object).SftpPut(ExportAPI.this._targetFormat.getSftpParms(), true);
                        if (!bl) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportWizArb.getString("FTP_ERROR_MSG"), ExportWizArb.getString("FTP_ERROR_TITLE"), 0);
                        }
                    }
                    if (ExportAPI.this._showElog) {
                        ExportAPI.this.showELog();
                    }
                }
                catch (Exception exception) {
                    Logger.warn(ExportAPI.class, (Throwable)exception);
                }
                finally {
                    ExportAPI.this._task = null;
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                ExportAPI.this._cancel = true;
                ExportAPI.this.taskCancelledProcess();
                ExportAPI.this.eLog(ExportWizArb.getString("EXPORT_CANCEL"));
                ExportAPI.this.eLogToolEnd();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                ExportAPI.this._cancel = true;
                ExportAPI.this.taskFailedProcess();
                ExportAPI.this.eLog(ExportWizArb.getString("EXPORT_FAILED"));
                ExportAPI.this.eLogToolEnd();
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    protected void postTaskProcess() {
        this._task = null;
    }

    protected void taskFinishedProcess() {
    }

    protected void taskCancelledProcess() {
    }

    protected void taskFailedProcess() {
    }

    private void showELog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ExportAPI.this.getELogger() != null) {
                    ExportAPI.this.getELogger().closeLog();
                }
            }
        });
    }

    protected DatabaseQueryTask<Void> getTask() {
        return this._task;
    }

    protected void setTask(DatabaseQueryTask<Void> databaseQueryTask) {
        this._task = databaseQueryTask;
    }

    protected void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this._task != null) {
            raptorTaskDescriptor = this._task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    protected boolean taskProgress() {
        return this.taskProgress(null);
    }

    protected boolean taskProgress(String string) {
        if (this._progressUpdater != null) {
            try {
                this._progressUpdater.checkCanProceed();
            }
            catch (ExecutionException executionException) {
                this._cancel = true;
                return false;
            }
            if (string != null) {
                this._progressUpdater.getDescriptor().setMessage(string);
                if (!string.isEmpty()) {
                    this.eLog(string);
                }
            }
        }
        return true;
    }

    protected void eLog(String string) {
        if (this._eLogger != null) {
            this._eLogger.log(string);
        }
    }

    protected void eLogException(Exception exception) {
        if (exception != null && this._eLogger != null) {
            this._eLogger.logException(exception);
        }
    }

    protected void eLogHref(URL uRL) {
        if (uRL != null && this._eLogger != null) {
            this._eLogger.logHref(uRL);
        }
    }

    protected void eLogToolEnd() {
        if (this._eLogger != null) {
            this._eLogger.logToolEnd();
        }
    }
}

