/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.extract.DbmsCloudResources;
import oracle.dbtools.raptor.extract.DeployQuery;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;

public class DbmsCloudAPI {
    private static final String CLOSEP = ")";
    private static final String COMMA = ",";
    private static final String COPY_DATA = "copy_data";
    private static final String CREDENTIAL_NAME = "credential_name => ";
    private static final String DBMS_CLOUD_OWNER = "C##CLOUD$SERVICE";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String DOT = ".";
    private static final String EXT_TAB = "create_external_table";
    private static final String FILE_URI_LIST = "file_uri_list => ";
    private static final String NL = "\n";
    private static final String OPENP = "(";
    private static final String SINGLEQ = "'";
    private static final String SPACE = " ";
    private static final String TABLE_NAME = "table_name => ";
    Connection _conn;
    String _connName;
    String _connUser;
    String _schema;
    boolean _isConnLocked = false;
    ExitCode _exitCode;
    ExtractLogger _eLogger;
    BigDecimal _operationId;
    String _spacing = "\n";
    public static String COPY_DATA_PREFIX = "C##CLOUD$SERVICE.dbms_cloud.copy_data(\n";
    public static String COPY_DATA_PROC1 = "declare  PROCEDURE copy_data (operation_id OUT NOCOPY NUMBER, err_msg OUT NOCOPY VARCHAR2) IS  BEGIN \n";
    public static String COPY_DATA_PROC2 = "; \nEXCEPTION WHEN OTHERS THEN    FOR err_depth IN 1..UTL_CALL_STACK.ERROR_DEPTH LOOP       err_msg := err_msg || UTL_CALL_STACK.ERROR_MSG (err_depth) || ' ';    END LOOP; end; BEGIN \n   copy_data(OPERATION_ID => ?, ERR_MSG => ?);\nend; \n";
    public static String EXT_TABLE_PREFIX = "C##CLOUD$SERVICE.dbms_cloud.create_external_table(\n";
    public static final String dbms_cloudCreateExternalTablePrefix = "{call ";
    public static final String dbms_cloudCreateExternalTableSuffix = " }";
    private static String VALIDATE_EXTERNAL_TABLE = "declare  PROCEDURE validate_external_table (table_name IN VARCHAR2,operation_id OUT NOCOPY NUMBER,err_msg OUT NOCOPY VARCHAR2, schema_name IN VARCHAR2, row_count IN NUMBER) IS  BEGIN    DBMS_CLOUD.validate_external_table(    table_name      => table_name,    operation_id\t=> operation_id,    schema_name\t    => schema_name,    rowCount\t    => row_count,    STOP_ON_ERROR \t=> false); EXCEPTION WHEN OTHERS THEN    FOR err_depth IN 1..UTL_CALL_STACK.ERROR_DEPTH LOOP       err_msg := err_msg || UTL_CALL_STACK.ERROR_MSG (err_depth) || ' ';    END LOOP; end; BEGIN    validate_external_table(TABLE_NAME => ?, OPERATION_ID => ?, ERR_MSG => ?, SCHEMA_NAME => ?, ROW_COUNT => ?); end; ";
    public static final String dbms_cloudGetValidateLog = "select record from ";
    public static final String dbms_cloudGetValidateBadCount = "select count(*) from ";
    public static final String dbms_cloudGetValidateBad = "select record from ";
    public static final String dbms_cloudGetCloudTabCount1 = "select count(*) from ";
    public static final String dbms_cloudGetCloudTabCount2 = " where rownum = ";
    public static final String dbms_cloudGetXTabRows1 = "select count(*) from ";
    public static final String dbms_cloudGetXTabRows2 = " where rownum = 1";
    public static final String dbms_cloudPutObjectBlob = "{call C##CLOUD$SERVICE.DBMS_CLOUD.PUT_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?,CONTENTS => ?,COMPRESSION => ?)}";
    public static final String dbms_cloudPutObject = "{call C##CLOUD$SERVICE.DBMS_CLOUD.PUT_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?, DIRECTORY_NAME => ?, FILE_NAME => ?)}";
    public static final String dbms_cloudDeleteSingleObject = "{call C##CLOUD$SERVICE.DBMS_CLOUD.DELETE_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?)}";
    public static final String dbms_cloudDeleteOperation = "{call C##CLOUD$SERVICE.DBMS_CLOUD.DELETE_OPERATION(ID => ?)}";
    public static final String dropTable = "drop table ";

    public DbmsCloudAPI(String string, ExtractLogger extractLogger) {
        this._connName = string;
        this._eLogger = extractLogger;
    }

    public DbmsCloudAPI(ExtractLogger extractLogger) {
        this._eLogger = extractLogger;
    }

    public void isConnLocked(boolean bl) {
        this._isConnLocked = bl;
    }

    public void setELogger(ExtractLogger extractLogger) {
        this._eLogger = extractLogger;
    }

    public ExitCode startService(String string) {
        this._connName = string;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        String string2 = this.validateConnection();
        if (!string2.isEmpty()) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + string2);
            this.setExitCode(exitCode);
        }
        return this.getExitCode();
    }

    public ExitCode startService(Connection connection) {
        this._conn = connection;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        return this.getExitCode();
    }

    public void finishService() {
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getConnectionUser() {
        return this._connUser;
    }

    public void setSchema(String string) {
        this._schema = string;
    }

    public void setSqlSpacing(String string) {
        this._spacing = string;
    }

    public void setStream(ExtractLogger extractLogger) {
        this._eLogger = extractLogger;
    }

    public String getCopyDataStatement(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COPY_DATA_PREFIX);
        stringBuffer.append(this.getCopyDataParms(string, string2, string3, string4, string5, string6));
        return stringBuffer.toString();
    }

    public String getCopyDataProcedure(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COPY_DATA_PROC1);
        stringBuffer.append(COPY_DATA_PREFIX);
        stringBuffer.append(this.getCopyDataParms(string, string2, string3, string4, string5, string6));
        stringBuffer.append(COPY_DATA_PROC2);
        return stringBuffer.toString();
    }

    public String getCopyDataParms(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TABLE_NAME);
        stringBuffer.append(SINGLEQ + string + SINGLEQ);
        stringBuffer.append(COMMA + this._spacing);
        this.appendCredential(stringBuffer, string2);
        this.appendFileUri(stringBuffer, string3);
        this.appendOperationId(stringBuffer);
        this.appendSchemaName(stringBuffer, string4);
        this.appendFields(stringBuffer, string5);
        this.appendFormat(stringBuffer, string6);
        stringBuffer.append(CLOSEP);
        return stringBuffer.toString();
    }

    public BigDecimal getLastOperationId() {
        return this._operationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal doCopy(String string) throws SQLException {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        String string2 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")));
        this.eLog(string);
        this._operationId = null;
        String string3 = null;
        Statement statement = null;
        if (this.lock()) {
            try {
                statement = this._conn.prepareCall(string.toString());
                statement.registerOutParameter(1, 2);
                statement.registerOutParameter(2, 12);
                statement.execute();
                this._operationId = statement.getBigDecimal(1);
                this.eLog("Returned: OPERATION_ID => " + this._operationId);
                string3 = statement.getString(2);
                if (string3 != null) {
                    exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string2 = this.getExitCode().getShortMessage() + string3;
                    exitCode.setMessage(string2);
                    this.setExitCode(exitCode);
                    this.eLog(string2);
                    this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")) + NL);
                    throw new SQLException(string2);
                }
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string2);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")) + NL);
        return this._operationId;
    }

    public String getExtCreateTableStatement(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EXT_TABLE_PREFIX);
        stringBuffer.append(this.getExtCreateTableParms(string, string2, string3, string4, string5, string6));
        return stringBuffer.toString();
    }

    public String getExtCreateTableParms(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendQSchemaTableName(stringBuffer, string);
        this.appendCredential(stringBuffer, string2);
        this.appendFileUri(stringBuffer, string3);
        this.appendColumns(stringBuffer, string5);
        this.appendFormat(stringBuffer, string6);
        stringBuffer.append(CLOSEP);
        return stringBuffer.toString();
    }

    public void createExternalTable(String string) throws SQLException {
        String string2 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")));
        Statement statement = null;
        if (this.lock()) {
            try {
                statement = this._conn.prepareCall(dbms_cloudCreateExternalTablePrefix + string + dbms_cloudCreateExternalTableSuffix);
                this.eLog(dbms_cloudCreateExternalTablePrefix + string + dbms_cloudCreateExternalTableSuffix);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string2 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")) + NL);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string2);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")) + NL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal validateExternalTable(String string, String string2, BigDecimal bigDecimal) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")));
        BigDecimal bigDecimal2 = null;
        String string4 = null;
        Statement statement = null;
        if (this.lock()) {
            try {
                statement = this._conn.prepareCall(VALIDATE_EXTERNAL_TABLE);
                this.eLog(VALIDATE_EXTERNAL_TABLE);
                if (bigDecimal == null || bigDecimal.equals(new BigDecimal(-1))) {
                    statement.setBigDecimal(5, new BigDecimal(0));
                    this.eLog("ROWCOUNT => 0");
                } else {
                    statement.setBigDecimal(5, bigDecimal);
                    this.eLog("ROWCOUNT => " + bigDecimal);
                }
                statement.setString(1, string);
                statement.registerOutParameter(2, 2);
                statement.registerOutParameter(3, 12);
                statement.setString(4, string2);
                this.eLog("\nTABLE_NAME => " + string);
                this.eLog("SCHEMA_NAME => " + string2);
                statement.execute();
                bigDecimal2 = statement.getBigDecimal(2);
                this.eLog("\nReturned: OPERATION_ID => " + bigDecimal2);
                string4 = statement.getString(3);
                if (string4 != null) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string3 = this.getExitCode().getShortMessage() + string4;
                    this.setExitCode(exitCode);
                    this.eLog(string3);
                    this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")) + NL);
                    BigDecimal bigDecimal3 = bigDecimal2;
                    return bigDecimal3;
                }
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")) + NL);
        return bigDecimal2;
    }

    public boolean logXTabLog(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        return this.logXTabLog(null, string, arrayList, arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logXTabLog(String string, String string2, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")));
        boolean bl = false;
        ResultSet resultSet = null;
        if (this.lock()) {
            block16: {
                try {
                    String string4 = string2;
                    String string5 = null;
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
                    String string6 = "select record from " + string4;
                    this.eLog(string6);
                    resultSet = dBUtil.executeQuery(string6, Collections.EMPTY_MAP);
                    int n = -1;
                    if (resultSet == null) break block16;
                    while (resultSet.next()) {
                        bl = true;
                        string5 = resultSet.getString(1);
                        if (string5 == null) {
                            string5 = SPACE;
                        } else {
                            String string7;
                            String string8 = string5;
                            while (string8.length() > 4) {
                                n = string5.indexOf(".bad");
                                if (n != -1) {
                                    string7 = this.getFileNameFromLog(string8.substring(0, n + 4));
                                    if (!string7.isEmpty()) {
                                        arrayList.add(string7);
                                    }
                                    string8 = string8.substring(n + 4, string8.length());
                                    continue;
                                }
                                string8 = "";
                            }
                            string8 = string5;
                            while (string8.length() > 4) {
                                n = string5.indexOf(".log");
                                if (n != -1) {
                                    string7 = this.getFileNameFromLog(string8.substring(0, n + 4));
                                    if (!string7.isEmpty()) {
                                        arrayList2.add(string7);
                                    }
                                    string8 = string8.substring(n + 4, string8.length());
                                    continue;
                                }
                                string8 = "";
                            }
                        }
                        this.eLog(string5);
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl2;
                    try {
                        ExitCode exitCode = ExitCode.EXIT_WARNING;
                        exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                        string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                        this.setExitCode(exitCode);
                        this.eLogException(sQLException);
                        if (!bl) {
                            this.eLog(DbmsCloudResources.getString("DBMS_CLOUD_LOG_NO_ROWS"));
                        }
                        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")) + NL);
                        bl2 = bl;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        this.unlock();
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    this.unlock();
                    return bl2;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            this.unlock();
        }
        if (!bl) {
            this.eLog(DbmsCloudResources.getString("DBMS_CLOUD_LOG_NO_ROWS"));
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")) + NL);
        return bl;
    }

    public boolean logXTabBad(String string) {
        return this.logXTabBad(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logXTabBad(String string, String string2) {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_LOG_BAD")));
        String string4 = string2;
        String string5 = null;
        if (this.lock()) {
            try {
                string5 = DBUtil.getInstance((Connection)this._conn).executeReturnOneCol("select count(*) from " + string4, Collections.EMPTY_MAP);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", string4, string5));
            }
            finally {
                this.unlock();
            }
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_LOG_BAD")) + NL);
        return Float.valueOf(string5).floatValue() > 0.0f;
    }

    public String getCountCloudTab(String string) {
        return this.getCountCloudTab(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountCloudTab(String string, String string2) {
        String string3;
        String string4 = null;
        String string5 = string3 = string2 == null ? "" : dbms_cloudGetCloudTabCount2 + string2;
        if (this.lock()) {
            try {
                string4 = DBUtil.getInstance((Connection)this._conn).executeReturnOneCol("select count(*) from " + string + string3, Collections.EMPTY_MAP);
            }
            finally {
                this.unlock();
            }
        }
        return string4;
    }

    public boolean isDataRows(String string) {
        String string2 = "0";
        if (this.lock()) {
            try {
                string2 = DBUtil.getInstance((Connection)this._conn).executeReturnOneCol("select count(*) from " + this.addUser(string) + dbms_cloudGetXTabRows2, Collections.EMPTY_MAP);
            }
            finally {
                this.unlock();
            }
        }
        return string2 != null ? string2.equals("1") : false;
    }

    public void putObject(String string, String string2, InputStream inputStream) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_DATA")));
        Statement statement = null;
        if (this.lock()) {
            try {
                this.eLog(dbms_cloudPutObjectBlob);
                this.eLog(dbms_cloudPutObjectBlob);
                this.eLog("CREDENTIAL_NAME => " + string);
                this.eLog("OBJECT_URI => " + string2);
                statement = this._conn.prepareCall(dbms_cloudPutObjectBlob);
                statement.setString(1, string);
                statement.setString(2, string2);
                statement.setBlob(3, inputStream);
                statement.setString(4, null);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_DATA")) + NL);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_DATA")) + NL);
    }

    public String putObject(String string, String string2, ArrayList<String> arrayList, boolean bl) throws SQLException {
        String string3 = "";
        String string4 = "";
        String string5 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")));
        if (arrayList == null || arrayList.isEmpty()) {
            return string3;
        }
        int n = string2.lastIndexOf("/");
        String string6 = n < 0 ? string2 : string2.substring(0, n);
        Statement statement = null;
        for (String string7 : arrayList) {
            int n2 = string7.indexOf("_");
            if (n2 == -1) continue;
            if (this.lock()) {
                try {
                    if (this._eLogger != null) {
                        this.eLog(dbms_cloudPutObject);
                        this.eLog("CREDENTIAL_NAME => " + string);
                        this.eLog("OBJECT_URI => " + string6 + "/" + string7);
                        this.eLog("DIRECTORY_NAME => DATA_PUMP_DIR");
                        this.eLog("FILE_NAME => " + string7);
                    }
                    statement = this._conn.prepareCall(dbms_cloudPutObject);
                    statement.setString(1, string);
                    statement.setString(2, string6 + "/" + string7);
                    statement.setString(3, "DATA_PUMP_DIR");
                    statement.setString(4, string7);
                    statement.execute();
                    string3 = string3 + string4 + string6 + "/" + string7;
                }
                catch (SQLException sQLException) {
                    ExitCode exitCode = ExitCode.EXIT_WARNING;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string5 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                    this.setExitCode(exitCode);
                    this.eLogException(sQLException);
                    this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")) + NL);
                    throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
                }
                finally {
                    statement.close();
                    this.unlock();
                }
            }
            if (!bl) continue;
            this.eLog(DbmsCloudResources.format("DBMS_CLOUD_COPY_BAD_ADVICE", string6 + "/" + arrayList.get(0)));
        }
        this.eLog(string5);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")) + NL);
        return string3;
    }

    public void deleteObject(String string, String string2, ArrayList<String> arrayList) throws SQLException {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        int n = string2.lastIndexOf("/");
        String string3 = string2.substring(0, n);
        for (String string4 : arrayList) {
            int n2 = string4.indexOf("_");
            if (n2 == -1) continue;
            this.deleteObject(string, string3 + "/" + string4);
        }
    }

    public void deleteObject(String string, String string2) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DELETE_OBJECT")));
        Statement statement = null;
        if (this.lock()) {
            try {
                this.eLog(dbms_cloudDeleteSingleObject);
                this.eLog("CREDENTIAL_NAME => " + string);
                this.eLog("OBJECT_URI => " + string2);
                statement = this._conn.prepareCall(dbms_cloudDeleteSingleObject);
                statement.setString(1, string);
                statement.setString(2, string2);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_WARNING;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DELETE_OBJECT")) + NL);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DELETE_OBJECT")) + NL);
    }

    public void deleteOperation(BigDecimal bigDecimal) throws SQLException {
        String string = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")));
        Statement statement = null;
        if (this.lock()) {
            try {
                statement = this._conn.prepareCall(dbms_cloudDeleteOperation);
                this.eLog(dbms_cloudDeleteOperation);
                statement.setBigDecimal(1, bigDecimal);
                this.eLog("OPERATION_ID => " + bigDecimal);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")) + NL);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
        this.eLog(string);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")) + NL);
    }

    public boolean dropTable(String string, String string2) {
        return this.dropTable(string, string2, true);
    }

    public boolean dropTable(String string, String string2, boolean bl) {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        String string4 = DbmsCloudResources.format("DBMS_CLOUD_STEP_DROP_TABLE", string2 != null ? string2 : "");
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", string4));
        String string5 = dropTable + this.addUser(string);
        this.eLog(string5);
        boolean bl2 = this.pstmtExec(string5);
        if (!bl2) {
            this.getExitCode().setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            string3 = this.getExitCode().getShortMessage() + this.getExitCode().getMessage();
            this.eLog(string3);
            this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", string4 + NL));
            return false;
        }
        this.eLog(string3);
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", string4 + NL));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pstmtExec(String string) {
        if (this.lock()) {
            try {
                PreparedStatement preparedStatement = this._conn.prepareStatement(string);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                Logger.warn(DbmsCloudAPI.class, (Throwable)sQLException);
                this._exitCode = ExitCode.EXIT_ERROR;
                this._exitCode.setMessage(string + SPACE + sQLException.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSdDeploy(String string, String string2, String string3, BigDecimal bigDecimal, String string4, String string5, String string6) throws SQLException {
        String string7 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string8 = DeployQuery.getQuery("insert_sd_deploy", this._conn);
        hashMap.put("DEPLOY_NAME", string);
        hashMap.put("STATUS", "EXECUTING");
        hashMap.put("START_TIME", timestamp);
        hashMap.put("FILE_LOCATION", string2);
        hashMap.put("DEPLOYMENT_TYPE", string3);
        hashMap.put("DEPLOY_SCHEMA", string4);
        hashMap.put("CLOUD_STORAGE_LOCATION", string5);
        hashMap.put("CLOUD_STORAGE_CREDENTIAL", string6);
        hashMap.put("REQUESTED_BY", this._connUser);
        if (this.lock()) {
            try {
                dBUtil.executeUpdate(string8, hashMap);
            }
            finally {
                this.unlock();
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string7 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                    this.setExitCode(exitCode);
                    this.eLogException(sQLException);
                    throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSdDeploy(String string, String string2) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string4 = DeployQuery.getQuery("update_sd_deploy", this._conn);
        hashMap.put("DEPLOY_NAME", string);
        hashMap.put("STATUS", string2);
        hashMap.put("STOP_TIME", timestamp);
        if (this.lock()) {
            try {
                dBUtil.executeUpdate(string4, hashMap);
            }
            finally {
                this.unlock();
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                    this.setExitCode(exitCode);
                    this.eLogException(sQLException);
                    throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSdDeployOperation(String string, int n, String string2, String string3) throws SQLException {
        String string4 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string5 = DeployQuery.getQuery("insert_sd_deploy_operation", this._conn);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        hashMap.put("DEPLOY_NAME", string);
        hashMap.put("OPERATION_NUMBER", new Integer(n));
        hashMap.put("OPERATION_FILE_NAME", string2);
        hashMap.put("STATUS", "EXECUTING");
        hashMap.put("START_TIME", timestamp);
        hashMap.put("OPERATION_TYPE", string3);
        if (this.lock()) {
            try {
                dBUtil.executeUpdate(string5, hashMap);
            }
            finally {
                this.unlock();
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    string4 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                    this.setExitCode(exitCode);
                    this.eLogException(sQLException);
                    throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
                }
            }
        }
    }

    public void updateSdDeployOperation(String string, int n, String string2, String string3, BigDecimal bigDecimal, String string4, String string5, String string6) throws SQLException {
        String string7 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        Statement statement = null;
        if (this.lock()) {
            try {
                String string8 = DeployQuery.getQuery("update_sd_deploy_operation", this._conn);
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                statement = this._conn.prepareCall(string8);
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));){
                    statement.setClob(2, bufferedReader);
                }
                catch (Exception exception) {
                    statement.setNull(2, 2005);
                }
                statement.setString(1, string2);
                statement.setString(3, string5);
                statement.setString(4, string6);
                statement.setTimestamp(5, timestamp);
                statement.setBigDecimal(6, bigDecimal);
                statement.setString(7, string4);
                statement.setString(8, string);
                statement.setInt(9, n);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string7 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
    }

    public void updateSdDeployOperationBadFiles(String string, int n, String string2) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        Statement statement = null;
        if (this.lock()) {
            try {
                String string4 = DeployQuery.getQuery("update_sd_deploy_operation_bad", this._conn);
                statement = this._conn.prepareCall(string4);
                statement.setString(1, string2);
                statement.setString(2, string);
                statement.setInt(3, n);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
    }

    public void updateSdDeployOperationPreview(String string, int n, String string2) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        Statement statement = null;
        if (this.lock()) {
            try {
                String string4 = DeployQuery.getQuery("update_sd_deploy_operation_preview", this._conn);
                statement = this._conn.prepareCall(string4);
                statement.setString(1, string2);
                statement.setString(2, string);
                statement.setInt(3, n);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
    }

    public void updateSdDeployOperationLogFiles(String string, int n, String string2) throws SQLException {
        String string3 = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        Statement statement = null;
        if (this.lock()) {
            try {
                String string4 = DeployQuery.getQuery("update_sd_deploy_operation_log", this._conn);
                statement = this._conn.prepareCall(string4);
                statement.setString(1, string2);
                statement.setString(2, string);
                statement.setInt(3, n);
                statement.execute();
            }
            catch (SQLException sQLException) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                string3 = this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.eLogException(sQLException);
                throw new SQLException(sQLException.getLocalizedMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            finally {
                statement.close();
                this.unlock();
            }
        }
    }

    public String addUser(String string) {
        return string.contains(DOT) ? string : DBUtil.addDoubleQuote((String)this._schema) + DOT + string;
    }

    private void appendQSchemaTableName(StringBuffer stringBuffer, String string) {
        stringBuffer.append(TABLE_NAME);
        stringBuffer.append(this.getQSchemaTableName(string));
        stringBuffer.append(COMMA + this._spacing);
    }

    private String getQSchemaTableName(String string) {
        return SINGLEQ + string + SINGLEQ;
    }

    private void appendCredential(StringBuffer stringBuffer, String string) {
        stringBuffer.append(CREDENTIAL_NAME);
        stringBuffer.append(SINGLEQ + string + SINGLEQ);
        stringBuffer.append(COMMA + this._spacing);
    }

    private void appendFileUri(StringBuffer stringBuffer, String string) {
        stringBuffer.append(FILE_URI_LIST);
        stringBuffer.append(SINGLEQ + string + SINGLEQ);
        stringBuffer.append(COMMA + this._spacing);
    }

    private void appendOperationId(StringBuffer stringBuffer) {
        stringBuffer.append("operation_id => operation_id");
        stringBuffer.append(COMMA + this._spacing);
    }

    private void appendSchemaName(StringBuffer stringBuffer, String string) {
        stringBuffer.append("schema_name => ");
        stringBuffer.append(SINGLEQ + string + SINGLEQ);
        stringBuffer.append(COMMA + this._spacing);
    }

    private void appendFields(StringBuffer stringBuffer, String string) {
        if (string != null && !string.isEmpty()) {
            stringBuffer.append("field_list => '" + string);
            stringBuffer.append("'," + this._spacing);
        }
    }

    private void appendColumns(StringBuffer stringBuffer, String string) {
        if (string != null && !string.isEmpty()) {
            stringBuffer.append("column_list => '" + string);
            stringBuffer.append("'," + this._spacing);
        }
    }

    private void appendFormat(StringBuffer stringBuffer, String string) {
        stringBuffer.append("format => ");
        stringBuffer.append(string);
    }

    private String getFileNameFromLog(String string) {
        int n = string.lastIndexOf(SPACE);
        if (n == -1) {
            n = 0;
        }
        return string.substring(n + 1, string.length());
    }

    private String validateConnection() {
        String string = "";
        if (this._connName != null) {
            try {
                this._conn = Connections.getInstance().getConnection(this._connName);
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
                Logger.warn(DbmsCloudAPI.class, (Throwable)exception);
                return string;
            }
        }
        if (this._connName == null || this._conn == null) {
            string = DbmsCloudResources.getString("DBMS_CLOUD_DEST_CONN_UNAVAIL");
            return string;
        }
        if (this._schema == null) {
            try {
                this._schema = this._connUser = this._conn.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                string = sQLException.getLocalizedMessage();
                Logger.warn(DbmsCloudAPI.class, (Throwable)sQLException);
                return string;
            }
        }
        return string;
    }

    private void eLog(String string) {
        if (this._eLogger != null) {
            this._eLogger.log(string);
        }
    }

    private void eLogException(Exception exception) {
        if (this._eLogger != null) {
            this._eLogger.logException(exception);
        }
    }

    private boolean lock() {
        if (!this._isConnLocked) {
            return Connections.getInstance().lock(this._conn);
        }
        return true;
    }

    private void unlock() {
        if (!this._isConnLocked) {
            Connections.getInstance().unlock(this._conn);
        }
    }
}

