/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.data.readers.DataReaderUtils;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.extract.DbmsCloudAPI;
import oracle.dbtools.raptor.extract.DbmsCloudResources;
import oracle.dbtools.raptor.extract.DeployQuery;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.oviewer.base.ProcessMonitor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;

public class DeployPdbAPI {
    public static final String ACTION_COPY_DATA = "actionCopyData";
    public static final String ACTION_COPY_BAD = "actionCopyBad";
    public static final String ACTION_COPY_LOG = "actionCopyLog";
    public static final String ACTION_DROP_DATA = "actionDropData";
    public static final String ACTION_DROP_BAD_AND_LOG = "actionDropBadAndLog";
    public static final String ACTION_EXTERNAL_TABLE = "actionExternalTable";
    public static final String ACTION_INSERT_DATA = "actionInsert";
    public static final String ACTION_UPLOAD_DATA = "actionUploadPutData";
    public static final String ACTION_VALIDATE_DATA = "actionValidateData";
    public static final String DATA_FILE_NAME = "dataFileName";
    public static final String DATA_FILE_CREDENTIAL = "dataFileCredential";
    public static final String DATA_FILE_FORMAT = "dataFileFormat";
    public static final String DATA_FILE_PATH = "dataFilePath";
    public static final String DATA_CLOUD_FORMAT = "dataCloudFormat";
    public static final String DATA_FIELDS = "dataFields";
    public static final String DISPLAY_FILE_FORMAT = "displayFileFormat";
    public static final String FMT_DELIMITER = "fmtDelimiter";
    public static final String FMT_ENCLOSURE_LEFT = "fmtEnclosureLeft";
    public static final String FMT_ENCLOSURE_RIGHT = "fmtEnclosureRight";
    public static final String FMT_ENCODING = "fmtEncoding";
    public static final String FMT_FIELDS = "fmtFields";
    public static final String FMT_TERMINATOR = "fmtTerminator";
    public static final String IS_SOURCE_DBO = "isSourceDBO";
    public static final String IS_SOURCE_LOCAL_FILE = "isSourceLocalFile";
    public static final String IS_SOURCE_CLOUD_FILE = "isSourceCloudFile";
    public static final String TARGET_COLUMNS = "TargetColumns";
    public static final String TARGET_CONNECTION = "targetConnection";
    public static final String TARGET_CREDENTIAL = "targetCredential";
    public static final String TARGET_STORAGE_LOCATION = "targetStorageLocation";
    public static final String TARGET_SCHEMA = "targetSchema";
    public static final String TARGET_TABLE = "targetTable";
    public static final String IS_VALIDATE_LIMIT = "isValidateLimit";
    public static final String VALIDATE_LIMIT = "validateLimit";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    public static final String OP_TYPE_SQL = "SQL";
    public static final String OP_TYPE_LDR = "LDR";
    public static final String OP_TYPE_BLD = "BUILD";
    String _cartName;
    Connection _conn;
    String _connName;
    String _connUser;
    boolean _isSchemaConnOwner;
    boolean _isConnClone = false;
    boolean _isPConn = false;
    boolean _connLocked;
    boolean _autoCommit;
    ExitCode _exitCode;
    ExitCode _deployExitCode;
    ExitCode _operationExitCode;
    DbmsCloudAPI _cloudAPI;
    ExtractLogger _eLogger;
    String _zipFile;
    BigDecimal _zipFileSize;
    File _deployDir;
    ArrayList<String> _deployCtl = new ArrayList();
    String _cloudLocation;
    String _cloudCredential;
    String _dataFileCredential;
    String _dataFormat;
    String _dataBucketStgLoc;
    String _dataFileStgLoc;
    String _dataFileShortName;
    String _dataFilePath;
    String _displayFileFormat;
    String _schema;
    String _targetTable;
    boolean _isSourceDbo;
    boolean _isSourceLocalFile;
    boolean _isSourceCloudFile;
    private int _operation = 0;
    private boolean _isOperationComplete = false;
    private String _operationType = "BUILD";
    boolean _isBadRows;
    boolean _isLogRows;
    private String _badRowCount;
    private ArrayList<String> _badFileNames;
    private ArrayList<String> _logFileNames;
    private String _badFileLocations;
    private BigDecimal _operationId;
    private String _xTabLog;
    private String _xTabBad;
    private RaptorTask<Void> _task = null;
    private IRaptorTaskProgressUpdater _progressUpdater;
    private boolean _isCancel = false;
    private ProcessMonitor _monitor;

    public void setMonitor(ProcessMonitor processMonitor) {
        this._monitor = processMonitor;
    }

    private void showMonitor() {
        if (this._monitor != null) {
            this._monitor.show();
        }
    }

    private void refreshMonitor() {
        if (this._monitor != null) {
            this._monitor.refresh();
        }
    }

    public DeployPdbAPI(String string, ExtractLogger extractLogger) {
        this._connName = string;
        this._eLogger = extractLogger;
    }

    public DeployPdbAPI(String string) {
        this._connName = string;
        this._eLogger = new ExtractLogger();
    }

    public void setProgressUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this._progressUpdater = iRaptorTaskProgressUpdater;
    }

    public ExitCode startDeploy(String string, String string2, String string3, String string4, String string5) {
        block8: {
            this._deployExitCode = ExitCode.EXIT_SUCCESS;
            this._operationExitCode = ExitCode.EXIT_SUCCESS;
            this.setExitCode(ExitCode.EXIT_SUCCESS);
            this._schema = string3;
            this._cloudLocation = string4;
            this._cloudCredential = string5;
            this._zipFile = string2;
            this._cartName = string;
            try {
                this._cloudAPI = new DbmsCloudAPI(this._eLogger);
                this.setExitCode(this._cloudAPI.startService(this._connName));
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.setExitCode(ExitCode.EXIT_SEVERE);
                this.getExitCode().setShortMessage(exception.getMessage());
            }
            if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
                return this.getExitCode();
            }
            this._cloudAPI.setSqlSpacing("  ");
            this._conn = this._cloudAPI.getConnection();
            this._connUser = this._cloudAPI.getConnectionUser();
            this._isSchemaConnOwner = this._connUser.equals(this._schema);
            try {
                this._cloudAPI.insertSdDeploy(this._cartName, this._zipFile, "DEPLOY", this._zipFileSize, this._schema, this._cloudLocation, string5);
                this._conn.commit();
                this.showMonitor();
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("42000")) {
                    this.installDeploy();
                    if (this.getExitCode() == ExitCode.EXIT_SEVERE) break block8;
                    try {
                        this._cloudAPI.insertSdDeploy(this._cartName, this._zipFile, "DEPLOY", this._zipFileSize, this._schema, this._cloudLocation, "credential");
                        this._conn.commit();
                        this.showMonitor();
                    }
                    catch (SQLException sQLException2) {
                        Logger.warn(DeployPdbAPI.class, (Throwable)sQLException2);
                        ExitCode exitCode = ExitCode.EXIT_ERROR;
                        exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR_DEPLOY") + SPACE);
                        exitCode.setMessage(this.getExitCode().getShortMessage() + sQLException2.getLocalizedMessage());
                        this.setExitCode(exitCode);
                        return exitCode;
                    }
                }
                Logger.warn(DeployPdbAPI.class, (Throwable)sQLException);
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR_DEPLOY") + SPACE);
                exitCode.setMessage(this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage());
                this.setExitCode(exitCode);
                return exitCode;
            }
        }
        return this.getDeployExitCode();
    }

    public void installDeploy() {
        String string = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        String string2 = DeployQuery.getQuery("create_sd_deploy", this._conn);
        if (!this.executeSql(string2)) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE + DbmsCloudResources.getString("DBMS_CLOUD_STEP_INSTALL"));
            this.setExitCode(exitCode);
            this.eLog(exitCode.getShortMessage());
        } else {
            this.installDeployOperation();
        }
    }

    public void installDeployOperation() {
        String string = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        String string2 = DeployQuery.getQuery("create_sd_deploy_operation", this._conn);
        if (!this.executeSql(string2)) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE + DbmsCloudResources.getString("DBMS_CLOUD_STEP_INSTALL_OPERATION"));
            this.setExitCode(exitCode);
            this.eLog(exitCode.getShortMessage());
        }
    }

    public void executeDeployAsTask() {
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.IDE_STATUSBAR;
        String string = DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_CART");
        this._task = new DatabaseQueryTask<Void>(string, iRaptorTaskRunMode, false, true){

            public Void doWork() {
                DeployPdbAPI.this.executeDeploy();
                return null;
            }

            public boolean cancel() {
                DeployPdbAPI.this._isCancel = true;
                return true;
            }

            @Override
            public String getConnectionName() {
                return DeployPdbAPI.this._connName;
            }

            @Override
            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    DeployPdbAPI.this.finish();
                }
                finally {
                    DeployPdbAPI.this._task = null;
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                DeployPdbAPI.this.cancelled();
                DeployPdbAPI.this._isCancel = true;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                DeployPdbAPI.this.failed();
                DeployPdbAPI.this._isCancel = true;
            }
        });
        this._progressUpdater = this._task.getRaptorTaskProgressUpdater();
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    public ExitCode executeDeploy() {
        if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
            return this.getExitCode();
        }
        this._deployExitCode = ExitCode.EXIT_SUCCESS;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        try {
            this._conn = Connections.getInstance().cloneConnection(this._connName);
            this._isConnClone = true;
            this.setExitCode(this._cloudAPI.startService(this._conn));
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(exception.getMessage());
        }
        if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
            return this.getExitCode();
        }
        if (!this.lockConnectionLong()) {
            return this.getExitCode();
        }
        this._cloudAPI.isConnLocked(true);
        String string = this.validateDeploy();
        if (!string.isEmpty()) {
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR_DEPLOY") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + string);
            this.setExitCode(exitCode);
            return exitCode;
        }
        try {
            this._deployCtl = this.getFileAsArray("deploy.sqldev");
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        int n = 0;
        try {
            for (String string2 : this._deployCtl) {
                this._progressUpdater.checkCanProceed();
                ++this._operation;
                this._eLogger = new ExtractLogger();
                this._cloudAPI.setELogger(this._eLogger);
                this._displayFileFormat = null;
                this._operationId = null;
                String[] stringArray = string2.split(SPACE);
                this._operationType = stringArray[0];
                this._operationExitCode = ExitCode.EXIT_SUCCESS;
                this.setExitCode(ExitCode.EXIT_SUCCESS);
                this.taskProgress(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_START", stringArray[1]));
                if (this.insertDeployOperationMeta(this._operation + 1, stringArray[1], this._operationType)) {
                    this._isOperationComplete = false;
                    if (this._operationType.equals(OP_TYPE_SQL)) {
                        try {
                            this.taskProgress(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_START_SQL", stringArray[1]));
                            if (!this.executeSql(this.getFileAsString(stringArray[1]))) {
                                this.setExitCode(ExitCode.EXIT_ERROR);
                            }
                        }
                        catch (Exception exception) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                            this.eLogException(exception);
                        }
                    } else {
                        n = 2;
                    }
                    if (this._operationType.equals(OP_TYPE_LDR)) {
                        try {
                            this.taskProgress(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_START_LOAD", stringArray[1]));
                            this.executeLdr(stringArray[1]);
                        }
                        catch (Exception exception) {
                            this.setExitCode(ExitCode.EXIT_ERROR);
                            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                            this.eLogException(exception);
                        }
                    }
                }
                this.completeOperation();
            }
            this.completeDeployment("DBMS_CLOUD_DEPLOY_FINISH");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return this.getDeployExitCode();
    }

    private void completeOperation() {
        this._eLogger.finished();
        try {
            String string = this._isCancel ? DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_STATUS") : DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getDeployExitCode());
            this.updateDeployOperationMeta(this._operation + 1, this._operationType, string, this._eLogger.getLogName(), this._operationId, this._displayFileFormat);
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
        this._isOperationComplete = true;
    }

    private void completeDeployment(String string) {
        try {
            this.taskProgress(string);
            String string2 = this._isCancel ? DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_STATUS") : DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getDeployExitCode());
            this._cloudAPI.updateSdDeploy(this._cartName, string2);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_META_ERR") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + exception.getLocalizedMessage());
            this.setExitCode(exitCode);
        }
    }

    public ExitCode cancelled() {
        this._isCancel = true;
        ExitCode exitCode = ExitCode.EXIT_SEVERE;
        exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_STATUS") + SPACE);
        exitCode.setMessage(DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_MSG"));
        this.setExitCode(exitCode);
        if (!this._isOperationComplete) {
            this.completeOperation();
            this.refreshMonitor();
        }
        this.completeDeployment(DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_MSG"));
        return this.finish();
    }

    public ExitCode failed() {
        ExitCode exitCode = ExitCode.EXIT_SEVERE;
        exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_FAILED_STATUS") + SPACE);
        exitCode.setMessage(DbmsCloudResources.getString("DBMS_CLOUD_FAILED_MSG"));
        this.setExitCode(exitCode);
        if (!this._isOperationComplete) {
            this.completeOperation();
            this.refreshMonitor();
        }
        this.completeDeployment(DbmsCloudResources.getString("DBMS_CLOUD_CANCELLED_MSG"));
        return this.finish();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExitCode finish() {
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        try {
            if (!this._connLocked) return this.getExitCode();
            this._conn.setAutoCommit(this._autoCommit);
            Connections.getInstance().unlock(this._conn);
            return this.getExitCode();
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.setExitCode(ExitCode.EXIT_WARNING);
            this.getExitCode().setShortMessage(exception.getMessage());
            this.eLogException(exception);
            return this.getExitCode();
        }
        finally {
            this._cloudAPI.isConnLocked(false);
            this._connLocked = false;
            try {
                if (!this._isConnClone) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.setExitCode(ExitCode.EXIT_WARNING);
                this.getExitCode().setShortMessage(exception.getMessage());
                this.eLogException(exception);
            }
        }
    }

    private boolean lockConnectionLong() {
        try {
            this._connLocked = Connections.getInstance().lock(this._conn);
            if (!this._connLocked) {
                this.setExitCode(ExitCode.EXIT_SEVERE);
                this.getExitCode().setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_LOCK_CONN_ERR"));
                Logger.warn(DeployPdbAPI.class, (String)this.getExitCode().getShortMessage());
                return false;
            }
            this._autoCommit = this._conn.getAutoCommit();
            this._conn.setAutoCommit(false);
        }
        catch (Exception exception) {
            Logger.severe(DeployPdbAPI.class, (Throwable)exception);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(exception.getMessage());
            return false;
        }
        return this._connLocked;
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
        this.setOperationExitCode(this._exitCode);
        this.setDeployExitCode(this._exitCode);
    }

    public void setOperationExitCode(ExitCode exitCode) {
        if (exitCode != null && this._operationExitCode.getSeverity() < exitCode.getSeverity()) {
            this._operationExitCode = exitCode;
        }
    }

    public void setDeployExitCode(ExitCode exitCode) {
        if (exitCode != null && this._deployExitCode.getSeverity() < exitCode.getSeverity()) {
            this._deployExitCode = exitCode;
        }
    }

    public ExitCode getOperationExitCode() {
        return this._operationExitCode;
    }

    public ExitCode getDeployExitCode() {
        return this._deployExitCode;
    }

    public void setStream(ExtractLogger extractLogger) {
        this._eLogger = extractLogger;
    }

    private ArrayList<String> getFileAsArray(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this._deployDir + File.separator + string), "UTF8");
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("--")) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private String getFileAsString(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this._deployDir + File.separator + string), "UTF8");
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + NL);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    private JsonObject getJsonObject(String var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeLdr(String string) {
        boolean bl;
        JsonObject jsonObject;
        block17: {
            jsonObject = this.getJsonObject(string);
            bl = this.initLdr(jsonObject);
            this._displayFileFormat = jsonObject.getJsonObject(DISPLAY_FILE_FORMAT).toString();
            if (!jsonObject.getString(ACTION_UPLOAD_DATA, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) || this.doPut(jsonObject)) break block17;
            this.setExitCode(ExitCode.EXIT_ERROR);
            boolean bl2 = false;
            this.eLog(NL);
            this.eLog(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_STATUS", DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getExitCode())));
            if (this._badRowCount != null) {
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", this._xTabBad, this._badRowCount));
            }
            return bl2;
        }
        try {
            if (jsonObject.getString(ACTION_COPY_DATA, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doCopy(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (jsonObject.getString(ACTION_EXTERNAL_TABLE, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doExternalTable(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (jsonObject.getString(ACTION_DROP_DATA, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doDropData(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (jsonObject.getString(ACTION_INSERT_DATA, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doInsert(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (jsonObject.getString(ACTION_COPY_LOG, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doCopyLog(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (jsonObject.getString(ACTION_COPY_BAD, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doCopyBad(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            this.doBadPreview(jsonObject);
            if (jsonObject.getString(ACTION_DROP_BAD_AND_LOG, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString()) && !this.doDropLogAndBad(jsonObject)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._isBadRows) {
                this.setExitCode(ExitCode.EXIT_WARNING);
            }
            this.eLog(NL);
        }
        catch (Exception exception) {
            try {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.setExitCode(ExitCode.EXIT_ERROR);
                this.eLogException(exception);
                bl = true;
                this.eLog(NL);
            }
            catch (Throwable throwable) {
                this.eLog(NL);
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_STATUS", DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getExitCode())));
                if (this._badRowCount != null) {
                    this.eLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", this._xTabBad, this._badRowCount));
                }
                throw throwable;
            }
            this.eLog(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_STATUS", DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getExitCode())));
            if (this._badRowCount != null) {
                this.eLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", this._xTabBad, this._badRowCount));
            }
            return bl;
        }
        this.eLog(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_STATUS", DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_" + this.getExitCode())));
        if (this._badRowCount != null) {
            this.eLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", this._xTabBad, this._badRowCount));
        }
        return true;
    }

    private boolean initLdr(JsonObject jsonObject) {
        try {
            this._isSourceDbo = jsonObject.getString(IS_SOURCE_DBO, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString());
            this._isSourceLocalFile = jsonObject.getString(IS_SOURCE_LOCAL_FILE, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString());
            this._isSourceCloudFile = jsonObject.getString(IS_SOURCE_CLOUD_FILE, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString());
            if (!this._isSourceDbo) {
                this._dataFilePath = jsonObject.getString(DATA_FILE_PATH);
            }
            this._dataFormat = jsonObject.getString(DATA_FILE_FORMAT, "CSV".toLowerCase());
            this._dataBucketStgLoc = jsonObject.getString(TARGET_STORAGE_LOCATION, "");
            this._dataFileShortName = jsonObject.getString(DATA_FILE_NAME, "");
            int n = this._dataFileShortName.lastIndexOf(".");
            String string = n == -1 ? this._dataFileShortName : this._dataFileShortName.substring(0, n);
            String string2 = DataReaderUtils.getTempName(string) + "." + this._dataFormat;
            if (this._isSourceCloudFile) {
                this._dataFileStgLoc = this._dataFilePath;
                this._dataBucketStgLoc = this._dataFilePath.substring(0, this._dataFilePath.lastIndexOf("/"));
            } else {
                String string3 = this._dataFileStgLoc = this._dataBucketStgLoc.endsWith("/") ? this._dataBucketStgLoc + string2 : this._dataBucketStgLoc + "/" + string2;
            }
            if (!this._dataBucketStgLoc.endsWith("/")) {
                this._dataBucketStgLoc = this._dataBucketStgLoc + "/";
            }
            this._dataFileCredential = jsonObject.getString(DATA_FILE_CREDENTIAL, "");
            this._cloudCredential = jsonObject.getString(TARGET_CREDENTIAL, "");
            this._schema = jsonObject.getString(TARGET_SCHEMA, "");
            this._cloudAPI.setSchema(this._schema);
            this._targetTable = jsonObject.getString(TARGET_TABLE, "");
        }
        catch (Exception exception) {
            this.setExitCode(ExitCode.EXIT_ERROR);
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
            return false;
        }
        return true;
    }

    public boolean doPut(JsonObject jsonObject) {
        String string = this._isSourceDbo ? this._deployDir.getPath() + File.separator + this._dataFileShortName : this._dataFilePath;
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            this._cloudAPI.putObject(this._cloudCredential, this._dataFileStgLoc, fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
            return false;
        }
        return true;
    }

    public boolean doCopy(JsonObject jsonObject) throws SQLException {
        String string;
        this._isLogRows = false;
        this._isBadRows = false;
        this._xTabLog = "";
        this._xTabBad = "";
        this._badFileNames = new ArrayList();
        this._logFileNames = new ArrayList();
        try {
            string = this._cloudAPI.getCopyDataProcedure(jsonObject.getString(TARGET_TABLE), this._dataFileCredential, this._dataFileStgLoc, this._schema, jsonObject.getString(DATA_FIELDS, ""), this.formatString(jsonObject.getString(DATA_CLOUD_FORMAT)));
            this._operationId = this._cloudAPI.doCopy(string);
        }
        catch (Exception exception) {
            this.setExitCode(this._cloudAPI.getExitCode());
            this._operationId = this._cloudAPI.getLastOperationId();
        }
        if (this._operationId == null || this._operationId.compareTo(new BigDecimal(0)) == -1) {
            return false;
        }
        string = "COPY$";
        this._xTabLog = string + this._operationId + "_LOG";
        this._xTabBad = string + this._operationId + "_BAD";
        this._isLogRows = this._cloudAPI.logXTabLog(this._schema, this._xTabLog, this._badFileNames, this._logFileNames);
        this._badRowCount = this._cloudAPI.getCountCloudTab(this._xTabBad);
        this._isBadRows = this._badRowCount != null && !this._badRowCount.isEmpty() && !this._badRowCount.equals("0");
        return true;
    }

    public boolean doExternalTable(JsonObject jsonObject) throws SQLException {
        Object object;
        this._isLogRows = false;
        this._isBadRows = false;
        this._xTabLog = "";
        this._xTabBad = "";
        this._badFileNames = new ArrayList();
        this._logFileNames = new ArrayList();
        try {
            object = this._cloudAPI.getExtCreateTableStatement(this._targetTable, this._dataFileCredential, this._dataFileStgLoc, this._schema, jsonObject.getString(TARGET_COLUMNS, ""), this.formatString(jsonObject.getString(DATA_CLOUD_FORMAT)));
            this._cloudAPI.createExternalTable((String)object);
        }
        catch (Exception exception) {
            this.setExitCode(this._cloudAPI.getExitCode());
            return false;
        }
        if (jsonObject.getString(ACTION_VALIDATE_DATA, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString())) {
            try {
                object = null;
                if (jsonObject.getString(IS_VALIDATE_LIMIT, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString())) {
                    object = new BigDecimal(jsonObject.getString(VALIDATE_LIMIT, "0"));
                }
                this._operationId = this._cloudAPI.validateExternalTable(this._targetTable, this._schema, (BigDecimal)object);
            }
            catch (SQLException sQLException) {
                this.setExitCode(this._cloudAPI.getExitCode());
                this._operationId = this._cloudAPI.getLastOperationId();
            }
        }
        if (this._operationId == null || this._operationId.compareTo(new BigDecimal(0)) == -1) {
            return false;
        }
        object = "VALIDATE$";
        this._xTabLog = (String)object + this._operationId + "_LOG";
        this._xTabBad = (String)object + this._operationId + "_BAD";
        this._isLogRows = this._cloudAPI.logXTabLog(this._schema, this._xTabLog, this._badFileNames, this._logFileNames);
        this._badRowCount = this._cloudAPI.getCountCloudTab(this._xTabBad);
        this._isBadRows = this._badRowCount != null && !this._badRowCount.isEmpty() && !this._badRowCount.equals("0");
        return true;
    }

    public boolean doDropData(JsonObject jsonObject) {
        try {
            this._cloudAPI.deleteObject(this._cloudCredential, this._dataFileStgLoc);
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
            return false;
        }
        return true;
    }

    protected boolean doInsert(JsonObject jsonObject) {
        return true;
    }

    protected boolean doCopyLog(JsonObject jsonObject) {
        if (this._isLogRows) {
            String string;
            try {
                string = this._cloudAPI.putObject(this._dataFileCredential, this._dataBucketStgLoc, this._logFileNames, false);
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                return false;
            }
            try {
                this._cloudAPI.updateSdDeployOperationLogFiles(this._cartName, this._operation + 1, string);
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                return false;
            }
        }
        return true;
    }

    protected boolean doCopyBad(JsonObject jsonObject) {
        this._badFileLocations = "";
        if (this._isBadRows) {
            try {
                this._badFileLocations = this._cloudAPI.putObject(this._dataFileCredential, this._dataBucketStgLoc, this._badFileNames, false);
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                return false;
            }
            try {
                this._cloudAPI.updateSdDeployOperationBadFiles(this._cartName, this._operation + 1, this._badFileLocations);
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                return false;
            }
        }
        return true;
    }

    protected boolean doBadPreview(JsonObject jsonObject) {
        if (this._isBadRows) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Integer n = 20000;
            StringBuffer stringBuffer = new StringBuffer();
            if (this._badFileNames != null) {
                int n2;
                if (jsonObject.getString(ACTION_COPY_BAD, JsonValue.FALSE.toString()).equals(JsonValue.TRUE.toString())) {
                    for (n2 = 0; n2 < this._badFileNames.size() && n > 0; ++n2) {
                        arrayList.add(this._badFileNames.get(n2));
                        String string = "";
                        String string2 = "";
                        int n3 = this._dataFilePath.lastIndexOf("/");
                        if (this._isSourceCloudFile) {
                            string = n3 < 0 ? this._dataFilePath : this._dataFilePath.substring(0, n3);
                            string2 = string + "/" + this._badFileNames.get(n2);
                        } else {
                            string2 = this._dataBucketStgLoc + this._badFileNames.get(n2);
                        }
                        String string3 = DataUIUtils.getSample(this._connName, string2, this._dataFileCredential, n);
                        if (string3 != null) {
                            stringBuffer.append(string3);
                            n = n - string3.length();
                        }
                        arrayList.remove(0);
                    }
                } else {
                    for (n2 = 0; n2 < this._badFileNames.size() && n > 0; ++n2) {
                        String string;
                        arrayList.add(this._badFileNames.get(n2));
                        try {
                            string = this._cloudAPI.putObject(this._dataFileCredential, this._dataFileStgLoc, arrayList, false);
                        }
                        catch (Exception exception) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                            this.setExitCode(this._cloudAPI.getExitCode());
                            return false;
                        }
                        try {
                            String string4 = DataUIUtils.getSample(this._connName, string, this._dataFileCredential, n);
                            if (string4 != null) {
                                stringBuffer.append(string4);
                                n = n - string4.length();
                            }
                            this._cloudAPI.deleteObject(this._dataFileCredential, this._dataFileStgLoc, arrayList);
                        }
                        catch (Exception exception) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                            this.eLogException(exception);
                            return false;
                        }
                        arrayList.remove(0);
                    }
                }
            }
            try {
                this._cloudAPI.updateSdDeployOperationPreview(this._cartName, this._operation + 1, stringBuffer.toString());
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                return false;
            }
        }
        return true;
    }

    protected boolean doDropLogAndBad(JsonObject jsonObject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSql(String string) {
        try {
            try {
                this._conn.setSchema(this._schema);
            }
            catch (Exception exception) {
                Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                this.eLogException(exception);
                boolean bl = false;
                if (!this._isSchemaConnOwner) {
                    try {
                        this._conn.setSchema(this._connUser);
                    }
                    catch (Exception exception2) {
                        Logger.warn(DeployPdbAPI.class, (Throwable)exception2);
                        this.eLogException(exception2);
                    }
                }
                return bl;
            }
            String string2 = string + this.getTerm();
            this.eLog(string2);
            String string3 = ScriptRunnerContext.getOutputEncoding();
            StringReader stringReader = new StringReader(string2);
            ScriptExecutor scriptExecutor = new ScriptExecutor((Reader)stringReader, this._conn);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)true);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            scriptExecutor.setOut(bufferedOutputStream);
            scriptExecutor.run();
            bufferedOutputStream.flush();
            this.eLog(byteArrayOutputStream.toString(string3));
            boolean bl = (Boolean)scriptRunnerContext.getProperty("sqldev.error.any.in") == false;
            return bl;
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this._isSchemaConnOwner) {
                try {
                    this._conn.setSchema(this._connUser);
                }
                catch (Exception exception) {
                    Logger.warn(DeployPdbAPI.class, (Throwable)exception);
                    this.eLogException(exception);
                }
            }
        }
    }

    public boolean insertDeployOperationMeta(int n, String string, String string2) {
        try {
            this._cloudAPI.insertSdDeployOperation(this._cartName, n, string, string2);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("42000")) {
                this.installDeployOperation();
                if (this.getExitCode() != ExitCode.EXIT_SEVERE) {
                    try {
                        this._cloudAPI.insertSdDeployOperation(this._cartName, n, string, string2);
                        this._conn.commit();
                        this.refreshMonitor();
                    }
                    catch (SQLException sQLException2) {
                        ExitCode exitCode = ExitCode.EXIT_ERROR;
                        exitCode.setShortMessage(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_META_ERR", string) + SPACE);
                        exitCode.setMessage(this.getExitCode().getShortMessage() + sQLException2.getLocalizedMessage());
                        this.setExitCode(exitCode);
                        Logger.severe(DeployPdbAPI.class, (Throwable)sQLException2);
                        this.eLogException(sQLException2);
                        return false;
                    }
                }
                return false;
            }
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.format("DBMS_CLOUD_DEPLOY_OP_META_ERR", string) + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + sQLException.getLocalizedMessage());
            this.setExitCode(exitCode);
            Logger.severe(DeployPdbAPI.class, (Throwable)sQLException);
            this.eLogException(sQLException);
            return false;
        }
        return true;
    }

    public boolean updateDeployOperationMeta(int n, String string, String string2, String string3, BigDecimal bigDecimal, String string4) {
        try {
            this._cloudAPI.updateSdDeployOperation(this._cartName, n, string2, string3, bigDecimal, string4, string.equals(OP_TYPE_LDR) ? "TABLE" : null, string.equals(OP_TYPE_LDR) ? this._targetTable : null);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_DEPLOY_OP_META_ERR") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + exception.getLocalizedMessage());
            this.setExitCode(exitCode);
            Logger.severe(DeployPdbAPI.class, (Throwable)exception);
            this.eLog(exitCode.getMessage());
            return false;
        }
        return true;
    }

    private String validateDeploy() {
        String string = "";
        if (this._zipFile == null || this._zipFile.isEmpty()) {
            string = DbmsCloudResources.getString("DBMS_CLOUD_START_ERR_DEPLOY_NO_ZIP");
            return string;
        }
        try {
            File file = new File(this._zipFile);
            this._zipFileSize = new BigDecimal(file.length());
            this._deployDir = DeployPdbAPI.expandZip(file);
        }
        catch (Exception exception) {
            Logger.warn(DeployPdbAPI.class, (Throwable)exception);
            this.eLogException(exception);
            string = DbmsCloudResources.format("DBMS_CLOUD_START_ERR_DEPLOY_UNZIP", this._zipFile);
            return string;
        }
        return string;
    }

    private static File expandZip(File file) throws IOException {
        File file2 = null;
        Path path = Files.createTempDirectory(Resource.RAPTOR_USER_TEMP.toPath(), "cloudConfig", new FileAttribute[0]);
        File file3 = path.toFile();
        file3.deleteOnExit();
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file4 = new File(file3, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file4.mkdir();
                } else {
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file4);
                         BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                        int n = 0;
                        byte[] byArray = new byte[4096];
                        while ((n = zipInputStream.read(byArray, 0, byArray.length)) > 0) {
                            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                        }
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        file2 = file3;
        return file2;
    }

    private String formatString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String getTerm() {
        return NL;
    }

    private void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this._task != null) {
            raptorTaskDescriptor = this._task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    private boolean taskProgress() {
        return this.taskProgress(null);
    }

    private boolean taskProgress(String string) {
        if (this._progressUpdater != null) {
            try {
                this._progressUpdater.checkCanProceed();
            }
            catch (ExecutionException executionException) {
                this._isCancel = true;
                return false;
            }
            if (string != null) {
                this._progressUpdater.getDescriptor().setMessage(string);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        if (this._eLogger != null) {
            this._eLogger.finished();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this._eLogger.getLogName());
                String string = Ide.getEnvironOptions().getEncoding();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
                bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + NL);
                }
            }
            catch (IOException iOException) {
                Logger.warn(DeployPdbAPI.class, (Throwable)iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Logger.warn(DeployPdbAPI.class, (Throwable)iOException);
                    }
                }
                this._eLogger = null;
            }
        }
        return stringBuffer.toString();
    }

    protected void eLog(String string) {
        if (this._eLogger != null) {
            this._eLogger.log(string);
        }
    }

    protected void eLogException(Exception exception) {
        if (this._eLogger != null) {
            this._eLogger.logException(exception);
        }
    }
}

