/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.logging.LogUtils;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ExtractLogger {
    private ExtractMessagePage _messagePane;
    private File _file;
    private OutputStream _outs;
    private BufferedOutputStream _bouts;
    protected OutputStreamWriter _out;
    private String _encoding = IdeUtil.getIdeEncoding();
    private String _eol;
    private String _logName;
    private String _toolName;
    private String _processName;
    private String _stepName;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    private StringBuilder _startTime;
    private StringBuilder _endTime;

    public ExtractLogger() {
        this(IdeUtil.getIdeEncoding());
    }

    public ExtractLogger(OutputStreamWriter outputStreamWriter) {
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        this._out = outputStreamWriter;
        this.setWriter();
    }

    public ExtractLogger(OutputStream outputStream) {
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        this._outs = outputStream;
        this.setWriter();
    }

    public ExtractLogger(File file) {
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        this._file = file;
        this.setWriter();
    }

    public ExtractLogger(File file, String string) {
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        this._file = file;
        this._encoding = string;
        this.setWriter();
    }

    public ExtractLogger(String string) {
        this(ExtractResources.getString("EXTRACT_TOOL"), string);
    }

    public ExtractLogger(String string, String string2) {
        this(string, string2, null);
    }

    public ExtractLogger(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public ExtractLogger(String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string3 == null ? ".log" : string3;
        this._encoding = string2;
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        String string7 = string5 = string4 == null || string4.isEmpty() ? Ide.getUserSettingsDirectory() : string4;
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        this._logName = string5 + string + "_" + this._startTime + string6;
        this._file = new File(this._logName);
        this.setWriter();
    }

    public ExtractLogger(ViewId viewId) {
        this(viewId, null, null, null);
    }

    public ExtractLogger(ViewId viewId, String string, String string2, Icon icon) {
        this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        this._messagePane = ExtractMessagePage.getExportMessagePage(viewId, string, string2, icon);
        this.setTerm();
    }

    public String getStartTime() {
        if (this._startTime == null) {
            this._startTime = new StringBuilder(this._dateFormat.format(new Date()));
        }
        return this._startTime.toString();
    }

    public void setStream(OutputStream outputStream) {
        this._outs = outputStream;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setWriter() {
        try {
            if (this._out == null) {
                if (this._outs == null) {
                    this._outs = new FileOutputStream(this._file.getPath());
                }
                this._bouts = new BufferedOutputStream(this._outs);
                this._out = new OutputStreamWriter((OutputStream)this._bouts, this._encoding);
            }
            this.setTerm();
        }
        catch (IOException iOException) {
            if (this._file != null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)ExtractResources.getString("LOG_FILE_CREATION_ERROR"), (String)(this._file.getPath() + this._file.getName()), null);
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)ExtractResources.getString("LOG_FILE_CREATION_ERROR"), (String)"ExtractLog", null);
        }
    }

    public OutputStreamWriter getWriter() {
        return this._out;
    }

    public String getLogName() {
        return this._logName;
    }

    public void log(String string) {
        this.log(string, false);
    }

    public void log(String string, boolean bl) {
        try {
            if (this._out != null) {
                this._out.write(string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()));
            } else if (this._messagePane != null) {
                this._messagePane.log(string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()), bl);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void log(AttributeSet attributeSet, String string) {
        this.log(attributeSet, string, false);
    }

    public void log(AttributeSet attributeSet, String string, boolean bl) {
        try {
            if (this._out != null) {
                this._out.write(string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()));
            } else if (this._messagePane != null) {
                StyledMessage styledMessage = new StyledMessage(attributeSet, string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()));
                this._messagePane.log(styledMessage, bl);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void logLabel(String string) {
        this.log(string, false);
    }

    public void logLabel(String string, boolean bl) {
        try {
            if (this._out != null) {
                this._out.write(string);
            } else if (this._messagePane != null) {
                this._messagePane.log(string, bl);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void logToolStart(String string) {
        this._toolName = string;
        this.log(this.getTerm());
        this.log(ExtractResources.format("LOG_TOOL_START", string, this._startTime));
    }

    public void logToolEnd() {
        this._endTime = new StringBuilder(this._dateFormat.format(new Date()));
        this.log(ExtractResources.format("LOG_TOOL_END", this._toolName, this._endTime));
    }

    public void logProcessStart(String string) {
        this._processName = string;
        this.log(ExtractResources.getString("LOG_SEPARATOR"));
        this.log(ExtractResources.format("LOG_PROCESS_START", string));
    }

    public void logProcessEnd() {
        this.log(ExtractResources.format("LOG_PROCESS_END", this._processName));
        this.log(ExtractResources.getString("LOG_SEPARATOR"));
    }

    public void logStepStart(String string) {
        this._stepName = string;
        this.log(ExtractResources.getString("LOG_SEPARATOR"));
        this.log(ExtractResources.format("LOG_STEP_START", string));
    }

    public void logStepEnd() {
        this.log(ExtractResources.format("LOG_STEP_END", this._stepName));
        this.log(ExtractResources.getString("LOG_SEPARATOR"));
    }

    public void logError(String string) {
        this.log(ExtractResources.format("LOG_ERROR", string), true);
    }

    public void logException(Throwable throwable) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.RED);
        this.log(simpleAttributeSet, ExtractResources.format("EXCEPTION", ExtractResources.getString("EXCEPTION_CHECK_LOG")));
        if (throwable != null) {
            String string = throwable.getLocalizedMessage();
            if (string == null) {
                if (throwable.getCause() != null) {
                    string = throwable.getCause().getMessage();
                }
                if (string == null) {
                    string = String.valueOf(throwable);
                }
            }
            string = string + " " + throwable.getStackTrace()[0].toString();
            this.log(simpleAttributeSet, ExtractResources.format("EXCEPTION", string), true);
        }
    }

    public void logHref(URL uRL) {
        if (this._out != null) {
            this.log(uRL.toExternalForm());
        } else if (this._messagePane != null) {
            this._messagePane.log(LogUtils.getHref(uRL));
            this.log(this.getTerm());
        }
    }

    public void flushLog() {
        try {
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void finished() {
        this.closeLog();
    }

    public void closeLog() {
        try {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
                this._out = null;
            }
            this._outs = null;
            this._bouts = null;
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public boolean isFileUsed() {
        return this._file != null & this._file.exists() && this._file.length() > 0L;
    }

    public void deleteEmptyFile() {
        if (this._file != null && this._file.exists() && this._file.length() == 0L) {
            this._file.delete();
        }
    }

    public void setTerm() {
        if (this._eol == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._eol = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
    }

    public String getTerm() {
        return this._eol;
    }

    public URL getURL() {
        try {
            if (this._file != null) {
                return this._file.toURI().toURL();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return null;
    }

    public void openTextNodeForLog() throws Exception {
        TextNode textNode = null;
        textNode = (TextNode)NodeFactory.findOrCreate(TextNode.class, (URL)this.getURL());
        final TextNode textNode2 = textNode;
        if (textNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)textNode2);
                        }
                    });
                }
            });
        }
    }

    public static String getTempDir() throws IOException {
        File file = File.createTempFile("pref", "suf");
        String string = file.getParentFile().getPath();
        file.delete();
        return string;
    }
}

