/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccess;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccessCatalog;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleConnection;

public class ExtractListModel {
    public static final int TYPE_ALL_OBJECTS = 0;
    public static final int TYPE_CREATE = 1;
    public static final int TYPE_CREATE_PRE_DATA = 2;
    public static final int TYPE_CREATE_POST_DATA = 3;
    public static final int TYPE_DROP = 4;
    public static final int TYPE_TRUNCATE = 5;
    public static final int TYPE_ENABLE_CONSTRAINTS = 6;
    public static final int TYPE_DISABLE_CONSTRAINTS = 7;
    public static final int TYPE_DATA = 8;
    public static final int TYPE_PRE_SCRIPT = 9;
    public static final int TYPE_POST_SCRIPT = 10;
    public static final int TYPE_OBJECT_SCRIPT = 11;
    public static final int TYPE_SPATIAL_META_ALL = 12;
    public static final int TYPE_SPATIAL_META_NEW = 13;
    public static final int TYPE_SPATIAL_META_ALL_CONS = 14;
    public static final int TYPE_SPATIAL_META_NEW_CONS = 15;
    public static final String TYPE_OBJECT_NAME = ExtractResources.getString("TYPE_OBJECT_NAME");
    public static final String TYPE_CREATE_NAME = ExtractResources.getString("TYPE_CREATE_NAME");
    public static final String TYPE_CREATE_PRE_DATA_NAME = ExtractResources.getString("TYPE_CREATE_PRE_DATA_NAME");
    public static final String TYPE_CREATE_POST_DATA_NAME = ExtractResources.getString("TYPE_CREATE_POST_DATA_NAME");
    public static final String TYPE_DROP_NAME = ExtractResources.getString("TYPE_DROP_NAME");
    public static final String TYPE_TRUNCATE_NAME = ExtractResources.getString("TYPE_TRUNCATE_NAME");
    public static final String TYPE_ENABLE_CONSTRAINTS_NAME = ExtractResources.getString("TYPE_ENABLE_CONSTRAINTS_NAME");
    public static final String TYPE_DISABLE_CONSTRAINTS_NAME = ExtractResources.getString("TYPE_DISABLE_CONSTRAINTS_NAME");
    public static final String TYPE_DATA_NAME = ExtractResources.getString("TYPE_DATA_NAME");
    public static final String TYPE_PRE_SCRIPT_NAME = ExtractResources.getString("TYPE_PRE_SCRIPT_NAME");
    public static final String TYPE_POST_SCRIPT_NAME = ExtractResources.getString("TYPE_POST_SCRIPT_NAME");
    public static final String TYPE_OBJECT_SCRIPT_NAME = ExtractResources.getString("TYPE_OBJECT_SCRIPT_NAME");
    public static final String TYPE_SPATIAL_META_ALL_NAME = ExtractResources.getString("TYPE_SPATIAL_META_ALL_NAME");
    public static final String TYPE_SPATIAL_META_NEW_NAME = ExtractResources.getString("TYPE_SPATIAL_META_NEW_NAME");
    public static final String TYPE_SPATIAL_META_ALL_CONS_NAME = ExtractResources.getString("TYPE_SPATIAL_META_ALL_CONS_NAME");
    public static final String TYPE_SPATIAL_META_NEW_CONS_NAME = ExtractResources.getString("TYPE_SPATIAL_META_NEW_CONS_NAME");
    public static final String[] LIST_TYPE_NAMES = new String[]{TYPE_OBJECT_NAME, TYPE_CREATE_NAME, TYPE_CREATE_PRE_DATA_NAME, TYPE_CREATE_POST_DATA_NAME, TYPE_DROP_NAME, TYPE_TRUNCATE_NAME, TYPE_ENABLE_CONSTRAINTS_NAME, TYPE_DISABLE_CONSTRAINTS_NAME, TYPE_DATA_NAME, TYPE_PRE_SCRIPT_NAME, TYPE_POST_SCRIPT_NAME, TYPE_OBJECT_SCRIPT_NAME, TYPE_SPATIAL_META_ALL_NAME, TYPE_SPATIAL_META_NEW_NAME, TYPE_SPATIAL_META_ALL_CONS_NAME, TYPE_SPATIAL_META_NEW_CONS_NAME};
    public static final int OPT_EXTRACT_METADATA = 100;
    public static final int OPT_EXTRACT_DATA = 101;
    public static final int OPT_DATA_OBJECT = 102;
    public static final int OPT_EXISTS_SOURCE = 103;
    public static final int OPT_EXISTS_DEST = 104;
    public static final int OPT_EXISTS_SOURCE_ONLY = 105;
    public static final int OPT_EXISTS_DEST_ONLY = 106;
    public static final int OPT_PRESELECTED = 107;
    public static final int OPT_SELECTED_META = 108;
    public static final int OPT_SELECTED_DATA = 109;
    public static final int OPT_BEFORE_CREATE_SCRIPT = 110;
    public static final int OPT_AFTER_CREATE_SCRIPT = 111;
    public static final int OPT_BEFORE_LOAD_SCRIPT = 112;
    public static final int OPT_AFTER_LOAD_SCRIPT = 113;
    public static final int OPT_INITIAL_SCRIPT = 114;
    public static final int OPT_FINAL_SCRIPT = 115;
    public static final String KEY_EXTRACT_LIST_MODEL = "EXTRACT_LIST_MODEL";
    private static final int DBO = 0;
    private static final int QUERY = 1;
    private int _dataObjectType;
    private DDLTypes _ddlTypes;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private List<ExtractObject> _EOList = new ArrayList<ExtractObject>();
    private List<ExtractObject> _destEOList = new ArrayList<ExtractObject>();
    private boolean _isDDLEnabled = false;
    private boolean _isDataEnabled = false;
    private String _sourceConnName = "";
    private String _destConnName = "";
    private Connection _sourceConn;
    private Connection _destConn;
    private String _sourceConnUser;
    private String _destConnUser;
    private List<String> _schemaList = new ArrayList<String>();
    private String[] _tablespaces;
    private boolean _isSourceConnOracle = true;
    private boolean _isSourceConnTimesTen = false;
    private boolean _isDestConnOracle = true;
    private boolean _isDestConnTimesTen = false;
    private boolean _isAllowLobs = true;
    private boolean _isPreSelected = false;
    private boolean _isPreSelectedDataExtractable = false;
    private boolean _isDestList = false;
    private boolean _isSelectedData = false;
    private boolean _isSelectedMetaData = false;
    private ExtractReconciler.ReconcileType _reconcileType = ExtractReconciler.ReconcileType.TYPES_AND_OBJECTS;
    private String _globalWhere = "";
    private HashMap<String, Object> _extendedProperties = new HashMap();
    private ExtractReconciler _listReconciler = new ExtractReconciler(this);
    public static final String MDSYS = "MDSYS";
    public static final String NON_USER_META = "SDO_GEOM_METADATA_TABLE";
    public static final String NON_USER_SDO_GEOM_META = "MDSYS.SDO_GEOM_METADATA_TABLE";
    public static final String USER_SDO_GEOM_META = "MDSYS.USER_SDO_GEOM_METADATA";
    final String USER_SOURCE_COLS = "TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String NON_USER_SOURCE_COLS = "OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String USER_DEST_COLS = "TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String NON_USER_DEST_COLS = "SDO_OWNER, SDO_TABLE_NAME, SDO_COLUMN_NAME, SDO_DIMINFO, SDO_SRID";
    final String OWNER_COL = "OWNER";
    final String NON_USER_OWNER_COL = "SDO_OWNER";
    final String TABLE_NAME_COL = "TABLE_NAME";
    final String NON_USER_TABLE_NAME_COL = "SDO_TABLE_NAME";
    final String TABLE = "TABLE";
    final String AND = " AND ";
    final String EQ = " = ";
    final String DOT = ".";
    final String IN = " IN(";
    final String SQ = "'";
    final String CLOSEP = ")";
    final String OPENP = "(";

    public ExtractListModel() {
        this._dataObjectType = 0;
    }

    public ExtractListModel(JTable jTable) {
        this(jTable, ((IResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
    }

    public ExtractListModel(JTable jTable, String string) {
        this._dataObjectType = 1;
        this.setSourceConnectionProperties(string);
        this._EOList.add(new ExtractObject(jTable, this));
    }

    public ExtractListModel(DBObject dBObject) {
        this.initForDBObjects(dBObject);
    }

    public ExtractListModel(List<DBObject> list) {
        this.initForDBObjects(list);
    }

    public ExtractListModel(DBObject[] dBObjectArray) {
        this.initForDBObjects(dBObjectArray);
    }

    public void setReconcileType(ExtractReconciler.ReconcileType reconcileType) {
        this._reconcileType = reconcileType;
    }

    public ExtractReconciler.ReconcileType getReconcileType() {
        return this._reconcileType;
    }

    public String getSourceConnName() {
        return this._sourceConnName;
    }

    public void setSourceConnName(String string) {
        this.setSourceConnectionProperties(string);
    }

    public Connection getSourceConn() {
        if (this._sourceConnName != null && this._sourceConn == null) {
            try {
                this._sourceConn = Connections.getInstance().getConnection(this._sourceConnName);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        return this._sourceConn;
    }

    public String getSourceConnUser() {
        if (this._sourceConnUser.length() == 0) {
            this._sourceConnUser = this.getConnectionUser(this.getSourceConn());
        }
        return this._sourceConnUser;
    }

    public String getDestConnName() {
        return this._destConnName;
    }

    public void setDestConnName(String string) {
        this._destConnName = string;
        this.setDestConnectionProperties(string);
    }

    public Connection getDestConn() {
        return this._destConn;
    }

    public String getDestConnUser() {
        if (this._destConnUser.length() == 0) {
            this._destConnUser = this.getConnectionUser(this._destConn);
        }
        return this._destConnUser;
    }

    public boolean isDestList() {
        return this._isDestList;
    }

    public void isDestList(boolean bl) {
        this._isDestList = bl;
    }

    public List<ExtractObject> getDestExtractObjects() {
        return this._destEOList;
    }

    public void setDestExtractObjects(List<ExtractObject> list) {
        this._destEOList = list;
        this._isDestList = true;
    }

    public String[] getSchemas() {
        return this._schemaList.toArray(new String[this._schemaList.size()]);
    }

    public void setSchemas(String[] stringArray) {
        this._schemaList.clear();
        for (String string : stringArray) {
            this._schemaList.add(string);
        }
    }

    public void setSchemas() {
        this._schemaList.clear();
        for (ExtractObject extractObject : this._EOList) {
            int n;
            if (!extractObject.isDataObject() || (n = this._schemaList.indexOf(extractObject.getDBObject().getSchemaName())) != -1) continue;
            this._schemaList.add(extractObject.getDBObject().getSchemaName());
        }
    }

    public String[] getTablespaces() {
        return this._tablespaces;
    }

    public void setTablespaces(String[] stringArray) {
        this._tablespaces = stringArray;
    }

    public DDLTypes getDDLTypes() {
        if (this._ddlTypes == null) {
            this._ddlTypes = new DDLTypes();
        }
        return this._ddlTypes;
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        this._ddlTypes = dDLTypes;
    }

    public void isDDLEnabled(boolean bl) {
        this._isDDLEnabled = bl;
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this._ddlFormat = new DDLFormat();
            this._ddlFormat.isExtractEnabled(true);
        }
    }

    public boolean isDDLEnabled() {
        return this._isDDLEnabled;
    }

    public void isDataEnabled(boolean bl) {
        this._isDataEnabled = bl;
        if (this._isDataEnabled && this._dataFormat == null) {
            this._dataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD, BaseDataFormat.INSERT);
            this._dataFormat.isExportEnabled(bl);
        }
    }

    public boolean isDataEnabled() {
        return this._isDataEnabled;
    }

    public DDLFormat getDDLFormat() {
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this.isDDLEnabled(true);
        }
        return this._ddlFormat;
    }

    public void setDDLFormat(DDLFormat dDLFormat) {
        this._ddlFormat = dDLFormat;
        this._isDDLEnabled = this._ddlFormat.isExtractEnabled();
    }

    public ExtractDataFormat getDataFormat() {
        if (this._isDataEnabled && this._dataFormat == null) {
            this.isDataEnabled(true);
        }
        return this._dataFormat;
    }

    public void setDataFormat(ExtractDataFormat extractDataFormat) {
        this._dataFormat = extractDataFormat;
        this._isDataEnabled = this._dataFormat.isExportEnabled();
        this._isAllowLobs = this._dataFormat.allowsLobs();
    }

    public ExtractReconciler getReconciler() {
        return this._listReconciler;
    }

    public void startProcess() {
        this._listReconciler.reconcileTypesAndObjects(103);
    }

    public void startProcess(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileTypesAndObjects(103, iRaptorTaskProgressUpdater);
    }

    public void startProcessReconcileObjects() {
        try {
            this.startProcessReconcileObjects(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void startProcessReconcileObjects(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileObjects(103, iRaptorTaskProgressUpdater);
    }

    public void startProcessReconcileObjects(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileObjects(103, n, iRaptorTaskProgressUpdater);
    }

    public void reconcileDestFromSource() {
        try {
            this._listReconciler.reconcileDestFromSource();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestFromSource(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileDestFromSource(iRaptorTaskProgressUpdater);
    }

    public void reconcileDestListFromSource() {
        try {
            this._listReconciler.reconcileDestListFromSource();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestListFromSource(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileDestListFromSource(iRaptorTaskProgressUpdater);
    }

    public void reconcileDestFull() {
        this._listReconciler.reconcileTypesAndObjects(104);
    }

    public void expandFolders(int n, int[] nArray, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.expandFolders(n, nArray, iRaptorTaskProgressUpdater);
    }

    public static String getListTypeName(int n) {
        if (n < LIST_TYPE_NAMES.length) {
            return LIST_TYPE_NAMES[n];
        }
        return "";
    }

    public List<ExtractObject> getList(int n) {
        ArrayList<ExtractObject> arrayList = null;
        switch (n) {
            case 0: {
                return this._EOList;
            }
            case 1: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 2: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 3: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 4: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 5: {
                return this.getCreateProcessList(5, new int[]{101});
            }
            case 7: {
                return this.getCreateProcessList(7, new int[]{101});
            }
            case 6: {
                return this.getCreateProcessList(6, new int[]{101});
            }
            case 8: {
                return this.getList(0, new int[]{101});
            }
            case 9: 
            case 10: {
                arrayList = new ArrayList<ExtractObject>();
                int n2 = n == 9 ? 2 : 3;
                for (ExtractObject extractObject : this._EOList) {
                    if (extractObject.getType() != n2) continue;
                    arrayList.add(extractObject);
                }
                return arrayList;
            }
            case 11: {
                arrayList = new ArrayList();
                for (ExtractObject extractObject : this._EOList) {
                    if (!extractObject.isIncludeScripts()) continue;
                    arrayList.add(extractObject);
                }
                return arrayList;
            }
            case 12: {
                return this.getSpatialMetaList(true, true);
            }
            case 13: {
                return this.getSpatialMetaList(false, true);
            }
            case 14: {
                return this.getSpatialMetaList(true, false);
            }
            case 15: {
                return this.getSpatialMetaList(false, false);
            }
        }
        return null;
    }

    public List<ExtractObject> getList(int n, int[] nArray) {
        List<ExtractObject> list = this.getList(n);
        List<ExtractObject> list2 = ExtractListModel.getList(list, nArray);
        return list2;
    }

    public static List<ExtractObject> getList(List<ExtractObject> list, int[] nArray) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : list) {
            block14: for (int n : nArray) {
                switch (n) {
                    case 100: {
                        if (!extractObject.isExtractMetaData() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 101: {
                        if (!extractObject.isExtractData() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 102: {
                        if (!extractObject.isDataObject() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 103: {
                        if (!extractObject.isExistsSource() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 104: {
                        if (!extractObject.isExistsDest() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 105: {
                        if (!extractObject.isExistsSource() || extractObject.isExistsDest() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 106: {
                        if (!extractObject.isExistsDest() || extractObject.isExistsSource() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 107: {
                        if (!extractObject.isPreSelected() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 108: {
                        if (!extractObject.isSelectedMetaData() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 109: {
                        if (!extractObject.isSelectedData() || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                        continue block14;
                    }
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        ExtractScript extractScript = extractObject.getScript(n);
                        if (extractScript == null || arrayList.contains(extractObject)) continue block14;
                        arrayList.add(extractObject);
                    }
                }
            }
        }
        return arrayList;
    }

    public List<ExtractObject> getList(int n, int[] nArray, String string) {
        List<ExtractObject> list = this.getList(n, nArray);
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : list) {
            if (!extractObject.getDBObject().getObjectType().equals(string)) continue;
            arrayList.add(extractObject);
        }
        return ExtractListModel.getList(arrayList, nArray);
    }

    public List<ExtractObject> getListForType(List<ExtractObject> list, String string) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        if (list == null || list.size() < 1) {
            return arrayList;
        }
        for (ExtractObject extractObject : list) {
            if (extractObject.getType() == 0) {
                String string2 = extractObject.getDBObject().getObjectType();
                if (string2 == null || !string2.equals(string)) continue;
                arrayList.add(extractObject);
                continue;
            }
            if (extractObject.getType() != 4 || !string.equals("TABLE")) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public List<URL> getListURLs(int n) {
        return this.getListURL(this.getList(n));
    }

    public List<URL> getListURLs(int n, int[] nArray) {
        return this.getListURL(this.getList(n, nArray));
    }

    public List<URL> getURLListForType(ArrayList<URL> arrayList, String string) {
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        for (URL uRL : arrayList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList2.add(uRL);
        }
        return arrayList2;
    }

    public ArrayList<ExtractObject> getSpatialMetaList(boolean bl, boolean bl2) {
        DDLTypes dDLTypes = this.getDDLTypes();
        if (!this.isDDLEnabled() || !dDLTypes.getTable()) {
            return null;
        }
        List<ExtractObject> list = this.getListForType(this.getList(0, new int[]{100}), "TABLE");
        ExtractConnectionAccessCatalog extractConnectionAccessCatalog = new ExtractConnectionAccessCatalog(list, true);
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (Connection connection : extractConnectionAccessCatalog.getConnections()) {
            StringBuffer stringBuffer = null;
            for (ExtractConnectionAccess extractConnectionAccess : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
                stringBuffer = new StringBuffer();
                string = "";
                if (extractConnectionAccess.getConnection() != connection || !extractConnectionAccess.isSchemaSpatial()) continue;
                string2 = extractConnectionAccess.getSchemaName();
                string3 = extractConnectionAccess.getConnectionUser();
                String string5 = extractConnectionAccess.getConnectionName();
                string4 = extractConnectionAccess.isConnOwner() ? USER_SDO_GEOM_META : NON_USER_SDO_GEOM_META;
                URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string5, null, bl2 ? extractConnectionAccess.getSchemaName() : this.getDestConnUser(), "TABLE");
                URL uRL2 = DBURLFormatHelper.getURL(uRL, string4);
                DBObject dBObject = new DBObject(uRL2);
                ExtractObject extractObject = new ExtractObject(dBObject, this);
                for (ExtractObject extractObject2 : list) {
                    if (!bl && extractObject2.isExistsDest() || extractObject2.getSourceConn() != connection || !extractObject2.getDBObject().getSchemaName().equals(extractConnectionAccess.getSchemaName())) continue;
                    stringBuffer.append(string + "'" + extractObject2.getDBObject().getObjectName() + "'");
                    string = ", ";
                }
                if (stringBuffer.length() <= 0) continue;
                extractObject.setProperty("KEY_SPATIAL_SOURCE_TABLE", string4);
                extractObject.setProperty("KEY_SPATIAL_SOURCE_SCHEMA", string2);
                extractObject.setProperty("SPATIAL_SOURCE_SCHEMA_WHERE", " AND OWNER = '" + string2 + "'");
                if (extractConnectionAccess.isConnOwner()) {
                    extractObject.setProperty("KEY_SPATIAL_IS_SOURCE_CONN_OWNER", true);
                } else {
                    extractObject.setProperty("KEY_SPATIAL_IS_SOURCE_CONN_OWNER", false);
                    extractObject.setColumns("OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                }
                if (!bl2) {
                    string2 = this._destConnUser;
                }
                extractObject.getColumns();
                if (string2.equals(this.getDestConnUser())) {
                    extractObject.setProperty("KEY_SPATIAL_IS_DEST_CONN_OWNER", true);
                    extractObject.setProperty("KEY_SPATIAL_DEST_TABLE", USER_SDO_GEOM_META);
                    extractObject.setProperty("KEY_SPATIAL_DEST_SCHEMA", "");
                    extractObject.setProperty("SPATIAL_DEST_DELETE", "delete from MDSYS.USER_SDO_GEOM_METADATA where TABLE_NAME IN(" + stringBuffer.toString() + ")");
                    extractObject.setProperty("SPATIAL_DEST_INSERT", " insert into MDSYS.USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) ");
                    extractObject.setColumns("TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                } else {
                    extractObject.setProperty("KEY_SPATIAL_IS_DEST_CONN_OWNER", false);
                    extractObject.setProperty("KEY_SPATIAL_DEST_TABLE", NON_USER_SDO_GEOM_META);
                    extractObject.setProperty("KEY_SPATIAL_DEST_SCHEMA", string2);
                    extractObject.setProperty("SPATIAL_DEST_DELETE", "delete from MDSYS.SDO_GEOM_METADATA_TABLE where SDO_TABLE_NAME IN(" + stringBuffer.toString() + ")" + " AND " + "SDO_OWNER" + " = " + "'" + string2 + "'");
                    extractObject.setProperty("SPATIAL_DEST_INSERT", " insert into MDSYS.SDO_GEOM_METADATA_TABLE (SDO_OWNER, SDO_TABLE_NAME, SDO_COLUMN_NAME, SDO_DIMINFO, SDO_SRID) ");
                    extractObject.setColumns("OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                }
                extractObject.setWhere("TABLE_NAME IN(" + stringBuffer.toString() + ")");
                arrayList.add(extractObject);
            }
        }
        return arrayList;
    }

    public boolean isExistsForType(ArrayList<URL> arrayList, String string) {
        for (URL uRL : arrayList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedExtractObjects(List<ExtractObject> list) {
        this._EOList = list;
    }

    public void setSelectExtractData(List<ExtractObject> list) {
        this.clearSelectExtractData();
        if (list == null) {
            return;
        }
        for (ExtractObject extractObject : list) {
            URL uRL = extractObject.getUrl();
            ExtractObject extractObject2 = this.getOrAddExtractObject(uRL);
            extractObject2.isExistsSource(true);
            extractObject2.isDataObject(true);
            extractObject2.isSelectedData(true);
            extractObject2.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractData() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedData(false);
            extractObject.isExtractData(false);
        }
        this._isSelectedData = false;
    }

    public void setSelectExtractMetaData(List<URL> list) {
        this.clearSelectExtractMetaData();
        if (list == null) {
            return;
        }
        for (URL uRL : list) {
            ExtractObject extractObject = this.getOrAddExtractObject(uRL);
            extractObject.isExistsSource(true);
            extractObject.isSelectedMetaData(true);
            extractObject.isExtractMetaData(true);
            this._isSelectedMetaData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractMetaData() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedMetaData(false);
            extractObject.isExtractMetaData(false);
        }
        this._isSelectedMetaData = false;
    }

    public void setSelectExtractBoth(List<URL> list) {
        this.clearSelectExtractBoth();
        if (list == null) {
            return;
        }
        for (URL uRL : list) {
            ExtractObject extractObject = this.getOrAddExtractObject(uRL);
            extractObject.isExistsSource(true);
            extractObject.isSelectedMetaData(true);
            extractObject.isExtractMetaData(true);
            this._isSelectedMetaData = true;
            if (!ExtractListModel.isDataObject(extractObject.getDBObject())) continue;
            extractObject.isSelectedData(true);
            extractObject.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void setSelectExtractBoth(ExtractObject extractObject) {
        if (extractObject == null) {
            return;
        }
        extractObject.isExistsSource(true);
        extractObject.isSelectedMetaData(true);
        extractObject.isExtractMetaData(true);
        this._isSelectedMetaData = true;
        if (ExtractListModel.isDataObject(extractObject.getDBObject())) {
            extractObject.isSelectedData(true);
            extractObject.isExtractData(true);
            this._isSelectedData = true;
        }
    }

    public void clearSelectExtractBoth() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedMetaData(false);
            extractObject.isSelectedData(false);
            extractObject.isExtractData(false);
            extractObject.isExtractMetaData(false);
            this._isSelectedData = false;
            this._isSelectedMetaData = false;
        }
    }

    private void cleanupExtractObjects() {
        ExtractObject extractObject = null;
        for (int i = this._EOList.size() - 1; i >= 0; --i) {
            extractObject = this._EOList.get(i);
            if (extractObject.isSelectedMetaData() || !(!extractObject.isSelectedData() & !extractObject.isPreSelected())) continue;
            this._EOList.remove(extractObject);
        }
    }

    public ExtractObject getExtractObject(URL uRL) {
        for (ExtractObject extractObject : this._EOList) {
            if (!uRL.equals(extractObject.getUrl())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(int n) {
        for (ExtractObject extractObject : this._EOList) {
            if (extractObject.getType() != n) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(List<ExtractObject> list, String string, String string2, String string3) {
        for (ExtractObject extractObject : list) {
            DBObject dBObject = extractObject.getDBObject();
            if (!string.equals(dBObject.getSchemaName()) || !string2.equals(dBObject.getObjectType()) || !string3.equals(dBObject.getObjectName())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(List<ExtractObject> list, String string, String string2) {
        for (ExtractObject extractObject : list) {
            DBObject dBObject = extractObject.getDBObject();
            if (!string.equals(dBObject.getObjectType()) || !string2.equals(dBObject.getObjectName())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        for (ExtractObject extractObject : this._EOList) {
            if (!uRL.equals(extractObject.getUrl())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getFirstDataObject() {
        for (ExtractObject extractObject : this._EOList) {
            if (!extractObject.isDataObject() && extractObject.getType() != 1 && !extractObject.isTypeDataFile()) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getFirstExtractObject() {
        Iterator<ExtractObject> iterator = this._EOList.iterator();
        if (iterator.hasNext()) {
            ExtractObject extractObject = iterator.next();
            return extractObject;
        }
        return null;
    }

    public DBObject getDBObject(URL uRL) {
        if (this._EOList != null) {
            for (ExtractObject extractObject : this._EOList) {
                DBObject dBObject = extractObject.getDBObject();
                if (dBObject == null || !dBObject.getURL().equals(uRL)) continue;
                return dBObject;
            }
        }
        return null;
    }

    public String getGlobalWhere() {
        return this._globalWhere;
    }

    public void setGlobalWhere(String string) {
        int n = string.trim().toLowerCase().indexOf("where");
        this._globalWhere = n != 0 ? string : string.substring(n + 6);
    }

    public Object getPropertyValue(String string) {
        return this._extendedProperties.get(string);
    }

    public void setProperty(String string, Object object) {
        this._extendedProperties.put(string, object);
    }

    public Set<String> getPropertyKeySet() {
        return this._extendedProperties.keySet();
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(this.getConnectionsNode());
        if (this.isDDLEnabled()) {
            defaultMutableTreeNode.add(this.getDDLFormatNode());
        }
        defaultMutableTreeNode.add(this.getMetaNode());
        if (this.isDataEnabled()) {
            defaultMutableTreeNode.add(this.getDataNode());
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getConnectionsNode() {
        String string;
        JLabel jLabel;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("CONNECTIONS"));
        if (this.getSourceConn() != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this.getSourceConn()));
            jLabel.setText(ExtractResources.getString("SOURCE") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon("CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        if (this._destConn != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._destConn));
            jLabel.setText(ExtractResources.getString("DEST") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon("CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDDLFormatNode() {
        DDLFormat dDLFormat = this.getDDLFormat();
        return dDLFormat.getSummaryNode();
    }

    public DefaultMutableTreeNode getSummaryGlobalWhere() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("EO_PRED_GLOBAL_WHERE") + " " + this._globalWhere);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getMetaNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("DDL_OBJECTS"));
        List<String> list = this.getDDLTypes().getTypeList();
        for (String string : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypes.getFolderLabel(string));
            List<JLabel> list2 = this.getSummaryMetaObjectByType(string);
            for (JLabel jLabel : list2) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDataFormatNode() {
        ExtractDataFormat extractDataFormat = this.getDataFormat();
        return extractDataFormat.getSummaryNode(this);
    }

    public DefaultMutableTreeNode getDataNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("DATA_OBJECTS"));
        List<String> list = this.getDDLTypes().getTypeListForData();
        for (String string : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypes.getFolderLabel(string));
            List<DefaultMutableTreeNode> list2 = this.getSummaryDataNodeByType(string);
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : list2) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public List<JLabel> getSummaryMetaObjectByType(String string) {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        List<ExtractObject> list = this.getList(0, new int[]{108});
        List<ExtractObject> list2 = this.getListForType(this.getList(0), "TABLE");
        List<ExtractObject> list3 = this.getListForType(list, string);
        if (list3.size() < 1) {
            if (list2.isEmpty()) {
                arrayList.add(this.getAllObjectsLabel(string));
            } else if (string == "CONSTRAINT" || string == "REFCONSTRAINT" || string == "INDEX" || string == "TRIGGER") {
                for (ExtractObject extractObject : list2) {
                    String string2 = extractObject.getSourceConnName();
                    DBObject dBObject = this.getDBObject(extractObject.getUrl());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, dBObject.getSchemaName(), string);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                    DBObject dBObject2 = new DBObject(uRL2);
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject2.getURL()));
                    jLabel.setText(ExtractResources.format("FOR", DDLTypes.getFolderName(string), dBObject2.getObjectName()));
                    arrayList.add(jLabel);
                }
            } else {
                arrayList.add(this.getAllObjectsLabel(string));
            }
        } else {
            for (ExtractObject extractObject : list3) {
                arrayList.add(extractObject.getLabel());
            }
        }
        return arrayList;
    }

    public List<JLabel> getSummaryMetaObjectForType(List<ExtractObject> list, String string, boolean bl) {
        ArrayList<JLabel> arrayList;
        block5: {
            List<ExtractObject> list2;
            block4: {
                arrayList = new ArrayList<JLabel>();
                List<ExtractObject> list3 = this.getListForType(list, "TABLE");
                list2 = this.getListForType(list, string);
                if (list2.size() >= 1) break block4;
                if (list3.isEmpty() || string != "CONSTRAINT" && string != "REFCONSTRAINT" && string != "INDEX" && string != "TRIGGER") break block5;
                for (ExtractObject extractObject : list3) {
                    String string2 = extractObject.getSourceConnName();
                    DBObject dBObject = this.getDBObject(extractObject.getUrl());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, dBObject.getSchemaName(), string);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                    DBObject dBObject2 = new DBObject(uRL2);
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject2.getURL()));
                    DBObject dBObject3 = extractObject.getDBObject();
                    if (dBObject3.getElement() != null && dBObject3.getElement() instanceof ObjectFolder) {
                        jLabel.setText(ExtractResources.format("FOR_ALL_FOLDER", DDLTypes.getFolderName(string), DDLTypes.getFolderName(dBObject3.getObjectFolderType()), Connections.getDisplayName(dBObject3.getConnectionName()) + "." + dBObject3.getSchemaName()));
                    } else {
                        jLabel.setText(ExtractResources.format("FOR", DDLTypes.getFolderName(string), extractObject.getDisplayName(bl)));
                    }
                    arrayList.add(jLabel);
                }
                break block5;
            }
            for (ExtractObject extractObject : list2) {
                arrayList.add(extractObject.getLabel(bl));
            }
        }
        return arrayList;
    }

    public List<DefaultMutableTreeNode> getSummaryDataNodeByType(String string) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        List<ExtractObject> list = this.getList(0, new int[]{109});
        List<ExtractObject> list2 = this.getListForType(list, string);
        if (list2.size() < 1) {
            arrayList.add(new DefaultMutableTreeNode(this.getAllObjectsLabel(string)));
        } else {
            for (ExtractObject extractObject : list2) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(extractObject.getLabel());
                if (extractObject.getWhere().length() > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ExtractResources.getString("EO_PRED_OBJ_WHERE") + " " + extractObject.getWhere());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                arrayList.add(defaultMutableTreeNode);
            }
        }
        return arrayList;
    }

    public static DefaultMutableTreeNode getSummaryBooleanItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, Icon icon, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(icon);
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, String string2) {
        return ExtractListModel.getSummaryLabelItem(string, OracleIcons.getIcon((String)"attribute.png"), string2);
    }

    public void finish() {
    }

    public boolean isTypeDBO() {
        return this._dataObjectType == 0;
    }

    public boolean isTypeQuery() {
        return this._dataObjectType == 1;
    }

    public boolean isAllowLobs() {
        return this._isAllowLobs;
    }

    public void isAllowLobs(boolean bl) {
        if (!this._isAllowLobs == bl) {
            for (ExtractObject extractObject : this._EOList) {
                extractObject.isDataPrepared(false);
            }
        }
        this._isAllowLobs = bl;
    }

    public boolean isPreSelected() {
        return this._isPreSelected;
    }

    public boolean isPreSelectedDataExtractable() {
        return this._isPreSelectedDataExtractable;
    }

    public boolean isSelectedMetaData() {
        return this._isSelectedMetaData;
    }

    public boolean isSelectedData() {
        return this._isSelectedData;
    }

    public boolean isSourceConnOracle() {
        return this._isSourceConnOracle;
    }

    public boolean isSourceConnTimesTen() {
        return this._isSourceConnTimesTen;
    }

    private void setSourceConnectionProperties(String string) {
        this._sourceConnName = string;
        this._sourceConnUser = "";
        this._isSourceConnOracle = Connections.getInstance().isOracle(this._sourceConnName);
        this._isSourceConnTimesTen = Connections.getInstance().isTimesTen(this._sourceConnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionUser(Connection connection) {
        boolean bl = false;
        String string = "";
        try {
            if (connection != null) {
                if (connection instanceof OracleConnection) {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string2 = dBUtil.executeReturnOneCol("select USER from dual");
                    if (string2 != null) {
                        String string3 = string2;
                        return string3;
                    }
                }
                if (bl = Connections.getInstance().lock(connection, true)) {
                    string = connection.getMetaData().getUserName();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    private void setDestConnectionProperties(String string) {
        this._destConnName = string;
        this._destConnUser = "";
        try {
            this._destConn = Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this._destConnUser = "";
        this._isDestConnOracle = Connections.getInstance().isOracle(this._destConnName);
        this._isDestConnTimesTen = Connections.getInstance().isTimesTen(this._destConnName);
    }

    public List<ExtractObject> getCreateProcessList(int n, int[] nArray) {
        return this.getCreateProcessList(this.getList(0, nArray), n);
    }

    public List<ExtractObject> getCreateProcessList(List<ExtractObject> list, int n) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        List<String> list2 = this._ddlTypes.getTypes(n);
        for (String string : list2) {
            ArrayList arrayList2 = (ArrayList)this.getListForType(list, string);
            for (ExtractObject extractObject : arrayList2) {
                arrayList.add(extractObject);
            }
        }
        return arrayList;
    }

    private JLabel getAllObjectsLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(this.getAllObjectsString(string));
        return jLabel;
    }

    public String getAllObjectsString(String string) {
        return ExtractResources.getString("ALL") + " " + DDLTypes.getFolderName(string);
    }

    private List<URL> getListURL(List<ExtractObject> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (list != null && !list.isEmpty()) {
            for (ExtractObject extractObject : list) {
                DBObject dBObject = extractObject.getDBObject();
                URL uRL = dBObject.getURL();
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    private void initForDBObjects(DBObject dBObject) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dBObject.getConnectionName());
        this.addExtractObjectPreSelected(dBObject);
    }

    private void initForDBObjects(DBObject[] dBObjectArray) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dBObjectArray[0].getConnectionName());
        for (DBObject dBObject : dBObjectArray) {
            this.addExtractObjectPreSelected(dBObject);
        }
    }

    private void initForDBObjects(List<DBObject> list) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(list.get(0).getConnectionName());
        for (DBObject dBObject : list) {
            this.addExtractObjectPreSelected(dBObject);
        }
    }

    private void initForDBObjects() {
        this._dataObjectType = 0;
        this._isPreSelected = true;
    }

    public ExtractObject getOrAddExtractObject(DBObject dBObject, int[] nArray) {
        ExtractObject extractObject = this.getOrAddExtractObject(dBObject);
        block7: for (int n : nArray) {
            switch (n) {
                case 100: {
                    extractObject.isExtractMetaData(true);
                    continue block7;
                }
                case 101: {
                    extractObject.isExtractData(true);
                    continue block7;
                }
                case 102: {
                    extractObject.isDataObject(true);
                    continue block7;
                }
                case 103: {
                    extractObject.isExistsSource(true);
                    continue block7;
                }
                case 104: {
                    extractObject.isExistsDest(true);
                }
            }
        }
        return extractObject;
    }

    private void addExtractObjectPreSelected(DBObject dBObject) {
        ExtractObject extractObject = this.getOrAddExtractObject(dBObject);
        if (ExtractListModel.isDataObject(dBObject)) {
            this._isPreSelectedDataExtractable = true;
            this._isSelectedData = true;
            extractObject.isDataObject(true);
            extractObject.isExtractData(true);
            extractObject.isSelectedData(true);
        }
        extractObject.isExistsSource(true);
        extractObject.isPreSelected(true);
        extractObject.isExtractMetaData(true);
        extractObject.isSelectedMetaData(true);
        this._isSelectedMetaData = true;
    }

    public ExtractObject getOrAddExtractObject(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        ExtractObject extractObject = this.getExtractObject(uRL);
        if (extractObject == null) {
            extractObject = this.addExtractObject(dBObject);
        }
        return extractObject;
    }

    public ExtractObject getOrAddExtractObject(URL uRL) {
        ExtractObject extractObject = this.getExtractObject(uRL);
        if (extractObject == null) {
            extractObject = this.addExtractObject(uRL);
        }
        return extractObject;
    }

    public ExtractObject getOrAddExtractObject(int n) {
        ExtractObject extractObject = this.getExtractObject(n);
        if (extractObject == null) {
            extractObject = this.addExtractObject(n);
        }
        return extractObject;
    }

    private ExtractObject addExtractObject(DBObject dBObject) {
        ExtractObject extractObject = new ExtractObject(dBObject, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    private ExtractObject addExtractObject(URL uRL) {
        ExtractObject extractObject = new ExtractObject(uRL, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    private ExtractObject addExtractObject(int n) {
        ExtractObject extractObject = new ExtractObject(n, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    public boolean removeExtractObject(ExtractObject extractObject) {
        return this._EOList.remove(extractObject);
    }

    public static boolean isDataObject(DBObject dBObject) {
        if (dBObject == null) {
            return false;
        }
        return "TABLE".equals(dBObject.getObjectType()) || "VIEW".equals(dBObject.getObjectType()) || "MATERIALIZED VIEW".equals(dBObject.getObjectType());
    }

    public static boolean isDataFolder(DBObject dBObject) {
        if (dBObject == null) {
            return false;
        }
        String string = dBObject.getObjectFolderType();
        return string.equals("TABLE") || string.equals("VIEW") || string.equals("MATERIALIZED VIEW");
    }

    public boolean isDestConnOracle() {
        return this._isDestConnOracle;
    }

    public boolean isDestConnTimesTen() {
        return this._isDestConnTimesTen;
    }
}

