/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.ide.util.ResourceUtils;

public class DdlOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    protected JCheckBox _exportDDL = new JCheckBox();
    protected JCheckBox _schema = new JCheckBox();
    protected JCheckBox _segments = new JCheckBox();
    protected JCheckBox _terminiator = new JCheckBox();
    protected JCheckBox _pretty = new JCheckBox();
    protected JCheckBox _byte = new JCheckBox();
    protected JCheckBox _force = new JCheckBox();
    protected JCheckBox _drop = new JCheckBox();
    protected JCheckBox _cascade = new JCheckBox();
    protected JCheckBox _grant = new JCheckBox();
    protected JCheckBox _dep = new JCheckBox();
    protected JCheckBox _constraint = new JCheckBox();
    protected JCheckBox _refConstraint = new JCheckBox();
    protected JCheckBox _trigger = new JCheckBox();
    protected JCheckBox _dummy1 = new JCheckBox();
    protected JCheckBox _dummy2 = new JCheckBox();
    protected JCheckBox _dummy3 = new JCheckBox();
    protected JCheckBox _alter = new JCheckBox();
    protected JCheckBox _truncate = new JCheckBox();
    protected JComboBox<String> _version = new JComboBox();
    protected JLabel _versionLabel = new JLabel();
    protected DDLFormat _format;
    protected int _usage;
    private static final String s10_1 = "10.1";
    private static final String s10_2 = "10.2";
    private static final String s11_1 = "11.1";
    private static final String s11_2 = "11.2";
    private static final String s12_1 = "12.1";
    private static final String s12_2 = "12.2";
    private static final Version v10_1 = new Version("10.1");
    private static final Version v10_2 = new Version("10.2");
    private static final Version v11_1 = new Version("11.1");
    private static final Version v11_2 = new Version("11.2");
    private static final Version v12_1 = new Version("12.1");
    private static final Version v12_2 = new Version("12.2");

    public DdlOptionsPanel(DDLFormat dDLFormat) {
        this._usage = WIZARD;
        this._format = dDLFormat;
        this.initVersionComponent();
    }

    public DdlOptionsPanel(int n) {
        this._usage = n;
        this._format = new DDLFormat();
        this.initVersionComponent();
    }

    public JCheckBox getExportDDLComponent() {
        return this._exportDDL;
    }

    public JCheckBox getSchemaComponent() {
        return this._schema;
    }

    public void setUsage(int n) {
        this._usage = n;
    }

    public DDLFormat getFormat() {
        this._format.isExtractEnabled(this._exportDDL.isSelected());
        this._format.setAlter(this._alter.isSelected());
        this._format.setForce(this._force.isSelected());
        this._format.setByte(this._byte.isSelected());
        this._format.setPretty(this._pretty.isSelected());
        this._format.setTerminiator(this._terminiator.isSelected());
        this._format.setSegments(this._segments.isSelected());
        this._format.setSchema(this._schema.isSelected());
        this._format.setDrop(this._drop.isSelected());
        this._format.setCascade(this._cascade.isSelected());
        this._format.setGrant(this._grant.isSelected());
        this._format.setDep(this._dep.isSelected());
        this._format.setConstraint(this._constraint.isSelected());
        this._format.setRefConstraint(this._refConstraint.isSelected());
        this._format.setTrigger(this._trigger.isSelected());
        this._format.setTruncate(this._truncate.isSelected());
        this._format.setVersion((String)this._version.getSelectedItem());
        return this._format;
    }

    public void setFormat(DDLFormat dDLFormat) {
        this._exportDDL.setSelected(dDLFormat.isExtractEnabled());
        this._alter.setSelected(dDLFormat.getAlter());
        this._force.setSelected(dDLFormat.getForce());
        this._byte.setSelected(dDLFormat.getByte());
        this._pretty.setSelected(dDLFormat.getPretty());
        this._terminiator.setSelected(dDLFormat.getTerminator());
        this._segments.setSelected(dDLFormat.getSegments());
        this._schema.setSelected(dDLFormat.getSchema());
        this._drop.setSelected(dDLFormat.getDrop());
        this._cascade.setSelected(dDLFormat.getCascade());
        this._grant.setSelected(dDLFormat.getGrant());
        this._dep.setSelected(dDLFormat.getDep());
        this._constraint.setSelected(dDLFormat.getConstraint());
        this._refConstraint.setSelected(dDLFormat.getRefConstraint());
        this._trigger.setSelected(dDLFormat.getTrigger());
        this._truncate.setSelected(dDLFormat.getTruncate());
        this._version.setSelectedItem(dDLFormat.getVersion());
    }

    protected void initComponents() {
        String string = ExportWizArb.getString("OPT_TITLE");
        if (this._usage == PREFERENCES && this._format.getPreference() != 3) {
            string = ExportWizArb.getString("OPT_TITLE_PREF");
        } else if (this._usage == PREFERENCES) {
            string = ExportWizArb.getString("DEPLOY_OPT_TITLE_PREF");
        }
        ResourceUtils.resButton((AbstractButton)this._exportDDL, (String)string);
        ResourceUtils.resButton((AbstractButton)this._schema, (String)DDLFormat.getLabelText(DDLFormat.SCHEMA));
        ResourceUtils.resButton((AbstractButton)this._segments, (String)DDLFormat.getLabelText(DDLFormat.STORAGE));
        ResourceUtils.resButton((AbstractButton)this._terminiator, (String)DDLFormat.getLabelText(DDLFormat.TERM));
        ResourceUtils.resButton((AbstractButton)this._pretty, (String)DDLFormat.getLabelText(DDLFormat.PRETTY));
        ResourceUtils.resButton((AbstractButton)this._byte, (String)DDLFormat.getLabelText(DDLFormat.BYTE));
        ResourceUtils.resButton((AbstractButton)this._force, (String)DDLFormat.getLabelText(DDLFormat.FORCE));
        ResourceUtils.resButton((AbstractButton)this._alter, (String)DDLFormat.getLabelText(DDLFormat.ALTER));
        ResourceUtils.resButton((AbstractButton)this._drop, (String)DDLFormat.getLabelText(DDLFormat.DROP));
        ResourceUtils.resButton((AbstractButton)this._cascade, (String)DDLFormat.getLabelText(DDLFormat.CASCADE));
        ResourceUtils.resButton((AbstractButton)this._grant, (String)DDLFormat.getLabelText(DDLFormat.GRANT));
        ResourceUtils.resButton((AbstractButton)this._dep, (String)DDLFormat.getLabelText(DDLFormat.DEPS));
        ResourceUtils.resButton((AbstractButton)this._constraint, (String)DDLFormat.getLabelText(DDLFormat.CONS));
        ResourceUtils.resButton((AbstractButton)this._refConstraint, (String)DDLFormat.getLabelText(DDLFormat.REF_CONS));
        ResourceUtils.resButton((AbstractButton)this._trigger, (String)DDLFormat.getLabelText(DDLFormat.TRIG));
        ResourceUtils.resButton((AbstractButton)this._truncate, (String)DDLFormat.getLabelText(DDLFormat.TRUNCATE));
        ResourceUtils.resLabel((JLabel)this._versionLabel, this._version, (String)DDLFormat.getLabelText(DDLFormat.VERSION));
    }

    private void initVersionComponent() {
        this.setVersionList(null);
        this._version.setToolTipText(ExtractResources.getString("VERSION_TIP"));
    }

    public void setVersionList(Version version) {
        this._version.removeAllItems();
        this._version.addItem(DDLFormat.COMPATIBLE);
        this._version.addItem(DDLFormat.LATEST);
        if (version != null) {
            if (version.compareTo(v10_1) > 0) {
                this._version.addItem(s10_1);
            }
            if (version.compareTo(v10_2) > 0) {
                this._version.addItem(s10_2);
            }
            if (version.compareTo(v11_1) > 0) {
                this._version.addItem(s11_1);
            }
            if (version.compareTo(v11_2) > 0) {
                this._version.addItem(s11_2);
            }
            if (version.compareTo(v12_1) > 0) {
                this._version.addItem(s12_1);
            }
            if (version.compareTo(v12_2) > 0) {
                this._version.addItem(s12_2);
            }
        }
    }

    public boolean getSchema() {
        return this._schema.isSelected();
    }

    public boolean getSegments() {
        return this._segments.isSelected();
    }

    public boolean getPretty() {
        return this._pretty.isSelected();
    }

    public boolean getTerminator() {
        return this._terminiator.isSelected();
    }

    public boolean getByte() {
        return this._byte.isSelected();
    }

    public boolean getForce() {
        return this._force.isSelected();
    }

    public boolean getAlter() {
        return this._alter.isSelected();
    }

    public boolean getTruncate() {
        return this._truncate.isSelected();
    }

    public boolean getDrop() {
        return this._drop.isSelected();
    }

    public boolean getCascade() {
        return this._cascade.isSelected();
    }

    public boolean getGrant() {
        return this._grant.isSelected();
    }

    public boolean getDep() {
        return this._dep.isSelected();
    }

    public boolean getConstraint() {
        return this._constraint.isSelected();
    }

    public boolean getRefConstraint() {
        return this._refConstraint.isSelected();
    }

    public boolean getTrigger() {
        return this._trigger.isSelected();
    }

    public void setSchema(boolean bl) {
        this._schema.setSelected(bl);
    }

    public void setSegments(boolean bl) {
        this._segments.setSelected(bl);
    }

    public void setPretty(boolean bl) {
        this._pretty.setSelected(bl);
    }

    public void setTerminator(boolean bl) {
        this._terminiator.setSelected(bl);
    }

    public void setByte(boolean bl) {
        this._byte.setSelected(bl);
    }

    public void setForce(boolean bl) {
        this._force.setSelected(bl);
    }

    public void setAlter(boolean bl) {
        this._alter.setSelected(bl);
    }

    public void setTruncate(boolean bl) {
        this._truncate.setSelected(bl);
    }

    public void setDrop(boolean bl) {
        this._drop.setSelected(bl);
    }

    public void setCascade(boolean bl) {
        this._cascade.setSelected(bl);
    }

    public void setGrant(boolean bl) {
        this._grant.setSelected(bl);
    }

    public void setDep(boolean bl) {
        this._dep.setSelected(bl);
    }

    public void setConstraint(boolean bl) {
        this._constraint.setSelected(bl);
    }

    public void setRefConstraint(boolean bl) {
        this._refConstraint.setSelected(bl);
    }

    public void setTrigger(boolean bl) {
        this._trigger.setSelected(bl);
    }

    public void setVersion(String string) {
        this._version.setSelectedItem(string);
    }

    public void enableSchema(boolean bl) {
        this._schema.setEnabled(bl);
    }

    public void enableOptions(boolean bl) {
        this._schema.setEnabled(bl);
        this._segments.setEnabled(bl);
        this._terminiator.setEnabled(bl);
        this._pretty.setEnabled(bl);
        this._byte.setEnabled(bl);
        this._force.setEnabled(bl);
        this._alter.setEnabled(bl);
        this._drop.setEnabled(bl);
        this._cascade.setEnabled(bl);
        this._grant.setEnabled(bl);
        this._dep.setEnabled(bl);
        this._constraint.setEnabled(bl);
        this._refConstraint.setEnabled(bl);
        this._trigger.setEnabled(bl);
        this._versionLabel.setEnabled(bl);
        this._version.setEnabled(bl);
    }
}

