/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.panels.TypeOptionsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public abstract class ExtractWizTypesPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    protected final JCheckBox cbGoToSummary = new JCheckBox();
    protected TypeOptionsPanel _typeOptions = new TypeOptionsPanel();
    protected TraversableContext _dataContext;
    protected DDLTypes _ddlType;
    private Map<String, String> types;

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._ddlType = this._typeOptions.getDDLType();
        ExtractListModel extractListModel = this.getListModel();
        if (extractListModel != null) {
            extractListModel.setDDLTypes(this._ddlType);
        }
        this.types = this._ddlType.getTypes(false);
        if (this.types.size() == 0) {
            throw new TraversalException(UiResources.getString("TYPE_REQUIRED"));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this._dataContext == null) {
            this._dataContext = traversableContext;
        }
        this.removeAll();
        this.buildPanel();
        this.repaint();
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        traversableContext.getWizardCallbacks().wizardSetInitialFocus((Component)this._typeOptions);
    }

    public abstract Object getExitTransition();

    protected DDLTypes getDDLTypes() {
        ExtractListModel extractListModel = this.getListModel();
        if (extractListModel.getDDLTypes() == null) {
            DDLTypes dDLTypes = new DDLTypes();
            extractListModel.setDDLTypes(dDLTypes);
        }
        return extractListModel.getDDLTypes();
    }

    protected void setTypesToShow() {
    }

    private void buildPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        if (this._ddlType == null) {
            this._ddlType = this.getDDLTypes();
        }
        this.setTypesToShow();
        this._typeOptions.setDDLType(this._ddlType);
        jPanel.add((Component)this._typeOptions.getPanel(), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, n, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.5, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(this.createInstructions(), "North");
        this.add(jPanel, "Center");
        ResourceUtils.resButton((AbstractButton)this.cbGoToSummary, (String)UiResources.getString("GOTO_SUMMARY"));
        this.add(this.cbGoToSummary, "South");
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(UiResources.getString("TYPES_INSTRUCTIONS"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    protected ExtractListModel getListModel() {
        return (ExtractListModel)this._dataContext.get("EXTRACT_LIST_MODEL");
    }
}

