/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.util.Service;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.TextTabber;
import oracle.javatools.editor.insight.ListInsightData;

public class DBListInsightData
implements ListInsightData {
    private Logger logger = Logger.getLogger(DBListInsightData.class.getName());
    protected ListModel instance = new ListModel(){

        public Object getElementAt(int n) {
            if (n >= DBListInsightData.this._matchingDataList.length || n < 0) {
                return null;
            }
            return DBListInsightData.this._matchingDataList[n];
        }

        @Override
        public int getSize() {
            return DBListInsightData.this._matchingDataList.length;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }
    };
    protected SuggestedItem[] _matchingDataList;
    final CompletionInsight _insight;
    private boolean completedOnce = false;
    private static final EditDescriptor _editDescriptor = new EditDescriptor("Undo Completion");

    DBListInsightData(CompletionInsight completionInsight) {
        this._insight = completionInsight;
    }

    public Object[] getData() {
        return this.getMatchingData();
    }

    public Object[] getMatchingData() {
        int n = this._insight.getAliacedPrefix().length();
        if (n > 0) {
            int n2;
            LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
            for (SuggestedItem suggestedItem : this._matchingDataList) {
                if ("...".equals(suggestedItem.getName()) || "TEMPLATE".equals(suggestedItem.getType())) {
                    linkedList.add(suggestedItem);
                    continue;
                }
                int n3 = n;
                if ("".equals(suggestedItem.getOwner())) {
                    n3 = this._insight.identifierPrefix.length();
                }
                suggestedItem.setPrefixLength(n3);
                linkedList.add(suggestedItem);
            }
            if (this._insight.wasAutoInvoked && (n2 = DBConfig.getInstance().getInt("MAXTRIGGERCOMPLETIONLISTSIZE")) < linkedList.size()) {
                return new SuggestedItem[0];
            }
            this._matchingDataList = new SuggestedItem[linkedList.size()];
            int n4 = 0;
            for (SuggestedItem suggestedItem : linkedList) {
                this._matchingDataList[n4++] = suggestedItem;
            }
        }
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object object) {
        if (this.completedOnce) {
            return false;
        }
        this.completedOnce = true;
        SuggestedItem suggestedItem = (SuggestedItem)object;
        String string = suggestedItem.format();
        String string2 = suggestedItem.getType();
        if (string.startsWith("...")) {
            if (string2.equals("SNIPPET")) {
                this._insight.raiseSlimit = true;
            } else if (string2.equals("HISTORY")) {
                this._insight.raiseHlimit = true;
            } else if (string2.equals("TEMPLATE")) {
                this._insight.raiseTlimit = true;
            } else {
                this._insight.raiselimit = true;
            }
            final BasicEditorPane basicEditorPane = this._insight.getEditorPane();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    basicEditorPane.invokeAction("completion-insight");
                }
            };
            SwingUtilities.invokeLater(runnable);
            return false;
        }
        BasicDocument basicDocument = this._insight.getDocument();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        basicEditorPane.beginEdit(DBListInsightData.getEditDescriptor());
        try {
            int n2;
            int n3;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n4 : this._insight.getInsightView().getSelectedIndices()) {
                hashSet.add(n4);
            }
            Object object2 = new LinkedList();
            for (int n5 : this._insight.selectionOrder) {
                if (!hashSet.contains(n5)) continue;
                object2.add(n5);
            }
            this._insight.selectionOrder.clear();
            if (n < this._insight.startCaretPosition) {
                boolean bl = false;
                return bl;
            }
            int n6 = suggestedItem.getPrefixLength();
            if ("TEMPLATE".equals(suggestedItem.getType())) {
                n6 = n - this._insight.startCaretPosition;
            }
            if (object2.size() > 1) {
                int n4;
                string = "";
                String[] stringArray = new String[object2.size()];
                n4 = 0;
                String[] stringArray2 = object2.iterator();
                while (stringArray2.hasNext()) {
                    n3 = (Integer)stringArray2.next();
                    stringArray[n4++] = this._matchingDataList[n3].toString();
                }
                stringArray2 = this.generateAliases(stringArray);
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    String string3 = stringArray[n3];
                    string = string3.indexOf(61) >= 0 ? string + (n3 == 0 ? "" : " AND ") + string3 : string + (n3 == 0 ? "" : ", ") + string3 + " " + stringArray2[n3];
                }
            }
            string = string.replace(SuggestedItem.getPlaceholderPrefix(), "[");
            string = string.replace(SuggestedItem.placeholderSuffix, "]");
            string = string.replace("&lt;", "<");
            if ((string = string.replace("&gt;", ">")).toUpperCase().startsWith("PUBLIC.")) {
                string = string.substring("PUBLIC.".length());
            }
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            StringBuilder stringBuilder = new StringBuilder();
            if (!(string.indexOf(32) <= 0 || "SNIPPET".equals(string2) || "HISTORY".equals(string2) || "TEMPLATE".equals(string2) || "ARGUMENT".equals(string2))) {
                try {
                    string = CustomFormat.getInstance().format(string);
                    int n7 = string.indexOf("\n/***");
                    if (0 < n7) {
                        n3 = string.indexOf("***/") + "***/".length();
                        string = string.substring(0, n7) + string.substring(n3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string4 = ProcedureExtractor.indent(n, basicEditorPane);
            string = string.replace("\n", "\n" + string4);
            if ("ARGUMENT".equals(string2) && !this.balancedParen(this._insight.parser.src)) {
                string = string + "\n" + string4 + ");";
            }
            n3 = n - n6;
            if (n6 > 0 && basicDocument.getText(n3, n6).contains("\n")) {
                n3 = DBListInsightData.tokenStart(this._insight.parser.src, n3);
            }
            if ((n2 = DBListInsightData.dotNameOffset(this._insight.parser.src, n3, string)) < 0) {
                n3 += n2;
                n6 -= n2;
            } else {
                int n8 = DBListInsightData.ownerOffset(this._insight.parser.src, n3, string);
                if (0 < n8) {
                    n3 += n8;
                    n6 -= n8;
                }
            }
            basicDocument.remove(n3, n6);
            if (string.indexOf("]") > 0) {
                TextTabber textTabber = new TextTabber(basicEditorPane);
                int n9 = 0;
                int n10 = -1;
                int n11 = 0;
                while ((n10 = string.indexOf("[", n9)) >= 0) {
                    stringBuilder.append(string.substring(n9, n10));
                    n9 = string.indexOf("]", n10) + "]".length();
                    linkedList.add(Service.pair((int)(n3 + n10 - n11), (int)(n3 + n9 - "]".length() - "[".length() - n11)));
                    stringBuilder.append(string.substring(n10 + "[".length(), n9 - "]".length()));
                    n11 += "[".length() + "]".length();
                }
                stringBuilder.append(string.substring(n9));
                basicDocument.insertString(n3, stringBuilder.toString(), null);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    int n12 = (Integer)iterator.next();
                    textTabber.addRange(Service.X((int)n12), Service.Y((int)n12));
                }
                textTabber.setActive(true);
            } else {
                basicDocument.insertString(n3, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.warning("Exception occurred in completion: " + badLocationException);
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    private boolean balancedParen(List<LexerToken> list) {
        if (list == null) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        for (LexerToken lexerToken : list) {
            if ("(".equals(lexerToken.content)) {
                ++n;
            }
            if (!")".equals(lexerToken.content)) continue;
            ++n2;
        }
        return n <= n2;
    }

    private static int tokenStart(List<LexerToken> list, int n) {
        int n2 = n;
        if (list == null) {
            return n2;
        }
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin > n) break;
            if (lexerToken.type == Token.WS) continue;
            n2 = lexerToken.begin;
        }
        return n2;
    }

    private static int dotNameOffset(List<LexerToken> list, int n, String string) {
        if (list == null) {
            return 0;
        }
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return 0;
        }
        String string2 = string.substring(0, n2).toLowerCase();
        String string3 = null;
        String string4 = null;
        for (LexerToken lexerToken : list) {
            if (n <= lexerToken.begin) break;
            string3 = string4;
            string4 = lexerToken.content;
        }
        if (!".".equals(string4)) {
            return 0;
        }
        if (!string2.equals(string3.toLowerCase())) {
            return 0;
        }
        return -string2.length() - 1;
    }

    private static int ownerOffset(List<LexerToken> list, int n, String string) {
        if (list == null) {
            return 0;
        }
        String string2 = null;
        String string3 = null;
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin < n) continue;
            if (string3 != null) {
                if (string.toLowerCase().startsWith(lexerToken.content.toLowerCase())) break;
                return 0;
            }
            if (string2 == null) {
                string2 = lexerToken.content;
                continue;
            }
            string3 = lexerToken.content;
        }
        if (!".".equals(string3)) {
            return 0;
        }
        if (string.toLowerCase().startsWith(string2.toLowerCase())) {
            return 0;
        }
        return string2.length() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private String[] generateAliases(String[] stringArray) {
        String string7;
        String string2 = this._insight.prior.content.toUpperCase();
        if (!DBConfig.getInstance().getBoolean("AUTOGENERATEALIASES").booleanValue() || !"SELECT".equals(string2) && !"FROM".equals(string2)) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = "";
            }
            return stringArray2;
        }
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i].indexOf(".") > 0 ? stringArray[i].substring(stringArray[i].lastIndexOf(".") + 1) : stringArray[i];
        }
        String string3 = stringArray3[0];
        for (String stringArray4 : stringArray3) {
            string3 = DBListInsightData.commonPrefix(string3, stringArray4);
        }
        int n = 1;
        int n2 = 1;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string4 : stringArray3) {
            String string5 = string7 = string4.length() >= string3.length() + n ? string4.substring(string3.length(), string3.length() + n) : string4.substring(0, n);
            if (string7.startsWith("_")) {
                n2 = 0;
            }
            if (n2 == 0) {
                string7 = string3 + string7;
            }
            if (linkedList.contains(string7)) {
                linkedList = new LinkedList();
                ++n;
                break;
            }
            linkedList.add(string7);
        }
        n2 = 1;
        if (n == 2) {
            for (String string4 : stringArray3) {
                String string6 = string7 = string4.length() >= string3.length() + n ? string4.substring(string3.length(), string3.length() + n) : string4.substring(0, n);
                if (string7.startsWith("_")) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    string7 = string3 + string7;
                }
                if (linkedList.contains(string7)) {
                    linkedList = new LinkedList();
                    ++n;
                    break;
                }
                linkedList.add(string7);
            }
        }
        n2 = 1;
        if (n == 3) {
            boolean bl = true;
            for (String string7 : stringArray3) {
                void var8_18;
                String string8;
                String string9 = string8 = string7.length() >= string3.length() + n ? string7.substring(string3.length(), string3.length() + n) : string7.substring(0, n);
                if (string8.startsWith("_")) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    string8 = string3 + string8;
                }
                if (!linkedList.contains(string8)) {
                    linkedList.add(string8);
                    continue;
                }
                linkedList.add(string8 + (int)(++var8_18));
            }
        }
        return linkedList.toArray(new String[0]);
    }

    private static String commonPrefix(String string, String string2) {
        if (string2.startsWith(string)) {
            return string;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return "";
        }
        return DBListInsightData.commonPrefix(string.substring(0, string.length() - 1), string2);
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return this.instance;
    }

    protected void setData(SuggestedItem[] suggestedItemArray) {
        int n;
        if (this._insight.wasAutoInvoked && (n = DBConfig.getInstance().getInt("MAXTRIGGERCOMPLETIONLISTSIZE")) < suggestedItemArray.length) {
            this._matchingDataList = new SuggestedItem[0];
            return;
        }
        this._matchingDataList = suggestedItemArray;
    }
}

