/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.SynonymsCache;
import oracle.dbtools.raptor.insight.UsersCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.Service;
import oracle.javatools.db.DBException;
import oracle.javatools.util.Log;
import oracle.jdeveloper.db.ConnectionException;

public class InsightableOracleDatabase {
    private static final Logger logger = Logger.getLogger(InsightableOracleDatabase.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<Object> binds = new ArrayList<Object>();
    public boolean colNameOrdering = true;
    public final int minLimit = 50;
    public int limit = 50;
    UsersCache users = null;
    SynonymsCache synonyms = null;
    static Map<String, Boolean> dbaSynonymsAtConnection = new HashMap<String, Boolean>();
    private static final String USERNAME_CRITERIA = " and username like ? ";
    private static final String OBJ_TYPE_EQ_PKG = " and object_type = 'PACKAGE' ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String PROCNAME_CRITERIA = " and procedure_name like ? ";
    private static final String VARNAME_CRITERIA = " and name like ? ";
    private static final String OWN_PKG_CRITERIA = " and (o.object_name = ? and a.package_name = ? or o.owner=?) ";
    private static final String STANDALONE_PROC_CRITERIA = " and o.object_name = ? ";
    private static final String PACKAGED_PROC_CRITERIA = " and o.object_name = ? and a.object_name = ? ";
    private boolean prepareUserTablesCalled = false;
    private boolean prepareAllTablesCalled = false;
    boolean prepareColumnsCalled = false;
    private String schema = null;
    private boolean prepareAllFunctionsCalled = false;
    private boolean prepareAllSequencesCalled = false;
    private boolean prepareAllSchemasCalled = false;
    private List<String> prefixedUsers = null;
    private boolean prepareAllPkgProcCalled = false;
    private boolean isSynonym = false;
    private boolean prepareArgumentsProcCalled = false;
    private Map<String, String> tableAliases = null;
    boolean setTableAliasesCalled = false;
    private boolean isPrefixed = false;
    public boolean adjustCase = true;

    public InsightableOracleDatabase(String string, boolean bl) {
        this.connectionName = string;
        this.colNameOrdering = bl;
        this.synonyms = SynonymsCache.synonymsAtConnection.get(string);
        if (this.synonyms == null) {
            SynonymsCache.fillIn(string);
            this.synonyms = SynonymsCache.synonymsAtConnection.get(string);
        }
        this.users = UsersCache.usersAtConnection.get(string);
    }

    private int limit() {
        return this.limit;
    }

    private final String queryUserTables() {
        if (this.users == null) {
            return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE     object_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "select 'TABLE' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
    }

    private final String queryUserViews() {
        if (this.users == null) {
            return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "select 'VIEW' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
    }

    private final String queryAllTables() {
        if (this.users == null) {
            return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "select 'TABLE' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
    }

    private final String queryAllViews() {
        if (this.users == null) {
            return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "select 'VIEW' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String queryAllSynonyms() {
        Boolean bl = dbaSynonymsAtConnection.get(this.connectionName);
        if (bl == null) {
            Connection connection = null;
            Statement statement = null;
            boolean bl2 = false;
            try {
                connection = ChameleonConnection.getConnection(this.connectionName);
                if (!ChameleonConnection.isTestConnection()) {
                    bl2 = Connections.getInstance().tryLock(connection, 500L);
                }
                if (!bl2) {
                    bl = false;
                }
                if (bl == null) {
                    statement = connection.prepareStatement("select 1 from sys.DBA_OBJECTS where 1=0");
                    statement.executeQuery();
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (bl2) {
                    Connections.getInstance().unlock(connection);
                }
                dbaSynonymsAtConnection.put(this.connectionName, bl);
            }
        }
        return "select 'TABLE' type, owner, object_name, null column_name, null column_id, null data_type \nfrom " + (bl != false ? " dba_objects" : " all_objects") + "\nwhere object_name like ? and object_type = 'SYNONYM' \nand rownum <=" + this.limit() + "\n";
    }

    private final String objName() {
        return (this.users == null ? "object_" : "") + "name";
    }

    private final String OBJ_LIKE_CRITERIA() {
        return " and " + this.objName() + " like ? ";
    }

    private final String OWNER_CRITERIA() {
        if (this.users == null) {
            return " and owner = ? ";
        }
        return " and owner# = ? ";
    }

    private final String MIXED_CASE_CRITERIA() {
        return " and upper(" + this.objName() + ")!=" + this.objName() + " ";
    }

    private final String QUERY_COLUMNS_BY_OWNER_TABLE() {
        return "SELECT 'COLUMN' type, owner, table_name object_name, column_name, column_id, data_type \nFROM sys.all_tab_cols \nWHERE hidden_column = 'NO' and rownum <=" + this.limit() + " and owner = ? and table_name = ? ";
    }

    private final String QUERY_COLUMN_SEQUENCES() {
        return "SELECT 'SEQUENCE' type, USER owner,  object_name, 'NEXTVAL' column_name, null column_id, null data_type \nFROM sys.user_objects \nWHERE object_type = 'SEQUENCE' and rownum <=" + this.limit() + "  ";
    }

    private final String COLUMN_LIKE_CRITERIA() {
        return " and column_name like ? ";
    }

    private final String COLUMN_TYPE_NOT_CRITERIA() {
        return " and data_type != ? ";
    }

    private final String COLUMN_NAME_NOT_CRITERIA() {
        return " and column_name != ? ";
    }

    private final String queryProcedures(boolean bl) {
        if (this.users == null) {
            return "SELECT object_type type, " + (bl ? "SYS_CONTEXT('USERENV','CURRENT_SCHEMA')" : "owner") + "  owner, object_name, null column_name, null column_id, null data_type \nFROM " + (bl ? "user" : "all") + "_objects \nWHERE rownum <=" + this.limit() + " and object_name not like 'BIN$%'  and object_type IN ('PROCEDURE','FUNCTION','PACKAGE','OPERATOR') \n";
        }
        return "select case type# when 7 then 'PROCEDURE' \n               when 8 then 'FUNCTION' \n               when 9 then 'PACKAGE' \n               when 33 then 'OPERATOR' \nend type,\n ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere " + (bl ? "o.owner# = " + this.users.schema + " and " : "") + "name not like 'BIN%' \nand type# in (7,8,9) \nand rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_SCHEMAS() {
        return "SELECT 'SCHEMA' type, username owner, username object_name, null column_name, null column_id, null data_type \nFROM all_users WHERE rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_PACKAGED_PROCEDURES() {
        return "SELECT 'FUNCTION' type, owner, object_name/*||'.'||procedure_name*/ object_name, /*null*/procedure_name column_name, null column_id, null data_type \nFROM all_procedures \nWHERE rownum <=" + this.limit() + " OBJ_TYPE_EQ_PKG  and procedure_name is not null \n";
    }

    private final String QUERY_PACKAGED_GLOBAL_VARIABLES() {
        return "select 'NUMBER' type, owner, object_name, name as column_name, null column_id, null data_type \nfrom all_identifiers a\n where usage_context_id = 1\n   and usage = 'DECLARATION'\n   and type = 'VARIABLE'\nand object_type = 'PACKAGE'\n";
    }

    private final String QUERY_ARGUMENTS() {
        return "SELECT 'ARGUMENT' type, null owner,  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' column_name, a.position column_id, null data_type \nFROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and rownum <=" + this.limit() + " and    argument_name is not null \n";
    }

    public void prepareUserTables() {
        if (this.prepareUserTablesCalled) {
            return;
        }
        this.prepareUserTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryUserTables());
        this.query.append("\n union all \n");
        this.query.append(this.queryUserViews());
    }

    public void prepareAllTables(String string, String string2) {
        if (this.prepareAllTablesCalled) {
            return;
        }
        this.prepareAllTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryAllTables());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        this.query.append("\n union all \n");
        this.query.append(this.queryAllViews());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        boolean bl = true;
        if (bl && string2 != null && string2.length() > 0) {
            this.query.append("\n union all \n");
            this.query.append(this.queryAllSynonyms());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string != null) {
                this.query.append(" and owner = ? ");
                this.binds.add(string);
            } else {
                this.query.append(" and owner in (SYS_CONTEXT('USERENV','CURRENT_SCHEMA') ,'PUBLIC') ");
            }
        }
    }

    private void addOwnerCriteria(String string) {
        if (string != null) {
            if (this.users == null) {
                this.query.append(this.OWNER_CRITERIA());
                this.binds.add(string);
            } else {
                Integer n = this.users.getUserId(string);
                if (n != null) {
                    this.query.append(this.OWNER_CRITERIA());
                    this.binds.add(n);
                } else {
                    this.query.append(" and 0 = 1 ");
                }
            }
        }
    }

    public void prepareColumns(String string, String string2) {
        String string3 = null;
        String string4 = null;
        List list = LexerToken.parse((String)string);
        if (list.size() != 3 || !".".equals(((LexerToken)list.get((int)1)).content)) {
            String string5;
            string4 = string;
            if (this.synonyms != null && (string5 = this.synonyms.getTable(null, string4)) != null) {
                string3 = string5.substring(0, string5.indexOf(46));
                string4 = string5.substring(string5.indexOf(46) + 1);
            }
        } else {
            List list2;
            String string6;
            string3 = ((LexerToken)list.get((int)0)).content;
            string4 = ((LexerToken)list.get((int)2)).content;
            if (this.synonyms != null && (string6 = this.synonyms.getTable(string3, string4)) != null && (list2 = LexerToken.parse((String)string6)).size() == 3) {
                string3 = ((LexerToken)list2.get((int)0)).content;
                string4 = ((LexerToken)list2.get((int)2)).content;
            }
        }
        if (string3 == null) {
            string3 = this.getCurrentSchema();
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(1));
        this.binds.add(Service.handleMixedCase((String)string3));
        this.binds.add(Service.handleMixedCase((String)string4));
        if (string2 != null && !"".equals(string2)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
    }

    private String getCurrentSchema() {
        if (this.schema == null) {
            try {
                this.schema = DBUtil.getInstance((Connection)this.getConnection()).executeOracleReturnOneCol("select SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema from dual", new HashMap());
            }
            catch (Exception exception) {
                Log.error((String)("IOD.gcs():" + exception.getMessage()));
                this.schema = "N/A";
            }
        }
        if (this.schema == null) {
            Log.error((String)"IOD.gcs(): schema == null");
            this.schema = "N/A";
        }
        return this.schema;
    }

    public void prepareFQColumns(Set<String> set, String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(set.size()));
        this.setFQBinds(set, this.binds);
        if (string != null && !"".equals(string)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
    }

    public void excludeColTypes(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_TYPE_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void excludeColNames(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_NAME_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void prepareAllProcedures(String string, String string2) {
        if (this.prepareAllFunctionsCalled) {
            return;
        }
        this.prepareAllFunctionsCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryProcedures(false));
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
        this.addOwnerCriteria(string);
    }

    public void prepareAllSequences(String string, boolean bl) {
        if (this.prepareAllSequencesCalled) {
            return;
        }
        this.prepareAllSequencesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_COLUMN_SEQUENCES());
        if (bl) {
            this.query.append(" and object_name like ?");
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        } else {
            this.query.append(" and object_name = ?");
            this.binds.add(Service.handleMixedCase((String)string));
        }
    }

    public void prepareAllSchemas(String string) {
        if (this.users != null) {
            this.prefixedUsers = this.users.prefixedUsers(string);
            return;
        }
        this.prefixedUsers = null;
        if (this.prepareAllSchemasCalled) {
            return;
        }
        this.prepareAllSchemasCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string2 = this.QUERY_SCHEMAS();
        if (string != null && !"".equals(string)) {
            string2 = string2 + USERNAME_CRITERIA;
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
        this.query.append(string2);
    }

    public void prepareAllPkgProc(String string, String string2, String string3) {
        List list;
        String string4;
        if (this.prepareAllPkgProcCalled) {
            return;
        }
        this.prepareAllPkgProcCalled = true;
        if (this.synonyms != null && (string4 = this.synonyms.getTable(string, string2)) != null && (list = LexerToken.parse((String)string4)).size() == 3) {
            string = ((LexerToken)list.get((int)0)).content;
            string2 = ((LexerToken)list.get((int)2)).content;
            this.isSynonym = true;
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_PACKAGED_PROCEDURES());
        if (string == null) {
            string = Service.handleMixedCase((String)this.getCurrentSchema());
            this.query.append(" and owner in('SYS',?) ");
            this.binds.add(string);
        } else {
            this.query.append(" and owner = ? ");
            this.binds.add(Service.handleMixedCase((String)string));
        }
        if (string2 != null) {
            this.query.append(OBJ_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.query.append(PROCNAME_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string3) + "%");
        }
        if (string2 == null) {
            return;
        }
        try {
            string4 = RaptorVersionTracker.getDbVersion(Connections.getInstance().getConnection(this.connectionName, false));
        }
        catch (DBException dBException) {
            return;
        }
        if (string4 == null) {
            return;
        }
        int n = string4.toIntArray()[0];
        int n2 = string4.toIntArray()[1];
        if (n < 11) {
            return;
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_PACKAGED_GLOBAL_VARIABLES());
        if (string == null) {
            string = Service.handleMixedCase((String)this.getCurrentSchema());
            this.query.append(" and owner in('SYS',?) ");
            this.binds.add(string);
        } else {
            this.query.append(" and owner = ? ");
            this.binds.add(Service.handleMixedCase((String)string));
        }
        if (string2 != null) {
            this.query.append(OBJ_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.query.append(VARNAME_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string3) + "%");
        }
    }

    public void prepareArgumentsProc(String string, String string2) {
        if (this.prepareArgumentsProcCalled) {
            return;
        }
        this.prepareArgumentsProcCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ARGUMENTS();
        if (string != null) {
            string3 = string3 + OWN_PKG_CRITERIA;
            this.binds.add(string);
            this.binds.add(string);
            this.binds.add(string);
        }
        if (string2 != null) {
            if (string != null) {
                string3 = string3 + PACKAGED_PROC_CRITERIA;
                this.binds.add(string);
                this.binds.add(string2);
            } else {
                string3 = string3 + STANDALONE_PROC_CRITERIA;
                this.binds.add(string2);
            }
        }
        this.query.append(string3);
    }

    public void setTableAliases(Map<String, String> map) {
        this.setTableAliases(map, false);
    }

    public void setTableAliases(Map<String, String> map, boolean bl) {
        if (this.setTableAliasesCalled) {
            return;
        }
        this.setTableAliasesCalled = true;
        this.isPrefixed = bl;
        if (this.synonyms == null) {
            this.tableAliases = map;
        } else {
            this.tableAliases = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2;
                String string3 = map.get(string);
                String string4 = null;
                String string5 = string3;
                if (string5.charAt(0) != '\"' && string5.indexOf(46) > 0) {
                    string4 = string5.substring(0, string5.indexOf(46));
                    string5 = string5.substring(string5.indexOf(46) + 1);
                }
                if ((string2 = this.synonyms.getTable(string4, string5)) != null) {
                    string3 = string2;
                }
                this.tableAliases.put(string, string3);
            }
        }
    }

    String getTable(String string) {
        if (this.tableAliases == null) {
            return null;
        }
        return this.tableAliases.get(string);
    }

    private List<String> translate(String string, String string2, String string3) {
        String string4;
        String string5;
        boolean bl = false;
        int n = 0;
        for (String object2 : this.tableAliases.keySet()) {
            String string6;
            ++n;
            String string7 = this.tableAliases.get(object2);
            if (object2.equalsIgnoreCase(string7)) continue;
            string5 = null;
            string4 = object2;
            if (string4.charAt(0) != '\"' && string4.indexOf(46) > 0) {
                string5 = string4.substring(0, string4.indexOf(46));
                string4 = string4.substring(string4.indexOf(46) + 1);
            }
            if (string7.equals(string6 = this.synonyms.getTable(string5, string4))) continue;
            bl = true;
            break;
        }
        if (this.colNameOrdering && this.isPrefixed) {
            bl = true;
        }
        if (1 < n) {
            bl = true;
        }
        ArrayList arrayList = new ArrayList();
        if (this.tableAliases.size() == 0) {
            arrayList.add(string3);
            return arrayList;
        }
        for (String string7 : this.tableAliases.keySet()) {
            string5 = this.tableAliases.get(string7);
            if (!string5.equalsIgnoreCase(string + '.' + string2) && !string5.equalsIgnoreCase(string2) && !string5.equalsIgnoreCase("\"" + string + "\".\"" + string2 + "\"") && !string5.equalsIgnoreCase("\"" + string + "\"." + string2) && !string5.equalsIgnoreCase("\"" + string2 + "\"")) continue;
            string4 = bl ? string7 + "." + string3 : string3;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean isPrepared() {
        return this.query.length() > 0;
    }

    private String queryByOwnerTable(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("\n  union all\n");
            }
            stringBuffer.append(this.QUERY_COLUMNS_BY_OWNER_TABLE());
        }
        return stringBuffer.toString();
    }

    private void setFQBinds(Set<String> set, List<Object> list) {
        for (String string : set) {
            String string2;
            String string3 = string.substring(0, string.indexOf(46));
            list.add(Service.handleMixedCase((String)string3));
            String string4 = string.substring(string.indexOf(46) + 1);
            if (this.synonyms != null && (string2 = this.synonyms.getTable(string3, string4)) != null) {
                string3 = string2.substring(0, string2.indexOf(46));
                string4 = string2.substring(string2.indexOf(46) + 1);
            }
            list.add(Service.handleMixedCase((String)string4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Set<SuggestedItem> fetch() throws Exception {
        String string;
        Object object;
        boolean bl;
        Connection connection;
        String string2;
        TreeSet<SuggestedItem> treeSet;
        long l;
        block39: {
            ResultSet resultSet;
            block37: {
                Set<SuggestedItem> set;
                block38: {
                    block35: {
                        Set<SuggestedItem> set2;
                        block36: {
                            if (this.query == null || this.query.length() == 0) {
                                return Collections.emptySet();
                            }
                            l = System.currentTimeMillis();
                            treeSet = new TreeSet<SuggestedItem>();
                            resultSet = null;
                            string2 = null;
                            connection = null;
                            bl = false;
                            connection = this.getConnection();
                            if (connection != null) break block35;
                            set2 = Collections.emptySet();
                            if (resultSet == null) break block36;
                            DBUtil.closeResultSet(resultSet);
                        }
                        if (bl) {
                            Connections.getInstance().unlock(connection);
                        }
                        return set2;
                    }
                    if (ChameleonConnection.isTestConnection() || (bl = Connections.getInstance().tryLock(connection, 500L))) break block37;
                    set = Collections.emptySet();
                    if (resultSet == null) break block38;
                    DBUtil.closeResultSet(resultSet);
                }
                if (bl) {
                    Connections.getInstance().unlock(connection);
                }
                return set;
            }
            try {
                string2 = connection.getMetaData().getDatabaseMajorVersion() > 10 ? this.query.toString().replace("OBJ_TYPE_EQ_PKG", OBJ_TYPE_EQ_PKG) : this.query.toString().replace("OBJ_TYPE_EQ_PKG", "");
                String string3 = connection.getMetaData().getUserName();
                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string2, this.binds);
                String string4 = null;
                object = new HashMap<Integer, String>();
                while (resultSet.next()) {
                    void var14_24;
                    String string5 = resultSet.getString("type");
                    string = resultSet.getString("object_name");
                    if (string2.indexOf("object_name||'.'||procedure_name") <= 0) {
                        string = Service.addDoubleQuote((String)string);
                    }
                    Iterator<String> iterator = resultSet.getString("column_name");
                    if ("ARGUMENT".equals(string5)) {
                        String string6 = string;
                        if (string4 == null || string6.equals(string4)) {
                            object.put(resultSet.getInt("column_id"), (String)((Object)iterator));
                        } else {
                            this.inlineArguments(treeSet, (Map<Integer, String>)object);
                            object.put(resultSet.getInt("column_id"), iterator);
                        }
                        string4 = string6;
                        continue;
                    }
                    String string7 = resultSet.getString("owner");
                    if (iterator != null && ("COLUMN".equals(string5) || "PROCEDURE".equals(string5) || "FUNCTION".equals(string5)) || "NUMBER".equals(string5)) {
                        iterator = Service.addDoubleQuote((String)((Object)iterator));
                        if (string7 == null || string == null) {
                            System.out.println(string7);
                        }
                        List<String> list = this.translate(string7, string, (String)((Object)iterator));
                        Integer n = resultSet.getInt("column_id");
                        if (n == null || this.colNameOrdering) {
                            n = -1;
                        }
                        for (String string8 : list) {
                            SuggestedItem suggestedItem = new SuggestedItem(string5, null, string8, n, this.adjustCase);
                            suggestedItem.columnType = resultSet.getString("data_type");
                            treeSet.add(suggestedItem);
                        }
                        continue;
                    }
                    if ("SEQUENCE".equals(string5)) {
                        treeSet.add(new SuggestedItem(string5, string, (String)((Object)iterator)));
                        continue;
                    }
                    if (this.users != null) {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n >= 0) {
                            String string9 = this.users.getUserName(n);
                        }
                    }
                    treeSet.add(new SuggestedItem(string5, (String)(string3.equals(var14_24) || this.isSynonym ? "" : var14_24), string));
                }
                if (object.size() > 0) {
                    this.inlineArguments((Set<SuggestedItem>)treeSet, (Map<Integer, String>)object);
                    object.clear();
                }
                if (resultSet == null) break block39;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    DBUtil.closeResultSet(resultSet);
                }
                if (bl) {
                    Connections.getInstance().unlock(connection);
                }
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        if (bl) {
            Connections.getInstance().unlock(connection);
        }
        long l2 = System.currentTimeMillis();
        if (CompletionInsight.timing) {
            System.out.println("InsightableOracleDatabase.fetch() time = " + (l2 - l));
        }
        if (l + 500L < l2) {
            logger.warning("InsightableOracleDatabase.fetch() time = " + (l2 - l));
            logger.warning(string2);
            if (CompletionInsight.timing) {
                System.out.println(string2);
                for (Object e : this.binds) {
                    System.out.println(e);
                    if (e != null) {
                        logger.warning(e.toString());
                        continue;
                    }
                    logger.warning("bind=null");
                }
            }
        }
        object = new TreeSet();
        boolean bl2 = false;
        string = null;
        for (SuggestedItem suggestedItem : treeSet) {
            int n;
            if (!suggestedItem.getType().equals(string)) {
                n = 0;
            }
            if (++n >= this.limit()) {
                object.add(new SuggestedItem(suggestedItem.getType(), null, "..."));
            }
            string = suggestedItem.getType();
        }
        treeSet.addAll((Collection<SuggestedItem>)object);
        if (this.prefixedUsers != null) {
            for (String string10 : this.prefixedUsers) {
                treeSet.add(new SuggestedItem("SCHEMA", null, string10));
            }
        }
        return treeSet;
    }

    private void inlineArguments(Set<SuggestedItem> set, Map<Integer, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 1; i <= map.size(); ++i) {
            String string = map.get(i);
            boolean bl = 0 < string.indexOf(" Y*/");
            string = string.replace(" Y*/", "*/");
            string = string.replace(" N*/", "*/");
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            if (bl) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(string);
        }
        if (stringBuilder.length() != stringBuilder2.length()) {
            set.add(new SuggestedItem("ARGUMENT", null, "/*min sig:*/" + stringBuilder2.toString()));
            set.add(new SuggestedItem("ARGUMENT", null, "/*full sig:*/" + stringBuilder.toString()));
        } else {
            set.add(new SuggestedItem("ARGUMENT", null, stringBuilder.toString()));
        }
    }

    public Connection getConnection() throws DBException, ClassNotFoundException, SQLException, ConnectionException {
        return ChameleonConnection.getConnection(this.connectionName);
    }
}

