/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.logging;

import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.net.URL;
import oracle.dbtools.raptor.mimeeditor.ExternalBlobEditor;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.log.Href;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.ExceptionDialog;

public class LogUtils {
    public static Href getHref(final URL uRL) {
        Href href = new Href(URLFileSystem.getPath((URL)uRL), uRL){

            public void go() {
                File file = LogUtils.toFile(this.getURL());
                if (file.isDirectory()) {
                    try {
                        BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                        browserRunner.runBrowserOnURL(this.getURL(), null, null);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                } else {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)this.getURL());
                        if (node instanceof UnrecognizedTextNode && !URLFileSystem.getSuffix((URL)uRL).equals(".log")) {
                            ExternalBlobEditor externalBlobEditor = new ExternalBlobEditor();
                            externalBlobEditor.setAbsolutePathFileName(file);
                            externalBlobEditor.executeExternalEditor(false);
                        } else {
                            Context context = Context.newIdeContext((Node)node);
                            context.setWorkspace(Ide.getActiveWorkspace());
                            context.setProject(Ide.getActiveProject());
                            EditorManager editorManager = EditorManager.getEditorManager();
                            editorManager.openEditor(new OpenEditorOptions(context, CodeEditor.class));
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            }
        };
        return href;
    }

    public static File toFile(URL uRL) {
        URI uRI = LogUtils.toURI(uRL);
        return null == uRI ? null : new File(uRI);
    }

    public static URI toURI(URL uRL) {
        URI uRI = null;
        try {
            uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
        catch (Exception exception) {
            Logger.severe(LogUtils.class, (Throwable)exception);
        }
        return uRI;
    }
}

