/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class Databases
extends DatabaseTypeRoot
implements ConnectionListener,
ConnectionStoreNode {
    private String m_id;
    private String m_label;
    private String m_tooltip;

    public static Databases findConnectionStore(String string) {
        return StoreCache.INSTANCE.lookup(string);
    }

    public static Databases findOrCreateConnectionStore(String string) {
        Databases databases = StoreCache.INSTANCE.lookup(string);
        if (databases == null) {
            databases = new Databases(string);
            StoreCache.INSTANCE.cache(databases);
        }
        return databases;
    }

    public static void removeConnectionStore(String string) {
        Databases databases = StoreCache.INSTANCE.lookup(string);
        if (databases != null) {
            StoreCache.INSTANCE.uncache(databases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Databases(String string) {
        Object object;
        this.m_id = string;
        if ("IdeConnections".equals(this.m_id) && Product.isRaptor()) {
            this.m_tooltip = this.m_label = DatabaseNavigatorResources.getString("STANDALONE_NAVIGATOR_LABEL");
        } else {
            object = DatabaseConnectionStores.getInstance();
            this.m_label = object.getShortLabel(this.m_id);
            this.m_tooltip = object.getToolTipText(this.m_id);
        }
        object = Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string2 : ((Connections)object).getConnNames(this.m_id)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string2, true);
                if (databaseConnection == null) continue;
                this.updateOverlaysForNode(databaseConnection);
                this._children.add(databaseConnection);
            }
        }
        if (Boolean.parseBoolean(System.getProperty("sqldev.tnsping", "true"))) {
            this.refreshPingTimes();
        }
        ((Connections)object).addConnectionListener(this);
    }

    public String getStoreId() {
        return this.m_id;
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getLongLabel() {
        return this.getToolTipText();
    }

    public Icon getIcon() {
        return DatabaseConnectionStores.getInstance().getIcon(this.m_id);
    }

    public static DatabaseConnection getConnectionNode(String string, boolean bl) {
        DatabaseConnection databaseConnection = null;
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
        databaseConnection = bl ? DatabaseConnection.findOrCreateConnectionNode(uRL) : DatabaseConnection.findConnectionNode(uRL);
        return databaseConnection;
    }

    @Override
    public void connectionAdded(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        if (Connections.isPrivateConnection(string)) {
            return;
        }
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (databaseConnection = Databases.getConnectionNode(string, true)) != null) {
            this.updateOverlaysForNode(databaseConnection);
            if (this.add(databaseConnection)) {
                UpdateMessage.fireChildAdded((Subject)this, (Element)databaseConnection);
            }
        }
    }

    private void updateOverlaysForNode(DatabaseConnection databaseConnection) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)databaseConnection);
            iconOverlayTracker.repaintOverlays();
        }
    }

    @Override
    public void connectionRemoved(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (databaseConnection = Databases.getConnectionNode(string, false)) != null && this.remove(databaseConnection)) {
            UpdateMessage.fireChildRemoved((Subject)this, (Element)databaseConnection);
        }
    }

    @Override
    public void connectionModified(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getOldName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id)) {
            String string3 = connectionEvent.getConnectionName();
            if (ModelUtil.areDifferent((Object)string, (Object)string3)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
                if (databaseConnection != null) {
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string3);
                    databaseConnection.setURL(uRL);
                }
            } else {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string3, false);
                if (databaseConnection != null) {
                    UpdateMessage.firePropertiesChanged((Subject)databaseConnection, (PropertyChangeEvent[])new PropertyChangeEvent[0], null);
                }
            }
        }
    }

    @Override
    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void markDirty(boolean bl) {
    }

    public String getToolTipText() {
        return this.m_tooltip;
    }

    public String getStoreName() {
        return this.m_id;
    }

    public void refreshPingTimes() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>("", true, IRaptorTaskRunMode.NO_GUI){

            protected Void doWork() throws TaskException {
                DatabaseConnection databaseConnection = null;
                for (Object e : Databases.this._children) {
                    databaseConnection = (DatabaseConnection)e;
                    if (!Connections.getInstance().isOracle(databaseConnection.getQualifiedConnectionName())) continue;
                    databaseConnection.refreshPingTime();
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public String getKey() {
        return this.getStoreId();
    }

    @Override
    public int getWeight() {
        return "IdeConnections".equals(this.getStoreId()) ? 100 : 50;
    }

    @Override
    public String getDatabaseType() {
        return "sqldev.nav";
    }

    @Override
    public String getID() {
        return this.getStoreId();
    }

    private static final class StoreCache {
        private static StoreCache INSTANCE = new StoreCache();
        private Map<String, Databases> mCache = new HashMap<String, Databases>();

        private StoreCache() {
        }

        Databases lookup(String string) {
            return this.mCache.get(string);
        }

        void cache(Databases databases) {
            String string = databases.getID();
            Databases databases2 = this.mCache.put(string, databases);
            if (databases2 != null && databases2 != databases) {
                Logger.warn(Databases.class, (String)("Warning: replaced Databases node for id " + string));
            }
        }

        void uncache(Databases databases) {
            this.mCache.remove(databases.getStoreId());
        }
    }
}

