/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataObjectFactory;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.jdbc.OracleConnection;

public final class ObjectFactoryRegistry {
    private static final Logger LOGGER = Logger.getLogger(ObjectFactoryRegistry.class.getName());
    public static final String DB_NAV_KEY = "sqldev.nav";
    private static Map<String, ObjectFactoryRegistry> s_registries = new HashMap<String, ObjectFactoryRegistry>();
    private Map<Connection, ObjectFactory> m_factories = new HashMap<Connection, ObjectFactory>();
    private List<ConnectionRecognizer> m_recognizers = new ArrayList<ConnectionRecognizer>();
    private ConnectionRecognizer m_defaultRecognizer = new DefaultConnectionRecognizer();
    private String m_type;
    private Constructor<? extends ObjectFactory> m_defaultFactoryCtor;

    public static ObjectFactoryRegistry getRegistry(String string) {
        ObjectFactoryRegistry objectFactoryRegistry = s_registries.get(string);
        if (objectFactoryRegistry == null) {
            objectFactoryRegistry = new ObjectFactoryRegistry(string);
            s_registries.put(string, objectFactoryRegistry);
        }
        return objectFactoryRegistry;
    }

    public static ObjectFactoryRegistry getDatabaseNavigatorRegistry() {
        return ObjectFactoryRegistry.getRegistry(DB_NAV_KEY);
    }

    private ObjectFactoryRegistry(String string) {
        this.m_type = string;
    }

    public void setDefaultFactoryClass(Class<? extends ObjectFactory> clazz) {
        try {
            this.m_defaultFactoryCtor = clazz.getConstructor(ConnectionInfo.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Missing constructor");
        }
    }

    private ObjectFactoryRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFactory getFactory(String string, Connection connection) {
        ObjectFactory objectFactory;
        if (connection == null) {
            return null;
        }
        Map<Connection, ObjectFactory> map = this.m_factories;
        synchronized (map) {
            objectFactory = this.m_factories.get(connection);
            if (objectFactory == null) {
                if (string == null) {
                    string = Connections.getInstance().getConnectionName(connection);
                }
                objectFactory = this.createFactory(string, connection);
                this.m_factories.put(connection, objectFactory);
            }
        }
        return objectFactory;
    }

    private ObjectFactory createFactory(String string, Connection connection) {
        ObjectFactory objectFactory = null;
        ConnectionInfo connectionInfo = this.createConnectionInfo(string, connection);
        ConnectionType connectionType = NavigatorHook.getHookInstance(this.m_type).getConnectionType(connectionInfo);
        if (connectionType != null) {
            String string2 = connectionType.getProviderClass();
            if (string2 != null) {
                try {
                    Class<?> clazz = Class.forName(string2, true, connectionType.getClassLoader());
                    Constructor<?> constructor = clazz.getConstructor(ConnectionInfo.class, ConnectionType.class);
                    if (constructor != null) {
                        objectFactory = (ObjectFactory)constructor.newInstance(connectionInfo, connectionType);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            if (objectFactory == null) {
                objectFactory = new XmlObjectFactory(connectionInfo, connectionType);
            }
        }
        if (objectFactory == null) {
            try {
                objectFactory = this.m_defaultFactoryCtor.newInstance(connectionInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.WARNING, illegalArgumentException.getStackTrace()[0].toString(), illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
            }
        } else {
            objectFactory.setNavigatorType(this.m_type);
        }
        return objectFactory;
    }

    public void registerRecognizer(ConnectionRecognizer connectionRecognizer) {
        if (!this.m_recognizers.contains(connectionRecognizer)) {
            this.m_recognizers.add(connectionRecognizer);
        }
        Collections.sort(this.m_recognizers, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object != null && object.getClass().getName().endsWith("JdbcRealConnectionRecognizer")) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public void unregisterRecognizer(ConnectionRecognizer connectionRecognizer) {
        this.m_recognizers.remove(connectionRecognizer);
    }

    public ConnectionInfo createConnectionInfo(String string, Connection connection) {
        for (ConnectionRecognizer connectionRecognizer : this.m_recognizers) {
            ConnectionInfo connectionInfo = connectionRecognizer.createConnectionInfo(string, connection);
            if (connectionInfo == null) continue;
            return connectionInfo;
        }
        return this.m_defaultRecognizer.createConnectionInfo(string, connection);
    }

    static {
        ObjectFactoryRegistry objectFactoryRegistry = ObjectFactoryRegistry.getDatabaseNavigatorRegistry();
        objectFactoryRegistry.setDefaultFactoryClass(MetadataObjectFactory.class);
        objectFactoryRegistry.registerRecognizer(new OracleRecognizer());
    }

    private static class OracleRecognizer
    implements ConnectionRecognizer {
        private OracleRecognizer() {
        }

        @Override
        public ConnectionInfo createConnectionInfo(String string, Connection connection) {
            ConnectionInfo connectionInfo = null;
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = connection.getMetaData();
                String string2 = databaseMetaData.getDatabaseProductName();
                if ("Oracle".equals(string2)) {
                    Version version = RaptorVersionTracker.getDbVersion(connection);
                    String string3 = databaseMetaData.getUserName();
                    if (connection instanceof OracleConnection) {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(false);
                        String string4 = dBUtil.executeReturnOneCol("select USER from dual");
                        if (string4 != null) {
                            string3 = string4;
                        }
                    }
                    connectionInfo = new ConnectionInfo(string, connection, version, string2, null, string3);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return connectionInfo;
        }
    }

    private static class DefaultConnectionRecognizer
    implements ConnectionRecognizer {
        private DefaultConnectionRecognizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConnectionInfo createConnectionInfo(String string, Connection connection) {
            ConnectionInfo connectionInfo = null;
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = connection.getMetaData();
                Version version = RaptorVersionTracker.getDbVersion(connection);
                connectionInfo = new ConnectionInfo(string, connection, version, databaseMetaData.getDatabaseProductName(), null, databaseMetaData.getUserName());
            }
            catch (SQLException sQLException) {}
            return connectionInfo;
        }
    }
}

