/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.ColoredDisplayable;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.javatools.db.DBException;

public final class DatabaseConnection
extends AbstractConnectionNode
implements IConnectionNode<Connection>,
ColoredDisplayable {
    public static final String REMOTE_DEBUG_NAME = "Remote Debug";
    public static final String LAST_PING_ERROR = "Last_ping_error";
    private Icon m_icon;
    private String m_type;
    private long _lastPing = -1L;

    public static DatabaseConnection findConnectionNode(URL uRL) {
        return (DatabaseConnection)DatabaseConnection.findConnectionNodeImpl(uRL);
    }

    public static DatabaseConnection findOrCreateConnectionNode(URL uRL) {
        return DatabaseConnection.findOrCreateConnectionNodeImpl(uRL, DatabaseConnection.class);
    }

    DatabaseConnection() {
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    DatabaseConnection(String string) {
        this();
        this.setURL(DBURLFormatHelper.getURL("sqldev.nav", string));
    }

    @Override
    protected boolean closeConnectionImpl() {
        return Connections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    @Override
    protected Connection openConnectionImpl() throws IOException {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            if (connection == null) {
                throw new WrappedException((Throwable)new ConnectionCanceledException());
            }
        }
        catch (DBException dBException) {
            throw new WrappedException(dBException);
        }
        catch (RuntimeException runtimeException) {
            throw new WrappedException(runtimeException);
        }
        return connection;
    }

    @Override
    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName(this.getURL());
    }

    public String getConnectionName() {
        return Connections.getConnectionName(this.getQualifiedConnectionName());
    }

    @Override
    public String getStoreName() {
        return Connections.getStoreName(this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("RaptorConnectionType");
        if (this.m_type == null || !this.m_type.equals(string) || this.m_icon == null) {
            this.m_icon = DatabaseConnection.loadIcon(this.getQualifiedConnectionName());
            this.m_type = properties.getProperty("RaptorConnectionType");
        }
        return this.m_icon;
    }

    public static Icon loadIcon(String string) {
        String string2 = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            string2 = properties.getProperty("RaptorConnectionType");
        }
        return DatabaseConnection.loadIconForType(string2);
    }

    public static Icon loadIconForType(String string) {
        ConnectionType connectionType;
        Icon icon = null;
        if (string != null && (connectionType = NavigatorHook.getHookInstance("sqldev.nav").getConnectionType(string)) != null) {
            icon = connectionType.getIcon();
        }
        if (icon == null) {
            icon = RaptorImagesArb.getIcon("DB");
        }
        return icon;
    }

    public String getToolTipText() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        long l = this._lastPing;
        String string = this.getShortLabel();
        return DatabaseConnection.formatTooltip(properties, string, l, this.isConnected());
    }

    public static String formatTooltip(Properties properties, String string) {
        return DatabaseConnection.formatTooltip(properties, string, -1L, false);
    }

    public static String formatTooltip(Properties properties, String string, long l) {
        return DatabaseConnection.formatTooltip(properties, string, l, false);
    }

    public static String formatTooltip(Properties properties, String string, long l, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<html>").append(string);
        try {
            if (properties != null) {
                stringBuilder.append("<br/>");
                stringBuilder.append((CharSequence)DatabaseConnection.formatDetailsForTooltip(properties));
                String string2 = null;
                string2 = properties.getProperty(LAST_PING_ERROR);
                if (string2 != null) {
                    stringBuilder.append("<br/>");
                    stringBuilder.append(string2);
                } else if (l != -1L) {
                    stringBuilder.append("<br/>").append(DatabaseNavigatorResources.format("PING_TIME", l));
                }
            }
            if (bl) {
                stringBuilder.append("<br/>").append("<b>").append(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECTED_MSG")).append("</b>");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static StringBuilder formatDetailsForTooltip(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = properties.getProperty("user");
        stringBuilder.append(string != null ? string : "").append('@');
        String string2 = properties.getProperty("hostname");
        if (string2 != null) {
            String string3 = properties.getProperty("port");
            String string4 = properties.getProperty("sid");
            String string5 = properties.getProperty("serviceName");
            string4 = string4 != null ? string4 : string5;
            stringBuilder.append(MessageFormat.format("//{0}:{1}/{2}", string2, string3 != null ? string3 : "1521", string4));
        } else {
            String string6 = properties.getProperty("customUrl");
            if (string6 != null) {
                stringBuilder.append(string6.substring(string6.lastIndexOf(64) + 1));
            }
        }
        return stringBuilder;
    }

    public String getLongLabel() {
        String string = this.getQualifiedConnectionName();
        return Connections.getDisplayName(string);
    }

    public String getMetaData(String string) {
        try {
            String string2 = null;
            Connection connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string2 = string2 + " " + databaseMetaData.getDatabaseMajorVersion();
            string2 = string2 + "." + databaseMetaData.getDatabaseMinorVersion();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void refreshPingTime() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        this._lastPing = TNSPing.ping(properties);
    }

    public synchronized long getPingTime() {
        return this._lastPing;
    }

    public synchronized void setPingTime(long l) {
        this._lastPing = l;
    }

    @Override
    public Color getColor() {
        return Connections.getInstance().getConnectionColor(this.getQualifiedConnectionName());
    }
}

