/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.db.impl.GroupingProcessor;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.SynchronousNavigatorTreeNode;
import oracle.ide.model.Element;

public abstract class ConnectionsTreeNode
extends SynchronousNavigatorTreeNode {
    private static GroupingProcessor DEFAULT_PROCESSOR = new GroupingProcessor(){

        @Override
        public Iterator<Element> process(List<Element> list) {
            return new ArrayList<Element>(list).iterator();
        }
    };
    private GroupingProcessor mProcessor = DEFAULT_PROCESSOR;

    void setGroupingProcessor(GroupingProcessor groupingProcessor) {
        boolean bl = false;
        if (groupingProcessor == null) {
            if (this.mProcessor != DEFAULT_PROCESSOR) {
                this.mProcessor = DEFAULT_PROCESSOR;
                bl = true;
            }
        } else if (this.mProcessor != groupingProcessor) {
            this.mProcessor = groupingProcessor;
            bl = true;
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorTree navigatorTree = ConnectionsTreeNode.this.getOwningNavigatorTree();
                    navigatorTree.refresh(ConnectionsTreeNode.this);
                }
            });
        }
    }

    @Override
    protected Iterator<Element> loadChildrenImpl() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.getElement();
        Iterator iterator = element.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                arrayList.add((Element)iterator.next());
            }
        }
        return this.mProcessor.process(arrayList);
    }

    @Override
    protected void handleChildrenAdded(Collection<Element> collection) {
        super.handleChildrenAdded(collection);
    }

    @Override
    protected void handleChildrenRemoved(Collection<Element> collection) {
        super.handleChildrenRemoved(collection);
    }
}

