/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.BaseElement;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.AbstractObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.ResourceProvider;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlCategoryType;
import oracle.dbtools.raptor.navigator.db.xml.XmlConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemasImpl;
import oracle.dbtools.xml.navigator.CategoryElement;
import oracle.dbtools.xml.navigator.ConnectionTypeElement;
import oracle.dbtools.xml.navigator.NavigatorDescriptorFile;
import oracle.dbtools.xml.navigator.ObjectTypeElement;
import oracle.javatools.util.Pair;

public final class NavigatorDescriptor
implements ResourceProvider {
    private String m_navType;
    private ResourceBundle m_bundle;
    private Map<String, ConnectionType> m_types;
    private List<Pair<String, ObjectType>> m_objectTypes = new ArrayList<Pair<String, ObjectType>>();
    private List<Pair<String, ObjectCategory>> m_categories = new ArrayList<Pair<String, ObjectCategory>>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;
    private ClassLoader m_loader;

    public static NavigatorDescriptor createDescriptor(String string, NavigatorDescriptorFile navigatorDescriptorFile, ClassLoader classLoader) {
        return new NavigatorDescriptor(string, navigatorDescriptorFile, classLoader);
    }

    private NavigatorDescriptor(String string, NavigatorDescriptorFile navigatorDescriptorFile, ClassLoader classLoader) {
        String string2;
        String string3;
        Object object;
        List list;
        this.m_loader = classLoader;
        this.m_navType = string;
        String string4 = navigatorDescriptorFile.getResourceKey();
        if (string4 != null) {
            this.m_bundle = ResourceBundle.getBundle(string4, Locale.getDefault(), this.m_loader);
        }
        if ((list = navigatorDescriptorFile.getConnectionTypes()).size() > 0) {
            this.m_types = new HashMap<String, ConnectionType>();
            for (ObjectTypeElement objectTypeElement : list) {
                object = new XmlConnectionType((ConnectionTypeElement)objectTypeElement, this);
                this.m_types.put(((ConnectionType)object).getType(), (ConnectionType)object);
            }
        } else {
            this.m_types = Collections.emptyMap();
        }
        for (ObjectTypeElement objectTypeElement : navigatorDescriptorFile.getTypes()) {
            object = objectTypeElement.getType();
            string3 = objectTypeElement.getDatabaseType();
            if ("SCHEMAS".equals(object)) {
                this.m_schemas = new XmlSchemasImpl(string3, this, objectTypeElement);
                continue;
            }
            if ("CATALOGS".equals(object)) {
                this.m_catalogs = new XmlCatalogsImpl(string3, this, objectTypeElement);
                continue;
            }
            string2 = objectTypeElement.getCategory();
            BaseElement baseElement = this.createObjectType(string3, (String)object, objectTypeElement);
            this.m_objectTypes.add((Pair<String, ObjectType>)new Pair((Object)string2, (Object)baseElement));
        }
        for (ObjectTypeElement objectTypeElement : navigatorDescriptorFile.getCategories()) {
            object = objectTypeElement.getType();
            string3 = objectTypeElement.getDatabaseType();
            string2 = objectTypeElement.getCategory();
            this.m_categories.add((Pair<String, ObjectCategory>)new Pair((Object)string2, (Object)new XmlCategoryType(string3, (String)object, this, (CategoryElement)objectTypeElement)));
        }
    }

    private BaseElement createObjectType(String string, String string2, ObjectTypeElement objectTypeElement) {
        ObjectType objectType = new XmlObjectType(string, string2, this, objectTypeElement);
        String string3 = objectTypeElement.getImplementationClass();
        if (string3 != null) {
            try {
                Class<?> clazz = Class.forName(string3, true, this.m_loader);
                assert (AbstractObjectType.class.isAssignableFrom(clazz));
                AbstractObjectType abstractObjectType = (AbstractObjectType)clazz.newInstance();
                abstractObjectType.setDelegate((XmlObjectType)objectType);
                objectType = abstractObjectType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectType;
    }

    @Override
    public ClassLoader getDescriptorClassLoader() {
        return this.m_loader;
    }

    @Override
    public String getResource(String string) {
        try {
            return this.m_bundle != null ? this.m_bundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "No Value for key:" + string);
            return string;
        }
    }

    public Collection<Pair<String, ObjectType>> getObjectTypes() {
        return this.m_objectTypes;
    }

    public Collection<Pair<String, ObjectCategory>> getCategories() {
        return this.m_categories;
    }

    XmlSchemasImpl getSchemasDescriptor() {
        return this.m_schemas;
    }

    XmlCatalogsImpl getCatalogsDescriptor() {
        return this.m_catalogs;
    }

    public ConnectionType getConnectionType(String string) {
        return this.m_types.get(string);
    }

    public Iterator<ConnectionType> getConnectionTypes() {
        return this.m_types.values().iterator();
    }
}

