/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import javax.swing.tree.TreePath;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class DatabasesFolderCache
extends RaptorHashStructureAdapter {
    private static final String CONN_NAME_KEY = "CONN_NAME";
    private static final String CONN_TYPE_KEY = "CONN_TYPE";
    private static final String DATA_KEY = "DatabaseFoldersCache";
    private static final String CONNECTIONS_KEY = "Connections";
    private static final String LEGACY_KEY = "Folders";
    private static final String DELIM = "/";

    private static String createKey(String string, String string2) {
        return string + DELIM + string2;
    }

    public static DatabasesFolderCache getInstance() {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        return databasesFolderCache;
    }

    static DatabasesFolderCache getInstance(PropertyStorage propertyStorage) {
        return new DatabasesFolderCache(DatabasesFolderCache.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    static String convertToEncodedPath(TreePath treePath) {
        String string = "";
        Object[] objectArray = treePath.getPath();
        if (objectArray.length > 0) {
            string = DatabasesFolderCache.encode((String)objectArray[0].toString());
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + DELIM + DatabasesFolderCache.encode((String)objectArray[i].toString());
            }
        }
        return string;
    }

    static TreePath createTreePath(String string) {
        Object[] objectArray = string.split(DELIM);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = DatabasesFolderCache.decode((String)objectArray[i]);
        }
        return new TreePath(objectArray);
    }

    private DatabasesFolderCache(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected String getRootKey() {
        return CONNECTIONS_KEY;
    }

    public TreePath getFolder(String string, String string2) {
        HashStructure hashStructure = this.getRootHash();
        String string3 = hashStructure.getString(DatabasesFolderCache.createKey(string, string2));
        return string3 != null ? DatabasesFolderCache.createTreePath(string3) : null;
    }

    public void addFolder(String string, String string2, TreePath treePath) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.putString(DatabasesFolderCache.createKey(string, string2), DatabasesFolderCache.convertToEncodedPath(treePath));
    }

    public void removeFolder(String string, String string2) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.remove(DatabasesFolderCache.createKey(string, string2));
    }

    public void updateFolder(String string, String string2, TreePath treePath) {
        HashStructure hashStructure = this.getRootHash();
        String string3 = DatabasesFolderCache.createKey(string, string2);
        hashStructure.putString(string3, DatabasesFolderCache.convertToEncodedPath(treePath));
    }

    public void renameConnection(String string, String string2, String string3) {
        String string4;
        String string5;
        HashStructure hashStructure = this.getRootHash();
        String string6 = DatabasesFolderCache.createKey(string, string2);
        if (ModelUtil.areDifferent((Object)string6, (Object)(string5 = DatabasesFolderCache.createKey(string, string3))) && (string4 = hashStructure.getString(string6)) != null) {
            hashStructure.remove(string6);
            hashStructure.putString(string5, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void migrateFolderSettings() {
        HashStructure hashStructure = DatabasesFolderCache.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DATA_KEY);
        HashStructure hashStructure2 = hashStructure.getHashStructure(LEGACY_KEY);
        if (hashStructure2 != null) {
            HashStructure hashStructure3 = hashStructure.getOrCreateHashStructure(CONNECTIONS_KEY);
            for (String string : hashStructure2.keySet()) {
                HashStructure hashStructure4;
                if (hashStructure2.keyStatus(string) != 1 || (hashStructure4 = hashStructure2.getHashStructure(string)) == null) continue;
                for (String string2 : hashStructure4.keySet()) {
                    if (hashStructure4.keyStatus(string2) != 1) continue;
                    ListStructure listStructure = hashStructure4.getListStructure(string2);
                    Object object = listStructure.iteratorLock();
                    synchronized (object) {
                        for (Object e : listStructure) {
                            String string3 = DatabasesFolderCache.decode((String)((String)e));
                            Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(string, string3);
                            String string4 = DatabasesFolderCache.createKey("sqldev.nav", connectionKey.getQualifiedName());
                            hashStructure3.putString(string4, string2);
                        }
                    }
                }
            }
            hashStructure.remove(LEGACY_KEY);
        }
    }

    private ListStructure getConnectionList(String string, String string2) {
        String string3 = DatabasesFolderCache.encode((String)string2);
        HashStructure hashStructure = this.getRootHash().getOrCreateHashStructure(string);
        ListStructure listStructure = hashStructure.getListStructure(string3);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            hashStructure.putListStructure(string3, listStructure);
        }
        return listStructure;
    }
}

