/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.Ide;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class FolderNamePanel
extends DialogTraversable {
    static final String FOLDER_NAME_KEY = "FolderName";
    static final String OTHER_NAMES_KEY = "OtherFolderNames";
    private JTextField mFldName = new JTextField();
    private Set<String> m_names;
    private String m_origName;

    static String getFolderName(String[] stringArray, String string) {
        FolderNamePanel folderNamePanel = new FolderNamePanel();
        Namespace namespace = new Namespace();
        namespace.put(FOLDER_NAME_KEY, (Object)string);
        namespace.put(OTHER_NAMES_KEY, (Object)stringArray);
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), DatabaseNavigatorResources.getString("MENU_NEW_FOLDER"), (Traversable)folderNamePanel, namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog();
        return tDialogLauncher.showDialog() ? (String)namespace.find(FOLDER_NAME_KEY) : null;
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldName, (String)DatabaseNavigatorResources.getString("LABEL_FOLDER_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE));
        jPanel.add((Component)this.mFldName, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        return jPanel;
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        String[] stringArray;
        super.onEntry(traversableContext);
        final DialogCallbacks dialogCallbacks = traversableContext.getDialogCallbacks();
        this.mFldName.getDocument().addDocumentListener(new DocumentListener(){

            private void validateName() {
                String string = FolderNamePanel.this.mFldName.getText();
                if (FolderNamePanel.this.m_origName != null && FolderNamePanel.this.m_origName.equals(string) || string == null || string.trim().length() == 0) {
                    dialogCallbacks.enableOKButton(false);
                } else {
                    dialogCallbacks.enableOKButton(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }
        });
        String string = (String)traversableContext.find(FOLDER_NAME_KEY);
        if (string != null) {
            this.m_origName = string;
            this.mFldName.setText(string);
        }
        this.m_names = (stringArray = (String[])traversableContext.find(OTHER_NAMES_KEY)) != null ? new HashSet<String>(Arrays.asList(stringArray)) : Collections.emptySet();
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        String string = this.mFldName.getText().trim();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(ExtrasMessages.getString("FolderNamePanel.3"));
        }
        if (ModelUtil.areEqual((Object)string, (Object)this.m_origName)) {
            throw new TraversalException(ExtrasMessages.getString("FolderNamePanel.4"));
        }
        if (this.m_names.contains(string)) {
            throw new TraversalException(ExtrasMessages.getString("FolderNamePanel.5"));
        }
        traversableContext.put(FOLDER_NAME_KEY, (Object)string);
    }

    public String getHelpID() {
        return "f1_newconnfolder_html";
    }

    @Override
    public Component getInitialFocusComponent() {
        return this.mFldName;
    }
}

