/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.util.Properties;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.util.ModelUtil;

public final class FoldersConnectionPropertiesUpdater
implements ConnectionPropertiesUpdater {
    private static final String FOLDER_KEY = "NAV_FOLDER";
    private String m_storeID;

    private String createQualifiedConnectionName(String string) {
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(this.m_storeID, string);
        return connectionKey.getQualifiedName();
    }

    @Override
    public void processForExport(String string, Properties properties) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        TreePath treePath = databasesFolderCache.getFolder("sqldev.nav", this.createQualifiedConnectionName(string));
        if (treePath != null) {
            properties.put(FOLDER_KEY, DatabasesFolderCache.convertToEncodedPath(treePath));
        }
    }

    @Override
    public void processForImport(String string, Properties properties, boolean bl) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        String string2 = properties.getProperty(FOLDER_KEY);
        TreePath treePath = DatabasesFolderCache.createTreePath(string2);
        String string3 = this.createQualifiedConnectionName(string);
        TreePath treePath2 = databasesFolderCache.getFolder("sqldev.nav", string3);
        if (treePath2 != null) {
            databasesFolderCache.removeFolder("sqldev.nav", string3);
        }
        if (treePath != null) {
            databasesFolderCache.addFolder("sqldev.nav", string3, new TreePath(treePath));
        }
    }

    @Override
    public void setConnectionStore(String string) {
        if (ModelUtil.areDifferent((Object)string, (Object)this.m_storeID)) {
            this.m_storeID = string;
        }
    }
}

