/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.net.AbstractURLStreamHandler;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;

public class DBURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static Set<String> SOURCE_TYPE = new HashSet<String>(Arrays.asList("PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY", "PROCEDURE", "FUNCTION", "TRIGGER", "EDITION_TRIGGER", "OPERATOR"));
    public static final String createOrReplace = "create or replace ";

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        return string.startsWith("sqldev.nav") ? new DBURLStreamHandler() : null;
    }

    static boolean isOracleSource(URL uRL) {
        return Connections.getInstance().isOracle(DBURLFormatHelper.getConnectionName(uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType(uRL));
    }

    static boolean isOracleTimesTenSource(URL uRL) {
        return Connections.getInstance().isTimesTen(DBURLFormatHelper.getConnectionName(uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType(uRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] fetchSource(URL uRL) {
        Query query;
        PlSqlNode plSqlNode = PlSqlNode.get(uRL);
        if (plSqlNode != null) {
            TextBuffer textBuffer = plSqlNode.acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            plSqlNode.releaseTextBuffer();
            return string.toCharArray();
        }
        StringBuffer stringBuffer = new StringBuffer(createOrReplace);
        String string = DBURLFormatHelper.getConnectionName(uRL);
        String string2 = DBURLFormatHelper.getSchema(uRL);
        String string3 = DBURLFormatHelper.getName(uRL);
        ConnectionIdentifier connectionIdentifier = DefaultConnectionIdentifier.createIdentifier((String)string, null);
        if (connectionIdentifier != null && (query = Queries.getQuery(connectionIdentifier, "source")) != null) {
            String string4;
            String string5 = DBURLFormatHelper.getBaseType(uRL);
            if (string5.equals("EDITION_TRIGGER")) {
                string5 = "TRIGGER";
            }
            if (!createOrReplace.contains("\n")) {
                DebugJDI.setLineNumberAdjustmentValue((int)0);
            }
            boolean bl = 1 < (string4 = query.getSql()).toUpperCase().indexOf("SYS.DBA_SOURCE");
            boolean bl2 = "TRIGGER".equals(string5) && !bl;
            boolean bl3 = "OPERATOR".equals(string5);
            if (bl2) {
                query = Queries.getQuery(connectionIdentifier, "trigger_source");
                string4 = query != null ? query.getSql() : null;
            } else if (bl3) {
                query = Queries.getQuery(connectionIdentifier, "operator_source");
                String string6 = string4 = query != null ? query.getSql() : null;
            }
            if (string4 != null) {
                ResultSet resultSet = null;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TYPE", string5);
                hashMap.put("OWNER", string2);
                hashMap.put("NAME", string3);
                if (Connections.getInstance().lock(connectionIdentifier.getConnection())) {
                    block19: {
                        try {
                            DBUtil dBUtil = DBUtil.getInstance((String)string);
                            if (dBUtil == null) break block19;
                            resultSet = dBUtil.executeQuery(string4, hashMap);
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    String string7 = resultSet.getString(1);
                                    if (bl2) {
                                        String string8 = resultSet.getString(2);
                                        if (string8 != null) {
                                            string7 = string7 != null && string7.length() > 0 && Character.isWhitespace(string7.charAt(string7.length() - 1)) || string8.length() > 0 && Character.isWhitespace(string8.charAt(0)) ? string7 + string8 : string7 + " " + string8;
                                        }
                                    } else if (bl3) {
                                        string7 = resultSet.getString(1);
                                        stringBuffer = new StringBuffer(string7);
                                        break block19;
                                    }
                                    stringBuffer.append(string7);
                                }
                                break block19;
                            }
                            SQLException sQLException = dBUtil.getLastException();
                            if (sQLException == null) break block19;
                            Logger.warn(DBURLStreamHandlerFactory.class, (String)sQLException.getLocalizedMessage(), (Throwable)sQLException);
                        }
                        catch (SQLException sQLException) {
                            try {
                                Logger.warn(DBURLStreamHandlerFactory.class, (String)sQLException.getLocalizedMessage(), (Throwable)sQLException);
                            }
                            catch (Throwable throwable) {
                                DBUtil.closeResultSet(resultSet);
                                Connections.getInstance().unlock(string);
                                throw throwable;
                            }
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            Connections.getInstance().unlock(string);
                        }
                    }
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(string);
                }
            }
        }
        return stringBuffer.toString().toCharArray();
    }

    private static final class Queries {
        private static QueryXMLSupport defaultQueries = Queries.loadQueries("oracle/dbtools/raptor/navigator/net/source.xml");
        private static QueryXMLSupport ttQueries = Queries.loadQueries("oracle/dbtools/raptor/navigator/net/x10source.xml");

        private Queries() {
        }

        static Query getQuery(ConnectionIdentifier connectionIdentifier, String string) {
            Query query;
            if (Connections.getInstance().isTimesTen(connectionIdentifier.getConnection())) {
                query = ttQueries.getQuery(string, connectionIdentifier);
                if (query == null) {
                    query = defaultQueries.getQuery(string, connectionIdentifier);
                }
            } else {
                query = QueryUtils.promoteToDba((Query)defaultQueries.getQuery(string, connectionIdentifier), (ConnectionIdentifier)connectionIdentifier);
            }
            return query;
        }

        private static QueryXMLSupport loadQueries(String string) {
            return QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(DBURLStreamHandlerFactory.class.getClassLoader(), string));
        }
    }

    private static class DBURLConnection
    extends URLConnection {
        private Database m_db;

        private DBURLConnection(URL uRL) {
            super(uRL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            DBURLConnection dBURLConnection = this;
            synchronized (dBURLConnection) {
                if (!this.connected) {
                    try {
                        this.m_db = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName(this.url));
                        if (this.m_db == null) {
                            throw new FileNotFoundException(this.url.toExternalForm());
                        }
                    }
                    catch (DBException dBException) {
                        throw new IOException(dBException.getLocalizedMessage());
                    }
                    this.connected = true;
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            InputStream inputStream = null;
            String string = DBURLFormatHelper.getSchema(this.url);
            String string2 = DBURLFormatHelper.getName(this.url);
            String string3 = DBURLFormatHelper.getBaseType(this.url);
            if (string3.equals("EDITION_TRIGGER")) {
                string3 = "TRIGGER";
            }
            if (DBURLStreamHandlerFactory.isOracleSource(this.url) || DBURLStreamHandlerFactory.isOracleTimesTenSource(this.url)) {
                char[] cArray = DBURLStreamHandlerFactory.fetchSource(this.url);
                if (cArray != null) {
                    String string4 = new String(cArray);
                    inputStream = this.getInputStreamFromString(string4);
                }
            } else {
                String string5 = null;
                if ("PACKAGE".equals(string3) || "TYPE".equals(string3)) {
                    string5 = "Spec";
                } else if ("PACKAGE BODY".equals(string3) || "TYPE BODY".equals(string3)) {
                    string3 = "PACKAGE BODY".equals(string3) ? "PACKAGE" : "TYPE";
                    string5 = "Body";
                }
                try {
                    SchemaObject schemaObject;
                    Schema schema = this.m_db.getSchema(string);
                    String string6 = this.m_db.getDatabaseSource(string3, schema, string2, string5);
                    inputStream = string6 != null ? this.getInputStreamFromString(string6) : ((schemaObject = this.m_db.getObject(string3, schema, string2)) instanceof BinaryObject ? ((BinaryObject)schemaObject).getInputStream() : new ByteArrayInputStream(new byte[0]));
                }
                catch (DBException dBException) {
                    throw new IOException(dBException.getLocalizedMessage());
                }
            }
            return inputStream;
        }

        private InputStream getInputStreamFromString(String string) {
            byte[] byArray;
            try {
                byArray = string.getBytes(IdeUtil.getIdeEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }
    }

    private static class DBURLStreamHandler
    extends AbstractURLStreamHandler {
        private DBURLStreamHandler() {
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            return new DBURLConnection(uRL);
        }

        protected boolean equals(URL uRL, URL uRL2) {
            return ModelUtil.areEqual((Object)this.toExternalForm(uRL), (Object)this.toExternalForm(uRL2));
        }

        protected int hashCode(URL uRL) {
            return this.toExternalForm(uRL).hashCode();
        }
    }
}

