/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlSqlCompilerPage;
import oracle.dbtools.raptor.navigator.plsql.PlSqlTranslator;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.navigator.plsql.Project;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.dbtools.raptor.runner.DBSourceFinder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Debugger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class PlSqlNode
extends RunnableSourceNode
implements DBObjectPlSqlNode,
Comparable<PlSqlNode>,
EquippedWithParser {
    private static final String KEYWORD_BODY = "BODY";
    private static final String KEYWORD_FUNCTION = "FUNCTION";
    private static final String KEYWORD_PROCEDURE = "PROCEDURE";
    public static final String PLSQL_SOURCE_EXTENSION = ".pls";
    private List<Member> members = new LinkedList<Member>();
    private BackgroundParser parser = new BackgroundParser();
    private static Map<String, PlSqlNode> cache = new HashMap<String, PlSqlNode>();
    private String m_parsedOwner = null;
    private String m_parsedType = null;
    private String m_parsedName = null;
    public boolean invokedFromToolbar = false;
    private LinkedList<Observer> listeners = new LinkedList();
    private boolean readOnly = false;

    public static PlSqlNode get(URL uRL) {
        return cache.get(uRL.toString());
    }

    public static PlSqlNode find(URL uRL) {
        DatabaseNode databaseNode;
        String string = uRL.toString();
        PlSqlNode plSqlNode = cache.get(string);
        if (plSqlNode == null && (databaseNode = DatabaseNavigatorElementFactory.getObjectNode(uRL)) instanceof PlSqlNode) {
            plSqlNode = (PlSqlNode)databaseNode;
            cache.put(string, plSqlNode);
        }
        return plSqlNode;
    }

    public PlSqlNode() {
        Attributes attributes = this.getAttributes();
        attributes.unset(ElementAttributes.RENAMEABLE);
        attributes.set(ElementAttributes.SAVEABLE_AS);
    }

    void setCursor(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Ide.getMainWindow().setCursor(new Cursor(n));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void openImpl() throws IOException {
        this.setCursor(3);
        this.m_name = null;
        this.m_cName = null;
        this.m_type = null;
        this.m_schema = null;
        this.parseURL();
        cache.remove(this.getURL().toString());
        super.openImpl();
        this.readOnly = DBConfig.getInstance().getBoolean("READONLYSQLEDITORS");
        this.setCursor(0);
        cache.put(this.getURL().toString(), this);
    }

    protected void closeImpl() throws IOException {
        try {
            super.closeImpl();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        LogPage logPage = PlSqlCompilerPage.getErrorLog();
        logPage.clearAll();
        cache.remove(this.getURL().toString());
    }

    public boolean mayHaveChildren() {
        return DBURLFormatHelper.isDBURL(this.getURL());
    }

    public Icon getIcon() {
        Icon icon = null;
        if (this.m_node != null && this.m_node.getObjectFactory() != null) {
            ConnectionTypeDetails connectionTypeDetails = this.m_node.getObjectFactory().getConnectionTypeDescriptor().getImpl();
            icon = connectionTypeDetails.getIcon(this.m_node);
        }
        if (icon == null && DBURLFormatHelper.isDBURL(this.getURL()) && this.getNodeInstance() != null && !"BLOCK".equals(this.m_type) && this.getNodeInstance().getDescriptor() != null) {
            icon = this.getNodeInstance().getDescriptor().getIcon();
        } else if (icon == null) {
            icon = OracleNavigatorResource.getIcon("PACKAGE_ICON");
        }
        return icon;
    }

    public boolean isBody() {
        URL uRL = this.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        return string != null && string.contains(KEYWORD_BODY);
    }

    public String getPackage(oracle.ide.model.Project project) {
        CharSequence charSequence;
        URL uRL = this.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if (string == null) {
            string = this.getSrcType();
        }
        string = ArgusHelper.getArgusNameForType(string);
        String string2 = DBURLFormatHelper.getSchema(uRL);
        if (string2 == null) {
            string2 = this.getSrcOwner();
        }
        if (string2 == null) {
            try {
                charSequence = this.getConnectionName();
                if (charSequence == null) {
                    Set<String> set = Project.getInstance().getDbURL(uRL.toString());
                    if (set.size() == 1) {
                        for (String string3 : set) {
                            string2 = DBURLFormatHelper.getSchema(new URL(string3));
                        }
                    }
                } else {
                    Database database = Connections.getInstance().getDatabase((String)charSequence, false);
                    string2 = database.getUserName();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("$Oracle.");
        ((StringBuilder)charSequence).append(string);
        ((StringBuilder)charSequence).append(".");
        ((StringBuilder)charSequence).append(string2);
        return ((StringBuilder)charSequence).toString();
    }

    public String getSourceFile() {
        String string;
        String string2 = (String)this.getProperty("NAME");
        String string3 = string = ModelUtil.hasLength((String)string2) ? string2 : URLFileSystem.getFileName((URL)this.getURL());
        if (string.indexOf(46) >= 0) {
            string = string.substring(0, string.indexOf(46));
        }
        return string + PLSQL_SOURCE_EXTENSION;
    }

    public String getSrcType() {
        if (this.m_parsedType == null) {
            this.parseNameTypeOwner();
        }
        return this.m_parsedType;
    }

    public String getSrcName() {
        if (this.m_parsedName == null) {
            this.parseNameTypeOwner();
        }
        return this.m_parsedName;
    }

    public String getSrcOwner() {
        if (this.m_parsedName == null) {
            this.parseNameTypeOwner();
        }
        if (this.m_parsedOwner != null) {
            return this.m_parsedOwner;
        }
        return this.getOwner();
    }

    public URL matchingDbUrl() {
        String string = this.getSrcName();
        String string2 = this.getSrcType();
        String string3 = this.getSrcOwner();
        String string4 = this.getConnectionName();
        if (string3 == null) {
            try {
                Database database = Connections.getInstance().getDatabase(string4, true);
                string3 = database.getUserName();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.matchingDbUrlImpl(string, string2, string3, string4);
    }

    private URL matchingDbUrlImpl(String string, String string2, String string3, String string4) {
        URL uRL;
        String string5 = " BODY";
        if (string2.endsWith(string5)) {
            String string6 = string2.substring(0, string2.indexOf(string5));
            URL uRL2 = this.matchingDbUrlImpl(string, string6, string3, string4);
            uRL = DBURLFormatHelper.getEnclosedTypeURL(uRL2, string2);
        } else {
            uRL = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string3, string2);
        }
        return DBURLFormatHelper.getURL(uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImpl() throws IOException {
        this.writeLock();
        try {
            String string;
            URL uRL = this.getURL();
            if (!DBURLFormatHelper.isDBURL(uRL)) {
                if (!this.validated(uRL)) {
                    if (MessageDialog.confirm(null, (Object)DatabaseNavigatorResources.getString("PLSQLNODE_FILEPATH_CHANGED"), (String)"", null)) {
                        this.close();
                    }
                    return;
                }
                super.saveImpl();
                if (!this.invokedFromToolbar) {
                    return;
                }
            }
            this.invokedFromToolbar = false;
            final String string2 = this.getConnectionName();
            if (string2 == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString("PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
                return;
            }
            this.parseNameTypeOwner();
            if (this.m_parsedOwner == null) {
                if (this.getSrcOwner() != null) {
                    this.m_parsedOwner = this.getSrcOwner();
                } else if (Connections.getInstance().lock(string2)) {
                    try {
                        this.m_parsedOwner = DBUtil.getInstance((String)string2).executeOracleReturnOneCol("select SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema from dual", new HashMap());
                    }
                    finally {
                        Connections.getInstance().unlock(string2);
                    }
                }
            }
            this.setProperty("SCHEMA", this.m_parsedOwner);
            String string3 = this.m_parsedOwner;
            if (string3 != null) {
                int n = string3.length();
                if (string3.charAt(0) == '\"' && n > 1 && string3.charAt(n - 1) == '\"') {
                    string3 = Service.addDoubleQuote((String)string3.substring(1, n - 1));
                }
            }
            if ((string = this.m_parsedName) == null) {
                string = this.m_name;
                this.m_parsedName = this.m_name;
            }
            if (this.m_parsedType == null || "EDITION_TRIGGER".equals(this.m_type)) {
                this.m_parsedType = this.m_type;
            }
            final URL uRL2 = this.matchingDbUrlImpl(string, this.m_parsedType, string3, string2);
            Debugger debugger = Debugger.getDebugger();
            if (debugger.isDebugging()) {
                throw new IOException(ConnectionArb.getString((String)"ERROR_SAVING_WHILE_DEBUGGING"));
            }
            TextBuffer textBuffer = this.getTextBufferDirectly();
            if (textBuffer != null) {
                textBuffer.clearModified();
            }
            final PlSqlTranslator plSqlTranslator = new PlSqlTranslator(this);
            plSqlTranslator.translate();
            List<PlSqlErrorInfo> list = plSqlTranslator.getErrors();
            this.setProperty("INVALID", "false");
            boolean bl = false;
            boolean bl2 = false;
            for (PlSqlErrorInfo plSqlErrorInfo : list) {
                if (!plSqlErrorInfo.isWarning() && !plSqlErrorInfo.getErrorMessage().startsWith("ORA-02303: can't")) {
                    this.setProperty("INVALID", "true");
                    bl2 = true;
                    continue;
                }
                bl = true;
            }
            this.setProperty("PLSQL_DEBUG", DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL") < 2 ? "true" : "false");
            this.setProperty("PLSQL_OPTIMIZE_LEVEL", DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL"));
            final boolean bl3 = bl2;
            final boolean bl4 = bl;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IdeStorage ideStorage = new IdeStorage((Node)PlSqlNode.this);
                    ideStorage.setProperty("PlSqlCompilerPage.URL", (Object)uRL2);
                    IdeLog ideLog = new IdeLog();
                    LogPage logPage = PlSqlCompilerPage.getErrorLog();
                    logPage.clearAll();
                    ideLog.registerAsynchronousLogPage(logPage);
                    ideLog.setProject(DBNavigatorWindow.getProject(string2));
                    ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
                    ideLog.clear((Storage)ideStorage);
                    plSqlTranslator.logErrors((Translator.Log)ideLog);
                    ideLog.completed();
                    ideLog.unregisterAsynchronousLogPage(logPage);
                    String string = bl3 && bl4 ? "PLSQLNODE_ERRORS_AND_WARNINGS" : (bl3 ? "PLSQLNODE_ERRORS" : (bl4 ? "PLSQLNODE_WARNINGS" : "PLSQLNODE_COMPILED"));
                    LogManager logManager = LogManager.getLogManager();
                    logManager.getMsgPage().log((Object)DatabaseNavigatorResources.format(string, PlSqlNode.this.getShortLabel()));
                    if (!logManager.isLogVisible()) {
                        logManager.showLog();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            DatabaseOverlayClient.updateOverlay(this);
            if (DBURLFormatHelper.isDBURL(uRL)) {
                URL uRL3;
                PlSqlNode plSqlNode;
                if (!uRL2.equals(uRL)) {
                    PlSqlNode plSqlNode2 = this;
                    Thread thread = new Thread((Node)plSqlNode2, uRL2){
                        final /* synthetic */ Node val$self;
                        final /* synthetic */ URL val$matchingDbUrl;
                        {
                            this.val$self = node;
                            this.val$matchingDbUrl = uRL;
                        }

                        @Override
                        public void run() {
                            EditorManager editorManager = EditorManager.getEditorManager();
                            LinkedList<Editor> linkedList = new LinkedList<Editor>();
                            for (Object e : editorManager.getAllEditors()) {
                                Context context = ((Editor)e).getContext();
                                Node node = context != null ? context.getNode() : null;
                                if (node != this.val$self) continue;
                                linkedList.add((Editor)e);
                            }
                            editorManager.closeEditors(linkedList);
                            NavSelectionListener.getInstance().waitOnOpen(this.val$matchingDbUrl, 1, 1);
                        }
                    };
                    thread.run();
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString("PLSQLNODE_RENAMED"), (String)"Name changed", null);
                    return;
                }
                if (this.isBody() && (plSqlNode = (PlSqlNode)NodeFactory.find((URL)(uRL3 = DBURLFormatHelper.getEnclosingURL(this.getURL())))) != null) {
                    plSqlNode.setProperty("HAS_BODY", "TRUE");
                }
                this.updateNavigator();
                this.updateListeners();
                return;
            }
            this.setURL(uRL2);
            if (!bl2) {
                Project.getInstance().save(uRL.toString(), uRL2.toString());
            }
            this.setURL(uRL);
            this.updateNavigator();
            DBSourceFinder.resetWarning(this);
            this.updateListeners();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void updateListeners() {
        for (Observer observer : this.listeners) {
            observer.update((Object)this, null);
        }
    }

    private void updateNavigator() {
        UpdateMessage.fireStructureChanged((Subject)this);
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)this);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void parseNameTypeOwner() {
        this.m_parsedName = null;
        this.m_parsedType = null;
        this.m_parsedOwner = null;
        this.getSource();
        Item item = this.parser.parseNameTypeOwner(this);
        this.m_parsedName = item.objName;
        this.m_parsedType = item.objType;
        this.m_parsedOwner = item.owner;
    }

    public void addListener(Observer observer) {
        if (!this.listeners.contains(observer)) {
            this.listeners.add(observer);
        }
    }

    public void removeListener(Observer observer) {
        this.listeners.remove(observer);
    }

    public void initMembers() {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
    }

    public synchronized List<Member> parseMembers() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        String string = textBuffer.getString(0, textBuffer.getLength());
        this.releaseTextBuffer();
        List list = LexerToken.parse((String)string);
        this.members.clear();
        this.members.addAll(this.parseMembers(list));
        return this.members;
    }

    private List<Member> parseMembers(List<LexerToken> list) {
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(list, PlSqlArguments.getSort());
        LinkedList<Member> linkedList = new LinkedList<Member>();
        linkedList.addAll(plsqlStructureParser.children);
        if (this.isBody()) {
            URL uRL = this.getURL();
            String string = DBURLFormatHelper.getBaseType(uRL);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
            PlSqlNode plSqlNode = PlSqlNode.find(uRL2);
            if (plSqlNode == null) {
                System.out.println("pkgNode == null for pkgUrl=" + uRL2.toString());
                return linkedList;
            }
            if (plSqlNode.members.size() == 0) {
                plSqlNode.parseMembers();
            }
            for (Member member : linkedList) {
                if (!KEYWORD_FUNCTION.equals(member.type) && !KEYWORD_PROCEDURE.equals(member.type)) continue;
                boolean bl = false;
                for (Member member2 : plSqlNode.members) {
                    if (!KEYWORD_FUNCTION.equals(member2.type) && !KEYWORD_PROCEDURE.equals(member2.type) || !member2.name.equalsIgnoreCase(member.name)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                member.isPrivate = true;
            }
        }
        return linkedList;
    }

    public void addMembersTo(Collection<Member> collection) {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
        for (Member member : this.members) {
            collection.add(member);
        }
    }

    public List<Member> getMembers(String string) {
        if (0 < string.indexOf(46)) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        LinkedList<Member> linkedList = new LinkedList<Member>();
        for (Member member : this.members) {
            if (!Service.handleMixedCase((String)member.name).equals(Service.handleMixedCase((String)string))) continue;
            linkedList.add(member);
        }
        return linkedList;
    }

    @Override
    public final String getSource() {
        String string = super.getSource().trim();
        if (!DBURLFormatHelper.isDBURL(this.getURL())) {
            string = PlSqlNode.trimRemErrorsSlash(string);
        }
        return string;
    }

    private static String trimRemErrorsSlash(String string) {
        int n = 0;
        int n2 = string.length();
        List list = LexerToken.parse((String)string);
        int n3 = -1;
        int n4 = -1;
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : list) {
            if (n4 == -1) {
                n = lexerToken2.begin;
            }
            ++n4;
            if ("/".equals(lexerToken2.content) && ";".equals(lexerToken.content)) {
                n3 = n4;
            }
            lexerToken = lexerToken2;
        }
        if (n3 != -1) {
            LexerToken lexerToken2;
            List list2 = list.subList(n3 + 1, list.size());
            lexerToken2 = SqlEarley.getInstance().parse(list2);
            if (PlSqlNode.recognizedRemAlter((ParseNode)lexerToken2)) {
                n2 = ((LexerToken)list.get((int)n3)).begin;
            }
        }
        return string.substring(n, n2);
    }

    private static boolean recognizedRemAlter(ParseNode parseNode) {
        return true;
    }

    public static int offset(String string, String string2) {
        if (string == null) {
            return 0;
        }
        List list = LexerToken.parse((String)string, (boolean)true);
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (!"procedure".equalsIgnoreCase(lexerToken.content) && !"function".equalsIgnoreCase(lexerToken.content) && !"package".equalsIgnoreCase(lexerToken.content) && !"type".equalsIgnoreCase(lexerToken.content) && (!"trigger".equalsIgnoreCase(string2) || !"begin".equalsIgnoreCase(lexerToken.content) && !"declare".equalsIgnoreCase(lexerToken.content))) continue;
            n = lexerToken.begin;
            break;
        }
        if (n == -1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ('\n' != string.charAt(i)) continue;
            ++n2;
        }
        return n2;
    }

    public int offset(String string) {
        return PlSqlNode.offset(this.parser.text, string);
    }

    @Override
    public Object getProperty(String string) {
        return "SHORT_NAME".equals(string) && "BLOCK".equals(this.m_type) ? "ANONYMOUS_BLOCK" : super.getProperty(string);
    }

    @Override
    public String getShortLabel() {
        String string = super.getShortLabel();
        return this.isBody() ? string + " Body" : string;
    }

    @Override
    public int compareTo(PlSqlNode plSqlNode) {
        return this.getURL().toString().compareTo(plSqlNode.getURL().toString());
    }

    @Override
    public BackgroundParser getParser() {
        return this.parser;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void toggleReadOnly() {
        this.readOnly = !this.readOnly;
    }

    public boolean dictionarySupported() {
        return true;
    }

    public boolean hasBody() {
        return Boolean.parseBoolean((String)this.getProperty("HAS_BODY")) || !DBURLFormatHelper.isDBURL(this.getURL());
    }

    private boolean validated(URL uRL) {
        String string = URLFileSystem.getPath((URL)uRL);
        return new File(string).exists();
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() != UpdateMessage.OBJECT_CLOSED) {
            super.notifyObservers(object, updateMessage);
        }
    }

    @Override
    public String getType() {
        String string = super.getType();
        if (string != null) {
            return string;
        }
        return this.getSrcType();
    }

    static {
        CodeEditor.registerNodeType(PlSqlNode.class, (String)CodeEditorConstants.TYPE_PLSQL);
    }
}

