/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.TabColTest;
import oracle.dbtools.raptor.phighlight.GbyAdvice;
import oracle.dbtools.raptor.phighlight.SemanticAnalysis;
import oracle.dbtools.util.Service;

public class GbyTest {
    private static int testNo = 0;
    private static boolean unitTestIsOK = true;
    static Set<RuleTuple> rules = GbyTest.gbyRules();
    static Earley earley = new Earley(rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING || n2 == this.identifier && lexerToken.type == Token.BQUOTED_STRING;
        }
    };
    private static int output = (Integer)GbyTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)GbyTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)GbyTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)GbyTest.earley.symbolIndexes.get("comment");
    private static int prompt = (Integer)GbyTest.earley.symbolIndexes.get("prompt");

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(GbyTest.class, (String)"gby.test");
        List list = LexerToken.parse((String)string, (String)"`");
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, (Matriceable)matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw((Matriceable)matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        GbyTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (unitTestIsOK) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    private static Set<RuleTuple> gbyRules() {
        try {
            String string = Service.readFile(TabColTest.class, (String)"TabColTest.grammar");
            List list = LexerToken.parse((String)string, (boolean)false, (int)1);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            treeSet.remove(new RuleTuple("prompt", new String[]{"\"sql fragment\""}));
            treeSet.add(new RuleTuple("prompt", new String[]{"'GROUP'", "'BY'"}));
            treeSet.add(new RuleTuple("prompt", new String[]{"prompt", "sql_token"}));
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for Gby test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            System.out.print("TEST#" + testNo++ + " -> ");
            if (GbyTest.assertion(parseNode, list, string)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                System.out.println("TEST#" + testNo++ + " ->\n" + GbyTest.query(parseNode2, list, string));
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            GbyTest.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            GbyTest.atest(parseNode3, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = null;
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(query)) {
                string2 = GbyTest.output(parseNode2, list, string);
                continue;
            }
            if (!parseNode2.contains(prompt)) continue;
            string3 = GbyTest.prompt(parseNode2, list, string);
        }
        if (!string2.equals(string3)) {
            for (int i = 0; i < string2.length() && i < string3.length(); ++i) {
                if (string2.charAt(i) == string3.charAt(i)) continue;
                int n = i + 30;
                String string4 = "...";
                if (string2.length() < n) {
                    n = string2.length();
                    string4 = "";
                }
                System.out.println(string2.substring(0, i) + " >>> " + string2.substring(i, n) + string4 + " <<<");
                break;
            }
            unitTestIsOK = false;
            return false;
        }
        return true;
    }

    private static String prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        return string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
    }

    private static String query(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = GbyTest.output(parseNode, list, string);
        return string2;
    }

    private static String output(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        ParseNode parseNode2;
        ParseNode parseNode3;
        Object object3;
        Object object2;
        MaterializedPredicate materializedPredicate;
        String string2 = string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
        string2 = string2.replace("`", "");
        list = LexerToken.parse((String)string2);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, (Matriceable)matrix);
        parseNode = sqlEarley.forest(list, matrix);
        SemanticAnalysis semanticAnalysis = new SemanticAnalysis();
        Map map = semanticAnalysis.run(string, list);
        TreeMap<Object, ParseNode> treeMap = new TreeMap<Object, ParseNode>();
        MaterializedPredicate materializedPredicate2 = (MaterializedPredicate)map.get("\"aggregate expr\"");
        if (materializedPredicate2 != null) {
            materializedPredicate = materializedPredicate2.getTuples().iterator();
            while (materializedPredicate.hasNext()) {
                object2 = (Tuple)materializedPredicate.next();
                object3 = materializedPredicate2.getAttribute((Tuple)object2, "top_select_list");
                treeMap.put(object3, null);
            }
        }
        if ((materializedPredicate = (MaterializedPredicate)map.get("\"matching gby\"")) != null) {
            for (Object object3 : materializedPredicate.getTuples()) {
                parseNode3 = materializedPredicate.getAttribute((Tuple)object3, "top_select_list");
                parseNode2 = materializedPredicate.getAttribute((Tuple)object3, "group_by_list");
                treeMap.put(parseNode3, parseNode2);
            }
        }
        object2 = (MaterializedPredicate)map.get("columns");
        object3 = treeMap.keySet().iterator();
        if (object3.hasNext()) {
            parseNode3 = (ParseNode)object3.next();
            parseNode2 = new TreeMap();
            for (Tuple tuple : object2.getTuples()) {
                Iterator iterator;
                ParseNode parseNode4 = object2.getAttribute(tuple, "top_select_list");
                ParseNode parseNode5 = object2.getAttribute(tuple, "column");
                if (parseNode4.compareTo((Object)parseNode3) != 0) continue;
                String string3 = parseNode5.content(list);
                if (parseNode5.contains("\"aliased_expr\"") && (iterator = parseNode5.children().iterator()).hasNext()) {
                    ParseNode parseNode6 = (ParseNode)iterator.next();
                    string3 = parseNode6.content(list);
                }
                parseNode2.put(parseNode5.from, string3);
            }
            if (parseNode2.size() == 0) {
                return "group by null";
            }
            GbyAdvice gbyAdvice = new GbyAdvice(-1, -1, -1, -1, (Map<Integer, String>)parseNode2);
            return "group by " + gbyAdvice.replacement;
        }
        return "group by null";
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end));
        return null;
    }
}

