/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.raptor.phighlight.StarTemplate;
import oracle.dbtools.raptor.phighlight.TableAdvice;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ItemTemplate;

public class StarAdvice
extends Issue {
    String connection;
    String tables;
    String sql;
    static Map<String, Map<String, String>> colCache = new HashMap<String, Map<String, String>>();

    void clearCache() {
        Map<String, String> map = colCache.get(this.connection);
        if (map == null) {
            return;
        }
        map.remove(this.tables.toString());
    }

    static void starAdvice(int n, int n2, String string, Set<Issue> set, String string2) {
        try {
            TabCol tabCol = new TabCol(string2);
            List list = LexerToken.parse((String)string);
            SqlEarley sqlEarley = SqlEarley.getInstance();
            Matrix matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(list, (Matriceable)matrix);
            ParseNode parseNode = sqlEarley.forest(list, matrix);
            Map<ParseNode, String> map = tabCol.tblNames(parseNode, list);
            Map<String, Boolean> map2 = TableAdvice.tablesCache.get(string2);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string3 : map.values()) {
                Boolean bl = map2.get(string3.toUpperCase());
                if (bl == null || !bl.booleanValue()) continue;
                treeSet.add(string3 + ',');
            }
            if (treeSet.size() == 0) {
                return;
            }
            StarAdvice starAdvice = new StarAdvice(n, n2, string2, ((Object)treeSet).toString(), string);
            starAdvice.refresh();
            set.add(starAdvice);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void refresh() throws Exception {
        Map<String, String> map = colCache.get(this.connection);
        if (map == null) {
            map = new HashMap<String, String>();
            colCache.put(this.connection, map);
        }
        this.replacement = map.get(this.tables);
        if (this.replacement == null) {
            TabCol tabCol = new TabCol(this.connection);
            ArrayList<TabCol.Column> arrayList = tabCol.fetchColumns(this.sql);
            this.replacement = tabCol.expandColumns(arrayList, new String[]{}, ",\n", tabCol.tableCount() < 2);
            map.put(this.tables, this.replacement);
        }
    }

    StarAdvice(int n, int n2, String string, String string2, String string3) {
        super(n, n2, Messages.getString("ExpandColumns"), Issue.Type.ADVISORY);
        this.connection = string;
        this.tables = string2;
        this.sql = string3;
    }

    @Override
    boolean isFixable() {
        return true;
    }

    @Override
    public ItemTemplate getItemTemplate(InfoTipHover infoTipHover, InfoTipStyles infoTipStyles, BasicEditorPane basicEditorPane, String string) {
        StarTemplate starTemplate = new StarTemplate(this, infoTipStyles, basicEditorPane, this.from, this.to);
        return starTemplate;
    }
}

