/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnDPlugin;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.Project;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.dbtools.raptor.plsql.PinningTracker;
import oracle.dbtools.raptor.plsql.structure.OutlineMenu;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Array;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class PLSQLEditorToolbar
implements EditorPlugin,
Controller,
Observer {
    private ToggleToolButton pinToggle;
    private ToggleToolButton roToggle;
    private ToolButton gotoSpecBodyButton;
    private IdeAction pinAction;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    private CodeEditor parent;
    private Toolbar toolbar;
    private int buttonPos = 0;

    public void install(BasicEditorPane basicEditorPane) {
        Set<String> set;
        Object object;
        Component component;
        int n;
        this.parent = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.toolbar = this.parent.getToolbar();
        basicEditorPane.installPlugin((EditorPlugin)new RaptorDnDPlugin());
        Node node = this.parent.getContext().getNode();
        String string = node.getShortLabel();
        if (string != null && string.toLowerCase().startsWith("anon_block")) {
            return;
        }
        int[] nArray = null;
        for (n = 0; n < this.toolbar.getComponentCount(); ++n) {
            component = this.toolbar.getComponentAtIndex(n);
            if ("Ide.QUICK_ACTION_CMD_ID".equals(component.getName())) {
                nArray = Array.insert(nArray, (int)n);
            }
            if (!"Ide.SELECT_BLOCK_CMD_ID".equals(component.getName())) continue;
            nArray = Array.insert((int[])nArray, (int)n);
        }
        for (n = nArray.length - 1; 0 <= n; --n) {
            this.toolbar.remove((int)nArray[n]);
        }
        this.toolbar.remove(0);
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController((BasicEditorPane)basicEditorPane);
        if (findToolbarController != null) {
            findToolbarController.dispose();
        }
        component = UIUtils.createFindToolbarController((BasicEditorPane)basicEditorPane);
        JComponent jComponent = component.getToolbarsComponent();
        ((JComponent)this.parent.getFixedTopMargin()).add(jComponent);
        this.addPinAction(this.parent, this.toolbar);
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            this.addROAction(this.parent, this.toolbar);
        }
        IdeAction ideAction = OutlineMenu.getAction();
        ideAction.addController((Controller)OutlineMenu.getInstance());
        ToolButton toolButton = new ToolButton((Action)ideAction);
        this.toolbar.add((Component)toolButton, this.buttonPos++);
        if (node instanceof PlSqlNode) {
            object = (PlSqlNode)node;
            ((PlSqlNode)object).addListener(this);
            this.addGoToActions(this.parent, this.toolbar, (Node)object);
        }
        this.addCompileActions(this.parent, this.toolbar, node);
        this.addRunActions(this.parent, this.toolbar, node);
        object = new DBConnectionComboBox();
        this.toolbar.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0), new Dimension(Short.MAX_VALUE, 0)));
        this.toolbar.add((Component)((DBConnectionComboBox)object).getJComboBox());
        final PlSqlNode plSqlNode = (PlSqlNode)node;
        String string2 = null;
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            string2 = plSqlNode.getConnectionName();
        } else if (DBConfig.getInstance().getBoolean("LINKDBWITHFILESOURCES").booleanValue()) {
            set = Project.getInstance().getDbURL(node.getURL().toString());
            if (set.size() == 1) {
                for (String string3 : set) {
                    try {
                        string2 = DBURLFormatHelper.getConnectionName(new URL(string3));
                        plSqlNode.setConnectionName(string2);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else {
                int n2 = 0;
                for (String string4 : Connections.getInstance().getConnNames()) {
                    if (!Connections.getInstance().isConnectionOpen(string4)) continue;
                    string2 = string4;
                    ++n2;
                }
                if (n2 == 1) {
                    plSqlNode.setConnectionName(string2);
                } else {
                    string2 = null;
                }
            }
        }
        if (string2 != null) {
            ((DBConnectionComboBox)object).setCurrentConnection(string2);
        }
        set = new ItemListener((DBConnectionComboBox)object){
            String m_currConn;
            final /* synthetic */ DBConnectionComboBox val$dbSelector;
            {
                this.val$dbSelector = dBConnectionComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        String string = (String)itemEvent.getItem();
                        try {
                            Connections.getInstance().getConnection(string);
                            this.m_currConn = string;
                            plSqlNode.setConnectionName(string);
                        }
                        catch (DBException dBException) {
                            Throwable throwable = dBException.getCause();
                            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                            }
                            this.val$dbSelector.setCurrentConnection(this.m_currConn);
                        }
                        View.updateToolbarActions((Toolbar)PLSQLEditorToolbar.this.toolbar);
                        break;
                    }
                }
            }
        };
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            ((DBConnectionComboBox)object).getJComboBox().setEnabled(false);
            ((DBConnectionComboBox)object).getJComboBox().setFocusable(false);
        } else {
            ((DBConnectionComboBox)object).getJComboBox().addItemListener((ItemListener)((Object)set));
        }
        View.updateToolbarActions((Toolbar)this.toolbar);
    }

    private void addPinAction(CodeEditor codeEditor, Toolbar toolbar) {
        this.pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID);
        this.pinAction.addController((Controller)this);
        this.pinToggle = new ToggleToolButton((ToggleAction)this.pinAction);
        toolbar.add((Component)this.pinToggle, this.buttonPos++);
        Node node = codeEditor.getContext().getNode();
        boolean bl = PinningTracker.isPinned(node);
        this.pinAction.setState(bl);
        if (!bl) {
            this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
        }
    }

    private void addROAction(CodeEditor codeEditor, Toolbar toolbar) {
        IdeAction ideAction = IdeAction.find((int)PLSQLController.RO_EDITOR_CMD_ID);
        this.roToggle = new ToggleToolButton((ToggleAction)ideAction);
        toolbar.add((Component)this.roToggle, this.buttonPos++);
        PlSqlNode plSqlNode = (PlSqlNode)codeEditor.getContext().getNode();
        boolean bl = PinningTracker.isPinned((Node)plSqlNode);
        ideAction.setState(bl);
        PLSQLEditorToolbar.toggleROIcon(ideAction, plSqlNode, (View)codeEditor);
    }

    private void addCompileActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        IdeAction[] ideActionArray;
        String string;
        if (DBURLFormatHelper.isDBURL(node.getURL()) && ((string = (ideActionArray = new DBObject((Element)node)).getObjectType()) == null || "XML SCHEMA".equals(string))) {
            return;
        }
        ideActionArray = new IdeAction[]{this.createLocalAction((View)codeEditor, CompileArb.getIcon("COMPILECODEBUG_ICON"), Messages.getString("CompileForDebug"), PLSQLController.COMPILE_DEBUG_COMMAND), this.createLocalAction((View)codeEditor, CompileArb.getIcon("COMPILECODE_ICON"), Messages.getString("Compile"), PLSQLController.COMPILE_COMMAND)};
        string = this.createLocalAction((View)codeEditor, CompileArb.getIcon("MAKE_ICON"), Messages.getString("Make"), PLSQLController.MAKE_COMMAND);
        ActionMenuToolButton actionMenuToolButton = new ActionMenuToolButton((Action)((Object)string));
        actionMenuToolButton.setMenuActions((Action[])ideActionArray);
        toolbar.add((Component)toolbar.newSeparator(), this.buttonPos++);
        toolbar.add((Component)actionMenuToolButton, this.buttonPos++);
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        DBObject dBObject = new DBObject((Element)node);
        String string = dBObject.getObjectType();
        if (string == null) {
            if (DBURLFormatHelper.isDBURL(node.getURL())) {
                return;
            }
            string = ((PlSqlNode)node).getType();
        }
        ToolButton toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, PLSQLController.RUN_COMMAND));
        if (string != null && !string.endsWith("TRIGGER")) {
            toolbar.add((Component)toolButton, this.buttonPos++);
        }
        toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, OracleIcons.getIcon((String)"debug.png"), Messages.getString("Debug"), PLSQLController.DEBUG_COMMAND));
        toolbar.add((Component)toolButton, this.buttonPos++);
    }

    private void addGoToActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        DBObject dBObject = new DBObject((Element)node);
        String string = dBObject.getObjectType();
        if (string == null) {
            if (DBURLFormatHelper.isDBURL(node.getURL())) {
                return;
            }
            string = ((PlSqlNode)node).getType();
        }
        if (!string.startsWith("PACKAGE")) {
            return;
        }
        String string2 = Messages.getString("GOTO.spec");
        if ("PACKAGE".equals(string)) {
            string2 = Messages.getString("GOTO.body");
        }
        this.gotoSpecBodyButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, OracleNavigatorResource.getIcon("PACKAGE_ICON"), string2, PLSQLController.GOTO_SPEC_BODY_COMMAND));
        toolbar.add((Component)this.gotoSpecBodyButton, this.buttonPos++);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        FindToolbarController findToolbarController;
        Node node = this.parent.getContext().getNode();
        if (node instanceof PlSqlNode) {
            ((PlSqlNode)node).removeListener(this);
        }
        if ((findToolbarController = AbstractFindToolbarController.getFindController((BasicEditorPane)basicEditorPane)) != null) {
            findToolbarController.dispose();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, int n) {
        IdeAction ideAction = this.createLocalAction(view, n);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.putValue("ShortDescription", (Object)string);
        return ideAction;
    }

    private IdeAction createLocalAction(View view, int n) {
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        ideAction.setEnabled(false);
        return ideAction;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            Node node = context.getNode();
            boolean bl = PinningTracker.isPinned(node);
            if (!bl) {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
                PinningTracker.pinNode(node);
            } else {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                PinningTracker.unpinNode(node);
            }
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        return false;
    }

    static void toggleROIcon(IdeAction ideAction, Context context) {
        PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
        View view = context.getView();
        PLSQLEditorToolbar.toggleROIcon(ideAction, plSqlNode, view);
    }

    static void toggleROIcon(IdeAction ideAction, final PlSqlNode plSqlNode, View view) {
        if (view == null || !(view instanceof CodeEditor)) {
            return;
        }
        final BasicEditorPane basicEditorPane = ((CodeEditor)view).getFocusedEditorPane();
        basicEditorPane.setEditable(!plSqlNode.isReadOnly());
        basicEditorPane.getCaret().setVisible(!plSqlNode.isReadOnly());
        if (plSqlNode.isReadOnly() || "BLOCK".equals(plSqlNode.getObjectType())) {
            ideAction.setName(Messages.getString("PLSQLEditorToolbar.switchWrite"));
            ideAction.putValue("SmallIcon", (Object)RaptorImagesArb.getIcon("EDIT_CODE_BROKEN"));
            ideAction.putValue("ShortDescription", (Object)Messages.getString("PLSQLEditorToolbar.switchWrite"));
        } else {
            ideAction.setName(Messages.getString("PLSQLEditorToolbar.switchReadOnly"));
            ideAction.putValue("SmallIcon", (Object)RaptorImagesArb.getIcon("EDIT_CODE_WRITE"));
            ideAction.putValue("ShortDescription", (Object)Messages.getString("PLSQLEditorToolbar.switchReadOnly"));
        }
        CaretListener[] caretListenerArray = basicEditorPane.getCaretListeners();
        if (caretListenerArray.length == 0) {
            CaretListener caretListener = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    basicEditorPane.getCaret().setVisible(!plSqlNode.isReadOnly());
                }
            };
            basicEditorPane.addCaretListener(caretListener);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode && ideAction != this.pinAction) {
            PLSQLController.updateAction(ideAction, (PlSqlNode)node);
            if ("PACKAGE".equals(((PlSqlNode)node).getType())) {
                this.gotoSpecBodyButton.setEnabled(((PlSqlNode)node).hasBody());
            }
        }
        return true;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (object instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)object;
            if ("PACKAGE".equals(plSqlNode.getType())) {
                this.gotoSpecBodyButton.setEnabled(plSqlNode.hasBody());
            }
            for (Component component : this.toolbar.getComponents()) {
                AbstractButton abstractButton;
                Action action;
                if (!(component instanceof AbstractButton) || !((action = (abstractButton = (AbstractButton)component).getAction()) instanceof IdeAction) || action == this.pinAction) continue;
                IdeAction ideAction = (IdeAction)action;
                PLSQLController.updateAction(ideAction, plSqlNode);
            }
        }
    }
}

