/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.breadcrumbs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.breadcrumbs.PlSqlBreadcrumb;
import oracle.dbtools.raptor.plsql.breadcrumbs.PlSqlBreadcrumbsModel;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.PeekHelper;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;

public final class PlSqlBreadcrumbsPlugin
extends BreadcrumbsPlugin
implements CaretListener {
    private PlSqlBreadcrumbsListener m_listener;
    private PlSqlBreadcrumbsModel m_breadcrumbsModel;
    private PopupHandler m_popupHandler;
    BackgroundParser parser;

    public PlSqlBreadcrumbsPlugin(PlSqlNode plSqlNode) {
        this.parser = plSqlNode.getParser();
    }

    public void install(BasicEditorPane basicEditorPane) {
        Preferences preferences = Preferences.getPreferences();
        if (DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs()) {
            super.install(basicEditorPane);
            basicEditorPane.addCaretListener((CaretListener)this);
            this.m_breadcrumbsModel = new PlSqlBreadcrumbsModel(this.parser);
            this.breadcrumbs.setModel((BreadcrumbsModel)this.m_breadcrumbsModel);
            this.m_listener = new PlSqlBreadcrumbsListener();
            this.breadcrumbs.addBreadcrumbsListener((BreadcrumbsListener)this.m_listener);
            this.m_popupHandler = new PopupHandler();
            this.m_popupHandler.attach(this.breadcrumbs, (PopupProvider)new PlSqlPopupProvider());
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        PlSqlBreadcrumbsModel plSqlBreadcrumbsModel;
        PlSqlBreadcrumbsListener plSqlBreadcrumbsListener;
        PopupHandler popupHandler = this.m_popupHandler;
        if (popupHandler != null) {
            popupHandler.detatch();
            this.m_popupHandler = null;
        }
        if ((plSqlBreadcrumbsListener = this.m_listener) != null) {
            this.breadcrumbs.removeBreadcrumbsListener((BreadcrumbsListener)plSqlBreadcrumbsListener);
            this.m_listener = null;
        }
        if ((plSqlBreadcrumbsModel = this.m_breadcrumbsModel) != null) {
            plSqlBreadcrumbsModel.dispose();
            this.breadcrumbs.setModel(null);
            this.m_breadcrumbsModel = null;
        }
        basicEditorPane.removeCaretListener((CaretListener)this);
        super.deinstall(basicEditorPane);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateBreadCrumbs();
    }

    private void updateBreadCrumbs() {
        if (this.m_breadcrumbsModel != null && this.m_breadcrumbsModel.update(this.editor.getCaretPosition())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel != null) {
                        PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel.fireBreadcrumbsUpdated();
                    }
                }
            });
        }
    }

    private class PlSqlBreadcrumbsListener
    implements BreadcrumbsListener<Integer> {
        private CodePeek m_peek;

        private PlSqlBreadcrumbsListener() {
        }

        public void breadcrumbClicked(Breadcrumb<Integer> breadcrumb) {
            if (breadcrumb != null) {
                PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)breadcrumb.getUserObject()).intValue());
                PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
            }
        }

        public void breadcrumbContextClicked(Breadcrumb<Integer> breadcrumb, Point point) {
        }

        public void showBreadcrumbPeek(Breadcrumb breadcrumb, Rectangle rectangle) {
            String string;
            if (breadcrumb == null) {
                return;
            }
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
            if ((string = ((PlSqlBreadcrumb)breadcrumb).getPeekText()) == null) {
                return;
            }
            this.m_peek = PeekHelper.createCodePeek((JComponent)PlSqlBreadcrumbsPlugin.this.breadcrumbs, (String)"getTextNode().getURL().toExternalForm()", (String)string, null, (Rectangle)rectangle);
            this.m_peek.getGhostPointingPalette().setShowRectangle(false);
            this.m_peek.showPeek();
        }

        public void hideBreadcrumbPeek() {
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
        }

        public void separatorClicked(Breadcrumb breadcrumb, Rectangle rectangle) {
        }
    }

    private class PlSqlPopupProvider
    implements PopupProvider<Integer> {
        private PlSqlPopupProvider() {
        }

        public List<PopupItem<Integer>> getPopupItems(Breadcrumb<Integer> breadcrumb) {
            List<PopupItem<Integer>> list = ((PlSqlBreadcrumb)breadcrumb).getPopupItems();
            return list;
        }

        public void itemSelected(PopupItem<Integer> popupItem) {
            PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)popupItem.getUserObject()).intValue());
            PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
        }
    }
}

