/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.folding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.folding.PlSqlFoldingModel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.icons.OracleIcons;

public class PlSqlFoldingPlugin
extends AbstractCodeFoldingPlugin
implements CodeFoldingProvider {
    BackgroundParser parser;
    PlSqlNode node;

    public PlSqlFoldingPlugin(PlSqlNode plSqlNode) {
        this.parser = plSqlNode.getParser();
        this.node = plSqlNode;
    }

    protected CodeFoldingProvider createProvider() {
        return this;
    }

    public CodeFoldingModel createModel(BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        return new PlSqlFoldingModel(basicDocument, this.parser);
    }

    public JPopupMenu getPopupMenu() {
        return PlSqlFoldingPlugin.generateMenu((PlSqlFoldingModel)this.getModel(), this.parser.output);
    }

    public static JPopupMenu generateMenu(final PlSqlFoldingModel plSqlFoldingModel, final LazyNode lazyNode) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = Messages.getString("PlSqlFoldingPlugin.0");
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.1") + string, OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode = typedFoldingBlock2.src;
                    if (parseNode == null || !(parseNode instanceof LazyNode) || !((LazyNode)parseNode).isProcedure()) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                plSqlFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.2") + string, OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) == null || !(parseNode instanceof LazyNode) || !((LazyNode)parseNode).isProcedure()) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                plSqlFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.3"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode = typedFoldingBlock2.src;
                    if (parseNode == null || !(parseNode instanceof LazyNode) || !((LazyNode)parseNode).isStmt(lazyNode)) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                plSqlFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.4"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) == null || !(parseNode instanceof LazyNode) || !((LazyNode)parseNode).isStmt(lazyNode)) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                plSqlFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.ExpandComments"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) != null) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                plSqlFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.CollapseComments"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) != null) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                plSqlFoldingModel.reload();
            }
        });
        return jPopupMenu;
    }

    public void insertUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)codeFoldingModel;
        plSqlFoldingModel.reload(n, n2);
    }

    public void removeUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)codeFoldingModel;
        plSqlFoldingModel.reload(n, -n2);
    }
}

