/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;

public class ArboriEditor
extends JTextPane {
    private Map<Token, Style> styles;
    Style queryStyle;
    int fontSize;
    String fontFamily;
    private static Earley arboriParser = null;
    private static Style errStyle = null;

    public ArboriEditor() {
        ArboriEditor arboriEditor = this;
        final UndoManager undoManager = new UndoManager();
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                UndoableEdit undoableEdit = undoableEditEvent.getEdit();
                if (UIManager.getString("AbstractDocument.styleChangeText").equals(undoableEdit.getPresentationName())) {
                    return;
                }
                ArboriEditor.this.colorize();
                undoManager.addEdit(undoableEdit);
            }
        });
        arboriEditor.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        arboriEditor.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        arboriEditor.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        arboriEditor.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    private void initStyles() {
        this.queryStyle = this.addStyle("queryStyle", null);
        StyleConstants.setForeground(this.queryStyle, new Color(50, 100, 50));
        StyleConstants.setFontFamily(this.queryStyle, "monospaced");
        Preferences preferences = Preferences.getPreferences();
        FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)preferences);
        this.fontFamily = fontSizeOptions.getFontFamily();
        this.fontSize = fontSizeOptions.getFontSize() + 3;
        StyleConstants.setFontSize(this.queryStyle, this.fontSize);
        StyleConstants.setBold(this.queryStyle, true);
        StyleConstants.setItalic(this.queryStyle, true);
        this.initStyle(Token.COMMENT, Color.gray);
        this.initStyle(Token.OPERATION, new Color(150, 75, 75));
        this.initStyle(Token.IDENTIFIER, Color.black);
        this.initStyle(Token.DIGITS, Color.blue);
        this.initStyle(Token.AUXILIARY, Color.red);
        this.initStyle(Token.BQUOTED_STRING, Color.magenta);
        this.initStyle(Token.DQUOTED_STRING, Color.black);
        this.initStyle(Token.QUOTED_STRING, new Color(150, 0, 0));
        this.initStyle(Token.WS, Color.black);
        this.initStyle(Token.LINE_COMMENT, Color.DARK_GRAY);
    }

    private void initStyle(Token token, Color color) {
        Style style = this.addStyle(color.toString(), null);
        StyleConstants.setForeground(style, color);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setFontSize(this.queryStyle, this.fontSize);
        this.styles.put(token, style);
    }

    public void colorize() {
        if (this.styles == null) {
            this.styles = new HashMap<Token, Style>();
            this.initStyles();
        }
        final StyledDocument styledDocument = this.getStyledDocument();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArboriEditor.this.colorize(styledDocument);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void colorize(StyledDocument styledDocument) {
        String string = "N/A";
        try {
            string = styledDocument.getText(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        List list = LexerToken.parse((String)string, (boolean)true);
        for (LexerToken lexerToken : list) {
            styledDocument.setCharacterAttributes(lexerToken.begin, lexerToken.end - lexerToken.begin, this.styles.get(lexerToken.type), true);
        }
        try {
            Object object = ArboriEditor.checkSyntax(string);
            if (object != null) {
                if (errStyle == null) {
                    errStyle = this.addStyle("Error Style", null);
                    StyleConstants.setForeground(errStyle, Color.red);
                    StyleConstants.setBackground(errStyle, new Color(250, 180, 180));
                    StyleConstants.setFontFamily(errStyle, "monospaced");
                    StyleConstants.setFontSize(this.queryStyle, this.fontSize);
                    StyleConstants.setUnderline(this.queryStyle, true);
                }
                int n = ((SyntaxError)((Object)object)).end;
                if (string.length() - 3 < n) {
                    n = string.length() - 3;
                }
                if (n < 0) {
                    n = 0;
                }
                int n2 = n + 3;
                if (string.length() < n2) {
                    n2 = string.length();
                }
                styledDocument.setCharacterAttributes(n, n2 - n, errStyle, true);
            }
        }
        catch (IOException iOException) {
            Log.error((String)("arbori parse error: " + iOException.getMessage()));
        }
    }

    static SyntaxError checkSyntax(String string) throws IOException {
        if (arboriParser == null) {
            arboriParser = Program.getArboriParser();
        }
        Parsed parsed = new Parsed(string, arboriParser, "program");
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"program"}, (List)parsed.getSrc(), (Earley)arboriParser, (Matrix)parsed.getMatrix());
        return syntaxError;
    }
}

