/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.icons.OracleIcons;

public abstract class LegacyToggleButton
extends JToggleButton {
    static Icon onIcon = null;
    static Icon offIcon = null;
    JComponent[] dependents;
    static LegacyToggleButton instance = null;

    public LegacyToggleButton(JComponent[] jComponentArray) {
        this.dependents = jComponentArray;
        Icon icon = RaptorImagesArb.getIcon("MICROSCOPE");
        Icon icon2 = OracleIcons.getIcon((String)"search.png");
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        if (icon instanceof ImageIcon) {
            bufferedImage.getGraphics().drawImage(((ImageIcon)icon).getImage(), 0, 0, 16, 16, 0, 0, 32, 32, null);
        } else {
            JComponent[] jComponentArray2 = new JButton();
            icon.paintIcon((Component)jComponentArray2, bufferedImage.getGraphics(), 0, 0);
        }
        onIcon = new ImageIcon(bufferedImage);
        offIcon = icon2;
        this.setSelected(!LegacyToggleButton.isOff());
        if (this.isSelected()) {
            this.setIcon(onIcon);
            for (JComponent jComponent : jComponentArray) {
                jComponent.setEnabled(true);
            }
        } else {
            this.setIcon(offIcon);
            for (JComponent jComponent : jComponentArray) {
                jComponent.setEnabled(false);
            }
        }
        this.setToolTipText(LegacyToggleButton.ttipText());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LegacyToggleButton.this.toggle();
                LegacyToggleButton.this.reconcileStateWithDependents();
            }
        });
        instance = this;
    }

    abstract void stateChanged();

    static boolean isOff() {
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = dBConfig.getBoolean("LEGACY_OUTLINE");
        return bl;
    }

    private void toggle() {
        DBConfig dBConfig = DBConfig.getInstance();
        dBConfig.putBoolean("LEGACY_OUTLINE", !LegacyToggleButton.isOff());
        this.setToolTipText(LegacyToggleButton.ttipText());
    }

    void reconcileStateWithDependents() {
        this.setEnabled(true);
        if (this.isSelected()) {
            this.setIcon(onIcon);
            for (JComponent jComponent : this.dependents) {
                jComponent.setEnabled(true);
            }
        } else {
            this.setIcon(offIcon);
            for (JComponent jComponent : this.dependents) {
                jComponent.setEnabled(false);
            }
        }
        this.stateChanged();
    }

    private static String ttipText() {
        if (!LegacyToggleButton.isOff()) {
            return Messages.getString("OutlinePanel.Simple");
        }
        return Messages.getString("OutlinePanel.Detailed");
    }

    static void disableToolbarActions() {
        instance.setEnabled(false);
        for (JComponent jComponent : LegacyToggleButton.instance.dependents) {
            jComponent.setEnabled(false);
        }
    }
}

